/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSClipView;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTCanvasView;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    Layout layout;
    Control[] tabList;
    int layoutCount;
    int backgroundMode;

    Composite() {
    }

    public Composite(Composite composite, int n) {
        super(composite, n);
    }

    Control[] _getChildren() {
        NSArray nSArray = this.contentView().subviews();
        int n = (int)nSArray.count();
        Control[] controlArray = new Control[n];
        if (n == 0) {
            return controlArray;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Widget widget = this.display.getWidget(nSArray.objectAtIndex((long)((long)(n - n3 - 1))).id);
            if (widget != null && widget != this && widget instanceof Control) {
                controlArray[n2++] = (Control)widget;
            }
            ++n3;
        }
        if (n2 == n) {
            return controlArray;
        }
        Control[] controlArray2 = new Control[n2];
        System.arraycopy(controlArray, 0, controlArray2, 0, n2);
        return controlArray2;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.tabList.length) {
            if (!this.tabList[n2].isDisposed()) {
                ++n;
            }
            ++n2;
        }
        if (n == this.tabList.length) {
            return this.tabList;
        }
        Control[] controlArray = new Control[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.tabList.length) {
            if (!this.tabList[n4].isDisposed()) {
                controlArray[n3++] = this.tabList[n4];
            }
            ++n4;
        }
        this.tabList = controlArray;
        return this.tabList;
    }

    boolean acceptsFirstResponder(long l, long l2) {
        if ((this.state & 2) != 0) {
            return (this.style & 0x80000) == 0 && this.hooksKeys() && this.contentView().subviews().count() == 0L;
        }
        return super.acceptsFirstResponder(l, l2);
    }

    long accessibilityAttributeNames(long l, long l2) {
        NSArray nSArray;
        if (l == this.view.id && this.accessible != null && (nSArray = this.accessible.internal_accessibilityAttributeNames(-1)) != null) {
            return nSArray.id;
        }
        return super.accessibilityAttributeNames(l, l2);
    }

    boolean accessibilityIsIgnored(long l, long l2) {
        id id2;
        if (this.view != null && l == this.view.id && this.accessible != null && (id2 = this.accessible.internal_accessibilityAttributeValue(OS.NSAccessibilityRoleAttribute, -1)) != null) {
            return false;
        }
        return super.accessibilityIsIgnored(l, l2);
    }

    public void changed(Control[] controlArray) {
        Control control;
        this.checkWidget();
        if (controlArray == null) {
            this.error(5);
        }
        int n = 0;
        while (n < controlArray.length) {
            control = controlArray[n];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean bl = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl2 = bl = composite == this;
                if (bl) break;
                composite = composite.parent;
            }
            if (!bl) {
                this.error(32);
            }
            ++n;
        }
        n = 0;
        while (n < controlArray.length) {
            control = controlArray[n];
            Composite composite = control.parent;
            while (control != this) {
                if (composite.layout == null || !composite.layout.flushCache(control)) {
                    composite.state |= 0x2000;
                }
                control = composite;
                composite = control.parent;
            }
            ++n;
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point;
        this.checkWidget();
        if (this.layout != null) {
            if (n == -1 || n2 == -1) {
                point = this.layout.computeSize(this, n, n2, bl |= (this.state & 0x2000) != 0);
                this.state &= 0xFFFFDFFF;
            } else {
                point = new Point(n, n2);
            }
        } else {
            point = this.minimumSize(n, n2, bl);
        }
        if (point.x == 0) {
            point.x = 64;
        }
        if (point.y == 0) {
            point.y = 64;
        }
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        return new Point(rectangle.width, rectangle.height);
    }

    protected void checkSubclass() {
    }

    Widget[] computeTabList() {
        Widget[] widgetArray = super.computeTabList();
        if (widgetArray.length == 0) {
            return widgetArray;
        }
        Control[] controlArray = this.tabList != null ? this._getTabList() : this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            Widget[] widgetArray2 = control.computeTabList();
            if (widgetArray2.length != 0) {
                Widget[] widgetArray3 = new Widget[widgetArray.length + widgetArray2.length];
                System.arraycopy(widgetArray, 0, widgetArray3, 0, widgetArray.length);
                System.arraycopy(widgetArray2, 0, widgetArray3, widgetArray.length, widgetArray2.length);
                widgetArray = widgetArray3;
            }
            ++n;
        }
        return widgetArray;
    }

    void createHandle() {
        NSView nSView;
        boolean bl;
        this.state |= 2;
        boolean bl2 = bl = (this.style & 0x300) != 0;
        if (!bl) {
            this.state |= 0x800;
        }
        NSRect nSRect = new NSRect();
        if (bl || this.hasBorder()) {
            nSView = (NSScrollView)new SWTScrollView().alloc();
            nSView.initWithFrame(nSRect);
            ((NSScrollView)nSView).setDrawsBackground(false);
            if ((this.style & 0x100) != 0) {
                ((NSScrollView)nSView).setHasHorizontalScroller(true);
            }
            if ((this.style & 0x200) != 0) {
                ((NSScrollView)nSView).setHasVerticalScroller(true);
            }
            ((NSScrollView)nSView).setBorderType(this.hasBorder() ? 2 : 0);
            this.scrollView = nSView;
        }
        nSView = (NSView)new SWTCanvasView().alloc();
        nSView.initWithFrame(nSRect);
        this.view = nSView;
        if (this.scrollView != null) {
            NSClipView nSClipView = this.scrollView.contentView();
            nSClipView.setAutoresizesSubviews(true);
            this.view.setAutoresizingMask(18L);
        }
    }

    void drawBackground(long l, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l != this.view.id) {
            return;
        }
        if ((this.state & 2) != 0 && (this.style & 0x40000) == 0) {
            this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
        }
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] menuArray = super.findMenus(control);
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control2 = controlArray[n];
            Menu[] menuArray2 = control2.findMenus(control);
            if (menuArray2.length != 0) {
                Menu[] menuArray3 = new Menu[menuArray.length + menuArray2.length];
                System.arraycopy(menuArray, 0, menuArray3, 0, menuArray.length);
                System.arraycopy(menuArray2, 0, menuArray3, menuArray.length, menuArray2.length);
                menuArray = menuArray3;
            }
            ++n;
        }
        return menuArray;
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].fixChildren(shell, shell2, decorations, decorations2, menuArray);
            ++n;
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.tabList.length) {
            if (this.tabList[n2] == control) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return;
        }
        Control[] controlArray = null;
        int n3 = this.tabList.length - n;
        if (n3 != 0) {
            controlArray = new Control[n3];
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.tabList.length) {
                if (this.tabList[n5] != control) {
                    controlArray[n4++] = this.tabList[n5];
                }
                ++n5;
            }
        }
        this.tabList = controlArray;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] controlArray = this._getTabList();
        if (controlArray == null) {
            int n = 0;
            Control[] controlArray2 = this._getChildren();
            int n2 = 0;
            while (n2 < controlArray2.length) {
                if (controlArray2[n2].isTabGroup()) {
                    ++n;
                }
                ++n2;
            }
            controlArray = new Control[n];
            n2 = 0;
            int n3 = 0;
            while (n3 < controlArray2.length) {
                if (controlArray2[n3].isTabGroup()) {
                    controlArray[n2++] = controlArray2[n3];
                }
                ++n3;
            }
        }
        return controlArray;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    void invalidateChildrenVisibleRegion() {
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            control.resetVisibleRegion();
            control.invalidateChildrenVisibleRegion();
            ++n;
        }
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    boolean isOpaque(long l, long l2) {
        if ((this.state & 2) != 0 && l == this.view.id && this.region == null && this.background != null && this.background[3] == 1.0) {
            return true;
        }
        return super.isOpaque(l, l2);
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    void keyDown(long l, long l2, long l3) {
        if (this.view.window().firstResponder().id == l && (this.state & 2) != 0) {
            Shell shell = this.getShell();
            NSArray nSArray = NSArray.arrayWithObject(new NSEvent(l3));
            shell.keyInputHappened = false;
            this.view.interpretKeyEvents(nSArray);
            if (this.imeInComposition()) {
                return;
            }
            if (!shell.keyInputHappened) {
                NSEvent nSEvent = new NSEvent(l3);
                boolean[] blArray = new boolean[1];
                if (this.translateTraversal(nSEvent.keyCode(), nSEvent, blArray)) {
                    return;
                }
                if (this.isDisposed()) {
                    return;
                }
                if (!this.sendKeyEvent(nSEvent, 1)) {
                    return;
                }
                if (blArray[0]) {
                    return;
                }
            }
            return;
        }
        super.keyDown(l, l2, l3);
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean bl) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(bl, false);
    }

    public void layout(boolean bl, boolean bl2) {
        this.checkWidget();
        if (this.layout == null && !bl2) {
            return;
        }
        this.markLayout(bl, bl2);
        this.updateLayout(bl2);
    }

    public void layout(Control[] controlArray) {
        Control control;
        int n;
        Composite[] compositeArray;
        this.checkWidget();
        if (controlArray == null) {
            this.error(5);
        }
        int n2 = 0;
        while (n2 < controlArray.length) {
            compositeArray = controlArray[n2];
            if (compositeArray == null) {
                this.error(5);
            }
            if (compositeArray.isDisposed()) {
                this.error(5);
            }
            n = 0;
            control = compositeArray.parent;
            while (control != null) {
                int n3 = n = control == this ? 1 : 0;
                if (n != 0) break;
                control = control.parent;
            }
            if (n == 0) {
                this.error(32);
            }
            ++n2;
        }
        n2 = 0;
        compositeArray = new Composite[16];
        n = 0;
        while (n < controlArray.length) {
            control = controlArray[n];
            Composite composite = control.parent;
            while (control != this) {
                if (composite.layout != null) {
                    composite.state |= 0x1000;
                    if (!composite.layout.flushCache(control)) {
                        composite.state |= 0x2000;
                    }
                }
                if (n2 == compositeArray.length) {
                    Composite[] compositeArray2 = new Composite[compositeArray.length + 16];
                    System.arraycopy(compositeArray, 0, compositeArray2, 0, compositeArray.length);
                    compositeArray = compositeArray2;
                }
                int n4 = n2++;
                Composite composite2 = composite;
                compositeArray[n4] = composite2;
                control = composite2;
                composite = control.parent;
            }
            ++n;
        }
        n = n2 - 1;
        while (n >= 0) {
            compositeArray[n].updateLayout(false);
            --n;
        }
    }

    void markLayout(boolean bl, boolean bl2) {
        if (this.layout != null) {
            this.state |= 0x1000;
            if (bl) {
                this.state |= 0x2000;
            }
        }
        if (bl2) {
            Control[] controlArray = this._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].markLayout(bl, bl2);
                ++n;
            }
        }
    }

    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = this._getChildren();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < controlArray.length) {
            Rectangle rectangle = controlArray[n5].getBounds();
            n3 = Math.max(n3, rectangle.x + rectangle.width);
            n4 = Math.max(n4, rectangle.y + rectangle.height);
            ++n5;
        }
        return new Point(n3, n4);
    }

    boolean mouseEvent(long l, long l2, long l3, int n) {
        boolean bl = super.mouseEvent(l, l2, l3, n);
        return (this.state & 2) == 0 ? bl : new NSEvent(l3).type() != 1L;
    }

    void pageDown(long l, long l2, long l3) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.pageDown(l, l2, l3);
    }

    void pageUp(long l, long l2, long l3) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.pageUp(l, l2, l3);
    }

    void reflectScrolledClipView(long l, long l2, long l3) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.reflectScrolledClipView(l, l2, l3);
    }

    void releaseChildren(boolean bl) {
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control != null && !control.isDisposed()) {
                control.release(false);
            }
            ++n;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.layout = null;
        this.tabList = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
    }

    void resized() {
        super.resized();
        if (this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
    }

    void scrollWheel(long l, long l2, long l3) {
        if ((this.state & 2) != 0) {
            NSView nSView;
            NSView nSView2 = nSView = this.scrollView != null ? this.scrollView : this.view;
            if (l == nSView.id) {
                Event event;
                int n;
                NSEvent nSEvent = new NSEvent(l3);
                double d = nSEvent.deltaY();
                if (d != 0.0 && (this.hooks(37) || this.filters(37)) && !this.sendMouseEvent(nSEvent, 37, true)) {
                    return;
                }
                boolean bl = false;
                ScrollBar scrollBar = this.verticalBar;
                if (d != 0.0 && scrollBar != null && scrollBar.getEnabled()) {
                    if (-1.0 < d && d < 0.0) {
                        d = -1.0;
                    }
                    if (0.0 < d && d < 1.0) {
                        d = 1.0;
                    }
                    n = Math.max(0, (int)((double)(0.5f + (float)scrollBar.getSelection()) - (double)scrollBar.getIncrement() * d));
                    scrollBar.setSelection(n);
                    event = new Event();
                    event.detail = d > 0.0 ? 0x1000005 : 0x1000006;
                    scrollBar.sendEvent(13, event);
                    bl = true;
                }
                scrollBar = this.horizontalBar;
                d = nSEvent.deltaX();
                if (d != 0.0 && scrollBar != null && scrollBar.getEnabled()) {
                    n = Math.max(0, (int)((double)(0.5f + (float)scrollBar.getSelection()) - (double)scrollBar.getIncrement() * d));
                    scrollBar.setSelection(n);
                    event = new Event();
                    event.detail = d > 0.0 ? 0x1000005 : 0x1000006;
                    scrollBar.sendEvent(13, event);
                    bl = true;
                }
                if (!bl) {
                    nSView.superview().scrollWheel(nSEvent);
                }
                return;
            }
            this.callSuper(l, l2, l3);
            return;
        }
        super.scrollWheel(l, l2, l3);
    }

    public void setBackgroundMode(int n) {
        this.checkWidget();
        this.backgroundMode = n;
        Control[] controlArray = this._getChildren();
        int n2 = 0;
        while (n2 < controlArray.length) {
            controlArray[n2].updateBackgroundMode();
            ++n2;
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n].setFocus()) {
                return true;
            }
            ++n;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean bl) {
        if (!bl) {
            if (--this.layoutCount == 0 && ((this.state & 0x4000) != 0 || (this.state & 0x1000) != 0)) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    boolean setScrollBarVisible(ScrollBar scrollBar, boolean bl) {
        boolean bl2 = super.setScrollBarVisible(scrollBar, bl);
        if (bl2 && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return bl2;
    }

    boolean setTabGroupFocus() {
        boolean bl;
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        boolean bl2 = bl = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            bl = this.hooksKeys();
        }
        if (bl && this.setTabItemFocus()) {
            return true;
        }
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control.isTabItem() && control.setTabItemFocus()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setTabList(Control[] controlArray) {
        this.checkWidget();
        if (controlArray != null) {
            int n = 0;
            while (n < controlArray.length) {
                Control control = controlArray[n];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++n;
            }
            Control[] controlArray2 = new Control[controlArray.length];
            System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
            controlArray = controlArray2;
        }
        this.tabList = controlArray;
    }

    int traversalCode(int n, NSEvent nSEvent) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(n, nSEvent);
    }

    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].updateBackgroundMode();
            ++n;
        }
    }

    void updateCursorRects(boolean bl) {
        super.updateCursorRects(bl);
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            control.updateCursorRects(bl && control.isEnabled());
            ++n;
        }
    }

    void updateLayout(boolean bl) {
        Composite composite = this.findDeferredControl();
        if (composite != null) {
            composite.state |= 0x4000;
            return;
        }
        if ((this.state & 0x1000) != 0) {
            boolean bl2 = (this.state & 0x2000) != 0;
            this.state &= 0xFFFFCFFF;
            this.layout.layout(this, bl2);
        }
        if (bl) {
            this.state &= 0xFFFFBFFF;
            Control[] controlArray = this._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].updateLayout(bl);
                ++n;
            }
        }
    }
}

