/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.util.ArrayList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSOutlineView;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTTreeItem;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    static Callback dropTarget2Args;
    static Callback dropTarget3Args;
    static Callback dropTarget6Args;
    static long proc2Args;
    static long proc3Args;
    static long proc6Args;
    static boolean dropNotAllowed;
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    int feedback = 0;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((proc2Args = (dropTarget2Args = new Callback(clazz = clazz2, "dropTargetProc", 2)).getAddress()) == 0L) {
            SWT.error(3);
        }
        if ((proc3Args = (dropTarget3Args = new Callback(clazz, "dropTargetProc", 3)).getAddress()) == 0L) {
            SWT.error(3);
        }
        if ((proc6Args = (dropTarget6Args = new Callback(clazz, "dropTargetProc", 6)).getAddress()) == 0L) {
            SWT.error(3);
        }
        dropNotAllowed = false;
    }

    void addDragHandlers() {
        long l;
        long l2 = OS.object_getClass(this.control.view.id);
        if (l2 == 0L) {
            DND.error(2001);
        }
        if ((l = OS.class_getMethodImplementation(l2, OS.sel_draggingEntered_)) == proc3Args) {
            return;
        }
        OS.class_addMethod(l2, OS.sel_draggingEntered_, proc3Args, "@:@");
        OS.class_addMethod(l2, OS.sel_draggingUpdated_, proc3Args, "@:@");
        OS.class_addMethod(l2, OS.sel_draggingExited_, proc3Args, "@:@");
        OS.class_addMethod(l2, OS.sel_performDragOperation_, proc3Args, "@:@");
        OS.class_addMethod(l2, OS.sel_wantsPeriodicDraggingUpdates, proc2Args, "@:");
        if (OS.class_getSuperclass(l2) == OS.class_NSOutlineView) {
            OS.class_addMethod(l2, OS.sel_outlineView_acceptDrop_item_childIndex_, proc6Args, "@:@@@i");
            OS.class_addMethod(l2, OS.sel_outlineView_validateDrop_proposedItem_proposedChildIndex_, proc6Args, "@:@@@i");
        } else if (OS.class_getSuperclass(l2) == OS.class_NSTableView) {
            OS.class_addMethod(l2, OS.sel_tableView_acceptDrop_row_dropOperation_, proc6Args, "@:@@@i");
            OS.class_addMethod(l2, OS.sel_tableView_validateDrop_proposedRow_proposedDropOperation_, proc6Args, "@:@@@i");
        }
    }

    public void addDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dropTargetListener);
        dNDListener.dndWidget = this;
        this.addListener(2002, dNDListener);
        this.addListener(2003, dNDListener);
        this.addListener(2004, dNDListener);
        this.addListener(2005, dNDListener);
        this.addListener(2006, dNDListener);
        this.addListener(2007, dNDListener);
    }

    long callSuper(long l, long l2, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2, l3);
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    int draggingEntered(long l, long l2, NSObject nSObject) {
        if (nSObject == null) {
            return 0;
        }
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(nSObject, dNDEvent)) {
            this.keyOperation = -1;
            this.setDropNotAllowed();
            return 0;
        }
        int n = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(2002, dNDEvent);
        if (dNDEvent.detail == 16) {
            int n2 = dNDEvent.detail = (n & 2) != 0 ? 2 : 0;
        }
        if (dNDEvent.dataType != null) {
            int n3 = 0;
            while (n3 < transferDataArray.length) {
                if (transferDataArray[n3].type == dNDEvent.dataType.type) {
                    this.selectedDataType = transferDataArray[n3];
                    break;
                }
                ++n3;
            }
        }
        if (this.selectedDataType != null && (n & dNDEvent.detail) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0 && OS.PTR_SIZEOF == 4) {
            this.setDropNotAllowed();
        } else {
            this.clearDropNotAllowed();
        }
        if (new NSObject(l).isKindOfClass(OS.class_NSTableView)) {
            return (int)this.callSuper(l, l2, nSObject.id);
        }
        return this.opToOsOp(this.selectedOperation);
    }

    void draggingExited(long l, long l2, NSObject nSObject) {
        this.clearDropNotAllowed();
        if (this.keyOperation == -1) {
            return;
        }
        this.keyOperation = -1;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = (int)System.currentTimeMillis();
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
        if (new NSObject(l).isKindOfClass(OS.class_NSTableView)) {
            this.callSuper(l, l2, nSObject.id);
        }
    }

    int draggingUpdated(long l, long l2, NSObject nSObject) {
        if (nSObject == null) {
            return 0;
        }
        int n = this.keyOperation;
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(nSObject, dNDEvent)) {
            this.keyOperation = -1;
            this.setDropNotAllowed();
            return 0;
        }
        int n2 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        if (this.keyOperation == n) {
            dNDEvent.type = 2004;
            dNDEvent.dataType = this.selectedDataType;
            dNDEvent.detail = this.selectedOperation;
        } else {
            dNDEvent.type = 2005;
            dNDEvent.dataType = this.selectedDataType;
        }
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(dNDEvent.type, dNDEvent);
        if (dNDEvent.detail == 16) {
            int n3 = dNDEvent.detail = (n2 & 2) != 0 ? 2 : 0;
        }
        if (dNDEvent.dataType != null) {
            int n4 = 0;
            while (n4 < transferDataArray.length) {
                if (transferDataArray[n4].type == dNDEvent.dataType.type) {
                    this.selectedDataType = transferDataArray[n4];
                    break;
                }
                ++n4;
            }
        }
        if (this.selectedDataType != null && (dNDEvent.detail & n2) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0 && OS.PTR_SIZEOF == 4) {
            this.setDropNotAllowed();
        } else {
            this.clearDropNotAllowed();
        }
        if (new NSObject(l).isKindOfClass(OS.class_NSTableView)) {
            return (int)this.callSuper(l, l2, nSObject.id);
        }
        return this.opToOsOp(this.selectedOperation);
    }

    public DropTarget(Control control, int n) {
        super(control, DropTarget.checkStyle(n));
        this.control = control;
        if (control.getData("DropTarget") != null) {
            DND.error(2001);
        }
        control.setData("DropTarget", this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        Object object = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (object instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)object;
        } else if (control instanceof Table) {
            this.dropEffect = new TableDropTargetEffect((Table)control);
        } else if (control instanceof Tree) {
            this.dropEffect = new TreeDropTargetEffect((Tree)control);
        }
        this.addDragHandlers();
    }

    static long dropTargetProc(long l, long l2) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(l);
        if (widget == null) {
            return 0L;
        }
        DropTarget dropTarget = (DropTarget)widget.getData("DropTarget");
        if (dropTarget == null) {
            return 0L;
        }
        if (l2 == OS.sel_wantsPeriodicDraggingUpdates) {
            return dropTarget.wantsPeriodicDraggingUpdates(l, l2) ? 1 : 0;
        }
        return 0L;
    }

    static long dropTargetProc(long l, long l2, long l3) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(l);
        if (widget == null) {
            return 0L;
        }
        DropTarget dropTarget = (DropTarget)widget.getData("DropTarget");
        if (dropTarget == null) {
            return 0L;
        }
        NSObject nSObject = new NSObject(l3);
        if (l2 == OS.sel_draggingEntered_) {
            return dropTarget.draggingEntered(l, l2, nSObject);
        }
        if (l2 == OS.sel_draggingUpdated_) {
            return dropTarget.draggingUpdated(l, l2, nSObject);
        }
        if (l2 == OS.sel_draggingExited_) {
            dropTarget.draggingExited(l, l2, nSObject);
        } else if (l2 == OS.sel_performDragOperation_) {
            return dropTarget.performDragOperation(l, l2, nSObject) ? 1 : 0;
        }
        return 0L;
    }

    static long dropTargetProc(long l, long l2, long l3, long l4, long l5, long l6) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(l);
        if (widget == null) {
            return 0L;
        }
        DropTarget dropTarget = (DropTarget)widget.getData("DropTarget");
        if (dropTarget == null) {
            return 0L;
        }
        if (l2 == OS.sel_outlineView_acceptDrop_item_childIndex_) {
            return dropTarget.outlineView_acceptDrop_item_childIndex(l, l2, l3, l4, l5, l6) ? 1 : 0;
        }
        if (l2 == OS.sel_outlineView_validateDrop_proposedItem_proposedChildIndex_) {
            return dropTarget.outlineView_validateDrop_proposedItem_proposedChildIndex(l, l2, l3, l4, l5, l6);
        }
        if (l2 == OS.sel_tableView_acceptDrop_row_dropOperation_) {
            return dropTarget.tableView_acceptDrop_row_dropOperation(l, l2, l3, l4, l5, l6) ? 1 : 0;
        }
        if (l2 == OS.sel_tableView_validateDrop_proposedRow_proposedDropOperation_) {
            return dropTarget.tableView_validateDrop_proposedRow_proposedDropOperation(l, l2, l3, l4, l5, l6);
        }
        return 0L;
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetListener[] getDropListeners() {
        Listener[] listenerArray = this.getListeners(2002);
        int n = listenerArray.length;
        DropTargetListener[] dropTargetListenerArray = new DropTargetListener[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Listener listener = listenerArray[n3];
            if (listener instanceof DNDListener) {
                dropTargetListenerArray[n2] = (DropTargetListener)((DNDListener)listener).getEventListener();
                ++n2;
            }
            ++n3;
        }
        if (n2 == n) {
            return dropTargetListenerArray;
        }
        DropTargetListener[] dropTargetListenerArray2 = new DropTargetListener[n2];
        System.arraycopy(dropTargetListenerArray, 0, dropTargetListenerArray2, 0, n2);
        return dropTargetListenerArray2;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState() {
        boolean bl;
        NSEvent nSEvent = NSApplication.sharedApplication().currentEvent();
        long l = nSEvent.modifierFlags();
        boolean bl2 = (l & 0x80000L) == 524288L;
        boolean bl3 = bl = (l & 0x40000L) == 262144L;
        if (bl && bl2) {
            return 16;
        }
        if (bl) {
            return 4;
        }
        if (bl2) {
            return 1;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DropTarget", null);
        this.transferAgents = null;
        this.control.view.unregisterDraggedTypes();
        this.control = null;
    }

    int opToOsOp(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 2;
        }
        if ((n & 2) != 0) {
            n2 |= 0x10;
        }
        if ((n & 8) != 0) {
            n2 |= 0x20;
        }
        return n2;
    }

    int osOpToOp(long l) {
        int n = 0;
        if ((l & 1L) != 0L) {
            n |= 1;
        }
        if ((l & 2L) != 0L) {
            n |= 4;
        }
        if ((l & 0x20L) != 0L) {
            n |= 8;
        }
        if ((l & 0x10L) != 0L) {
            n |= 2;
        }
        if (l == -1L) {
            n = 7;
        }
        return n;
    }

    boolean drop(NSObject nSObject) {
        Object object;
        Object object2;
        TransferData[] transferDataArray;
        this.clearDropNotAllowed();
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = (int)System.currentTimeMillis();
        if (this.dropEffect != null) {
            NSPoint nSPoint = nSObject.draggingLocation();
            transferDataArray = nSObject.draggingDestinationWindow().convertBaseToScreen(nSPoint);
            dNDEvent.item = this.dropEffect.getItem((int)transferDataArray.x, (int)transferDataArray.y);
        }
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
        dNDEvent = new DNDEvent();
        if (!this.setEventData(nSObject, dNDEvent)) {
            return false;
        }
        this.keyOperation = -1;
        int n = dNDEvent.operations;
        transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, dNDEvent.dataTypes.length);
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.detail = this.selectedOperation;
        this.notifyListeners(2007, dNDEvent);
        this.selectedDataType = null;
        if (dNDEvent.dataType != null) {
            int n2 = 0;
            while (n2 < transferDataArray.length) {
                if (transferDataArray[n2].type == dNDEvent.dataType.type) {
                    this.selectedDataType = transferDataArray[n2];
                    break;
                }
                ++n2;
            }
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (dNDEvent.detail & n) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0) {
            return false;
        }
        NSPasteboard nSPasteboard = nSObject.draggingPasteboard();
        NSObject nSObject2 = null;
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(10L);
        int n3 = 0;
        while (n3 < this.transferAgents.length) {
            object2 = this.transferAgents[n3];
            object = ((Transfer)object2).getTypeNames();
            int[] nArray = ((Transfer)object2).getTypeIds();
            int n4 = 0;
            while (n4 < ((String[])object).length) {
                if (this.selectedDataType.type == nArray[n4]) {
                    nSMutableArray.addObject(NSString.stringWith(object[n4]));
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        NSString nSString = nSPasteboard.availableTypeFromArray(nSMutableArray);
        object2 = new TransferData();
        if (nSString != null) {
            ((TransferData)object2).type = Transfer.registerType(nSString.getString());
            ((TransferData)object2).data = nSString.isEqual(OS.NSStringPboardType) || nSString.isEqual(OS.NSHTMLPboardType) || nSString.isEqual(OS.NSRTFPboardType) ? nSPasteboard.stringForType(nSString) : (nSString.isEqual(OS.NSURLPboardType) ? NSURL.URLFromPasteboard(nSPasteboard) : (nSString.isEqual(OS.NSFilenamesPboardType) ? new NSArray(nSPasteboard.propertyListForType((NSString)nSString).id) : nSPasteboard.dataForType(nSString)));
        }
        if (((TransferData)object2).data != null) {
            nSObject2 = ((TransferData)object2).data;
        }
        object = null;
        int n5 = 0;
        while (n5 < this.transferAgents.length) {
            Transfer transfer = this.transferAgents[n5];
            if (transfer != null && transfer.isSupportedType(this.selectedDataType)) {
                this.selectedDataType.data = nSObject2;
                object = transfer.nativeToJava(this.selectedDataType);
                break;
            }
            ++n5;
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.detail = this.selectedOperation;
        dNDEvent.data = object;
        this.notifyListeners(2006, dNDEvent);
        this.selectedOperation = 0;
        if ((n & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        return this.selectedOperation != 0;
    }

    boolean performDragOperation(long l, long l2, NSObject nSObject) {
        if (new NSObject(l).isKindOfClass(OS.class_NSTableView)) {
            return this.callSuper(l, l2, nSObject.id) != 0L;
        }
        return this.drop(nSObject);
    }

    boolean outlineView_acceptDrop_item_childIndex(long l, long l2, long l3, long l4, long l5, long l6) {
        return this.drop(new NSObject(l4));
    }

    long outlineView_validateDrop_proposedItem_proposedChildIndex(long l, long l2, long l3, long l4, long l5, long l6) {
        NSOutlineView nSOutlineView = new NSOutlineView(l3);
        NSObject nSObject = new NSObject(l4);
        NSPoint nSPoint = nSObject.draggingLocation();
        nSPoint = nSOutlineView.convertPoint_fromView_(nSPoint, null);
        Tree tree = (Tree)this.getControl();
        TreeItem treeItem = tree.getItem(new Point((int)nSPoint.x, (int)nSPoint.y));
        if (this.feedback == 0 || treeItem == null) {
            nSOutlineView.setDropItem(null, -1L);
        } else if ((this.feedback & 1) != 0) {
            nSOutlineView.setDropItem(treeItem.handle, -1L);
        } else {
            int n;
            TreeItem treeItem2 = treeItem.getParentItem();
            SWTTreeItem sWTTreeItem = null;
            if (treeItem2 != null) {
                sWTTreeItem = treeItem2.handle;
                n = treeItem2.indexOf(treeItem);
            } else {
                n = ((Tree)this.getControl()).indexOf(treeItem);
            }
            if ((this.feedback & 4) != 0) {
                nSOutlineView.setDropItem(sWTTreeItem, n + 1);
            }
            if ((this.feedback & 2) != 0) {
                nSOutlineView.setDropItem(sWTTreeItem, n);
            }
        }
        return this.opToOsOp(this.selectedOperation);
    }

    public void removeDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        this.removeListener(2002, dropTargetListener);
        this.removeListener(2003, dropTargetListener);
        this.removeListener(2004, dropTargetListener);
        this.removeListener(2005, dropTargetListener);
        this.removeListener(2006, dropTargetListener);
        this.removeListener(2007, dropTargetListener);
    }

    public void setDropTargetEffect(DropTargetEffect dropTargetEffect) {
        this.dropEffect = dropTargetEffect;
    }

    boolean setEventData(NSObject nSObject, DNDEvent dNDEvent) {
        Object object;
        NSObject nSObject2;
        Object object2;
        NSPasteboard nSPasteboard;
        NSArray nSArray;
        int n;
        if (nSObject == null) {
            return false;
        }
        int n2 = this.getStyle();
        long l = nSObject.draggingSourceOperationMask();
        int n3 = this.osOpToOp(l) & n2;
        if (n3 == 0) {
            return false;
        }
        this.keyOperation = n = this.getOperationFromKeyState();
        if (n == 16) {
            if ((n2 & 0x10) == 0) {
                n = (n3 & 2) != 0 ? 2 : 0;
            }
        } else if ((n & n3) == 0) {
            n = 0;
        }
        if ((nSArray = (nSPasteboard = nSObject.draggingPasteboard()).types()) == null) {
            return false;
        }
        long l2 = nSArray.count();
        TransferData[] transferDataArray = new TransferData[(int)l2];
        int n4 = -1;
        int n5 = 0;
        while ((long)n5 < l2) {
            object2 = nSArray.objectAtIndex(n5);
            nSObject2 = new NSString((id)object2);
            object = new TransferData();
            ((TransferData)object).type = Transfer.registerType(((NSString)nSObject2).getString());
            int n6 = 0;
            while (n6 < this.transferAgents.length) {
                Transfer transfer = this.transferAgents[n6];
                if (transfer != null && transfer.isSupportedType((TransferData)object)) {
                    transferDataArray[++n4] = object;
                    break;
                }
                ++n6;
            }
            ++n5;
        }
        if (n4 == -1) {
            return false;
        }
        if (n4 < transferDataArray.length - 1) {
            TransferData[] transferDataArray2 = new TransferData[n4 + 1];
            System.arraycopy(transferDataArray, 0, transferDataArray2, 0, n4 + 1);
            transferDataArray = transferDataArray2;
        }
        NSPoint nSPoint = nSObject.draggingLocation();
        object2 = nSObject.draggingDestinationWindow().convertBaseToScreen(nSPoint);
        nSObject2 = NSScreen.screens();
        object = new NSScreen(((NSArray)nSObject2).objectAtIndex(0L)).frame();
        ((NSPoint)object2).y = ((NSRect)object).height - ((NSPoint)object2).y;
        dNDEvent.widget = this;
        dNDEvent.x = (int)((NSPoint)object2).x;
        dNDEvent.y = (int)((NSPoint)object2).y;
        dNDEvent.time = (int)System.currentTimeMillis();
        dNDEvent.feedback = 1;
        dNDEvent.dataTypes = transferDataArray;
        dNDEvent.dataType = transferDataArray[0];
        dNDEvent.operations = n3;
        dNDEvent.detail = n;
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(dNDEvent.x, dNDEvent.y);
        }
        return true;
    }

    public void setTransfer(Transfer[] transferArray) {
        int n;
        Object object;
        if (transferArray == null) {
            DND.error(4);
        }
        this.transferAgents = transferArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < this.transferAgents.length) {
            object = transferArray[n2].getTypeNames();
            n = 0;
            while (n < ((String[])object).length) {
                arrayList.add(object[n]);
                ++n;
            }
            ++n2;
        }
        n2 = arrayList.size();
        object = NSMutableArray.arrayWithCapacity(n2);
        n = 0;
        while (n < n2) {
            ((NSMutableArray)object).addObject(NSString.stringWith((String)arrayList.get(n)));
            ++n;
        }
        this.control.view.registerForDraggedTypes((NSArray)object);
    }

    void setDropNotAllowed() {
        if (!dropNotAllowed) {
            NSCursor.currentCursor().push();
            if (OS.PTR_SIZEOF == 4) {
                OS.SetThemeCursor(18);
            }
            dropNotAllowed = true;
        }
    }

    void clearDropNotAllowed() {
        if (dropNotAllowed) {
            NSCursor.pop();
            dropNotAllowed = false;
        }
    }

    boolean tableView_acceptDrop_row_dropOperation(long l, long l2, long l3, long l4, long l5, long l6) {
        return this.drop(new NSObject(l4));
    }

    int tableView_validateDrop_proposedRow_proposedDropOperation(long l, long l2, long l3, long l4, long l5, long l6) {
        NSTableView nSTableView = new NSTableView(l3);
        if (0L <= l5 && l5 < nSTableView.numberOfRows()) {
            nSTableView.setDropRow(l5, 0L);
        }
        return this.opToOsOp(this.selectedOperation);
    }

    boolean wantsPeriodicDraggingUpdates(long l, long l2) {
        return true;
    }
}

