/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.manifmerger.IMergerLog;
import com.android.manifmerger.ManifestMerger;
import com.android.utils.XmlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

class MergerXmlUtils {
    private static final String DATA_ORIGIN_FILE = "manif.merger.file";
    private static final String DATA_FILE_NAME = "manif.merger.filename";
    private static final String DATA_LINE_NUMBER = "manif.merger.line#";

    MergerXmlUtils() {
    }

    @Nullable
    static Document parseDocument(final @NonNull File xmlFile, final @NonNull IMergerLog log, @NonNull ManifestMerger merger) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Reader reader = XmlUtils.getUtfReader(xmlFile);
            InputSource is = new InputSource(reader);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) {
                    log.error(IMergerLog.Severity.WARNING, new IMergerLog.FileAndLine(xmlFile.getAbsolutePath(), 0), "Warning when parsing: %1$s", e.toString());
                }

                @Override
                public void fatalError(SAXParseException e) {
                    log.error(IMergerLog.Severity.ERROR, new IMergerLog.FileAndLine(xmlFile.getAbsolutePath(), 0), "Fatal error when parsing: %1$s", xmlFile.getName(), e.toString());
                }

                @Override
                public void error(SAXParseException e) {
                    log.error(IMergerLog.Severity.ERROR, new IMergerLog.FileAndLine(xmlFile.getAbsolutePath(), 0), "Error when parsing: %1$s", e.toString());
                }
            });
            Document doc = builder.parse(is);
            doc.setUserData(DATA_ORIGIN_FILE, xmlFile, null);
            MergerXmlUtils.findLineNumbers(doc, 1);
            if (merger.isInsertSourceMarkers()) {
                MergerXmlUtils.setSource(doc, xmlFile);
            }
            return doc;
        }
        catch (FileNotFoundException e) {
            log.error(IMergerLog.Severity.ERROR, new IMergerLog.FileAndLine(xmlFile.getAbsolutePath(), 0), "XML file not found", new Object[0]);
        }
        catch (Exception e) {
            log.error(IMergerLog.Severity.ERROR, new IMergerLog.FileAndLine(xmlFile.getAbsolutePath(), 0), "Failed to parse XML file: %1$s", e.toString());
        }
        return null;
    }

    @Nullable
    static Document parseDocument(@NonNull String xml, @NonNull IMergerLog log, @NonNull IMergerLog.FileAndLine errorContext) {
        try {
            Document doc = XmlUtils.parseDocument(xml, true);
            MergerXmlUtils.findLineNumbers(doc, 1);
            if (errorContext.getFileName() != null) {
                MergerXmlUtils.setSource(doc, new File(errorContext.getFileName()));
            }
            return doc;
        }
        catch (Exception e) {
            log.error(IMergerLog.Severity.ERROR, errorContext, "Failed to parse XML string", new Object[0]);
            return null;
        }
    }

    static void decorateDocument(@NonNull Document doc, @NonNull String fileName) {
        doc.setUserData(DATA_FILE_NAME, fileName, null);
        MergerXmlUtils.findLineNumbers(doc, 1);
    }

    @NonNull
    static IMergerLog.FileAndLine xmlFileAndLine(@NonNull Node node) {
        String name = MergerXmlUtils.extractXmlFilename(node);
        int line = MergerXmlUtils.extractLineNumber(node);
        return new IMergerLog.FileAndLine(name, line);
    }

    @Nullable
    static String extractXmlFilename(@Nullable Node xmlNode) {
        if (xmlNode != null && xmlNode.getNodeType() != 9) {
            xmlNode = xmlNode.getOwnerDocument();
        }
        if (xmlNode != null) {
            Object data = xmlNode.getUserData(DATA_ORIGIN_FILE);
            if (data instanceof File) {
                return ((File)data).getPath();
            }
            data = xmlNode.getUserData(DATA_FILE_NAME);
            if (data instanceof String) {
                return (String)data;
            }
        }
        return null;
    }

    public static void setSource(@NonNull Node node, @NonNull File source) {
        while (node != null) {
            short nodeType = node.getNodeType();
            if (nodeType == 1 || nodeType == 8 || nodeType == 9 || nodeType == 4) {
                node.setUserData(DATA_ORIGIN_FILE, source, null);
            }
            Node child = node.getFirstChild();
            MergerXmlUtils.setSource(child, source);
            node = node.getNextSibling();
        }
    }

    private static int findLineNumbers(Node node, int line) {
        while (node != null) {
            Node child;
            String text;
            node.setUserData(DATA_LINE_NUMBER, line, null);
            if (node.getNodeType() == 3 && (text = node.getNodeValue()).length() > 0) {
                int pos = 0;
                while ((pos = text.indexOf(10, pos)) != -1) {
                    ++line;
                    ++pos;
                }
            }
            if ((child = node.getFirstChild()) != null) {
                line = MergerXmlUtils.findLineNumbers(child, line);
            }
            node = node.getNextSibling();
        }
        return line;
    }

    static int extractLineNumber(@Nullable Node xmlNode) {
        Object data;
        if (xmlNode != null && (data = xmlNode.getUserData(DATA_LINE_NUMBER)) instanceof Integer) {
            return (Integer)data;
        }
        return 0;
    }

    static boolean printXmlFile(@NonNull Document doc, @NonNull File outFile, @NonNull IMergerLog log) {
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("omit-xml-declaration", "yes");
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            tf.transform(new DOMSource(doc), new StreamResult(outFile));
            return true;
        }
        catch (TransformerException e) {
            log.error(IMergerLog.Severity.ERROR, new IMergerLog.FileAndLine(outFile.getName(), 0), "Failed to write XML file: %1$s", e.toString());
            return false;
        }
    }

    static String printXmlString(@NonNull Document doc, @NonNull IMergerLog log) {
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("omit-xml-declaration", "yes");
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            StringWriter sw = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerException e) {
            log.error(IMergerLog.Severity.ERROR, new IMergerLog.FileAndLine(MergerXmlUtils.extractXmlFilename(doc), 0), "Failed to write XML file: %1$s", e.toString());
            return null;
        }
    }

    @NonNull
    static String dump(@Nullable Node node, boolean nextSiblings) {
        return MergerXmlUtils.dump(node, 0, nextSiblings, true, null);
    }

    @NonNull
    static String dump(@Nullable Node node, int offsetIndex, boolean nextSiblings, boolean deep, @Nullable String keyAttr) {
        StringBuilder sb = new StringBuilder();
        String offset = "";
        for (int i = 0; i < offsetIndex; ++i) {
            offset = offset + "  ";
        }
        if (node == null) {
            sb.append(offset).append("(end reached)\n");
        } else {
            while (node != null) {
                String type = null;
                short t = node.getNodeType();
                switch (t) {
                    case 1: {
                        String attr = "";
                        if (keyAttr != null) {
                            for (Attr a : MergerXmlUtils.sortedAttributeList(node.getAttributes())) {
                                if (a == null || !keyAttr.equals(a.getLocalName())) continue;
                                attr = String.format(" %1$s=%2$s", a.getNodeName(), a.getNodeValue());
                                break;
                            }
                        }
                        sb.append(String.format("%1$s<%2$s%3$s>\n", offset, node.getNodeName(), attr));
                        break;
                    }
                    case 8: {
                        sb.append(String.format("%1$s<!-- %2$s -->\n", offset, node.getNodeValue()));
                        break;
                    }
                    case 3: {
                        String txt = node.getNodeValue().trim();
                        if (txt.length() == 0) break;
                        sb.append(String.format("%1$s%2$s\n", offset, txt));
                        break;
                    }
                    case 2: {
                        sb.append(String.format("%1$s    @%2$s = %3$s\n", offset, node.getNodeName(), node.getNodeValue()));
                        break;
                    }
                    case 4: {
                        type = "cdata";
                        break;
                    }
                    case 9: {
                        type = "document";
                        break;
                    }
                    case 7: {
                        type = "PI";
                        break;
                    }
                    default: {
                        type = Integer.toString(t);
                    }
                }
                if (type != null) {
                    sb.append(String.format("%1$s[%2$s] <%3$s> %4$s\n", offset, type, node.getNodeName(), node.getNodeValue()));
                }
                if (deep) {
                    for (Attr attr : MergerXmlUtils.sortedAttributeList(node.getAttributes())) {
                        sb.append(String.format("%1$s    @%2$s = %3$s\n", offset, attr.getNodeName(), attr.getNodeValue()));
                    }
                    Node child = node.getFirstChild();
                    if (child != null) {
                        sb.append(MergerXmlUtils.dump(child, offsetIndex + 1, true, true, keyAttr));
                    }
                }
                if (!nextSiblings) break;
                node = node.getNextSibling();
            }
        }
        return sb.toString();
    }

    @NonNull
    static List<Attr> sortedAttributeList(@Nullable NamedNodeMap attrMap) {
        ArrayList<Attr> list = new ArrayList<Attr>();
        if (attrMap != null) {
            for (int i = 0; i < attrMap.getLength(); ++i) {
                Node attr = attrMap.item(i);
                if (!(attr instanceof Attr)) continue;
                list.add((Attr)attr);
            }
        }
        if (list.size() > 1) {
            Collections.sort(list, MergerXmlUtils.getAttrComparator());
        }
        return list;
    }

    @NonNull
    static Comparator<? super Attr> getAttrComparator() {
        return new Comparator<Attr>(){

            @Override
            public int compare(Attr a1, Attr a2) {
                String s1 = a1 == null ? "" : a1.getNodeName();
                String s2 = a2 == null ? "" : a2.getNodeName();
                boolean name1 = s1.equals("name");
                boolean name2 = s2.equals("name");
                if (name1 && name2) {
                    return 0;
                }
                if (name1) {
                    return -1;
                }
                if (name2) {
                    return 1;
                }
                return s1.compareTo(s2);
            }
        };
    }

    static void injectAttributes(@Nullable Document doc, @Nullable Map<String, String> attributeMap, @NonNull IMergerLog log) {
        if (doc == null || attributeMap == null || attributeMap.isEmpty()) {
            return;
        }
        Pattern keyRx = Pattern.compile("^/([^\\|]+)\\|([^ ]*) +(.+)$");
        IMergerLog.FileAndLine docInfo = MergerXmlUtils.xmlFileAndLine(doc);
        block0: for (Map.Entry<String, String> entry : attributeMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || key.isEmpty()) continue;
            Matcher m = keyRx.matcher(key);
            if (!m.matches()) {
                log.error(IMergerLog.Severity.WARNING, docInfo, "Invalid injected attribute key: %s", key);
                continue;
            }
            String path = m.group(1);
            String attrNsUri = m.group(2);
            String attrName = m.group(3);
            String[] segment = path.split(Pattern.quote("/"));
            Node element = doc;
            block1: for (int i = 0; i < segment.length; ++i) {
                Node child;
                String name = segment[i];
                for (child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() != 1 || child.getNamespaceURI() != null || !child.getNodeName().equals(name)) continue;
                    element = child;
                    continue block1;
                }
                if (value == null) break block0;
                child = doc.createElement(name);
                element = element.insertBefore(child, element.getFirstChild());
            }
            if (element == null) {
                log.error(IMergerLog.Severity.WARNING, docInfo, "Invalid injected attribute path: %s", path);
                return;
            }
            NamedNodeMap attrs = element.getAttributes();
            if (attrs == null) continue;
            if (attrNsUri != null && attrNsUri.isEmpty()) {
                attrNsUri = null;
            }
            Node attr = attrs.getNamedItemNS(attrNsUri, attrName);
            if (value == null) {
                if (attr == null) continue;
                attrs.removeNamedItemNS(attrNsUri, attrName);
                continue;
            }
            if (attr == null) {
                attr = doc.createAttributeNS(attrNsUri, attrName);
                if (attrNsUri != null) {
                    attr.setPrefix(XmlUtils.lookupNamespacePrefix(element, attrNsUri));
                }
                attrs.setNamedItemNS(attr);
            }
            attr.setNodeValue(value);
        }
    }

    @NonNull
    static String printElement(@NonNull Node node, @NonNull Map<String, String> nsPrefix, @NonNull String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append('<');
        String uri = node.getNamespaceURI();
        if (uri != null) {
            sb.append(uri).append(':');
            nsPrefix.put(uri, node.getPrefix());
        }
        sb.append(node.getLocalName());
        MergerXmlUtils.printAttributes(sb, node, nsPrefix, prefix);
        sb.append(">\n");
        MergerXmlUtils.printChildren(sb, node.getFirstChild(), true, nsPrefix, prefix + "    ");
        sb.append(prefix).append("</");
        if (uri != null) {
            sb.append(uri).append(':');
        }
        sb.append(node.getLocalName());
        sb.append(">\n");
        return sb.toString();
    }

    @NonNull
    private static StringBuilder printChildren(@NonNull StringBuilder sb, @NonNull Node child, boolean nextSiblings, @NonNull Map<String, String> nsPrefix, @NonNull String prefix) {
        ArrayList<String> children = new ArrayList<String>();
        boolean hasText = false;
        while (child != null) {
            short t = child.getNodeType();
            if (nextSiblings && t == 3) {
                String s = child.getNodeValue().trim();
                if (s.length() > 0) {
                    sb.append(s);
                    hasText = true;
                }
            } else if (t == 1) {
                children.add(MergerXmlUtils.printElement(child, nsPrefix, prefix));
                if (!nextSiblings) break;
            }
            child = child.getNextSibling();
        }
        if (hasText) {
            sb.append('\n');
        }
        if (!children.isEmpty()) {
            Collections.sort(children);
            for (String s : children) {
                sb.append(s);
            }
        }
        return sb;
    }

    @NonNull
    private static StringBuilder printAttributes(@NonNull StringBuilder sb, @NonNull Node node, @NonNull Map<String, String> nsPrefix, @NonNull String prefix) {
        ArrayList<String> attrs = new ArrayList<String>();
        NamedNodeMap attrMap = node.getAttributes();
        if (attrMap != null) {
            StringBuilder sb2 = new StringBuilder();
            for (int i = 0; i < attrMap.getLength(); ++i) {
                Node attr = attrMap.item(i);
                if (!(attr instanceof Attr)) continue;
                sb2.setLength(0);
                sb2.append('@');
                String uri = attr.getNamespaceURI();
                if (uri != null) {
                    sb2.append(uri).append(':');
                    nsPrefix.put(uri, attr.getPrefix());
                }
                sb2.append(attr.getLocalName());
                sb2.append("=\"").append(attr.getNodeValue()).append('\"');
                attrs.add(sb2.toString());
            }
        }
        Collections.sort(attrs);
        for (String attr : attrs) {
            sb.append('\n');
            sb.append(prefix).append("    ").append(attr);
        }
        return sb;
    }

    static void printXmlDiff(StringBuilder sb, String expected, String actual, Map<String, String> nsPrefixE, Map<String, String> nsPrefixA, String keyAttr) {
        String[] aA;
        int lA;
        String[] aE = expected.split("\n");
        int lE = aE.length;
        int lm = lE < (lA = (aA = actual.split("\n")).length) ? lA : lE;
        boolean eofE = false;
        boolean eofA = false;
        boolean contextE = true;
        boolean contextA = true;
        int numDiff = 0;
        StringBuilder sE = new StringBuilder();
        StringBuilder sA = new StringBuilder();
        int iE = 0;
        int iA = 0;
        for (int i = 0; i < lm; ++i) {
            String p;
            if (iE < lE && iA < lA && aE[iE].equals(aA[iA])) {
                if (numDiff > 0) break;
                ++iE;
                ++iA;
                continue;
            }
            if (contextE) {
                if (iE > 0) {
                    p = MergerXmlUtils.diffGetPrefix(aE[iE]);
                    for (int kE = iE - 1; kE >= 0; --kE) {
                        if (!aE[kE].startsWith(p)) {
                            sE.insert(0, '\n').insert(0, MergerXmlUtils.diffReplaceNs(aE[kE], nsPrefixE)).insert(0, "  ");
                            if (p.length() == 0) break;
                            p = MergerXmlUtils.diffGetPrefix(aE[kE]);
                            continue;
                        }
                        if (!aE[kE].contains(keyAttr) && kE != 0) continue;
                        sE.insert(0, '\n').insert(0, MergerXmlUtils.diffReplaceNs(aE[kE], nsPrefixE)).insert(0, "  ");
                    }
                }
                contextE = false;
            }
            if (iE >= lE) {
                if (!eofE) {
                    sE.append("--(end reached)\n");
                    eofE = true;
                }
            } else {
                sE.append("--").append(MergerXmlUtils.diffReplaceNs(aE[iE++], nsPrefixE)).append('\n');
            }
            if (contextA) {
                if (iA > 0) {
                    p = MergerXmlUtils.diffGetPrefix(aA[iA]);
                    for (int kA = iA - 1; kA >= 0; --kA) {
                        if (!aA[kA].startsWith(p)) {
                            sA.insert(0, '\n').insert(0, MergerXmlUtils.diffReplaceNs(aA[kA], nsPrefixA)).insert(0, "  ");
                            p = MergerXmlUtils.diffGetPrefix(aA[kA]);
                            if (p.length() != 0) continue;
                            break;
                        }
                        if (!aA[kA].contains(keyAttr) && kA != 0) continue;
                        sA.insert(0, '\n').insert(0, MergerXmlUtils.diffReplaceNs(aA[kA], nsPrefixA)).insert(0, "  ");
                    }
                }
                contextA = false;
            }
            if (iA >= lA) {
                if (!eofA) {
                    sA.append("++(end reached)\n");
                    eofA = true;
                }
            } else {
                sA.append("++").append(MergerXmlUtils.diffReplaceNs(aA[iA++], nsPrefixA)).append('\n');
            }
            if (++numDiff == 3) break;
        }
        sb.append((CharSequence)sE);
        sb.append((CharSequence)sA);
    }

    private static String diffGetPrefix(String str) {
        int pos;
        int len = str.length();
        for (pos = 0; pos < len && str.charAt(pos) == ' '; ++pos) {
        }
        return str.substring(0, pos);
    }

    private static String diffReplaceNs(String str, Map<String, String> nsPrefix) {
        for (Map.Entry<String, String> entry : nsPrefix.entrySet()) {
            String uri = entry.getKey();
            String prefix = entry.getValue();
            if (prefix == null || !str.contains(uri)) continue;
            str = str.replaceAll(Pattern.quote(uri), Matcher.quoteReplacement(prefix));
        }
        return str;
    }

    @Nullable
    public static File getFileFor(@NonNull Node node) {
        return (File)node.getUserData(DATA_ORIGIN_FILE);
    }

    public static void setFileFor(Node node, File file) {
        node.setUserData(DATA_ORIGIN_FILE, file, null);
    }
}

