/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.utils.SdkUtils;

public class StatePrettyPrinter {
    private static final int SPACES_PER_INDENT = 4;
    private final String mLineSeparator = SdkUtils.getLineSeparator();
    private StringBuilder mSb = new StringBuilder(1000);
    private int mIndentLevel = 0;

    public void prettyPrint(@NonNull GLStateType name, @Nullable String value) {
        this.indentLine(this.mIndentLevel * 4);
        this.mSb.append(name.toString());
        if (value != null) {
            this.mSb.append(':');
            this.mSb.append(value);
        }
        this.mSb.append(this.mLineSeparator);
    }

    public void prettyPrint(@NonNull String s) {
        this.indentLine(this.mIndentLevel * 4);
        this.mSb.append(s);
        this.mSb.append(this.mLineSeparator);
    }

    private void indentLine(int spaces) {
        int i = 0;
        while (i < spaces) {
            this.mSb.append(' ');
            ++i;
        }
    }

    public void incrementIndentLevel() {
        ++this.mIndentLevel;
    }

    public void decrementIndentLevel() {
        --this.mIndentLevel;
    }

    public String toString() {
        return this.mSb.toString();
    }
}

