/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state;

import com.android.ide.eclipse.gltrace.state.DisplayRadix;
import com.android.ide.eclipse.gltrace.state.GLAbstractAtomicProperty;
import com.android.ide.eclipse.gltrace.state.GLStateType;

public class GLLongProperty
extends GLAbstractAtomicProperty {
    private final Long mDefaultValue;
    private Long mCurrentValue;
    private final DisplayRadix mRadix;

    public GLLongProperty(GLStateType name, Long defaultValue, DisplayRadix radix) {
        super(name);
        this.mDefaultValue = this.mCurrentValue = defaultValue;
        this.mRadix = radix;
    }

    public GLLongProperty(GLStateType name, Long defaultValue) {
        this(name, defaultValue, DisplayRadix.DECIMAL);
    }

    @Override
    public boolean isDefault() {
        return this.mDefaultValue != null & this.mDefaultValue.equals(this.mCurrentValue);
    }

    public void setValue(Long newValue) {
        this.mCurrentValue = newValue;
    }

    @Override
    public String getStringValue() {
        if (this.mRadix == DisplayRadix.HEX) {
            return String.format("0x%08x", (long)this.mCurrentValue);
        }
        return this.mCurrentValue.toString();
    }

    public String toString() {
        return (Object)((Object)this.getType()) + "=" + this.getStringValue();
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Long)) {
            throw new IllegalArgumentException("Attempt to set non-integer value for " + (Object)((Object)this.getType()));
        }
        this.mCurrentValue = (Long)value;
    }

    @Override
    public Object getValue() {
        return this.mCurrentValue;
    }
}

