/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace;

import com.android.ide.eclipse.gltrace.GLEnum;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class GLUtils {
    public static String formatData(byte[] data, GLEnum format) {
        switch (format) {
            case GL_BYTE: {
                return GLUtils.formatBytes(data, false);
            }
            case GL_UNSIGNED_BYTE: {
                return GLUtils.formatBytes(data, true);
            }
            case GL_SHORT: {
                return GLUtils.formatShorts(data, false);
            }
            case GL_UNSIGNED_SHORT: {
                return GLUtils.formatShorts(data, true);
            }
            case GL_FIXED: {
                return GLUtils.formatInts(data);
            }
            case GL_FLOAT: {
                return GLUtils.formatFloats(data);
            }
        }
        return "";
    }

    private static String formatFloats(byte[] data) {
        FloatBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
        StringBuilder sb = new StringBuilder(bb.capacity() * 3);
        while (bb.remaining() > 0) {
            sb.append(String.format("%.4f", Float.valueOf(bb.get())));
            sb.append(',');
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String formatInts(byte[] data) {
        IntBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        StringBuilder sb = new StringBuilder(bb.capacity() * 3);
        while (bb.remaining() > 0) {
            sb.append(bb.get());
            sb.append(',');
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String formatShorts(byte[] data, boolean unsigned) {
        ShortBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        StringBuilder sb = new StringBuilder(bb.capacity() * 3);
        while (bb.remaining() > 0) {
            if (unsigned) {
                sb.append(bb.get() & 0xFFFF);
            } else {
                sb.append(bb.get());
            }
            sb.append(',');
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String formatBytes(byte[] data, boolean unsigned) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        StringBuilder sb = new StringBuilder(bb.capacity() * 3);
        while (bb.remaining() > 0) {
            if (unsigned) {
                sb.append(bb.get() & 0xFF);
            } else {
                sb.append(bb.get());
            }
            sb.append(',');
            sb.append('\n');
        }
        return sb.toString();
    }
}

