/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.TextRange;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class IME
extends Widget {
    Canvas parent;
    int caretOffset;
    int startOffset;
    int commitCount;
    String text;
    int[] ranges;
    TextStyle[] styles;
    static final int UNDERLINE_IME_INPUT = 65536;
    static final int UNDERLINE_IME_TARGET_CONVERTED = 131072;
    static final int UNDERLINE_IME_CONVERTED = 196608;

    IME() {
    }

    public IME(Canvas canvas, int n) {
        super(canvas, n);
        this.parent = canvas;
        this.createWidget();
    }

    void createWidget() {
        this.text = "";
        this.startOffset = -1;
        if (this.parent.getIME() == null) {
            this.parent.setIME(this);
        }
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.startOffset + this.caretOffset;
    }

    public int getCommitCount() {
        this.checkWidget();
        return this.commitCount;
    }

    public int getCompositionOffset() {
        this.checkWidget();
        return this.startOffset;
    }

    public int[] getRanges() {
        this.checkWidget();
        if (this.ranges == null) {
            return new int[0];
        }
        int[] nArray = new int[this.ranges.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.ranges[n] + this.startOffset;
            ++n;
        }
        return nArray;
    }

    public TextStyle[] getStyles() {
        this.checkWidget();
        if (this.styles == null) {
            return new TextStyle[0];
        }
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        System.arraycopy(this.styles, 0, textStyleArray, 0, this.styles.length);
        return textStyleArray;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getWideCaret() {
        this.checkWidget();
        return false;
    }

    boolean isInlineEnabled() {
        return this.hooks(43);
    }

    int kEventTextInputOffsetToPos(int n, int n2, int n3) {
        if (!this.isInlineEnabled()) {
            return -9874;
        }
        Caret caret = this.parent.caret;
        if (caret == null) {
            return -9874;
        }
        Point point = new Point();
        int n4 = 4;
        org.eclipse.swt.graphics.Point point2 = this.parent.toDisplay(caret.x, caret.y + caret.height);
        point.h = (short)point2.x;
        point.v = (short)point2.y;
        OS.SetEventParameter(n2, 1953656948, 1363439732, n4, point);
        return 0;
    }

    int kEventTextInputPosToOffset(int n, int n2, int n3) {
        int n4;
        if (!this.isInlineEnabled()) {
            return -9874;
        }
        if (this.startOffset == -1) {
            return -9874;
        }
        Point point = new Point();
        int n5 = 4;
        OS.GetEventParameter(n2, 1953719152, 1363439732, null, n5, null, point);
        org.eclipse.swt.graphics.Point point2 = this.parent.toControl(point.h, point.v);
        Event event = new Event();
        event.detail = 2;
        event.x = point2.x;
        event.y = point2.y;
        this.sendEvent(43, event);
        int n6 = event.index + event.count;
        if (n6 == -1) {
            n4 = 1;
        } else if (this.startOffset <= n6 && n6 < this.startOffset + this.text.length()) {
            n4 = 3;
            n6 -= this.startOffset;
        } else {
            n4 = 2;
        }
        OS.SetEventParameter(n2, 1953657967, 1819242087, 4, new int[]{n6 * 2});
        OS.SetEventParameter(n2, 1953657447, 1819242087, 4, new int[]{n4});
        OS.SetEventParameter(n2, 1953655909, 1651470188, 4, new boolean[]{event.count == 0});
        return 0;
    }

    int kEventTextInputGetSelectedText(int n, int n2, int n3) {
        Event event = new Event();
        event.detail = 3;
        this.sendEvent(43, event);
        String string = event.text;
        if (string.length() > 0) {
            char[] cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
            OS.SetEventParameter(n2, 1953657976, 1970567284, cArray.length * 2, cArray);
            return 0;
        }
        return -9874;
    }

    int kEventTextInputUpdateActiveInputArea(int n, int n2, int n3) {
        int n4;
        int n5;
        if (!this.isInlineEnabled()) {
            return -9874;
        }
        this.ranges = null;
        this.styles = null;
        this.commitCount = 0;
        this.caretOffset = 0;
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1953723512, 1970567284, null, 0, nArray, null);
        char[] cArray = new char[nArray[0]];
        OS.GetEventParameter(n2, 1953723512, 1970567284, null, nArray[0], null, cArray);
        int[] nArray2 = new int[1];
        OS.GetEventParameter(n2, 1953719928, 1819242087, null, 4, null, nArray2);
        int[] nArray3 = new int[1];
        int n6 = OS.GetEventParameter(n2, 1953720425, 1953653113, null, 0, nArray3, null);
        if (n6 == 0) {
            n5 = -1;
            boolean bl = false;
            n4 = OS.NewPtr(nArray3[0]);
            OS.GetEventParameter(n2, 1953720425, 1953653113, null, nArray3[0], null, n4);
            short[] sArray = new short[1];
            OS.memmove(sArray, n4, 2);
            int n7 = sArray[0];
            if (n7 > 0) {
                TextRange textRange = new TextRange();
                this.ranges = new int[(n7 - 1) * 2];
                this.styles = new TextStyle[n7 - 1];
                int n8 = 0;
                int n9 = 0;
                while (n8 < n7) {
                    OS.memmove(textRange, n4 + 2 + n8 * 10, 10);
                    switch (textRange.fHiliteStyle) {
                        case 1: {
                            this.caretOffset = textRange.fStart / 2;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            this.ranges[n9 * 2] = textRange.fStart / 2;
                            this.ranges[n9 * 2 + 1] = textRange.fEnd / 2 - 1;
                            this.styles[n9] = new TextStyle();
                            this.styles[n9].underline = true;
                            this.styles[n9].underlineStyle = 65536;
                            if (textRange.fHiliteStyle == 4) {
                                this.styles[n9].underlineStyle = 196608;
                                bl = true;
                            }
                            if (textRange.fHiliteStyle == 5) {
                                this.styles[n9].underlineStyle = 131072;
                                if (n5 == -1) {
                                    n5 = textRange.fStart;
                                }
                            }
                            ++n9;
                        }
                    }
                    ++n8;
                }
            }
            OS.DisposePtr(n4);
            if (bl && n5 != -1) {
                this.caretOffset = n5 / 2;
            }
        }
        n5 = this.startOffset + this.text.length();
        if (this.startOffset == -1) {
            Event event = new Event();
            event.detail = 3;
            this.sendEvent(43, event);
            this.startOffset = event.start;
            n5 = event.end;
        }
        Event event = new Event();
        event.detail = 1;
        event.start = this.startOffset;
        event.end = n5;
        event.text = this.text = new String(cArray, 0, nArray[0] / 2);
        this.commitCount = nArray2[0] != -1 ? nArray2[0] / 2 : nArray[0] / 2;
        this.sendEvent(43, event);
        if (this.commitCount == this.text.length()) {
            this.text = "";
            this.commitCount = 0;
            this.caretOffset = 0;
            this.startOffset = -1;
            this.ranges = null;
            this.styles = null;
        }
        if (event.doit && (nArray2[0] == -1 || nArray2[0] == nArray[0])) {
            n4 = 0;
            while (n4 < cArray.length) {
                if (cArray[n4] == '\u0000') break;
                event = new Event();
                event.character = cArray[n4];
                this.parent.sendKeyEvent(1, event);
                ++n4;
            }
        }
        return 0;
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getIME()) {
            this.parent.setIME(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.text = null;
        this.styles = null;
        this.ranges = null;
    }

    public void setCompositionOffset(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (this.startOffset != -1) {
            this.startOffset = n;
        }
    }
}

