/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;

public final class Region
extends Resource {
    public int handle;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        super(device);
        this.handle = OS.NewRgn();
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    Region(Device device, int n) {
        super(device);
        this.handle = n;
    }

    public void add(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length < 2) {
            return;
        }
        int n = OS.NewRgn();
        OS.OpenRgn();
        OS.MoveTo((short)nArray[0], (short)nArray[1]);
        int n2 = 1;
        while (n2 < nArray.length / 2) {
            OS.LineTo((short)nArray[2 * n2], (short)nArray[2 * n2 + 1]);
            ++n2;
        }
        OS.LineTo((short)nArray[0], (short)nArray[1]);
        OS.CloseRgn(n);
        OS.UnionRgn(this.handle, n, this.handle);
        OS.DisposeRgn(n);
    }

    public void add(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (rectangle.width < 0 || rectangle.height < 0) {
            SWT.error(5);
        }
        this.add(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void add(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        int n5 = OS.NewRgn();
        Rect rect = new Rect();
        OS.SetRect(rect, (short)n, (short)n2, (short)(n + n3), (short)(n2 + n4));
        OS.RectRgn(n5, rect);
        OS.UnionRgn(this.handle, n5, this.handle);
        OS.DisposeRgn(n5);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.UnionRgn(this.handle, region.handle, this.handle);
    }

    public boolean contains(int n, int n2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        org.eclipse.swt.internal.carbon.Point point = new org.eclipse.swt.internal.carbon.Point();
        OS.SetPt(point, (short)n, (short)n2);
        return OS.PtInRgn(point, this.handle);
    }

    public boolean contains(Point point) {
        if (point == null) {
            SWT.error(4);
        }
        return this.contains(point.x, point.y);
    }

    void destroy() {
        OS.DisposeRgn(this.handle);
        this.handle = 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Rect rect = new Rect();
        OS.GetRegionBounds(this.handle, rect);
        int n = rect.right - rect.left;
        int n2 = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, n, n2);
    }

    public static Region carbon_new(Device device, int n) {
        return new Region(device, n);
    }

    public int hashCode() {
        return this.handle;
    }

    public void intersect(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void intersect(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        int n5 = OS.NewRgn();
        Rect rect = new Rect();
        OS.SetRect(rect, (short)n, (short)n2, (short)(n + n3), (short)(n2 + n4));
        OS.RectRgn(n5, rect);
        OS.SectRgn(this.handle, n5, this.handle);
        OS.DisposeRgn(n5);
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.SectRgn(this.handle, region.handle, this.handle);
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Rect rect = new Rect();
        OS.SetRect(rect, (short)n, (short)n2, (short)(n + n3), (short)(n2 + n4));
        return OS.RectInRgn(rect, this.handle);
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        return this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.EmptyRgn(this.handle);
    }

    public void subtract(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length < 2) {
            return;
        }
        int n = OS.NewRgn();
        OS.OpenRgn();
        OS.MoveTo((short)nArray[0], (short)nArray[1]);
        int n2 = 1;
        while (n2 < nArray.length / 2) {
            OS.LineTo((short)nArray[2 * n2], (short)nArray[2 * n2 + 1]);
            ++n2;
        }
        OS.LineTo((short)nArray[0], (short)nArray[1]);
        OS.CloseRgn(n);
        OS.DiffRgn(this.handle, n, this.handle);
        OS.DisposeRgn(n);
    }

    public void subtract(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.subtract(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void subtract(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        int n5 = OS.NewRgn();
        Rect rect = new Rect();
        OS.SetRect(rect, (short)n, (short)n2, (short)(n + n3), (short)(n2 + n4));
        OS.RectRgn(n5, rect);
        OS.DiffRgn(this.handle, n5, this.handle);
        OS.DisposeRgn(n5);
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.DiffRgn(this.handle, region.handle, this.handle);
    }

    public void translate(int n, int n2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.OffsetRgn(this.handle, (short)n, (short)n2);
    }

    public void translate(Point point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        this.translate(point.x, point.y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

