/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.updater;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.internal.repository.updater.ISettingsPage;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.io.IFileOp;
import com.android.utils.ILogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SettingsController {
    private static final String SETTINGS_FILENAME = "androidtool.cfg";
    private final IFileOp mFileOp;
    private final ILogger mSdkLog;
    private final Settings mSettings;
    private final List<OnChangedListener> mChangedListeners = new ArrayList<OnChangedListener>(1);
    private ISettingsPage mSettingsPage;

    public SettingsController(@NonNull ILogger sdkLog) {
        this(new FileOp(), sdkLog);
    }

    public SettingsController(@NonNull IFileOp fileOp, @NonNull ILogger sdkLog) {
        this(fileOp, sdkLog, new Settings());
    }

    protected SettingsController(@NonNull IFileOp fileOp, @NonNull ILogger sdkLog, @NonNull Settings settings) {
        this.mFileOp = fileOp;
        this.mSdkLog = sdkLog;
        this.mSettings = settings;
    }

    @NonNull
    public Settings getSettings() {
        return this.mSettings;
    }

    public void registerOnChangedListener(@Nullable OnChangedListener listener) {
        if (listener != null && !this.mChangedListeners.contains(listener)) {
            this.mChangedListeners.add(listener);
        }
    }

    public void unregisterOnChangedListener(@Nullable OnChangedListener listener) {
        if (listener != null) {
            this.mChangedListeners.remove(listener);
        }
    }

    public void setShowUpdateOnly(boolean enabled) {
        this.setSetting("sdkman.show.update.only", enabled);
    }

    public void setMonitorDensity(int density) {
        this.mSettings.mProperties.setProperty("sdkman.monitor.density", Integer.toString(density));
    }

    void setSetting(@NonNull String key, boolean value) {
        this.mSettings.mProperties.setProperty(key, Boolean.toString(value));
    }

    public void setSettingsPage(@Nullable ISettingsPage settingsPage) {
        this.mSettingsPage = settingsPage;
        if (settingsPage != null) {
            settingsPage.loadSettings(this.mSettings.mProperties);
            settingsPage.setOnSettingsChanged(new ISettingsPage.SettingsChangedCallback(){

                @Override
                public void onSettingsChanged(ISettingsPage page) {
                    SettingsController.this.onSettingsChanged();
                }
            });
        }
    }

    public void loadSettings() {
        block2: {
            String path = null;
            try {
                String folder = AndroidLocation.getFolder();
                File f = new File(folder, SETTINGS_FILENAME);
                path = f.getPath();
                Properties props = this.mFileOp.loadProperties(f);
                this.mSettings.mProperties.clear();
                this.mSettings.mProperties.putAll((Map<?, ?>)props);
                this.setShowUpdateOnly(this.mSettings.getShowUpdateOnly());
                this.setSetting("sdkman.ask.adb.restart", this.mSettings.getAskBeforeAdbRestart());
                this.setSetting("sdkman.use.dl.cache", this.mSettings.getUseDownloadCache());
            }
            catch (Exception e) {
                if (this.mSdkLog == null) break block2;
                this.mSdkLog.error((Throwable)e, "Failed to load settings from .android folder. Path is '%1$s'.", new Object[]{path});
            }
        }
    }

    public void saveSettings() {
        block2: {
            String path = null;
            try {
                String folder = AndroidLocation.getFolder();
                File f = new File(folder, SETTINGS_FILENAME);
                path = f.getPath();
                this.mFileOp.saveProperties(f, this.mSettings.mProperties, "## Settings for Android Tool");
            }
            catch (Exception e) {
                if (this.mSdkLog == null) break block2;
                String reason = null;
                reason = e instanceof FileNotFoundException ? "File not found" : (e instanceof AndroidLocation.AndroidLocationException ? ".android folder not found, please define ANDROID_SDK_HOME" : (e.getMessage() != null ? String.format("%1$s: %2$s", e.getClass().getSimpleName(), e.getMessage()) : e.getClass().getName()));
                this.mSdkLog.error((Throwable)e, "Failed to save settings file '%1$s': %2$s", new Object[]{path, reason});
            }
        }
    }

    private void onSettingsChanged() {
        if (this.mSettingsPage == null) {
            return;
        }
        Settings oldSettings = new Settings(this.mSettings);
        this.mSettingsPage.retrieveSettings(this.mSettings.mProperties);
        this.applySettings();
        this.saveSettings();
        for (OnChangedListener listener : this.mChangedListeners) {
            try {
                listener.onSettingsChanged(this, oldSettings);
            }
            catch (Throwable ignore) {}
        }
    }

    public void applySettings() {
        Properties props = System.getProperties();
        String proxyHost = this.mSettings.mProperties.getProperty("http.proxyHost", "");
        String proxyPort = this.mSettings.mProperties.getProperty("http.proxyPort", "");
        String JAVA_PROP_HTTP_PROXY_HOST = "http.proxyHost";
        String JAVA_PROP_HTTP_PROXY_PORT = "http.proxyPort";
        String JAVA_PROP_HTTPS_PROXY_HOST = "https.proxyHost";
        String JAVA_PROP_HTTPS_PROXY_PORT = "https.proxyPort";
        if (proxyHost != null && proxyHost.length() > 0) {
            props.setProperty("http.proxyHost", proxyHost);
            props.setProperty("https.proxyHost", proxyHost);
        }
        if (proxyPort != null && proxyPort.length() > 0) {
            props.setProperty("http.proxyPort", proxyPort);
            props.setProperty("https.proxyPort", proxyPort);
        }
    }

    public static class Settings {
        private final Properties mProperties;

        public Settings() {
            this.mProperties = new Properties();
        }

        public Settings(@NonNull Settings settings) {
            this();
            for (Map.Entry<Object, Object> entry : settings.mProperties.entrySet()) {
                this.mProperties.put(entry.getKey(), entry.getValue());
            }
        }

        protected Settings(@NonNull Properties properties) {
            this.mProperties = properties;
        }

        public boolean getForceHttp() {
            return Boolean.parseBoolean(this.mProperties.getProperty("sdkman.force.http"));
        }

        public boolean getAskBeforeAdbRestart() {
            return Boolean.parseBoolean(this.mProperties.getProperty("sdkman.ask.adb.restart"));
        }

        public boolean getUseDownloadCache() {
            return Boolean.parseBoolean(this.mProperties.getProperty("sdkman.use.dl.cache", Boolean.TRUE.toString()));
        }

        public boolean getShowUpdateOnly() {
            return Boolean.parseBoolean(this.mProperties.getProperty("sdkman.show.update.only", Boolean.TRUE.toString()));
        }

        public boolean getEnablePreviews() {
            return Boolean.parseBoolean(this.mProperties.getProperty("sdkman.enable.previews"));
        }

        public int getMonitorDensity() {
            String value = this.mProperties.getProperty("sdkman.monitor.density", null);
            if (value == null) {
                return -1;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
    }

    public static interface OnChangedListener {
        public void onSettingsChanged(@NonNull SettingsController var1, @NonNull Settings var2);
    }
}

