/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.tasks;

import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskFactory;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdkuilib.internal.tasks.ProgressTask;
import org.eclipse.swt.widgets.Shell;

public final class ProgressTaskFactory
implements ITaskFactory {
    private final Shell mShell;

    public ProgressTaskFactory(Shell shell) {
        this.mShell = shell;
    }

    @Override
    public void start(String title, ITask task) {
        this.start(title, null, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(String title, ITaskMonitor parentMonitor, ITask task) {
        if (parentMonitor == null) {
            ProgressTask p = new ProgressTask(this.mShell, title);
            p.start(task);
        } else {
            if (parentMonitor.getProgressMax() == 0) {
                parentMonitor.setProgressMax(1);
            }
            ITaskMonitor sub = parentMonitor.createSubMonitor(parentMonitor.getProgressMax() - parentMonitor.getProgress());
            try {
                task.run(sub);
            }
            finally {
                int delta = sub.getProgressMax() - sub.getProgress();
                if (delta > 0) {
                    sub.incProgress(delta);
                }
            }
        }
    }
}

