# Part of the A-A-P recipe executive: Testing of assignments in a recipe

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

import sys, os

def runaap(args):
    return os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))

os.chdir("rectest")

# Create a recipe, run it and check the output.
# Checks expanding $VAR.
rec = "rectest.aap"
out = "rectest.out"

f = open(rec, "w")
f.write("""
VAR = value {attr = yes}
EVAR = te$*VAR te$*(VAR)st
VAR2 = foo {attr} bar {ver = 3}
EVAR2 = te$*(VAR2).ik
all:
    :print $+EVAR
    :print $+EVAR2
""")
f.close()

res = runaap("-f %s >%s" % (rec, out))

f = open(out)
l = f.read()
ok = """tevalue{attr = yes} tevaluest{attr = yes}
tefoo.ik{attr = 1} tebar.ik{ver = 3}"""
if l != ok + "\n":
    print 'Aap returned "%s" instead of "%s"' % (l, ok)
    res = 1
f.close()

os.remove(rec)
os.remove(out)

sys.exit(res)


# vim: set sw=4 et sts=4 tw=79 fo+=l:
