/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect.lang;

import java.util.Collections;
import java.util.Set;
import opennlp.tools.sentdetect.DefaultEndOfSentenceScanner;
import opennlp.tools.sentdetect.DefaultSDContextGenerator;
import opennlp.tools.sentdetect.EndOfSentenceScanner;
import opennlp.tools.sentdetect.SDContextGenerator;
import opennlp.tools.sentdetect.lang.th.SentenceContextGenerator;

public class Factory {
    public static final char[] ptEosCharacters = new char[]{'.', '?', '!', ';', ':', '(', ')', '\u00ab', '\u00bb', '\'', '\"'};
    public static final char[] defaultEosCharacters = new char[]{'.', '!', '?'};
    public static final char[] thEosCharacters = new char[]{' ', '\n'};

    public EndOfSentenceScanner createEndOfSentenceScanner(String languageCode) {
        if ("th".equals(languageCode)) {
            return new DefaultEndOfSentenceScanner(new char[]{' ', '\n'});
        }
        if ("pt".equals(languageCode)) {
            return new DefaultEndOfSentenceScanner(ptEosCharacters);
        }
        return new DefaultEndOfSentenceScanner(defaultEosCharacters);
    }

    public EndOfSentenceScanner createEndOfSentenceScanner(char[] customEOSCharacters) {
        return new DefaultEndOfSentenceScanner(customEOSCharacters);
    }

    public SDContextGenerator createSentenceContextGenerator(String languageCode, Set<String> abbreviations) {
        if ("th".equals(languageCode)) {
            return new SentenceContextGenerator();
        }
        if ("pt".equals(languageCode)) {
            return new DefaultSDContextGenerator(abbreviations, ptEosCharacters);
        }
        return new DefaultSDContextGenerator(abbreviations, defaultEosCharacters);
    }

    public SDContextGenerator createSentenceContextGenerator(Set<String> abbreviations, char[] customEOSCharacters) {
        return new DefaultSDContextGenerator(abbreviations, customEOSCharacters);
    }

    public SDContextGenerator createSentenceContextGenerator(String languageCode) {
        return this.createSentenceContextGenerator(languageCode, Collections.emptySet());
    }

    public char[] getEOSCharacters(String languageCode) {
        if ("th".equals(languageCode)) {
            return thEosCharacters;
        }
        if ("pt".equals(languageCode)) {
            return ptEosCharacters;
        }
        return defaultEosCharacters;
    }
}

