/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.exttrans;

import java.awt.Dimension;
import java.awt.Font;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.machinetranslators.MachineTranslators;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.gui.exttrans.MachineTranslationInfo;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.preferences.PreferencesWindowController;
import org.omegat.gui.preferences.view.MachineTranslationPreferencesController;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.IPaneMenu;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class MachineTranslateTextArea
extends EntryInfoThreadPane<MachineTranslationInfo>
implements IPaneMenu {
    private static final String EXPLANATION = OStrings.getString("GUI_MACHINETRANSLATESWINDOW_explanation");
    protected List<MachineTranslationInfo> displayed = new CopyOnWriteArrayList<MachineTranslationInfo>();
    protected final DockableScrollPane scrollPane;
    private int selectedIndex;

    public MachineTranslateTextArea(IMainWindow mw) {
        super(true);
        this.setEditable(false);
        StaticUIUtils.makeCaretAlwaysVisible(this);
        this.initDocument();
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        this.selectedIndex = -1;
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_MachineTranslate");
        this.scrollPane = new DockableScrollPane("MACHINE_TRANSLATE", title, this, true);
        mw.addDockable(this.scrollPane);
        for (Class<?> mtc : PluginUtils.getMachineTranslationClasses()) {
            try {
                IMachineTranslation mt = (IMachineTranslation)mtc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                mt.setGlossarySupplier(this::getGlossaryMap);
                MachineTranslators.add(mt);
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }

    Map<String, String> getGlossaryMap() {
        return Core.getGlossaryManager().searchSourceMatches(this.currentlyProcessedEntry).stream().collect(Collectors.toMap(GlossaryEntry::getSrcText, GlossaryEntry::getLocText));
    }

    private void initDocument() {
        StyleSheet baseStyleSheet = new StyleSheet();
        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        baseStyleSheet.addStyleSheet(htmlEditorKit.getStyleSheet());
        Font font = this.getFont();
        baseStyleSheet.addRule("body { font-family: " + font.getName() + ";  font-size: " + font.getSize() + ";  font-style: " + (font.getStyle() == 2 ? "italic" : "normal") + ";  font-weight: " + (font.getStyle() == 1 ? "bold" : "normal") + ";  color: " + Styles.EditorColor.COLOR_FOREGROUND.toHex() + ";  background: " + Styles.EditorColor.COLOR_BACKGROUND.toHex() + ";} .engine {font-style: italic; text-align: right;}");
        htmlEditorKit.setStyleSheet(baseStyleSheet);
        this.setEditorKit(htmlEditorKit);
    }

    public MachineTranslationInfo getDisplayedTranslation() {
        if (this.displayed.size() == 0) {
            return null;
        }
        this.selectedIndex = (this.selectedIndex + 1) % this.displayed.size();
        MachineTranslationInfo info = this.displayed.get(this.selectedIndex);
        this.highlightSelected(this.selectedIndex, info);
        return info;
    }

    private void highlightSelected(int selectedIndex, MachineTranslationInfo info) {
        UIThreadsUtil.mustBeSwingThread();
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        Element rootElement = doc.getDefaultRootElement();
        if (rootElement == null) {
            return;
        }
        Element el = doc.getElement(rootElement, HTML.Attribute.ID, String.valueOf(selectedIndex));
        if (el == null) {
            return;
        }
        int pos = el.getStartOffset();
        try {
            this.getHighlighter().removeAllHighlights();
            this.getHighlighter().addHighlight(pos, pos + info.result.length(), new DefaultHighlighter.DefaultHighlightPainter(Styles.EditorColor.COLOR_MACHINETRANSLATE_SELECTED_HIGHLIGHT.getColor()));
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    @Override
    protected void onProjectClose() {
        UIThreadsUtil.mustBeSwingThread();
        this.setText(EXPLANATION);
    }

    public void forceLoad() {
        this.startSearchThread(this.currentlyProcessedEntry, true);
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        this.startSearchThread(newEntry, false);
    }

    private void startSearchThread(SourceTextEntry newEntry, boolean force) {
        UIThreadsUtil.mustBeSwingThread();
        this.clear();
        for (IMachineTranslation mt : MachineTranslators.getMachineTranslators()) {
            if (!mt.isEnabled()) continue;
            new FindThread(mt, newEntry, force).start();
        }
    }

    @Override
    protected void setFoundResult(SourceTextEntry se, MachineTranslationInfo data) {
        UIThreadsUtil.mustBeSwingThread();
        if (data != null && data.result != null) {
            this.displayed.add(data);
            this.displayed.sort(Comparator.comparing(info -> info.translatorName));
            StringBuilder sb = new StringBuilder("<html>");
            for (int i = 0; i < this.displayed.size(); ++i) {
                MachineTranslationInfo info2 = this.displayed.get(i);
                sb.append("<div id=\"").append(i).append("\">");
                sb.append(info2.result);
                sb.append("<div class=\"engine\">&lt;");
                sb.append(info2.translatorName);
                sb.append("&gt;</div></div>");
            }
            sb.append("</html>");
            this.setText(sb.toString());
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.getHighlighter().removeAllHighlights();
        this.displayed.clear();
        this.selectedIndex = -1;
    }

    @Override
    public void populatePaneMenu(JPopupMenu menu) {
        JMenuItem prefs = new JMenuItem(OStrings.getString("GUI_MACHINETRANSLATESWINDOW_OPEN_PREFS"));
        prefs.addActionListener(e -> new PreferencesWindowController().show(Core.getMainWindow().getApplicationFrame(), MachineTranslationPreferencesController.class));
        menu.add(prefs);
    }

    protected class FindThread
    extends EntryInfoSearchThread<MachineTranslationInfo> {
        private final IMachineTranslation translator;
        private final String src;
        private final boolean force;

        public FindThread(IMachineTranslation translator, SourceTextEntry newEntry, boolean force) {
            super(MachineTranslateTextArea.this, newEntry);
            this.translator = translator;
            this.src = newEntry.getSrcText();
            this.force = force;
        }

        @Override
        protected MachineTranslationInfo search() throws Exception {
            Language source = null;
            Language target = null;
            ProjectProperties pp = Core.getProject().getProjectProperties();
            if (pp != null) {
                source = pp.getSourceLanguage();
                target = pp.getTargetLanguage();
            }
            if (source == null || target == null) {
                return null;
            }
            String result = this.getTranslation(source, target);
            return result == null ? null : new MachineTranslationInfo(this.translator.getName(), result);
        }

        private String getTranslation(Language source, Language target) {
            if (!this.force) {
                TMXEntry entry;
                if (!Preferences.isPreferenceDefault("mt_auto_fetch", true)) {
                    return this.translator.getCachedTranslation(source, target, this.src);
                }
                if (Preferences.isPreference("mt_only_untranslated") && (entry = Core.getProject().getTranslationInfo(this.currentlyProcessedEntry)).isTranslated()) {
                    return this.translator.getCachedTranslation(source, target, this.src);
                }
            }
            try {
                return this.translator.getTranslation(source, target, this.src);
            }
            catch (Exception e) {
                Log.log(e);
                Core.getMainWindow().showTimedStatusMessageRB("MT_ENGINE_ERROR", this.translator.getName(), e.getLocalizedMessage());
                return null;
            }
        }
    }
}

