/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.spellchecker.SpellCheckerMarker;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;
import org.omegat.util.Token;
import org.omegat.util.gui.MenuItemPager;
import org.omegat.util.gui.UIThreadsUtil;
import org.openide.awt.Mnemonics;

public final class EditorPopups {
    public static void init(EditorController ec) {
        ec.registerPopupMenuConstructors(100, new SpellCheckerPopup(ec));
        ec.registerPopupMenuConstructors(200, new GoToSegmentPopup(ec));
        ec.registerPopupMenuConstructors(400, new DefaultPopup());
        ec.registerPopupMenuConstructors(500, new DuplicateSegmentsPopup(ec));
        ec.registerPopupMenuConstructors(600, new EmptyNoneTranslationPopup(ec));
        ec.registerPopupMenuConstructors(700, new InsertTagsPopup(ec));
        ec.registerPopupMenuConstructors(800, new InsertBidiPopup(ec));
    }

    private EditorPopups() {
    }

    public static class InsertBidiPopup
    implements IPopupMenuConstructor {
        protected final EditorController ec;
        protected String[] names = new String[]{"TF_MENU_EDIT_INSERT_CHARS_LRM", "TF_MENU_EDIT_INSERT_CHARS_RLM", "TF_MENU_EDIT_INSERT_CHARS_LRE", "TF_MENU_EDIT_INSERT_CHARS_RLE", "TF_MENU_EDIT_INSERT_CHARS_PDF"};
        protected String[] inserts = new String[]{"\u200e", "\u200f", "\u202a", "\u202b", "\u202c"};

        public InsertBidiPopup(EditorController ec) {
            this.ec = ec;
        }

        @Override
        public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (!isInActiveTranslation) {
                return;
            }
            JMenu submenu = new JMenu(Mnemonics.removeMnemonics((String)OStrings.getString("TF_MENU_EDIT_INSERT_CHARS")));
            for (int i = 0; i < this.names.length; ++i) {
                JMenuItem item = new JMenuItem(Mnemonics.removeMnemonics((String)OStrings.getString(this.names[i])));
                final String insertText = this.inserts[i];
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Core.getEditor().insertText(insertText);
                    }
                });
                submenu.add(item);
            }
            menu.add(submenu);
        }
    }

    public static class InsertTagsPopup
    implements IPopupMenuConstructor {
        protected final EditorController ec;

        public InsertTagsPopup(EditorController ec) {
            this.ec = ec;
        }

        @Override
        public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (!isInActiveTranslation) {
                return;
            }
            for (final TagUtil.Tag tag : TagUtil.getAllTagsMissingFromTarget()) {
                JMenuItem item = menu.add(StringUtil.format(Mnemonics.removeMnemonics((String)OStrings.getString("TF_MENU_EDIT_TAG_INSERT_N")), tag.tag));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Core.getEditor().insertTag(tag.tag);
                    }
                });
            }
            menu.addSeparator();
        }
    }

    public static class EmptyNoneTranslationPopup
    implements IPopupMenuConstructor {
        protected final EditorController ec;

        public EmptyNoneTranslationPopup(EditorController ec) {
            this.ec = ec;
        }

        @Override
        public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (!isInActiveEntry) {
                return;
            }
            menu.add(Mnemonics.removeMnemonics((String)OStrings.getString("TRANS_POP_EMPTY_TRANSLATION"))).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ec.registerEmptyTranslation();
                }
            });
            menu.add(Mnemonics.removeMnemonics((String)OStrings.getString("TRANS_POP_REMOVE_TRANSLATION"))).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ec.registerUntranslated();
                }
            });
            menu.add(Mnemonics.removeMnemonics((String)OStrings.getString("TRANS_POP_IDENTICAL_TRANSLATION"))).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ec.registerIdenticalTranslation();
                }
            });
            menu.addSeparator();
        }
    }

    public static class DuplicateSegmentsPopup
    implements IPopupMenuConstructor {
        protected final EditorController ec;

        public DuplicateSegmentsPopup(EditorController ec) {
            this.ec = ec;
        }

        @Override
        public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (!isInActiveEntry) {
                return;
            }
            SourceTextEntry ste = this.ec.getCurrentEntry();
            List<SourceTextEntry> dups = ste.getDuplicates();
            if (dups.isEmpty()) {
                return;
            }
            JMenuItem header = menu.add(StringUtil.format(Mnemonics.removeMnemonics((String)OStrings.getString("MW_GO_TO_DUPLICATE_HEADER")), dups.size()));
            header.setEnabled(false);
            MenuItemPager pager = new MenuItemPager(menu);
            for (SourceTextEntry entry : dups) {
                int entryNum = entry.entryNum();
                String label = StringUtil.format(Mnemonics.removeMnemonics((String)OStrings.getString("MW_GO_TO_DUPLICATE_ITEM")), entryNum);
                JMenuItem item = pager.add(new JMenuItem(label));
                item.addActionListener(e -> this.ec.gotoEntry(entryNum));
            }
            menu.addSeparator();
        }
    }

    public static class GoToSegmentPopup
    implements IPopupMenuConstructor {
        protected final EditorController ec;

        public GoToSegmentPopup(EditorController ec) {
            this.ec = ec;
        }

        @Override
        public void addItems(JPopupMenu menu, final JTextComponent comp, final int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (isInActiveEntry) {
                return;
            }
            JMenuItem item = menu.add(Mnemonics.removeMnemonics((String)OStrings.getString("MW_PROMPT_SEG_NR_TITLE")));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    comp.setCaretPosition(mousepos);
                    ec.goToSegmentAtLocation(comp.getCaretPosition());
                }
            });
            menu.addSeparator();
        }
    }

    public static class DefaultPopup
    implements IPopupMenuConstructor {
        @Override
        public void addItems(JPopupMenu menu, final JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            String selText = comp.getSelectedText();
            Clipboard omClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = omClipboard.getContents(this);
            boolean cutEnabled = false;
            boolean copyEnabled = false;
            boolean pasteEnabled = false;
            if (selText != null && comp.getSelectionStart() <= mousepos && mousepos <= comp.getSelectionEnd()) {
                if (isInActiveTranslation) {
                    cutEnabled = true;
                }
                copyEnabled = true;
            }
            if (contents != null && isInActiveTranslation) {
                pasteEnabled = true;
            }
            JMenuItem cutContextItem = menu.add(Mnemonics.removeMnemonics((String)OStrings.getString("CCP_CUT")));
            if (cutEnabled) {
                cutContextItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        comp.cut();
                    }
                });
            } else {
                cutContextItem.setEnabled(false);
            }
            JMenuItem copyContextItem = menu.add(Mnemonics.removeMnemonics((String)OStrings.getString("CCP_COPY")));
            if (copyEnabled) {
                copyContextItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        comp.copy();
                    }
                });
            } else {
                copyContextItem.setEnabled(false);
            }
            JMenuItem pasteContextItem = menu.add(Mnemonics.removeMnemonics((String)OStrings.getString("CCP_PASTE")));
            if (pasteEnabled) {
                pasteContextItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        comp.paste();
                    }
                });
            } else {
                pasteContextItem.setEnabled(false);
            }
            menu.addSeparator();
            JMenuItem item = menu.add(Mnemonics.removeMnemonics((String)OStrings.getString("GUI_GLOSSARYWINDOW_addentry")));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Core.getGlossary().showCreateGlossaryEntryDialog(Core.getMainWindow().getApplicationFrame());
                }
            });
            menu.addSeparator();
        }
    }

    public static class SpellCheckerPopup
    implements IPopupMenuConstructor {
        protected final EditorController ec;

        public SpellCheckerPopup(EditorController ec) {
            this.ec = ec;
        }

        @Override
        public void addItems(JPopupMenu menu, final JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (!this.ec.getSettings().isAutoSpellChecking()) {
                return;
            }
            if (!isInActiveTranslation) {
                return;
            }
            String translation = this.ec.getCurrentTranslation();
            Token tok = null;
            int relOffset = this.ec.getPositionInEntryTranslation(mousepos);
            for (Token t : Core.getProject().getTargetTokenizer().tokenizeWords(translation, ITokenizer.StemmingMode.NONE)) {
                if (t.getOffset() > relOffset || relOffset >= t.getOffset() + t.getLength()) continue;
                tok = t;
                break;
            }
            if (tok == null) {
                return;
            }
            final String word = tok.getTextFromString(translation);
            final int wordStart = mousepos - relOffset + tok.getOffset();
            final int wordLength = tok.getLength();
            final AbstractDocument xlDoc = (AbstractDocument)comp.getDocument();
            if (!Core.getSpellChecker().isCorrect(word)) {
                JMenuItem item;
                List<String> suggestions = Core.getSpellChecker().suggest(word);
                for (final String replacement : suggestions) {
                    JMenuItem item2 = menu.add(replacement);
                    item2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                int pos = comp.getCaretPosition();
                                xlDoc.replace(wordStart, wordLength, replacement, null);
                                comp.setCaretPosition(pos);
                            }
                            catch (BadLocationException exc) {
                                Log.log(exc);
                            }
                        }
                    });
                }
                if (suggestions.isEmpty()) {
                    item = menu.add(Mnemonics.removeMnemonics((String)OStrings.getString("SC_NO_SUGGESTIONS")));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                        }
                    });
                }
                menu.addSeparator();
                item = menu.add(Mnemonics.removeMnemonics((String)OStrings.getString("SC_IGNORE_ALL")));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.addIgnoreWord(word, wordStart, false);
                    }
                });
                item = menu.add(Mnemonics.removeMnemonics((String)OStrings.getString("SC_ADD_TO_DICTIONARY")));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.addIgnoreWord(word, wordStart, true);
                    }
                });
                menu.addSeparator();
            }
        }

        protected void addIgnoreWord(String word, int offset, boolean add) {
            UIThreadsUtil.mustBeSwingThread();
            if (add) {
                Core.getSpellChecker().learnWord(word);
            } else {
                Core.getSpellChecker().ignoreWord(word);
            }
            this.ec.remarkOneMarker(SpellCheckerMarker.class.getName());
        }
    }
}

