/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.tagvalidation;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.omegat.core.Core;
import org.omegat.core.data.DataUtils;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.tagvalidation.ErrorReport;
import org.omegat.core.tagvalidation.ITagValidation;
import org.omegat.core.tagvalidation.TagRepair;
import org.omegat.core.tagvalidation.TagValidation;
import org.omegat.util.Preferences;
import org.omegat.util.StreamUtil;
import org.omegat.util.TagUtil;

public class TagValidationTool
implements ITagValidation {
    static final String ALL_FILES_PATTERN = ".*";

    @Override
    public synchronized void logTagValidationErrors(List<ErrorReport> suspects) {
        if (suspects != null && !suspects.isEmpty()) {
            for (ErrorReport report : suspects) {
                System.out.println(report.entryNum);
                System.out.println(report.source);
                System.out.println(report.translation);
                for (Map.Entry<ErrorReport.TagError, List<TagUtil.Tag>> e : report.inverseReport().entrySet()) {
                    System.out.print("  ");
                    System.out.print(ErrorReport.localizedTagError(e.getKey()));
                    System.out.print(": ");
                    for (TagUtil.Tag tag : e.getValue()) {
                        System.out.print(tag);
                        System.out.print(" ");
                    }
                    System.out.println();
                }
            }
        }
    }

    @Override
    public List<ErrorReport> listInvalidTags() {
        return this.listInvalidTags(ALL_FILES_PATTERN);
    }

    @Override
    public List<ErrorReport> listInvalidTags(String sourcePattern) {
        return Core.getProject().getProjectFiles().stream().filter(StreamUtil.patternFilter(sourcePattern, fi -> fi.filePath)).flatMap(fi -> fi.entries.stream().map(ste -> {
            TMXEntry te = Core.getProject().getTranslationInfo((SourceTextEntry)ste);
            if (sourcePattern.equals(ALL_FILES_PATTERN) && DataUtils.isDuplicate(ste, te)) {
                return null;
            }
            return this.checkEntry((IProject.FileInfo)fi, (SourceTextEntry)ste, te);
        })).filter(report -> report != null && !report.isEmpty()).collect(Collectors.toList());
    }

    @Override
    public boolean checkInvalidTags(SourceTextEntry ste) {
        Optional<Boolean> result = Core.getProject().getProjectFiles().stream().filter(fi -> fi.entries.contains(ste)).findFirst().map(fi -> this.checkEntry((IProject.FileInfo)fi, ste, Core.getProject().getTranslationInfo(ste)).isEmpty());
        if (result.isPresent()) {
            return result.get();
        }
        throw new RuntimeException("Invalid SourceTextEntry storage for tag validation");
    }

    private ErrorReport checkEntry(IProject.FileInfo fi, SourceTextEntry ste, TMXEntry te) {
        ErrorReport report = new ErrorReport(ste, te);
        if (!te.isTranslated() || ste.getSrcText().isEmpty()) {
            return report;
        }
        if (Preferences.isPreference("tagValidation_elaborateCheck")) {
            TagValidation.inspectPrintfVariables(false, report);
        } else if (Preferences.isPreference("tagValidation_simpleCheck")) {
            TagValidation.inspectPrintfVariables(true, report);
        }
        if (fi.filterClass.getCanonicalName().equals("PoFilter")) {
            TagValidation.inspectPOWhitespace(report);
        }
        TagValidation.inspectOmegaTTags(ste, report);
        if (Preferences.isPreference("tagValidation_javaMessageFormatSimplePatternCheck")) {
            TagValidation.inspectJavaMessageFormat(report);
        }
        TagValidation.inspectRemovePattern(report);
        return report;
    }

    public static String fixErrors(ErrorReport report) {
        if (report.srcErrors.containsValue((Object)ErrorReport.TagError.UNSPECIFIED) || report.transErrors.containsValue((Object)ErrorReport.TagError.UNSPECIFIED)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(report.translation);
        Stream.of(report.srcErrors, report.transErrors).flatMap(m -> m.entrySet().stream()).sorted(Comparator.comparing(e -> ((TagUtil.Tag)e.getKey()).pos)).forEach(e -> TagRepair.fixTag(report.ste, (TagUtil.Tag)e.getKey(), (ErrorReport.TagError)((Object)((Object)e.getValue())), sb, report.source));
        return sb.toString();
    }
}

