/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.File;
import java.io.IOException;
import opennlp.tools.ml.maxent.io.GISModelReader;
import opennlp.tools.ml.maxent.io.QNModelReader;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.AbstractModelReader;
import opennlp.tools.ml.model.DataReader;
import opennlp.tools.ml.model.GenericModelWriter;
import opennlp.tools.ml.perceptron.PerceptronModelReader;

public class GenericModelReader
extends AbstractModelReader {
    private AbstractModelReader delegateModelReader;

    public GenericModelReader(File f) throws IOException {
        super(f);
    }

    public GenericModelReader(DataReader dataReader) {
        super(dataReader);
    }

    @Override
    public void checkModelType() throws IOException {
        String modelType = this.readUTF();
        if (modelType.equals("Perceptron")) {
            this.delegateModelReader = new PerceptronModelReader(this.dataReader);
        } else if (modelType.equals("GIS")) {
            this.delegateModelReader = new GISModelReader(this.dataReader);
        } else if (modelType.equals("QN")) {
            this.delegateModelReader = new QNModelReader(this.dataReader);
        } else {
            throw new IOException("Unknown model format: " + modelType);
        }
    }

    @Override
    public AbstractModel constructModel() throws IOException {
        return this.delegateModelReader.constructModel();
    }

    public static void main(String[] args) throws IOException {
        AbstractModel m = new GenericModelReader(new File(args[0])).getModel();
        new GenericModelWriter(m, new File(args[1])).persist();
    }
}

