/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.input.BOMInputStream;
import org.omegat.core.dictionaries.DictionaryData;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.core.dictionaries.IDictionaryFactory;
import org.omegat.util.Language;

public class LingvoDSL
implements IDictionaryFactory {
    protected static final Pattern RE_SKIP = Pattern.compile("\\[.+?\\]");
    protected static final String[] EMPTY_RESULT = new String[0];

    @Override
    public boolean isSupportedFile(File file) {
        return file.getPath().endsWith(".dsl") || file.getPath().endsWith(".dsl.dz");
    }

    @Override
    public IDictionary loadDict(File file) throws Exception {
        return this.loadDict(file, new Language(Locale.getDefault()));
    }

    @Override
    public IDictionary loadDict(File file, Language language) throws Exception {
        return new LingvoDSLDict(file, language);
    }

    static class LingvoDSLDict
    implements IDictionary {
        protected final DictionaryData<String> data;

        LingvoDSLDict(File file, Language language) throws Exception {
            this.data = new DictionaryData(language);
            this.readDslFile(file);
        }

        private void readDslFile(File file) throws IOException {
            try (FileInputStream fis = new FileInputStream(file);){
                InputStream is = file.getName().endsWith(".dz") ? new GZIPInputStream((InputStream)fis, 8192) : fis;
                try (BOMInputStream bis = new BOMInputStream(is);){
                    Charset charset = bis.hasBOM() ? StandardCharsets.UTF_8 : StandardCharsets.UTF_16;
                    try (InputStreamReader isr = new InputStreamReader((InputStream)bis, charset);
                         BufferedReader reader = new BufferedReader(isr);){
                        this.loadData(reader.lines());
                    }
                }
            }
        }

        private void loadData(Stream<String> stream) {
            StringBuilder word = new StringBuilder();
            StringBuilder trans = new StringBuilder();
            stream.filter(line -> !line.isEmpty() && !line.startsWith("#")).map(line -> RE_SKIP.matcher((CharSequence)line).replaceAll("")).forEach(line -> {
                if (Character.isWhitespace(line.codePointAt(0))) {
                    trans.append(line.trim()).append('\n');
                } else {
                    if (word.length() > 0) {
                        this.data.add(word.toString(), trans.toString());
                        word.setLength(0);
                        trans.setLength(0);
                    }
                    word.append((String)line);
                }
            });
            if (word.length() > 0) {
                this.data.add(word.toString(), trans.toString());
            }
            this.data.done();
        }

        @Override
        public List<DictionaryEntry> readArticles(String word) {
            return this.data.lookUp(word).stream().map(e -> new DictionaryEntry((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }

        @Override
        public List<DictionaryEntry> readArticlesPredictive(String word) {
            return this.data.lookUpPredictive(word).stream().map(e -> new DictionaryEntry((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }
    }
}

