/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import javax.swing.JComponent;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.EditingBehaviorPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class EditingBehaviorController
extends BasePreferencesController {
    private EditingBehaviorPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_EDITING_BEHAVIOR");
    }

    private void initGui() {
        this.panel = new EditingBehaviorPanel();
        this.panel.insertFuzzyCheckBox.addActionListener(e -> {
            this.panel.similarityLabel.setEnabled(this.panel.insertFuzzyCheckBox.isSelected());
            this.panel.similaritySpinner.setEnabled(this.panel.insertFuzzyCheckBox.isSelected());
            this.panel.prefixLabel.setEnabled(this.panel.insertFuzzyCheckBox.isSelected());
            this.panel.prefixText.setEnabled(this.panel.insertFuzzyCheckBox.isSelected());
        });
    }

    @Override
    protected void initFromPrefs() {
        this.panel.defaultRadio.setSelected(!Preferences.isPreference("wf_noSourceText"));
        this.panel.leaveEmptyRadio.setSelected(Preferences.isPreference("wf_noSourceText"));
        this.panel.insertFuzzyCheckBox.setSelected(Preferences.isPreference("wf_insertBestMatch"));
        this.panel.similaritySpinner.setValue(Preferences.getPreferenceDefault("wf_minimalSimilarity", 80));
        if (!Preferences.existsPreference("wf_explanatoryText")) {
            this.panel.prefixText.setText(OStrings.getString("WF_DEFAULT_PREFIX"));
        } else {
            this.panel.prefixText.setText(Preferences.getPreference("wf_explanatoryText"));
        }
        this.panel.allowTranslationEqualToSource.setSelected(Preferences.isPreference("wf_allowTransEqualToSrc"));
        this.panel.exportCurrentSegment.setSelected(Preferences.isPreference("wf_exportCurrentSegment"));
        this.panel.stopOnAlternativeTranslation.setSelected(Preferences.isPreference("wf_stopOnAlternativeTranslation"));
        this.panel.convertNumbers.setSelected(Preferences.isPreference("wf_convertNumbers"));
        this.panel.allowTagEditing.setSelected(Preferences.isPreference("allowTagEditing"));
        this.panel.tagValidateOnLeave.setSelected(Preferences.isPreference("tagValidateOnLeave"));
        this.panel.cbSaveAutoStatus.setSelected(Preferences.isPreference("save_auto_status"));
        this.panel.initialSegCountSpinner.setValue(Preferences.getPreferenceDefault("editor_initial_segment_load_count", 2000));
        this.panel.paraMarkText.setText(Preferences.getPreferenceDefault("mark_para_delimitation_text", "\u2014 \u00b6 \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014"));
        this.updateEnabledness();
    }

    @Override
    public void restoreDefaults() {
        this.panel.defaultRadio.setSelected(true);
        this.panel.leaveEmptyRadio.setSelected(false);
        this.panel.insertFuzzyCheckBox.setSelected(false);
        this.panel.similaritySpinner.setValue(80);
        this.panel.prefixText.setText(OStrings.getString("WF_DEFAULT_PREFIX"));
        this.panel.allowTranslationEqualToSource.setSelected(false);
        this.panel.exportCurrentSegment.setSelected(false);
        this.panel.stopOnAlternativeTranslation.setSelected(false);
        this.panel.convertNumbers.setSelected(false);
        this.panel.allowTagEditing.setSelected(false);
        this.panel.tagValidateOnLeave.setSelected(false);
        this.panel.cbSaveAutoStatus.setSelected(false);
        this.panel.initialSegCountSpinner.setValue(2000);
        this.panel.paraMarkText.setText("\u2014 \u00b6 \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
        this.updateEnabledness();
    }

    private void updateEnabledness() {
        this.panel.similarityLabel.setEnabled(this.panel.insertFuzzyCheckBox.isSelected());
        this.panel.similaritySpinner.setEnabled(this.panel.insertFuzzyCheckBox.isSelected());
        this.panel.prefixLabel.setEnabled(this.panel.insertFuzzyCheckBox.isSelected());
        this.panel.prefixText.setEnabled(this.panel.insertFuzzyCheckBox.isSelected());
    }

    @Override
    public void persist() {
        Preferences.setPreference("wf_noSourceText", this.panel.leaveEmptyRadio.isSelected());
        Preferences.setPreference("wf_insertBestMatch", this.panel.insertFuzzyCheckBox.isSelected());
        if (this.panel.insertFuzzyCheckBox.isSelected()) {
            int val = Math.max(0, Math.min(100, (Integer)this.panel.similaritySpinner.getValue()));
            Preferences.setPreference("wf_minimalSimilarity", val);
            Preferences.setPreference("wf_explanatoryText", this.panel.prefixText.getText());
        }
        Preferences.setPreference("wf_allowTransEqualToSrc", this.panel.allowTranslationEqualToSource.isSelected());
        Preferences.setPreference("wf_exportCurrentSegment", this.panel.exportCurrentSegment.isSelected());
        Preferences.setPreference("wf_stopOnAlternativeTranslation", this.panel.stopOnAlternativeTranslation.isSelected());
        Preferences.setPreference("wf_convertNumbers", this.panel.convertNumbers.isSelected());
        Preferences.setPreference("allowTagEditing", this.panel.allowTagEditing.isSelected());
        Preferences.setPreference("tagValidateOnLeave", this.panel.tagValidateOnLeave.isSelected());
        Preferences.setPreference("save_auto_status", this.panel.cbSaveAutoStatus.isSelected());
        int segCount = Math.max(0, (Integer)this.panel.initialSegCountSpinner.getValue());
        Preferences.setPreference("editor_initial_segment_load_count", segCount);
        Preferences.setPreference("mark_para_delimitation_text", this.panel.paraMarkText.getText());
    }
}

