/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.IProject;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IStopped;
import org.omegat.core.matching.FuzzyMatcher;
import org.omegat.core.matching.ISimilarityCalculator;
import org.omegat.core.matching.LevenshteinDistance;
import org.omegat.core.matching.NearString;
import org.omegat.core.segmentation.Rule;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.TMXProp;
import org.omegat.util.Token;

public class FindMatches {
    static final int PENALTY_FOR_FUZZY = 40;
    private static final int PENALTY_FOR_REMOVED = 5;
    private static final int SUBSEGMENT_MATCH_THRESHOLD = 85;
    private static final Pattern SEARCH_FOR_PENALTY = Pattern.compile("penalty-(\\d+)");
    private static final String ORPHANED_FILE_NAME = OStrings.getString("CT_ORPHAN_STRINGS");
    private final ISimilarityCalculator distance = new LevenshteinDistance();
    private final Pattern removePattern = PatternConsts.getRemovePattern();
    private final IProject project;
    private final ITokenizer tok;
    private final Locale srcLocale;
    private final int maxCount;
    private List<NearString> result;
    private final boolean searchExactlyTheSame;
    private String srcText;
    private String removedText;
    private Token[] strTokensStem;
    private Token[] strTokensNoStem;
    private Token[] strTokensAll;
    private FindMatches separateSegmentMatcher;
    private int fuzzyMatchThreshold = 30;
    Map<String, Token[]> tokenizeStemCache = new HashMap<String, Token[]>();
    Map<String, Token[]> tokenizeNoStemCache = new HashMap<String, Token[]>();
    Map<String, Token[]> tokenizeAllCache = new HashMap<String, Token[]>();

    public FindMatches(IProject project, int maxCount, boolean allowSeparateSegmentMatch, boolean searchExactlyTheSame) {
        this.project = project;
        this.tok = project.getSourceTokenizer();
        this.srcLocale = project.getProjectProperties().getSourceLanguage().getLocale();
        this.maxCount = maxCount;
        this.searchExactlyTheSame = searchExactlyTheSame;
        if (allowSeparateSegmentMatch && !project.getProjectProperties().isSentenceSegmentingEnabled()) {
            this.separateSegmentMatcher = new FindMatches(project, 1, false, true);
        }
        this.fuzzyMatchThreshold = Preferences.getPreferenceDefault("ext_tmx_fuzzy_match_threshold", 30);
    }

    public List<NearString> search(final String searchText, final boolean requiresTranslation, boolean fillSimilarityData, final IStopped stop) throws StoppedException {
        this.result = new ArrayList<NearString>(6);
        this.srcText = searchText;
        this.removedText = "";
        if (this.removePattern != null) {
            StringBuilder removedBuffer = new StringBuilder();
            Iterator<SourceTextEntry> removeMatcher = this.removePattern.matcher(this.srcText);
            while (((Matcher)((Object)removeMatcher)).find()) {
                removedBuffer.append(((Matcher)((Object)removeMatcher)).group());
            }
            this.srcText = ((Matcher)((Object)removeMatcher)).replaceAll("");
            this.removedText = removedBuffer.toString();
        }
        this.strTokensStem = this.tokenizeStem(this.srcText);
        this.strTokensNoStem = this.tokenizeNoStem(this.srcText);
        this.strTokensAll = this.tokenizeAll(this.srcText);
        if (this.project.getProjectProperties().isSupportDefaultTranslations()) {
            this.project.iterateByDefaultTranslations(new IProject.DefaultTranslationsIterator(){

                @Override
                public void iterate(String source, TMXEntry trans) {
                    FindMatches.this.checkStopped(stop);
                    if (!FindMatches.this.searchExactlyTheSame && source.equals(searchText)) {
                        return;
                    }
                    if (requiresTranslation && trans.translation == null) {
                        return;
                    }
                    String fileName = FindMatches.this.project.isOrphaned(source) ? ORPHANED_FILE_NAME : null;
                    FindMatches.this.processEntry(null, source, trans.translation, NearString.MATCH_SOURCE.MEMORY, false, 0, fileName, trans.creator, trans.creationDate, trans.changer, trans.changeDate, null);
                }
            });
        }
        this.project.iterateByMultipleTranslations(new IProject.MultipleTranslationsIterator(){

            @Override
            public void iterate(EntryKey source, TMXEntry trans) {
                FindMatches.this.checkStopped(stop);
                if (!FindMatches.this.searchExactlyTheSame && source.sourceText.equals(searchText)) {
                    return;
                }
                if (requiresTranslation && trans.translation == null) {
                    return;
                }
                String fileName = FindMatches.this.project.isOrphaned(source) ? ORPHANED_FILE_NAME : null;
                FindMatches.this.processEntry(source, source.sourceText, trans.translation, NearString.MATCH_SOURCE.MEMORY, false, 0, fileName, trans.creator, trans.creationDate, trans.changer, trans.changeDate, null);
            }
        });
        int foreignPenalty = Preferences.getPreferenceDefault("penalty_foreign_matches", 30);
        for (Map.Entry entry : this.project.getTransMemories().entrySet()) {
            int penalty = 0;
            Matcher matcher = SEARCH_FOR_PENALTY.matcher((CharSequence)entry.getKey());
            if (matcher.find()) {
                penalty = Integer.parseInt(matcher.group(1));
            }
            for (PrepareTMXEntry tmen : ((ExternalTMX)entry.getValue()).getEntries()) {
                this.checkStopped(stop);
                if (tmen.source == null || requiresTranslation && tmen.translation == null) continue;
                int tmenPenalty = penalty;
                if (tmen.hasPropValue("foreignMatch", "true")) {
                    tmenPenalty += foreignPenalty;
                }
                this.processEntry(null, tmen.source, tmen.translation, NearString.MATCH_SOURCE.TM, false, tmenPenalty, (String)entry.getKey(), tmen.creator, tmen.creationDate, tmen.changer, tmen.changeDate, tmen.otherProperties);
            }
        }
        for (SourceTextEntry sourceTextEntry : this.project.getAllEntries()) {
            this.checkStopped(stop);
            if (sourceTextEntry.getSourceTranslation() == null) continue;
            this.processEntry(sourceTextEntry.getKey(), sourceTextEntry.getSrcText(), sourceTextEntry.getSourceTranslation(), NearString.MATCH_SOURCE.MEMORY, sourceTextEntry.isSourceTranslationFuzzy(), 0, sourceTextEntry.getKey().file, "", 0L, "", 0L, null);
        }
        if (this.separateSegmentMatcher != null) {
            ArrayList<StringBuilder> spaces = new ArrayList<StringBuilder>();
            ArrayList<Rule> arrayList = new ArrayList<Rule>();
            Language sourceLang = this.project.getProjectProperties().getSourceLanguage();
            Language targetLang = this.project.getProjectProperties().getTargetLanguage();
            List<String> segments = Core.getSegmenter().segment(sourceLang, this.srcText, spaces, arrayList);
            if (segments.size() > 1) {
                ArrayList<String> fsrc = new ArrayList<String>(segments.size());
                ArrayList<String> ftrans = new ArrayList<String>(segments.size());
                for (int i = 0; i < segments.size(); i = (int)((short)(i + 1))) {
                    String onesrc = segments.get(i);
                    List<NearString> segmentMatch = this.separateSegmentMatcher.search(onesrc, requiresTranslation, false, stop);
                    if (!segmentMatch.isEmpty() && segmentMatch.get((int)0).scores[0].score >= 85) {
                        fsrc.add(segmentMatch.get((int)0).source);
                        ftrans.add(segmentMatch.get((int)0).translation);
                        continue;
                    }
                    fsrc.add("");
                    ftrans.add("");
                }
                String foundSrc = Core.getSegmenter().glue(sourceLang, sourceLang, fsrc, spaces, arrayList);
                String foundTrans = Core.getSegmenter().glue(sourceLang, targetLang, ftrans, spaces, arrayList);
                this.processEntry(null, foundSrc, foundTrans, NearString.MATCH_SOURCE.TM, false, 0, "", "", 0L, "", 0L, null);
            }
        }
        if (fillSimilarityData) {
            for (NearString nearString : this.result) {
                byte[] similarityData = FuzzyMatcher.buildSimilarityData(this.strTokensAll, this.tokenizeAll(nearString.source));
                nearString.attr = similarityData;
            }
        }
        return this.result;
    }

    protected void processEntry(EntryKey key, String source, String translation, NearString.MATCH_SOURCE comesFrom, boolean fuzzy, int penalty, String tmxName, String creator, long creationDate, String changer, long changedDate, List<TMXProp> props) {
        String realSource = source;
        int realPenaltyForRemoved = 0;
        if (this.removePattern != null) {
            StringBuilder entryRemovedText = new StringBuilder();
            Matcher removeMatcher = this.removePattern.matcher(realSource);
            while (removeMatcher.find()) {
                entryRemovedText.append(removeMatcher.group());
            }
            realSource = removeMatcher.replaceAll("");
            if (!entryRemovedText.toString().equals(this.removedText)) {
                realPenaltyForRemoved = 5;
            }
        }
        Token[] candTokens = this.tokenizeStem(realSource);
        int similarityStem = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensStem, candTokens);
        similarityStem -= penalty;
        if (fuzzy) {
            similarityStem -= 40;
        }
        if (!this.haveChanceToAdd(similarityStem -= realPenaltyForRemoved, Integer.MAX_VALUE, Integer.MAX_VALUE)) {
            return;
        }
        Token[] candTokensNoStem = this.tokenizeNoStem(realSource);
        int similarityNoStem = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensNoStem, candTokensNoStem);
        similarityNoStem -= penalty;
        if (fuzzy) {
            similarityNoStem -= 40;
        }
        if (!this.haveChanceToAdd(similarityStem, similarityNoStem -= realPenaltyForRemoved, Integer.MAX_VALUE)) {
            return;
        }
        Token[] candTokensAll = this.tokenizeAll(realSource);
        int simAdjusted = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensAll, candTokensAll);
        simAdjusted -= penalty;
        if (fuzzy) {
            simAdjusted -= 40;
        }
        if (!this.haveChanceToAdd(similarityStem, similarityNoStem, simAdjusted -= realPenaltyForRemoved)) {
            return;
        }
        this.addNearString(key, source, translation, comesFrom, fuzzy, similarityStem, similarityNoStem, simAdjusted, null, tmxName, creator, creationDate, changer, changedDate, props);
    }

    protected boolean haveChanceToAdd(int simStem, int simNoStem, int simExactly) {
        if (simStem < this.fuzzyMatchThreshold && simNoStem < this.fuzzyMatchThreshold) {
            return false;
        }
        if (this.result.size() < this.maxCount) {
            return true;
        }
        NearString st = this.result.get(this.result.size() - 1);
        int chance = Integer.compare(st.scores[0].score, simStem);
        if (chance == 0) {
            chance = Integer.compare(st.scores[0].scoreNoStem, simNoStem);
        }
        if (chance == 0) {
            chance = Integer.compare(st.scores[0].adjustedScore, simExactly);
        }
        return chance != 1;
    }

    protected void addNearString(EntryKey key, String source, String translation, NearString.MATCH_SOURCE comesFrom, boolean fuzzy, int similarity, int similarityNoStem, int simAdjusted, byte[] similarityData, String tmxName, String creator, long creationDate, String changer, long changedDate, List<TMXProp> tuProperties) {
        int pos = 0;
        for (int i = 0; i < this.result.size(); ++i) {
            NearString st = this.result.get(i);
            if (source.equals(st.source) && Objects.equals(translation, st.translation)) {
                this.result.set(i, NearString.merge(st, key, source, translation, comesFrom, fuzzy, similarity, similarityNoStem, simAdjusted, similarityData, tmxName, creator, creationDate, changer, changedDate, tuProperties));
                return;
            }
            if (st.scores[0].score < similarity || st.scores[0].score == similarity && (st.scores[0].scoreNoStem < similarityNoStem || st.scores[0].scoreNoStem == similarityNoStem && (st.scores[0].adjustedScore < simAdjusted || similarity == 100 && !st.source.equals(this.srcText) && source.equals(this.srcText)))) break;
            pos = i + 1;
        }
        this.result.add(pos, new NearString(key, source, translation, comesFrom, fuzzy, similarity, similarityNoStem, simAdjusted, similarityData, tmxName, creator, creationDate, changer, changedDate, tuProperties));
        if (this.result.size() > this.maxCount) {
            this.result.remove(this.result.size() - 1);
        }
    }

    public Token[] tokenizeStem(String str) {
        Token[] result = this.tokenizeStemCache.get(str);
        if (result == null) {
            result = this.tok.tokenizeWords(str, ITokenizer.StemmingMode.MATCHING);
            this.tokenizeStemCache.put(str, result);
        }
        return result;
    }

    public Token[] tokenizeNoStem(String str) {
        Token[] result = this.tokenizeNoStemCache.get(str = str.toLowerCase(this.srcLocale));
        if (result == null) {
            result = this.tok.tokenizeWords(str, ITokenizer.StemmingMode.NONE);
            this.tokenizeNoStemCache.put(str, result);
        }
        return result;
    }

    public Token[] tokenizeAll(String str) {
        Token[] result = this.tokenizeAllCache.get(str = str.toLowerCase(this.srcLocale));
        if (result == null) {
            result = this.tok.tokenizeVerbatim(str);
            this.tokenizeAllCache.put(str, result);
        }
        return result;
    }

    protected void checkStopped(IStopped stop) throws StoppedException {
        if (stop.isStopped()) {
            throw new StoppedException();
        }
    }

    public static class StoppedException
    extends RuntimeException {
    }
}

