/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVPropertiesHandler;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.xml.sax.Attributes;

public class DAVLockHandler
extends BasicDAVHandler {
    private boolean myIsHandlingToken;
    private String myID;
    private String myComment;
    private String myExpiration;

    public static StringBuffer generateGetLockRequest(StringBuffer body) {
        return DAVPropertiesHandler.generatePropertiesRequest(body, new DAVElement[]{DAVElement.LOCK_DISCOVERY});
    }

    public static StringBuffer generateSetLockRequest(StringBuffer xmlBuffer, String comment) {
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("D", "lockinfo", DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, xmlBuffer);
        SVNXMLUtil.openXMLTag("D", "lockscope", 1, null, xmlBuffer);
        SVNXMLUtil.openXMLTag("D", "exclusive", 4, null, xmlBuffer);
        SVNXMLUtil.closeXMLTag("D", "lockscope", xmlBuffer);
        SVNXMLUtil.openXMLTag("D", "locktype", 1, null, xmlBuffer);
        SVNXMLUtil.openXMLTag("D", "write", 4, null, xmlBuffer);
        SVNXMLUtil.closeXMLTag("D", "locktype", xmlBuffer);
        comment = comment == null ? "" : comment;
        SVNXMLUtil.openCDataTag("D", "owner", comment, xmlBuffer);
        SVNXMLUtil.addXMLFooter("D", "lockinfo", xmlBuffer);
        return xmlBuffer;
    }

    public DAVLockHandler() {
        this.init();
    }

    public String getComment() {
        return this.myComment;
    }

    public String getExpiration() {
        return this.myExpiration;
    }

    public String getID() {
        return this.myID;
    }

    @Override
    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) {
        if (element == DAVElement.LOCK_TOKEN) {
            this.myIsHandlingToken = true;
        }
    }

    @Override
    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) {
        if (element == DAVElement.HREF && this.myIsHandlingToken && cdata != null) {
            this.myID = cdata.toString();
        } else if (element == DAVElement.LOCK_TOKEN) {
            this.myIsHandlingToken = false;
        } else if (element == DAVElement.LOCK_OWNER && cdata != null) {
            this.myComment = cdata.toString();
        } else if (element == DAVElement.LOCK_TIMEOUT && cdata != null) {
            this.myExpiration = cdata.toString();
        }
    }
}

