/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2.impl;

import gen.core.project.RepositoryDefinition;
import gen.core.project.RepositoryMapping;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.omegat.core.Core;
import org.omegat.core.team2.IRemoteRepository2;
import org.omegat.core.team2.ProjectTeamSettings;
import org.omegat.util.Log;

public class FileRepository
implements IRemoteRepository2 {
    private static final Logger LOGGER = Logger.getLogger(FileRepository.class.getName());
    private RepositoryDefinition config;
    private File baseDirectory;

    @Override
    public void init(RepositoryDefinition repo, File dir, ProjectTeamSettings teamSettings) throws Exception {
        Log.logDebug(LOGGER, "Initialize file repository", new Object[0]);
        this.config = repo;
        this.baseDirectory = dir;
    }

    @Override
    public String getFileVersion(String file) throws Exception {
        return null;
    }

    @Override
    public void switchToVersion(String version) throws Exception {
        if (version != null) {
            throw new RuntimeException("Not supported");
        }
        Log.logDebug(LOGGER, "Update to latest", new Object[0]);
        File baseSource = new File(this.config.getUrl());
        if (!baseSource.isAbsolute()) {
            baseSource = new File(Core.getProject().getProjectProperties().getProjectRootDir(), this.config.getUrl());
            Log.logDebug(LOGGER, "Using base directory \"" + baseSource.getCanonicalPath() + "\"", new Object[0]);
        }
        for (RepositoryMapping m : this.config.getMapping()) {
            File src = new File(baseSource, m.getRepository());
            File dst = new File(this.baseDirectory, m.getRepository());
            Log.logDebug(LOGGER, "Copy \"" + src.getAbsolutePath() + "\" to \"" + dst.getAbsolutePath() + "\".", new Object[0]);
            this.copyFiles(src, dst);
        }
    }

    private void copyFiles(File src, File dst) throws IOException {
        dst.getParentFile().mkdirs();
        String repoDir = new File(".repositories/").getName();
        if (src.exists() && src.isDirectory()) {
            for (File f : src.listFiles()) {
                if (f.getName().equals(repoDir)) continue;
                this.copyFiles(f, new File(dst, f.getName()));
            }
        } else {
            FileUtils.copyFile(src, dst);
        }
    }

    @Override
    public void addForCommit(String path) throws Exception {
        Log.logDebug(LOGGER, String.format("Cannot add files for commit for File repositories. Skipping \"%s\".", path), new Object[0]);
    }

    @Override
    public String commit(String[] onVersions, String comment) throws Exception {
        Log.logDebug(LOGGER, "Commit not supported for File repositories.", new Object[0]);
        return null;
    }
}

