/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking.ui;

import com.vlsolutions.swing.toolbars.ToolBarPanelBorder;
import java.awt.Color;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;

public class DockingUISettings {
    static DockingUISettings instance = null;
    protected boolean isSettingsInstalled = false;
    private Color shadow = UIManager.getColor("controlShadow");
    private Color highlight = UIManager.getColor("controlLtHighlight");
    private Color darkShadow = UIManager.getColor("controlDkShadow");

    public static DockingUISettings getInstance() {
        if (instance == null) {
            instance = new DockingUISettings();
        }
        return instance;
    }

    public static void setInstance(DockingUISettings newInstance) {
        instance = newInstance;
    }

    public void installUI() {
        if (!this.isSettingsInstalled) {
            this.installColors();
            this.installAutoHideSettings();
            this.installBorderSettings();
            this.installDockViewSettings();
            this.installDockViewTitleBarSettings();
            this.installSplitContainerSettings();
            this.installCloseableTabs();
            this.installTabbedContainerSettings();
            this.installIcons();
            this.installAccelerators();
            this.installDesktopSettings();
            this.installFloatingSettings();
            this.installToolBarSettings();
            this.isSettingsInstalled = true;
        }
    }

    public void updateUI() {
        this.isSettingsInstalled = false;
        this.installUI();
    }

    public void installBorderSettings() {
        CompoundBorder innerFlatSingleBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, this.highlight), BorderFactory.createMatteBorder(0, 0, 1, 1, this.shadow));
        CompoundBorder flatSingleBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), innerFlatSingleBorder);
        UIManager.put("DockView.singleDockableBorder", flatSingleBorder);
        UIManager.put("DockView.tabbedDockableBorder", null);
        UIManager.put("DockView.maximizedDockableBorder", null);
    }

    public void installAutoHideSettings() {
        UIManager.put("AutoHideButtonUI", "com.vlsolutions.swing.docking.ui.AutoHideButtonUI");
        UIManager.put("AutoHideButtonPanelUI", "com.vlsolutions.swing.docking.ui.AutoHideButtonPanelUI");
        UIManager.put("AutoHideExpandPanelUI", "com.vlsolutions.swing.docking.ui.AutoHideExpandPanelUI");
        UIManager.put("AutoHideButton.expandBorderTop", BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, this.shadow), BorderFactory.createMatteBorder(1, 1, 0, 1, this.highlight)), BorderFactory.createEmptyBorder(0, 6, 0, 6)));
        UIManager.put("AutoHideButton.expandBorderBottom", BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, this.shadow), BorderFactory.createMatteBorder(0, 1, 1, 1, this.highlight)), BorderFactory.createEmptyBorder(0, 6, 0, 6)));
        UIManager.put("AutoHideButton.expandBorderLeft", BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, this.shadow), BorderFactory.createMatteBorder(1, 1, 1, 0, this.highlight)), BorderFactory.createEmptyBorder(6, 0, 6, 0)));
        UIManager.put("AutoHideButton.expandBorderRight", BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, this.shadow), BorderFactory.createMatteBorder(1, 0, 1, 1, this.highlight)), BorderFactory.createEmptyBorder(6, 0, 6, 0)));
        UIManager.put("AutoHideButtonPanel.topBorder", BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0), BorderFactory.createMatteBorder(0, 0, 1, 0, this.shadow)));
        UIManager.put("AutoHideButtonPanel.bottomBorder", BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0), BorderFactory.createMatteBorder(1, 0, 0, 0, this.shadow)));
        UIManager.put("AutoHideButtonPanel.leftBorder", BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1), BorderFactory.createMatteBorder(0, 0, 0, 1, this.shadow)));
        UIManager.put("AutoHideButtonPanel.rightBorder", BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1), BorderFactory.createMatteBorder(0, 1, 0, 0, this.shadow)));
        UIManager.put("AutoHideButton.font", UIManager.get("MenuItem.font"));
    }

    public void installDockViewSettings() {
        UIManager.put("DockViewUI", "com.vlsolutions.swing.docking.ui.DockViewUI");
        UIManager.put("DetachedDockViewUI", "com.vlsolutions.swing.docking.ui.DetachedDockViewUI");
    }

    public void installDockViewTitleBarSettings() {
        UIManager.put("DockViewTitleBarUI", "com.vlsolutions.swing.docking.ui.DockViewTitleBarUI");
        UIManager.put("DockViewTitleBar.height", new Integer(20));
        UIManager.put("DockViewTitleBar.closeButtonText", UIManager.getString("InternalFrameTitlePane.closeButtonText"));
        UIManager.put("DockViewTitleBar.minimizeButtonText", UIManager.getString("InternalFrameTitlePane.minimizeButtonText"));
        UIManager.put("DockViewTitleBar.restoreButtonText", UIManager.getString("InternalFrameTitlePane.restoreButtonText"));
        UIManager.put("DockViewTitleBar.maximizeButtonText", UIManager.getString("InternalFrameTitlePane.maximizeButtonText"));
        UIManager.put("DockViewTitleBar.floatButtonText", "Detach");
        UIManager.put("DockViewTitleBar.attachButtonText", "Attach");
        UIManager.put("DockViewTitleBar.titleFont", UIManager.get("InternalFrame.titleFont"));
        UIManager.put("DockViewTitleBar.isCloseButtonDisplayed", Boolean.TRUE);
        UIManager.put("DockViewTitleBar.isHideButtonDisplayed", Boolean.TRUE);
        UIManager.put("DockViewTitleBar.isDockButtonDisplayed", Boolean.TRUE);
        UIManager.put("DockViewTitleBar.isMaximizeButtonDisplayed", Boolean.TRUE);
        UIManager.put("DockViewTitleBar.isRestoreButtonDisplayed", Boolean.TRUE);
        UIManager.put("DockViewTitleBar.isFloatButtonDisplayed", Boolean.TRUE);
        UIManager.put("DockViewTitleBar.isAttachButtonDisplayed", Boolean.TRUE);
        UIManager.put("DockViewTitleBar.border", BorderFactory.createMatteBorder(0, 0, 1, 0, this.shadow));
    }

    public void installSplitContainerSettings() {
        UIManager.put("DockingSplitPaneUI", "com.vlsolutions.swing.docking.ui.DockingSplitPaneUI");
        UIManager.put("SplitContainer.dividerSize", new Integer(4));
        UIManager.put("SplitContainer.isResizingEnabled", Boolean.TRUE);
    }

    public void installTabbedContainerSettings() {
        String prefix = "/com/vldocking/swing/docking/";
        UIManager.put("TabbedDockableContainer.tabPlacement", new Integer(1));
        UIManager.put("DockTabbedPane.closeButtonText", UIManager.getString("InternalFrameTitlePane.closeButtonText"));
        UIManager.put("DockTabbedPane.minimizeButtonText", UIManager.getString("InternalFrameTitlePane.minimizeButtonText"));
        UIManager.put("DockTabbedPane.restoreButtonText", UIManager.getString("InternalFrameTitlePane.restoreButtonText"));
        UIManager.put("DockTabbedPane.maximizeButtonText", UIManager.getString("InternalFrameTitlePane.maximizeButtonText"));
        UIManager.put("DockTabbedPane.floatButtonText", "Detach");
        UIManager.put("DockTabbedPane.attachButtonText", "Attach");
        UIManager.put("JTabbedPaneSmartIcon.font", UIManager.getFont("TabbedPane.font"));
        UIManager.put("TabbedContainer.requestFocusOnTabSelection", Boolean.FALSE);
    }

    public void installCloseableTabs() {
        UIManager.put("TabbedPane.otherIconsGap", new Integer(8));
        UIManager.put("TabbedPane.inBetweenOtherIconsGap", new Integer(4));
        UIManager.put("TabbedPane.alternateTabIcons", Boolean.FALSE);
    }

    public void installIcons() {
        String prefix = "/com/vlsolutions/swing/docking/";
        ImageIcon closeIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/close16v2.png"));
        ImageIcon closeRolloverIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/close16v2rollover.png"));
        ImageIcon closePressedIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/close16v2pressed.png"));
        ImageIcon closeTabIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/close16tab.png"));
        ImageIcon closeTabRolloverIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/close16tabRollover.png"));
        ImageIcon closeTabPressedIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/close16tabPressed.png"));
        ImageIcon hideIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/hide16v2.png"));
        ImageIcon hideRolloverIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/hide16v2rollover.png"));
        ImageIcon maximizeIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/maximize16v2.png"));
        ImageIcon maximizeRolloverIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/maximize16v2rollover.png"));
        ImageIcon restoreIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/restore16v2.png"));
        ImageIcon restoreRolloverIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/restore16v2rollover.png"));
        ImageIcon dockRolloverIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/dock16v2rollover.png"));
        ImageIcon floatIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/float16v2.png"));
        ImageIcon floatRolloverIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/float16v2rollover.png"));
        ImageIcon floatPressedIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/float16v2pressed.png"));
        ImageIcon attachIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/attach16v2.png"));
        ImageIcon attachRolloverIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/attach16v2rollover.png"));
        ImageIcon attachPressedIcon = new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/attach16v2pressed.png"));
        UIManager.put("DockViewTitleBar.close", closeIcon);
        UIManager.put("DockViewTitleBar.close.rollover", closeRolloverIcon);
        UIManager.put("DockViewTitleBar.close.pressed", closePressedIcon);
        UIManager.put("DockViewTitleBar.dock", new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/dock16v2.png")));
        UIManager.put("DockViewTitleBar.dock.rollover", dockRolloverIcon);
        UIManager.put("DockViewTitleBar.dock.pressed", new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/dock16v2pressed.png")));
        UIManager.put("DockViewTitleBar.hide", hideIcon);
        UIManager.put("DockViewTitleBar.hide.rollover", hideRolloverIcon);
        UIManager.put("DockViewTitleBar.hide.pressed", new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/hide16v2pressed.png")));
        UIManager.put("DockViewTitleBar.maximize", maximizeIcon);
        UIManager.put("DockViewTitleBar.maximize.pressed", new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/maximize16v2pressed.png")));
        UIManager.put("DockViewTitleBar.maximize.rollover", maximizeRolloverIcon);
        UIManager.put("DockViewTitleBar.restore", restoreIcon);
        UIManager.put("DockViewTitleBar.restore.pressed", new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/restore16v2pressed.png")));
        UIManager.put("DockViewTitleBar.restore.rollover", restoreRolloverIcon);
        UIManager.put("DockViewTitleBar.float", floatIcon);
        UIManager.put("DockViewTitleBar.float.rollover", floatRolloverIcon);
        UIManager.put("DockViewTitleBar.float.pressed", floatPressedIcon);
        UIManager.put("DockViewTitleBar.attach", attachIcon);
        UIManager.put("DockViewTitleBar.attach.rollover", attachRolloverIcon);
        UIManager.put("DockViewTitleBar.attach.pressed", attachPressedIcon);
        UIManager.put("DockViewTitleBar.menu.close", closeRolloverIcon);
        UIManager.put("DockViewTitleBar.menu.hide", hideRolloverIcon);
        UIManager.put("DockViewTitleBar.menu.maximize", maximizeRolloverIcon);
        UIManager.put("DockViewTitleBar.menu.restore", restoreRolloverIcon);
        UIManager.put("DockViewTitleBar.menu.dock", dockRolloverIcon);
        UIManager.put("DockViewTitleBar.menu.float", floatRolloverIcon);
        UIManager.put("DockViewTitleBar.menu.attach", attachRolloverIcon);
        UIManager.put("DockTabbedPane.close", closeIcon);
        UIManager.put("DockTabbedPane.close.rollover", closeRolloverIcon);
        UIManager.put("DockTabbedPane.close.pressed", closePressedIcon);
        UIManager.put("DockTabbedPane.unselected_close", null);
        UIManager.put("DockTabbedPane.unselected_close.rollover", closeRolloverIcon);
        UIManager.put("DockTabbedPane.unselected_close.pressed", closePressedIcon);
        UIManager.put("DockTabbedPane.menu.close", closeRolloverIcon);
        UIManager.put("DockTabbedPane.menu.hide", hideRolloverIcon);
        UIManager.put("DockTabbedPane.menu.maximize", maximizeRolloverIcon);
        UIManager.put("DockTabbedPane.menu.float", floatRolloverIcon);
        UIManager.put("DockTabbedPane.closeAll", new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/closeAll16.png")));
        UIManager.put("DockTabbedPane.closeAllOther", new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/closeAllOther16.png")));
        UIManager.put("DockTabbedPane.menu.attach", attachRolloverIcon);
    }

    public void installAccelerators() {
        int MENU_SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        UIManager.put("DockingDesktop.closeActionAccelerator", KeyStroke.getKeyStroke(115, MENU_SHORTCUT_MASK));
        UIManager.put("DockingDesktop.maximizeActionAccelerator", KeyStroke.getKeyStroke(27, 1));
        UIManager.put("DockingDesktop.dockActionAccelerator", KeyStroke.getKeyStroke(8, MENU_SHORTCUT_MASK));
        UIManager.put("DockingDesktop.floatActionAccelerator", KeyStroke.getKeyStroke(116, MENU_SHORTCUT_MASK));
    }

    public void installDesktopSettings() {
        UIManager.put("DockingDesktop.notificationColor", Color.ORANGE);
        UIManager.put("DockingDesktop.notificationBlinkCount", new Integer(5));
        UIManager.put("DragControler.stopDragCursor", new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/stopdragcursor.gif")).getImage());
        UIManager.put("DragControler.detachCursor", new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/detachCursor.png")).getImage());
        UIManager.put("DragControler.dragCursor", new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/dragcursor.gif")).getImage());
        UIManager.put("DragControler.swapDragCursor", new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/docking/swapdragcursor.gif")).getImage());
        UIManager.put("DragControler.isDragAndDropEnabled", Boolean.TRUE);
        UIManager.put("DragControler.paintBackgroundUnderDragRect", Boolean.FALSE);
    }

    public void installFloatingSettings() {
        Object border = null;
        Object titleBorder = null;
        UIManager.put("FloatingDialog.dialogBorder", border);
        UIManager.put("FloatingDialog.titleBorder", titleBorder);
        UIManager.put("FloatingContainer.followParentWindow", Boolean.TRUE);
        UIManager.put("FloatingContainer.paintDragShape", Boolean.TRUE);
    }

    public void installToolBarSettings() {
        UIManager.put("ToolBarGripperUI", "com.vlsolutions.swing.toolbars.ToolBarGripperUI");
        UIManager.put("ToolBarPanel.topBorder", new ToolBarPanelBorder(0));
        UIManager.put("ToolBarPanel.leftBorder", new ToolBarPanelBorder(1));
        UIManager.put("ToolBarPanel.bottomBorder", new ToolBarPanelBorder(2));
        UIManager.put("ToolBarPanel.rightBorder", new ToolBarPanelBorder(3));
    }

    private void installColors() {
        Color shadow = UIManager.getColor("controlShadow");
        Color highlight = UIManager.getColor("controlLtHighlight");
        if (shadow == null) {
            shadow = Color.GRAY;
        }
        if (highlight == null) {
            highlight = shadow.brighter();
        }
        UIManager.put("VLDocking.shadow", shadow);
        UIManager.put("VLDocking.highlight", highlight);
    }
}

