/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.madlonkay.supertmxmerge.data.DiffAnalysis;
import org.madlonkay.supertmxmerge.data.ITmx;
import org.madlonkay.supertmxmerge.data.ITuv;
import org.madlonkay.supertmxmerge.data.JAXB.JAXBTmx;
import org.madlonkay.supertmxmerge.data.Key;
import org.madlonkay.supertmxmerge.data.WriteFailedException;
import org.madlonkay.supertmxmerge.gui.DiffWindow;
import org.madlonkay.supertmxmerge.util.DiffUtil;
import org.madlonkay.supertmxmerge.util.GuiUtil;
import org.madlonkay.supertmxmerge.util.LocString;

public class DiffController
implements Serializable {
    public static final String PROP_TMX1 = "tmx1";
    public static final String PROP_TMX2 = "tmx2";
    public static final String PROP_CHANGECOUNT = "changeCount";
    public static final String PROP_CANSAVEDIFF = "canSaveDiff";
    private ITmx tmx1;
    private ITmx tmx2;
    private List<DiffInfo> diffInfos;
    private Integer[] counts;
    private JFrame diffWindow;
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ITmx getTmx1() {
        return this.tmx1;
    }

    public void setTmx1(ITmx tmx1) {
        ITmx oldTmx1 = this.tmx1;
        this.tmx1 = tmx1;
        this.propertySupport.firePropertyChange(PROP_TMX1, oldTmx1, tmx1);
        this.propertySupport.firePropertyChange(PROP_CANSAVEDIFF, null, null);
    }

    public ITmx getTmx2() {
        return this.tmx2;
    }

    public void setTmx2(ITmx tmx2) {
        ITmx oldTmx2 = this.tmx2;
        this.tmx2 = tmx2;
        this.propertySupport.firePropertyChange(PROP_TMX2, oldTmx2, tmx2);
        this.propertySupport.firePropertyChange(PROP_CANSAVEDIFF, null, null);
    }

    public void diff(ITmx tmx1, ITmx tmx2) {
        this.setTmx1(tmx1);
        this.setTmx2(tmx2);
        this.generateDiffData(tmx1, tmx2);
        this.propertySupport.firePropertyChange(PROP_CHANGECOUNT, null, null);
        if (this.diffInfos.isEmpty()) {
            JOptionPane.showMessageDialog(null, LocString.get("STM_IDENTICAL_FILES_MESSAGE"), LocString.get("STM_DIFF_WINDOW_TITLE"), 1);
        } else {
            this.diffWindow = DiffWindow.newAsFrame(this);
            GuiUtil.displayWindow(this.diffWindow);
        }
    }

    public List<DiffInfo> getDiffInfos() {
        return this.diffInfos;
    }

    public Integer[] getChangeCount() {
        return this.counts;
    }

    public boolean canSaveDiff() {
        return this.tmx1 instanceof JAXBTmx && this.tmx2 instanceof JAXBTmx;
    }

    public void saveAs() {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showSaveDialog(this.diffWindow) != 0) {
            return;
        }
        File outFile = chooser.getSelectedFile();
        JAXBTmx outTmx = JAXBTmx.createFromDiff((JAXBTmx)this.tmx1, (JAXBTmx)this.tmx2);
        try {
            outTmx.writeTo(outFile);
        }
        catch (WriteFailedException ex) {
            Logger.getLogger(DiffController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void generateDiffData(ITmx tmx1, ITmx tmx2) {
        ITuv tuv;
        this.diffInfos = new ArrayList<DiffInfo>();
        DiffAnalysis set = DiffUtil.mapDiff(tmx1, tmx2);
        for (Key key : set.deleted) {
            tuv = (ITuv)tmx1.get(key);
            this.diffInfos.add(new DiffInfo(key, tmx1.getSourceLanguage(), tuv, null));
        }
        for (Key key : set.added) {
            tuv = (ITuv)tmx2.get(key);
            this.diffInfos.add(new DiffInfo(key, tmx2.getSourceLanguage(), null, tuv));
        }
        for (Key key : set.modified) {
            ITuv tuv1 = (ITuv)tmx1.get(key);
            ITuv tuv2 = (ITuv)tmx2.get(key);
            this.diffInfos.add(new DiffInfo(key, tmx1.getSourceLanguage(), tuv1, tuv2));
        }
        this.counts = new Integer[]{this.diffInfos.size(), set.added.size(), set.deleted.size(), set.modified.size()};
    }

    public static class DiffInfo {
        public final Key key;
        public final String sourceLanguage;
        public final String targetLanguage;
        public final String tuv1Text;
        public final String tuv2Text;
        public final Map<String, String> tuv1Props;
        public final Map<String, String> tuv2Props;

        public DiffInfo(Key key, String sourceLanguage, ITuv tuv1, ITuv tuv2) {
            this.key = key;
            this.sourceLanguage = sourceLanguage;
            this.targetLanguage = tuv1 != null ? tuv1.getLanguage() : (tuv2 != null ? tuv2.getLanguage() : null);
            this.tuv1Text = tuv1 == null ? null : tuv1.getContent();
            this.tuv2Text = tuv2 == null ? null : tuv2.getContent();
            this.tuv1Props = tuv1 == null ? null : tuv1.getMetadata();
            this.tuv2Props = tuv2 == null ? null : tuv2.getMetadata();
        }
    }
}

