/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter;
import org.tmatesoft.svn.core.internal.io.fs.FSDeltaConsumer;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;
import org.tmatesoft.svn.util.Version;

public class FSCommitEditor
implements ISVNEditor {
    private Map<String, String> myPathsToLockTokens;
    private Collection<String> myLockTokens;
    private String myBasePath;
    private FSTransactionInfo myTxn;
    private FSTransactionRoot myTxnRoot;
    private boolean isTxnOwner;
    private FSFS myFSFS;
    private FSRepository myRepository;
    private Stack<DirBaton> myDirsStack;
    private FSDeltaConsumer myDeltaConsumer;
    private SVNProperties myCurrentFileProps;
    private String myCurrentFilePath;
    private FSCommitter myCommitter;
    private SVNProperties myRevProps;
    private String myAuthor;

    public FSCommitEditor(String path, String logMessage, String userName, Map<String, String> lockTokens, boolean keepLocks, FSTransactionInfo txn, FSFS owner, FSRepository repository) {
        this(path, lockTokens, keepLocks, txn, owner, repository, null);
        this.myRevProps = new SVNProperties();
        if (userName != null) {
            this.myAuthor = userName;
            this.myRevProps.put("svn:author", userName);
        }
        if (logMessage != null) {
            this.myRevProps.put("svn:log", logMessage);
        }
        this.myRevProps.put("svn:txn-client-compat-version", Version.getSVNVersion());
    }

    public FSCommitEditor(String path, Map<String, String> lockTokens, boolean keepLocks, FSTransactionInfo txn, FSFS owner, FSRepository repository, SVNProperties revProps) {
        this.myPathsToLockTokens = !keepLocks ? lockTokens : null;
        this.myLockTokens = lockTokens != null ? lockTokens.values() : new HashSet<String>();
        this.myBasePath = path;
        this.myTxn = txn;
        this.isTxnOwner = txn == null;
        this.myRepository = repository;
        this.myFSFS = owner;
        this.myDirsStack = new Stack();
        SVNProperties sVNProperties = this.myRevProps = revProps != null ? revProps : new SVNProperties();
        if (!this.myRevProps.containsName("svn:txn-client-compat-version")) {
            this.myRevProps.put("svn:txn-client-compat-version", Version.getSVNVersion());
        }
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        long youngestRev = this.myFSFS.getYoungestRevision();
        if (this.isTxnOwner) {
            this.myTxn = FSTransactionRoot.beginTransactionForCommit(youngestRev, this.myRevProps, this.myFSFS);
        } else {
            this.myFSFS.changeTransactionProperties(this.myTxn.getTxnId(), this.myRevProps);
        }
        this.myTxnRoot = this.myFSFS.createTransactionRoot(this.myTxn);
        this.myCommitter = new FSCommitter(this.myFSFS, this.myTxnRoot, this.myTxn, this.myLockTokens, this.getAuthor());
        DirBaton dirBaton = new DirBaton(revision, this.myBasePath, false);
        this.myDirsStack.push(dirBaton);
    }

    private String getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = this.myRevProps.getStringValue("svn:author");
        }
        return this.myAuthor;
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        DirBaton parentBaton = this.myDirsStack.peek();
        String fullPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, path));
        SVNNodeKind kind = this.myTxnRoot.checkNodeKind(fullPath);
        if (kind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Path ''{0}'' not present", (Object)path);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        DirBaton dirBaton = new DirBaton(revision, fullPath, parentBaton.isCopied());
        this.myDirsStack.push(dirBaton);
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        String fullPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, path));
        SVNNodeKind kind = this.myTxnRoot.checkNodeKind(fullPath);
        if (kind == SVNNodeKind.NONE) {
            SVNErrorManager.error(FSErrors.errorOutOfDate(fullPath, kind), SVNLogType.FSFS);
        }
        FSRevisionNode existingNode = this.myTxnRoot.getRevisionNode(fullPath);
        long createdRev = existingNode.getCreatedRevision();
        if (FSRepository.isValidRevision(revision) && revision < createdRev) {
            SVNErrorManager.error(FSErrors.errorOutOfDate(fullPath, kind), SVNLogType.FSFS);
        }
        this.myCommitter.deleteNode(fullPath);
    }

    @Override
    public void absentDir(String path) throws SVNException {
    }

    @Override
    public void absentFile(String path) throws SVNException {
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirBaton parentBaton = this.myDirsStack.peek();
        String fullPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, path));
        boolean isCopied = false;
        if (copyFromPath != null && FSRepository.isInvalidRevision(copyFromRevision)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "Got source path but no source revision for ''{0}''", (Object)fullPath);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        } else if (copyFromPath != null) {
            SVNNodeKind kind = this.myTxnRoot.checkNodeKind(fullPath);
            if (kind != SVNNodeKind.NONE && !parentBaton.isCopied()) {
                SVNErrorManager.error(FSErrors.errorOutOfDate(fullPath, kind), SVNLogType.FSFS);
            }
            copyFromPath = this.myRepository.getRepositoryPath(copyFromPath);
            FSRevisionRoot copyRoot = this.myFSFS.createRevisionRoot(copyFromRevision);
            this.myCommitter.makeCopy(copyRoot, copyFromPath, fullPath, true);
            isCopied = true;
        } else {
            this.myCommitter.makeDir(fullPath);
        }
        DirBaton dirBaton = new DirBaton(-1L, fullPath, isCopied);
        this.myDirsStack.push(dirBaton);
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        DirBaton dirBaton = this.myDirsStack.peek();
        if (FSRepository.isValidRevision(dirBaton.getBaseRevision())) {
            FSRevisionNode existingNode = this.myTxnRoot.getRevisionNode(dirBaton.getPath());
            long createdRev = existingNode.getCreatedRevision();
            if (dirBaton.getBaseRevision() < createdRev) {
                SVNErrorManager.error(FSErrors.errorOutOfDate(dirBaton.getPath(), SVNNodeKind.DIR), SVNLogType.FSFS);
            }
        }
        this.myCommitter.changeNodeProperty(dirBaton.getPath(), name, value);
    }

    private void changeNodeProperties(String path, SVNProperties propNamesToValues) throws SVNException {
        FSParentPath parentPath = null;
        SVNNodeKind kind = null;
        SVNProperties properties = null;
        boolean done = false;
        boolean haveRealChanges = false;
        boolean mergeInfoModifications = false;
        for (String propName : propNamesToValues.nameSet()) {
            SVNPropertyValue propValue = propNamesToValues.getSVNPropertyValue(propName);
            FSRepositoryUtil.validateProperty(propName, propValue);
            if (!done) {
                parentPath = this.myTxnRoot.openPath(path, true, true);
                kind = parentPath.getRevNode().getType();
                if ((this.myTxnRoot.getTxnFlags() & 2) != 0) {
                    this.myCommitter.allowLockedOperation(this.myFSFS, path, this.getAuthor(), this.myLockTokens, false, false);
                }
                this.myCommitter.makePathMutable(parentPath, path);
                properties = parentPath.getRevNode().getProperties(this.myFSFS);
                done = true;
            }
            if (properties.isEmpty() && propValue == null) continue;
            if (this.myFSFS.supportsMergeInfo() && propName.equals("svn:mergeinfo")) {
                long increment = 0L;
                boolean hadMergeInfo = parentPath.getRevNode().hasMergeInfo();
                if (propValue != null && !hadMergeInfo) {
                    increment = 1L;
                } else if (propValue == null && hadMergeInfo) {
                    increment = -1L;
                }
                if (increment != 0L) {
                    parentPath.getRevNode().setHasMergeInfo(propValue != null);
                    this.myCommitter.incrementMergeInfoUpTree(parentPath, increment);
                }
                mergeInfoModifications = true;
            }
            if (propValue == null) {
                properties.remove(propName);
            } else {
                properties.put(propName, propValue);
            }
            if (haveRealChanges) continue;
            haveRealChanges = true;
        }
        if (haveRealChanges) {
            this.myTxnRoot.setProplist(parentPath.getRevNode(), properties);
            this.myCommitter.addChange(path, parentPath.getRevNode().getId(), FSPathChangeKind.FS_PATH_CHANGE_MODIFY, false, true, mergeInfoModifications, -1L, null, kind);
        }
    }

    @Override
    public void closeDir() throws SVNException {
        this.flushPendingProperties();
        this.myDirsStack.pop();
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirBaton parentBaton = this.myDirsStack.peek();
        String fullPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, path));
        if (copyFromPath != null && FSRepository.isInvalidRevision(copyFromRevision)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "Got source path but no source revision for ''{0}''", (Object)fullPath);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        } else if (copyFromPath != null) {
            SVNNodeKind kind = this.myTxnRoot.checkNodeKind(fullPath);
            if (kind != SVNNodeKind.NONE && !parentBaton.isCopied()) {
                SVNErrorManager.error(FSErrors.errorOutOfDate(fullPath, kind), SVNLogType.FSFS);
            }
            copyFromPath = this.myRepository.getRepositoryPath(copyFromPath);
            FSRevisionRoot copyRoot = this.myFSFS.createRevisionRoot(copyFromRevision);
            this.myCommitter.makeCopy(copyRoot, copyFromPath, fullPath, true);
        } else {
            this.myCommitter.makeFile(fullPath);
        }
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        String fullPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, path));
        FSRevisionNode revNode = this.myTxnRoot.getRevisionNode(fullPath);
        if (FSRepository.isValidRevision(revision) && revision < revNode.getCreatedRevision()) {
            SVNErrorManager.error(FSErrors.errorOutOfDate(fullPath, SVNNodeKind.FILE), SVNLogType.FSFS);
        }
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.flushPendingProperties();
        FSDeltaConsumer fsfsConsumer = this.getDeltaConsumer();
        fsfsConsumer.applyTextDelta(path, baseChecksum);
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        FSDeltaConsumer fsfsConsumer = this.getDeltaConsumer();
        return fsfsConsumer.textDeltaChunk(path, diffWindow);
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
        FSDeltaConsumer fsfsConsumer = this.getDeltaConsumer();
        fsfsConsumer.textDeltaEnd(path);
    }

    private FSDeltaConsumer getDeltaConsumer() {
        if (this.myDeltaConsumer == null) {
            this.myDeltaConsumer = new FSDeltaConsumer(this.myBasePath, this.myTxnRoot, this.myFSFS, this.myCommitter, this.getAuthor(), this.myLockTokens);
        }
        return this.myDeltaConsumer;
    }

    @Override
    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        String fullPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, path));
        SVNProperties props = this.getFilePropertiesStorage();
        if (!fullPath.equals(this.myCurrentFilePath)) {
            if (this.myCurrentFilePath != null) {
                this.changeNodeProperties(this.myCurrentFilePath, props);
                props.clear();
            }
            this.myCurrentFilePath = fullPath;
        }
        props.put(name, value);
    }

    private SVNProperties getFilePropertiesStorage() {
        if (this.myCurrentFileProps == null) {
            this.myCurrentFileProps = new SVNProperties();
        }
        return this.myCurrentFileProps;
    }

    private void flushPendingProperties() throws SVNException {
        if (this.myCurrentFilePath != null) {
            SVNProperties props = this.getFilePropertiesStorage();
            this.changeNodeProperties(this.myCurrentFilePath, props);
            props.clear();
            this.myCurrentFilePath = null;
        }
    }

    @Override
    public void closeFile(String path, String textChecksum) throws SVNException {
        String fullPath;
        FSRevisionNode revNode;
        FSRepresentation txtRep;
        this.flushPendingProperties();
        if (textChecksum != null && (txtRep = (revNode = this.myTxnRoot.getRevisionNode(fullPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, path)))).getTextRepresentation()) != null && !textChecksum.equals(txtRep.getMD5HexDigest())) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for resulting fulltext\n({0}):\n   expected checksum:  {1}\n   actual checksum:    {2}\n", fullPath, textChecksum, txtRep.getMD5HexDigest());
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        try {
            SVNErrorMessage[] errorMessage;
            SVNProperties revProps;
            String dateProp;
            if (this.myTxn == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "No valid transaction supplied to closeEdit()");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            long committedRev = -1L;
            if (this.myDeltaConsumer != null) {
                this.myDeltaConsumer.close();
            }
            Date datestamp = (dateProp = (revProps = this.myFSFS.getRevisionProperties(committedRev = this.myCommitter.commitTxn(true, true, errorMessage = new SVNErrorMessage[1], null))).getStringValue("svn:date")) != null ? SVNDate.parseDateString(dateProp) : null;
            SVNErrorMessage err = errorMessage[0];
            if (err != null && err.getErrorCode() == SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED) {
                String message = err.getChildErrorMessage() != null ? err.getChildErrorMessage().getFullMessage() : err.getFullMessage();
                err = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED, message, 1);
            }
            SVNCommitInfo info = new SVNCommitInfo(committedRev, this.getAuthor(), datestamp, err);
            this.releaseLocks();
            SVNCommitInfo sVNCommitInfo = info;
            return sVNCommitInfo;
        }
        finally {
            this.myRepository.closeRepository();
        }
    }

    private void releaseLocks() {
        this.releaseLocks(this.myPathsToLockTokens, false, true);
        Map<String, String> autoUnlockPaths = this.myCommitter.getAutoUnlockPaths();
        this.releaseLocks(autoUnlockPaths, true, false);
    }

    private void releaseLocks(Map<String, String> pathsToLockTokens, boolean breakLocks, boolean runHooks) {
        if (pathsToLockTokens == null) {
            return;
        }
        for (String path : pathsToLockTokens.keySet()) {
            String token = pathsToLockTokens.get(path);
            String absPath = !path.startsWith("/") ? SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, path)) : path;
            try {
                this.myFSFS.unlockPath(absPath, token, this.getAuthor(), breakLocks, runHooks);
            }
            catch (SVNException svne) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortEdit() throws SVNException {
        if (this.myDeltaConsumer != null) {
            this.myDeltaConsumer.abort();
        }
        try {
            if (this.myTxn == null || !this.isTxnOwner) {
                return;
            }
            FSCommitter.abortTransaction(this.myFSFS, this.myTxn.getTxnId());
        }
        finally {
            this.myRepository.closeRepository();
            this.myTxn = null;
            this.myTxnRoot = null;
        }
    }

    private static class DirBaton {
        private long myBaseRevision;
        private String myPath;
        private boolean isCopied;

        public DirBaton(long revision, String path, boolean copied) {
            this.myBaseRevision = revision;
            this.myPath = path;
            this.isCopied = copied;
        }

        public boolean isCopied() {
            return this.isCopied;
        }

        public long getBaseRevision() {
            return this.myBaseRevision;
        }

        public String getPath() {
            return this.myPath;
        }
    }
}

