/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.storage.file.PackedBatchRefUpdate;
import org.eclipse.jgit.internal.storage.file.RefDirectoryRename;
import org.eclipse.jgit.internal.storage.file.RefDirectoryUpdate;
import org.eclipse.jgit.internal.storage.file.ReflogWriter;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefWriter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.RefList;
import org.eclipse.jgit.util.RefMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefDirectory
extends RefDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(RefDirectory.class);
    public static final String SYMREF = "ref: ";
    public static final String PACKED_REFS_HEADER = "# pack-refs with:";
    public static final String PACKED_REFS_PEELED = " peeled";
    private static final String[] additionalRefsNames = new String[]{"MERGE_HEAD", "FETCH_HEAD", "ORIG_HEAD", "CHERRY_PICK_HEAD"};
    private static final List<Integer> RETRY_SLEEP_MS = Collections.unmodifiableList(Arrays.asList(0, 100, 200, 400, 800, 1600));
    private final FileRepository parent;
    private final File gitDir;
    final File refsDir;
    final File packedRefsFile;
    final File logsDir;
    final File logsRefsDir;
    private final AtomicReference<RefList<LooseRef>> looseRefs = new AtomicReference();
    final AtomicReference<PackedRefList> packedRefs = new AtomicReference();
    final ReentrantLock inProcessPackedRefsLock = new ReentrantLock(true);
    private final AtomicInteger modCnt = new AtomicInteger();
    private final AtomicInteger lastNotifiedModCnt = new AtomicInteger();
    private List<Integer> retrySleepMs = RETRY_SLEEP_MS;
    private static final PackedRefList NO_PACKED_REFS = new PackedRefList(RefList.emptyList(), FileSnapshot.MISSING_FILE, ObjectId.zeroId());

    RefDirectory(FileRepository db) {
        FS fs = db.getFS();
        this.parent = db;
        this.gitDir = db.getDirectory();
        this.refsDir = fs.resolve(this.gitDir, "refs/");
        this.logsDir = fs.resolve(this.gitDir, "logs");
        this.logsRefsDir = fs.resolve(this.gitDir, "logs/refs/");
        this.packedRefsFile = fs.resolve(this.gitDir, "packed-refs");
        this.looseRefs.set(RefList.emptyList());
        this.packedRefs.set(NO_PACKED_REFS);
    }

    Repository getRepository() {
        return this.parent;
    }

    ReflogWriter newLogWriter(boolean force) {
        return new ReflogWriter(this, force);
    }

    public File logFor(String name) {
        if (name.startsWith("refs/")) {
            name = name.substring("refs/".length());
            return new File(this.logsRefsDir, name);
        }
        return new File(this.logsDir, name);
    }

    @Override
    public void create() throws IOException {
        FileUtils.mkdir(this.refsDir);
        FileUtils.mkdir(new File(this.refsDir, "refs/heads/".substring("refs/".length())));
        FileUtils.mkdir(new File(this.refsDir, "refs/tags/".substring("refs/".length())));
        this.newLogWriter(false).create();
    }

    @Override
    public void close() {
        this.clearReferences();
    }

    private void clearReferences() {
        this.looseRefs.set(RefList.emptyList());
        this.packedRefs.set(NO_PACKED_REFS);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.clearReferences();
    }

    @Override
    public boolean isNameConflicting(String name) throws IOException {
        PackedRefList packed = this.getPackedRefs();
        RefList<LooseRef> loose = this.getLooseRefs();
        int lastSlash = name.lastIndexOf(47);
        while (0 < lastSlash) {
            String needle = name.substring(0, lastSlash);
            if (loose.contains(needle) || packed.contains(needle)) {
                return true;
            }
            lastSlash = name.lastIndexOf(47, lastSlash - 1);
        }
        String prefix = name + '/';
        int idx = -(packed.find(prefix) + 1);
        if (idx < packed.size() && packed.get(idx).getName().startsWith(prefix)) {
            return true;
        }
        idx = -(loose.find(prefix) + 1);
        return idx < loose.size() && loose.get(idx).getName().startsWith(prefix);
    }

    private RefList<LooseRef> getLooseRefs() {
        RefList<LooseRef> loose;
        RefList<LooseRef> oldLoose = this.looseRefs.get();
        LooseScanner scan = new LooseScanner(oldLoose);
        scan.scan("");
        if (scan.newLoose != null) {
            loose = scan.newLoose.toRefList();
            if (this.looseRefs.compareAndSet(oldLoose, loose)) {
                this.modCnt.incrementAndGet();
            }
        } else {
            loose = oldLoose;
        }
        return loose;
    }

    @Override
    public Ref exactRef(String name) throws IOException {
        Ref ref;
        PackedRefList packed = this.getPackedRefs();
        try {
            ref = this.readRef(name, packed);
            if (ref != null) {
                ref = this.resolve(ref, 0, null, null, packed);
            }
        }
        catch (IOException e) {
            if (name.contains("/") || !(e.getCause() instanceof InvalidObjectIdException)) {
                throw e;
            }
            ref = null;
        }
        this.fireRefsChanged();
        return ref;
    }

    @Override
    public Ref getRef(String needle) throws IOException {
        PackedRefList packed = this.getPackedRefs();
        Ref ref = null;
        for (String prefix : SEARCH_PATH) {
            try {
                ref = this.readRef(prefix + needle, packed);
                if (ref != null) {
                    ref = this.resolve(ref, 0, null, null, packed);
                }
                if (ref == null) continue;
                break;
            }
            catch (IOException e) {
                if (!needle.contains("/") && "".equals(prefix) && e.getCause() instanceof InvalidObjectIdException) continue;
                throw e;
            }
        }
        this.fireRefsChanged();
        return ref;
    }

    @Override
    public Map<String, Ref> getRefs(String prefix) throws IOException {
        RefList<LooseRef> loose;
        RefList<LooseRef> oldLoose = this.looseRefs.get();
        LooseScanner scan = new LooseScanner(oldLoose);
        scan.scan(prefix);
        PackedRefList packed = this.getPackedRefs();
        if (scan.newLoose != null) {
            scan.newLoose.sort();
            loose = scan.newLoose.toRefList();
            if (this.looseRefs.compareAndSet(oldLoose, loose)) {
                this.modCnt.incrementAndGet();
            }
        } else {
            loose = oldLoose;
        }
        this.fireRefsChanged();
        RefList.Builder<Ref> symbolic = scan.symbolic;
        int idx = 0;
        while (idx < symbolic.size()) {
            Ref symbolicRef = symbolic.get(idx);
            Ref resolvedRef = this.resolve(symbolicRef, 0, prefix, loose, packed);
            if (resolvedRef != null && resolvedRef.getObjectId() != null) {
                symbolic.set(idx, resolvedRef);
                ++idx;
                continue;
            }
            symbolic.remove(idx);
            int toRemove = loose.find(symbolicRef.getName());
            if (0 > toRemove) continue;
            loose = loose.remove(toRemove);
        }
        symbolic.sort();
        return new RefMap(prefix, packed, this.upcast(loose), symbolic.toRefList());
    }

    @Override
    public List<Ref> getAdditionalRefs() throws IOException {
        LinkedList<Ref> ret = new LinkedList<Ref>();
        for (String name : additionalRefsNames) {
            Ref r = this.getRef(name);
            if (r == null) continue;
            ret.add(r);
        }
        return ret;
    }

    private RefList<Ref> upcast(RefList<? extends Ref> loose) {
        return loose;
    }

    @Override
    public Ref peel(Ref ref) throws IOException {
        RefList<LooseRef> curList;
        int idx;
        Ref leaf = ref.getLeaf();
        if (leaf.isPeeled() || leaf.getObjectId() == null) {
            return ref;
        }
        ObjectIdRef newLeaf = this.doPeel(leaf);
        if (leaf.getStorage().isLoose() && 0 <= (idx = (curList = this.looseRefs.get()).find(leaf.getName())) && curList.get(idx) == leaf) {
            LooseRef asPeeled = ((LooseRef)leaf).peel(newLeaf);
            RefList<LooseRef> newList = curList.set(idx, asPeeled);
            this.looseRefs.compareAndSet(curList, newList);
        }
        return RefDirectory.recreate(ref, newLeaf);
    }

    private ObjectIdRef doPeel(Ref leaf) throws MissingObjectException, IOException {
        try (RevWalk rw = new RevWalk(this.getRepository());){
            RevObject obj = rw.parseAny(leaf.getObjectId());
            if (obj instanceof RevTag) {
                ObjectIdRef.PeeledTag peeledTag = new ObjectIdRef.PeeledTag(leaf.getStorage(), leaf.getName(), leaf.getObjectId(), rw.peel(obj).copy());
                return peeledTag;
            }
            ObjectIdRef.PeeledNonTag peeledNonTag = new ObjectIdRef.PeeledNonTag(leaf.getStorage(), leaf.getName(), leaf.getObjectId());
            return peeledNonTag;
        }
    }

    private static Ref recreate(Ref old, ObjectIdRef leaf) {
        if (old.isSymbolic()) {
            Ref dst = RefDirectory.recreate(old.getTarget(), leaf);
            return new SymbolicRef(old.getName(), dst);
        }
        return leaf;
    }

    void storedSymbolicRef(RefDirectoryUpdate u, FileSnapshot snapshot, String target) {
        this.putLooseRef(RefDirectory.newSymbolicRef(snapshot, u.getRef().getName(), target));
        this.fireRefsChanged();
    }

    @Override
    public RefDirectoryUpdate newUpdate(String name, boolean detach) throws IOException {
        boolean detachingSymbolicRef = false;
        PackedRefList packed = this.getPackedRefs();
        Ref ref = this.readRef(name, packed);
        if (ref != null) {
            ref = this.resolve(ref, 0, null, null, packed);
        }
        if (ref == null) {
            ref = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, name, null);
        } else {
            detachingSymbolicRef = detach && ref.isSymbolic();
        }
        RefDirectoryUpdate refDirUpdate = new RefDirectoryUpdate(this, ref);
        if (detachingSymbolicRef) {
            refDirUpdate.setDetachingSymbolicRef();
        }
        return refDirUpdate;
    }

    @Override
    public RefDirectoryRename newRename(String fromName, String toName) throws IOException {
        RefDirectoryUpdate from = this.newUpdate(fromName, false);
        RefDirectoryUpdate to = this.newUpdate(toName, false);
        return new RefDirectoryRename(from, to);
    }

    @Override
    public PackedBatchRefUpdate newBatchUpdate() {
        return new PackedBatchRefUpdate(this);
    }

    @Override
    public boolean performsAtomicTransactions() {
        return true;
    }

    void stored(RefDirectoryUpdate update, FileSnapshot snapshot) {
        ObjectId target = update.getNewObjectId().copy();
        Ref leaf = update.getRef().getLeaf();
        this.putLooseRef(new LooseUnpeeled(snapshot, leaf.getName(), target));
    }

    private void putLooseRef(LooseRef ref) {
        RefList<LooseRef> nList;
        RefList<LooseRef> cList;
        while (!this.looseRefs.compareAndSet(cList = this.looseRefs.get(), nList = cList.put(ref))) {
        }
        this.modCnt.incrementAndGet();
        this.fireRefsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(RefDirectoryUpdate update) throws IOException {
        RefList<LooseRef> newLoose;
        RefList<LooseRef> curLoose;
        int idx;
        Ref dst = update.getRef();
        if (!update.isDetachingSymbolicRef()) {
            dst = dst.getLeaf();
        }
        String name = dst.getName();
        PackedRefList packed = this.getPackedRefs();
        if (packed.contains(name)) {
            this.inProcessPackedRefsLock.lock();
            try {
                LockFile lck = this.lockPackedRefsOrThrow();
                try {
                    PackedRefList cur = this.readPackedRefs();
                    idx = cur.find(name);
                    if (0 <= idx) {
                        this.commitPackedRefs(lck, cur.remove(idx), packed, true);
                    }
                }
                finally {
                    lck.unlock();
                }
            }
            finally {
                this.inProcessPackedRefsLock.unlock();
            }
        }
        while ((idx = (curLoose = this.looseRefs.get()).find(name)) >= 0 && !this.looseRefs.compareAndSet(curLoose, newLoose = curLoose.remove(idx))) {
        }
        int levels = RefDirectory.levelsIn(name) - 2;
        RefDirectory.delete(this.logFor(name), levels);
        if (dst.getStorage().isLoose()) {
            update.unlock();
            RefDirectory.delete(this.fileFor(name), levels);
        }
        this.modCnt.incrementAndGet();
        this.fireRefsChanged();
    }

    public void pack(List<String> refs) throws IOException {
        this.pack(refs, Collections.emptyMap());
    }

    PackedRefList pack(Map<String, LockFile> heldLocks) throws IOException {
        return this.pack(heldLocks.keySet(), heldLocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackedRefList pack(Collection<String> refs, Map<String, LockFile> heldLocks) throws IOException {
        for (LockFile ol : heldLocks.values()) {
            ol.requireLock();
        }
        if (refs.size() == 0) {
            return null;
        }
        FS fs = this.parent.getFS();
        this.inProcessPackedRefsLock.lock();
        try {
            RefList cur;
            PackedRefList packed;
            LockFile lck;
            block20: {
                lck = this.lockPackedRefsOrThrow();
                packed = this.getPackedRefs();
                cur = this.readPackedRefs();
                boolean dirty = false;
                for (String refName : refs) {
                    Ref newRef;
                    Ref oldRef = this.readRef(refName, cur);
                    if (oldRef == null || oldRef.isSymbolic() || (newRef = this.peeledPackedRef(oldRef)) == oldRef) continue;
                    dirty = true;
                    int idx = cur.find(refName);
                    if (idx >= 0) {
                        cur = cur.set(idx, newRef);
                        continue;
                    }
                    cur = cur.add(idx, newRef);
                }
                if (dirty) break block20;
                PackedRefList packedRefList = packed;
                lck.unlock();
                return packedRefList;
            }
            try {
                PackedRefList result = this.commitPackedRefs(lck, cur, packed, false);
                for (String refName : refs) {
                    boolean shouldUnlock;
                    File refFile = this.fileFor(refName);
                    if (!fs.exists(refFile)) continue;
                    LockFile rLck = heldLocks.get(refName);
                    if (rLck == null) {
                        rLck = new LockFile(refFile);
                        if (!rLck.lock()) continue;
                        shouldUnlock = true;
                    } else {
                        shouldUnlock = false;
                    }
                    try {
                        RefList<LooseRef> newLoose;
                        RefList<LooseRef> curLoose;
                        int idx;
                        LooseRef currentLooseRef = this.scanRef(null, refName);
                        if (currentLooseRef == null || currentLooseRef.isSymbolic()) continue;
                        Object packedRef = cur.get(refName);
                        ObjectId clr_oid = currentLooseRef.getObjectId();
                        if (clr_oid == null || !clr_oid.equals(packedRef.getObjectId())) continue;
                        while ((idx = (curLoose = this.looseRefs.get()).find(refName)) >= 0 && !this.looseRefs.compareAndSet(curLoose, newLoose = curLoose.remove(idx))) {
                        }
                        int levels = RefDirectory.levelsIn(refName) - 2;
                        RefDirectory.delete(refFile, levels, rLck);
                    }
                    finally {
                        if (!shouldUnlock) continue;
                        rLck.unlock();
                    }
                }
                PackedRefList packedRefList = result;
                lck.unlock();
                return packedRefList;
            }
            catch (Throwable throwable) {
                lck.unlock();
                throw throwable;
            }
        }
        finally {
            this.inProcessPackedRefsLock.unlock();
        }
    }

    @Nullable
    LockFile lockPackedRefs() throws IOException {
        LockFile lck = new LockFile(this.packedRefsFile);
        for (int ms : this.getRetrySleepMs()) {
            RefDirectory.sleep(ms);
            if (!lck.lock()) continue;
            return lck;
        }
        return null;
    }

    private LockFile lockPackedRefsOrThrow() throws IOException {
        LockFile lck = this.lockPackedRefs();
        if (lck == null) {
            throw new LockFailedException(this.packedRefsFile);
        }
        return lck;
    }

    private Ref peeledPackedRef(Ref f) throws MissingObjectException, IOException {
        ObjectId peeledObjectId;
        if (f.getStorage().isPacked() && f.isPeeled()) {
            return f;
        }
        if (!f.isPeeled()) {
            f = this.peel(f);
        }
        if ((peeledObjectId = f.getPeeledObjectId()) != null) {
            return new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, f.getName(), f.getObjectId(), peeledObjectId);
        }
        return new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, f.getName(), f.getObjectId());
    }

    void log(boolean force, RefUpdate update, String msg, boolean deref) throws IOException {
        this.newLogWriter(force).log(update, msg, deref);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Ref resolve(Ref ref, int depth, String prefix, RefList<LooseRef> loose, RefList<Ref> packed) throws IOException {
        if (!ref.isSymbolic()) return ref;
        Ref dst = ref.getTarget();
        if (5 <= depth) {
            return null;
        }
        if (loose != null && dst.getName().startsWith(prefix)) {
            int idx = loose.find(dst.getName());
            if (0 <= idx) {
                dst = loose.get(idx);
            } else {
                idx = packed.find(dst.getName());
                if (0 > idx) return ref;
                dst = packed.get(idx);
            }
        } else if ((dst = this.readRef(dst.getName(), packed)) == null) {
            return ref;
        }
        if ((dst = this.resolve(dst, depth + 1, prefix, loose, packed)) != null) return new SymbolicRef(ref.getName(), dst);
        return null;
    }

    PackedRefList getPackedRefs() throws IOException {
        boolean trustFolderStat = this.getRepository().getConfig().getBoolean("core", "trustfolderstat", true);
        PackedRefList curList = this.packedRefs.get();
        if (trustFolderStat && !curList.snapshot.isModified(this.packedRefsFile)) {
            return curList;
        }
        PackedRefList newList = this.readPackedRefs();
        if (this.packedRefs.compareAndSet(curList, newList) && !curList.id.equals(newList.id)) {
            this.modCnt.incrementAndGet();
        }
        return newList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PackedRefList readPackedRefs() throws IOException {
        int maxStaleRetries = 5;
        int retries = 0;
        while (true) {
            FileSnapshot snapshot = FileSnapshot.save(this.packedRefsFile);
            MessageDigest digest = Constants.newMessageDigest();
            try {
                Throwable throwable = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new DigestInputStream(new FileInputStream(this.packedRefsFile), digest), Constants.CHARSET));){
                    PackedRefList packedRefList = new PackedRefList(this.parsePackedRefs(br), snapshot, ObjectId.fromRaw(digest.digest()));
                    return packedRefList;
                }
                catch (IOException e) {
                    if (FileUtils.isStaleFileHandleInCausalChain(e) && retries < maxStaleRetries) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(MessageFormat.format(JGitText.get().packedRefsHandleIsStale, retries), (Throwable)e);
                        }
                        ++retries;
                        continue;
                    }
                    try {
                        throw e;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
            catch (FileNotFoundException noPackedRefs) {
                if (!this.packedRefsFile.exists()) return NO_PACKED_REFS;
                throw noPackedRefs;
            }
        }
    }

    private RefList<Ref> parsePackedRefs(BufferedReader br) throws IOException {
        String p;
        RefList.Builder<Ref> all = new RefList.Builder<Ref>();
        Ref last = null;
        boolean peeled = false;
        boolean needSort = false;
        while ((p = br.readLine()) != null) {
            if (p.charAt(0) == '#') {
                if (!p.startsWith(PACKED_REFS_HEADER)) continue;
                p = p.substring(PACKED_REFS_HEADER.length());
                peeled = p.contains(PACKED_REFS_PEELED);
                continue;
            }
            if (p.charAt(0) == '^') {
                if (last == null) {
                    throw new IOException(JGitText.get().peeledLineBeforeRef);
                }
                ObjectId id = ObjectId.fromString(p.substring(1));
                last = new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, last.getName(), last.getObjectId(), id);
                all.set(all.size() - 1, last);
                continue;
            }
            int sp = p.indexOf(32);
            if (sp < 0) {
                throw new IOException(MessageFormat.format(JGitText.get().packedRefsCorruptionDetected, this.packedRefsFile.getAbsolutePath()));
            }
            ObjectId id = ObjectId.fromString(p.substring(0, sp));
            String name = RefDirectory.copy(p, sp + 1, p.length());
            ObjectIdRef cur = peeled ? new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name, id) : new ObjectIdRef.Unpeeled(Ref.Storage.PACKED, name, id);
            if (last != null && RefComparator.compareTo(last, cur) > 0) {
                needSort = true;
            }
            all.add(cur);
            last = cur;
        }
        if (needSort) {
            all.sort();
        }
        return all.toRefList();
    }

    private static String copy(String src, int off, int end) {
        return new StringBuilder(end - off).append(src, off, end).toString();
    }

    PackedRefList commitPackedRefs(final LockFile lck, final RefList<Ref> refs, final PackedRefList oldPackedList, final boolean changed) throws IOException {
        final AtomicReference result = new AtomicReference();
        new RefWriter(refs){

            @Override
            protected void writeFile(String name, byte[] content) throws IOException {
                lck.setFSync(true);
                lck.setNeedSnapshot(true);
                try {
                    lck.write(content);
                }
                catch (IOException ioe) {
                    throw new ObjectWritingException(MessageFormat.format(JGitText.get().unableToWrite, name), ioe);
                }
                try {
                    lck.waitForStatChange();
                }
                catch (InterruptedException e) {
                    lck.unlock();
                    throw new ObjectWritingException(MessageFormat.format(JGitText.get().interruptedWriting, name));
                }
                if (!lck.commit()) {
                    throw new ObjectWritingException(MessageFormat.format(JGitText.get().unableToWrite, name));
                }
                byte[] digest = Constants.newMessageDigest().digest(content);
                PackedRefList newPackedList = new PackedRefList(refs, lck.getCommitSnapshot(), ObjectId.fromRaw(digest));
                PackedRefList afterUpdate = RefDirectory.this.packedRefs.updateAndGet(p -> ((PackedRefList)p).id.equals(oldPackedList.id) ? newPackedList : p);
                if (!afterUpdate.id.equals(newPackedList.id)) {
                    throw new ObjectWritingException(MessageFormat.format(JGitText.get().unableToWrite, name));
                }
                if (changed) {
                    RefDirectory.this.modCnt.incrementAndGet();
                }
                result.set(newPackedList);
            }
        }.writePackedRefs();
        return (PackedRefList)result.get();
    }

    private Ref readRef(String name, RefList<Ref> packed) throws IOException {
        RefList<LooseRef> curList = this.looseRefs.get();
        int idx = curList.find(name);
        if (0 <= idx) {
            LooseRef o = curList.get(idx);
            LooseRef n = this.scanRef(o, name);
            if (n == null) {
                if (this.looseRefs.compareAndSet(curList, curList.remove(idx))) {
                    this.modCnt.incrementAndGet();
                }
                return packed.get(name);
            }
            if (o == n) {
                return n;
            }
            if (this.looseRefs.compareAndSet(curList, curList.set(idx, n))) {
                this.modCnt.incrementAndGet();
            }
            return n;
        }
        LooseRef n = this.scanRef(null, name);
        if (n == null) {
            return packed.get(name);
        }
        for (int i = 0; i < additionalRefsNames.length; ++i) {
            if (!name.equals(additionalRefsNames[i])) continue;
            return n;
        }
        if (this.looseRefs.compareAndSet(curList, curList.add(idx, n))) {
            this.modCnt.incrementAndGet();
        }
        return n;
    }

    LooseRef scanRef(LooseRef ref, String name) throws IOException {
        ObjectId id;
        int n;
        byte[] buf;
        File path = this.fileFor(name);
        FileSnapshot currentSnapshot = null;
        if (ref != null) {
            currentSnapshot = ref.getSnapShot();
            if (!currentSnapshot.isModified(path)) {
                return ref;
            }
            name = ref.getName();
        }
        int limit = 4096;
        FileSnapshot otherSnapshot = FileSnapshot.save(path);
        try {
            buf = IO.readSome(path, 4096);
        }
        catch (FileNotFoundException noFile) {
            if (path.exists() && path.isFile()) {
                throw noFile;
            }
            return null;
        }
        if (n == 0) {
            return null;
        }
        if (RefDirectory.isSymRef(buf, n)) {
            if (n == 4096) {
                return null;
            }
            for (n = buf.length; 0 < n && Character.isWhitespace(buf[n - 1]); --n) {
            }
            if (n < 6) {
                String content = RawParseUtils.decode(buf, 0, n);
                throw new IOException(MessageFormat.format(JGitText.get().notARef, name, content));
            }
            String target = RawParseUtils.decode(buf, 5, n);
            if (ref != null && ref.isSymbolic() && ref.getTarget().getName().equals(target)) {
                assert (currentSnapshot != null);
                currentSnapshot.setClean(otherSnapshot);
                return ref;
            }
            return RefDirectory.newSymbolicRef(otherSnapshot, name, target);
        }
        if (n < 40) {
            return null;
        }
        try {
            id = ObjectId.fromString(buf, 0);
            if (ref != null && !ref.isSymbolic() && id.equals(ref.getTarget().getObjectId())) {
                assert (currentSnapshot != null);
                currentSnapshot.setClean(otherSnapshot);
                return ref;
            }
        }
        catch (IllegalArgumentException notRef) {
            while (0 < n && Character.isWhitespace(buf[n - 1])) {
                --n;
            }
            String content = RawParseUtils.decode(buf, 0, n);
            throw new IOException(MessageFormat.format(JGitText.get().notARef, name, content), notRef);
        }
        return new LooseUnpeeled(otherSnapshot, name, id);
    }

    private static boolean isSymRef(byte[] buf, int n) {
        if (n < 6) {
            return false;
        }
        return buf[0] == 114 && buf[1] == 101 && buf[2] == 102 && buf[3] == 58 && buf[4] == 32;
    }

    boolean isInClone() throws IOException {
        return this.hasDanglingHead() && !this.packedRefsFile.exists() && !this.hasLooseRef();
    }

    private boolean hasDanglingHead() throws IOException {
        Ref head = this.exactRef("HEAD");
        if (head != null) {
            ObjectId id = head.getObjectId();
            return id == null || id.equals(ObjectId.zeroId());
        }
        return false;
    }

    private boolean hasLooseRef() throws IOException {
        try (Stream<Path> stream = Files.walk(this.refsDir.toPath(), new FileVisitOption[0]);){
            boolean bl = stream.anyMatch(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
            return bl;
        }
    }

    void fireRefsChanged() {
        int curr;
        int last = this.lastNotifiedModCnt.get();
        if (last != (curr = this.modCnt.get()) && this.lastNotifiedModCnt.compareAndSet(last, curr) && last != 0) {
            this.parent.fireEvent(new RefsChangedEvent());
        }
    }

    RefDirectoryUpdate newTemporaryUpdate() throws IOException {
        File tmp = File.createTempFile("renamed_", "_ref", this.refsDir);
        String name = "refs/" + tmp.getName();
        ObjectIdRef.Unpeeled ref = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, name, null);
        return new RefDirectoryUpdate(this, ref);
    }

    File fileFor(String name) {
        if (name.startsWith("refs/")) {
            name = name.substring("refs/".length());
            return new File(this.refsDir, name);
        }
        return new File(this.gitDir, name);
    }

    static int levelsIn(String name) {
        int count = 0;
        int p = name.indexOf(47);
        while (p >= 0) {
            ++count;
            p = name.indexOf(47, p + 1);
        }
        return count;
    }

    static void delete(File file, int depth) throws IOException {
        RefDirectory.delete(file, depth, null);
    }

    private static void delete(File file, int depth, LockFile rLck) throws IOException {
        if (!file.delete() && file.isFile()) {
            throw new IOException(MessageFormat.format(JGitText.get().fileCannotBeDeleted, file));
        }
        if (rLck != null) {
            rLck.unlock();
        }
        File dir = file.getParentFile();
        for (int i = 0; i < depth; ++i) {
            try {
                Files.deleteIfExists(dir.toPath());
            }
            catch (DirectoryNotEmptyException e) {
                break;
            }
            catch (IOException e) {
                LOG.warn(MessageFormat.format(JGitText.get().unableToRemovePath, dir), (Throwable)e);
                break;
            }
            dir = dir.getParentFile();
        }
    }

    Iterable<Integer> getRetrySleepMs() {
        return this.retrySleepMs;
    }

    void setRetrySleepMs(List<Integer> retrySleepMs) {
        if (retrySleepMs == null || retrySleepMs.isEmpty() || retrySleepMs.get(0) != 0) {
            throw new IllegalArgumentException();
        }
        this.retrySleepMs = retrySleepMs;
    }

    static void sleep(long ms) throws InterruptedIOException {
        if (ms <= 0L) {
            return;
        }
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            InterruptedIOException ie = new InterruptedIOException();
            ie.initCause(e);
            throw ie;
        }
    }

    private static LooseSymbolicRef newSymbolicRef(FileSnapshot snapshot, String name, String target) {
        ObjectIdRef.Unpeeled dst = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null);
        return new LooseSymbolicRef(snapshot, name, dst);
    }

    private static final class LooseNonTag
    extends ObjectIdRef.PeeledNonTag
    implements LooseRef {
        private final FileSnapshot snapShot;

        LooseNonTag(FileSnapshot snapshot, @NonNull String refName, @NonNull ObjectId id) {
            super(Ref.Storage.LOOSE, refName, id);
            this.snapShot = snapshot;
        }

        @Override
        public FileSnapshot getSnapShot() {
            return this.snapShot;
        }

        @Override
        public LooseRef peel(ObjectIdRef newLeaf) {
            return this;
        }
    }

    private static final class LoosePeeledTag
    extends ObjectIdRef.PeeledTag
    implements LooseRef {
        private final FileSnapshot snapShot;

        LoosePeeledTag(FileSnapshot snapshot, @NonNull String refName, @NonNull ObjectId id, @NonNull ObjectId p) {
            super(Ref.Storage.LOOSE, refName, id, p);
            this.snapShot = snapshot;
        }

        @Override
        public FileSnapshot getSnapShot() {
            return this.snapShot;
        }

        @Override
        public LooseRef peel(ObjectIdRef newLeaf) {
            return this;
        }
    }

    private static interface LooseRef
    extends Ref {
        public FileSnapshot getSnapShot();

        public LooseRef peel(ObjectIdRef var1);
    }

    private class LooseScanner {
        private final RefList<LooseRef> curLoose;
        private int curIdx;
        final RefList.Builder<Ref> symbolic = new RefList.Builder(4);
        RefList.Builder<LooseRef> newLoose;

        LooseScanner(RefList<LooseRef> curLoose) {
            this.curLoose = curLoose;
        }

        void scan(String prefix) {
            if ("".equals(prefix)) {
                this.scanOne("HEAD");
                this.scanTree("refs/", RefDirectory.this.refsDir);
                if (this.newLoose == null && this.curIdx < this.curLoose.size()) {
                    this.newLoose = this.curLoose.copy(this.curIdx);
                }
            } else if (prefix.startsWith("refs/") && prefix.endsWith("/")) {
                this.curIdx = -(this.curLoose.find(prefix) + 1);
                File dir = new File(RefDirectory.this.refsDir, prefix.substring("refs/".length()));
                this.scanTree(prefix, dir);
                while (this.curIdx < this.curLoose.size() && this.curLoose.get(this.curIdx).getName().startsWith(prefix)) {
                    if (this.newLoose == null) {
                        this.newLoose = this.curLoose.copy(this.curIdx);
                    }
                    ++this.curIdx;
                }
                if (this.newLoose != null) {
                    while (this.curIdx < this.curLoose.size()) {
                        this.newLoose.add(this.curLoose.get(this.curIdx++));
                    }
                }
            }
        }

        private boolean scanTree(String prefix, File dir) {
            Object[] entries = dir.list(LockFile.FILTER);
            if (entries == null) {
                return false;
            }
            if (0 < entries.length) {
                for (int i = 0; i < entries.length; ++i) {
                    Object e = entries[i];
                    File f = new File(dir, (String)e);
                    if (!f.isDirectory()) continue;
                    int n = i;
                    entries[n] = (String)entries[n] + '/';
                }
                Arrays.sort(entries);
                for (Object name : entries) {
                    if (((String)name).charAt(((String)name).length() - 1) == '/') {
                        this.scanTree(prefix + (String)name, new File(dir, (String)name));
                        continue;
                    }
                    this.scanOne(prefix + (String)name);
                }
            }
            return true;
        }

        private void scanOne(String name) {
            LooseRef n;
            LooseRef cur;
            if (this.curIdx < this.curLoose.size()) {
                do {
                    int cmp;
                    if ((cmp = RefComparator.compareTo((Ref)(cur = this.curLoose.get(this.curIdx)), name)) >= 0) {
                        if (cmp > 0) {
                            cur = null;
                        }
                        break;
                    }
                    if (this.newLoose == null) {
                        this.newLoose = this.curLoose.copy(this.curIdx);
                    }
                    ++this.curIdx;
                    cur = null;
                } while (this.curIdx < this.curLoose.size());
            } else {
                cur = null;
            }
            try {
                n = RefDirectory.this.scanRef(cur, name);
            }
            catch (IOException notValid) {
                n = null;
            }
            if (n != null) {
                if (cur != n && this.newLoose == null) {
                    this.newLoose = this.curLoose.copy(this.curIdx);
                }
                if (this.newLoose != null) {
                    this.newLoose.add(n);
                }
                if (n.isSymbolic()) {
                    this.symbolic.add(n);
                }
            } else if (cur != null && this.newLoose == null) {
                this.newLoose = this.curLoose.copy(this.curIdx);
            }
            if (cur != null) {
                ++this.curIdx;
            }
        }
    }

    private static final class LooseSymbolicRef
    extends SymbolicRef
    implements LooseRef {
        private final FileSnapshot snapShot;

        LooseSymbolicRef(FileSnapshot snapshot, @NonNull String refName, @NonNull Ref target) {
            super(refName, target);
            this.snapShot = snapshot;
        }

        @Override
        public FileSnapshot getSnapShot() {
            return this.snapShot;
        }

        @Override
        public LooseRef peel(ObjectIdRef newLeaf) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class LooseUnpeeled
    extends ObjectIdRef.Unpeeled
    implements LooseRef {
        private FileSnapshot snapShot;

        LooseUnpeeled(FileSnapshot snapShot, @NonNull String refName, @NonNull ObjectId id) {
            super(Ref.Storage.LOOSE, refName, id);
            this.snapShot = snapShot;
        }

        @Override
        public FileSnapshot getSnapShot() {
            return this.snapShot;
        }

        @Override
        @NonNull
        public ObjectId getObjectId() {
            ObjectId id = super.getObjectId();
            assert (id != null);
            return id;
        }

        @Override
        public LooseRef peel(ObjectIdRef newLeaf) {
            ObjectId peeledObjectId = newLeaf.getPeeledObjectId();
            ObjectId objectId = this.getObjectId();
            if (peeledObjectId != null) {
                return new LoosePeeledTag(this.snapShot, this.getName(), objectId, peeledObjectId);
            }
            return new LooseNonTag(this.snapShot, this.getName(), objectId);
        }
    }

    static class PackedRefList
    extends RefList<Ref> {
        private final FileSnapshot snapshot;
        private final ObjectId id;

        private PackedRefList(RefList<Ref> src, FileSnapshot s, ObjectId i) {
            super(src);
            this.snapshot = s;
            this.id = i;
        }
    }
}

