/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.history;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.editor.autocompleter.AutoCompleterItem;
import org.omegat.gui.editor.autocompleter.AutoCompleterListView;
import org.omegat.gui.editor.history.WordCompleter;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class HistoryCompleter
extends AutoCompleterListView {
    private static final Logger LOGGER = Logger.getLogger(HistoryCompleter.class.getName());
    WordCompleter wordCompleter = new WordCompleter();
    private SourceTextEntry currentEntry;
    private boolean isCurrentEntryTranslated;

    public HistoryCompleter() {
        super(OStrings.getString("AC_HISTORY_COMPLETIONS_VIEW"));
        CoreEvents.registerProjectChangeListener(eventType -> {
            if (this.isEnabled() && eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.LOAD) {
                this.train();
            }
        });
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            @Override
            public void onNewFile(String activeFileName) {
            }

            @Override
            public void onEntryActivated(SourceTextEntry newEntry) {
                TMXEntry newTranslation;
                if (!HistoryCompleter.this.isEnabled()) {
                    return;
                }
                IProject project = Core.getProject();
                if (!project.isProjectLoaded()) {
                    return;
                }
                SourceTextEntry lastEntry = HistoryCompleter.this.currentEntry;
                boolean wasTranslated = HistoryCompleter.this.isCurrentEntryTranslated;
                if (lastEntry != null && !wasTranslated && (newTranslation = project.getTranslationInfo(lastEntry)).isTranslated()) {
                    HistoryCompleter.this.trainString(newTranslation.translation);
                }
                HistoryCompleter.this.currentEntry = newEntry;
                HistoryCompleter.this.isCurrentEntryTranslated = project.getTranslationInfo(newEntry).isTranslated();
            }
        });
        Preferences.addPropertyChangeListener("allow_history_completer", evt -> {
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                if (Core.getProject().isProjectLoaded()) {
                    this.train();
                }
            } else {
                this.wordCompleter.reset();
            }
        });
    }

    synchronized void train() {
        IProject project = Core.getProject();
        if (!project.isProjectLoaded()) {
            return;
        }
        long start = System.currentTimeMillis();
        this.wordCompleter.reset();
        project.iterateByDefaultTranslations((source, trans) -> this.trainString(trans.translation));
        project.iterateByMultipleTranslations((source, trans) -> this.trainString(trans.translation));
        long time = System.currentTimeMillis() - start;
        LOGGER.finer(() -> String.format("Time to train History Completer: %d ms", time));
    }

    private void trainString(String text) {
        if (text == null) {
            return;
        }
        String[] tokens = this.getTokenizer().tokenizeWordsToStrings(text, ITokenizer.StemmingMode.NONE);
        this.wordCompleter.train(tokens);
    }

    @Override
    public List<AutoCompleterItem> computeListData(String prevText, boolean contextualOnly) {
        if (prevText == null || prevText.isEmpty()) {
            return Collections.emptyList();
        }
        String lastToken = this.getLastToken(prevText);
        if (lastToken.isEmpty()) {
            return Collections.emptyList();
        }
        return this.wordCompleter.completeWord(lastToken).stream().map(s -> new AutoCompleterItem((String)s, null, lastToken.length())).collect(Collectors.toList());
    }

    @Override
    public String itemToString(AutoCompleterItem item) {
        return item.payload;
    }

    @Override
    protected boolean isEnabled() {
        return Preferences.isPreference("allow_history_completer");
    }
}

