/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.bower.ui.options;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.javascript.bower.exec.BowerExecutable;
import org.netbeans.modules.javascript.bower.ui.options.Bundle;
import org.netbeans.modules.javascript.bower.util.FileUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class BowerOptionsPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(BowerOptionsPanel.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton bowerBrowseButton;
    private JLabel bowerHintLabel;
    private JButton bowerSearchButton;
    private JTextField bowerTextField;
    private JLabel bowerjLabel;
    private JLabel errorLabel;
    private JCheckBox ignoreBowerComponentsCheckBox;
    private JLabel installLabel;

    public BowerOptionsPanel() {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        this.init();
    }

    private void init() {
        this.errorLabel.setText(" ");
        this.bowerHintLabel.setText(Bundle.BowerOptionsPanel_bower_hint(BowerExecutable.BOWER_NAME));
        this.bowerTextField.getDocument().addDocumentListener(new DefaultDocumentListener());
        this.ignoreBowerComponentsCheckBox.addItemListener(new DefaultItemListener());
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public String getBower() {
        return this.bowerTextField.getText();
    }

    public void setBower(String bower) {
        this.bowerTextField.setText(bower);
    }

    public boolean isIgnoreBowerComponents() {
        return this.ignoreBowerComponentsCheckBox.isSelected();
    }

    public void setIgnoreBowerComponents(boolean npmIgnoreNodeModules) {
        this.ignoreBowerComponentsCheckBox.setSelected(npmIgnoreNodeModules);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.bowerjLabel = new JLabel();
        this.bowerTextField = new JTextField();
        this.bowerBrowseButton = new JButton();
        this.bowerSearchButton = new JButton();
        this.bowerHintLabel = new JLabel();
        this.installLabel = new JLabel();
        this.ignoreBowerComponentsCheckBox = new JCheckBox();
        this.errorLabel = new JLabel();
        this.bowerjLabel.setLabelFor(this.bowerTextField);
        Mnemonics.setLocalizedText((JLabel)this.bowerjLabel, (String)NbBundle.getMessage(BowerOptionsPanel.class, (String)"BowerOptionsPanel.bowerjLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bowerBrowseButton, (String)NbBundle.getMessage(BowerOptionsPanel.class, (String)"BowerOptionsPanel.bowerBrowseButton.text"));
        this.bowerBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowerOptionsPanel.this.bowerBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bowerSearchButton, (String)NbBundle.getMessage(BowerOptionsPanel.class, (String)"BowerOptionsPanel.bowerSearchButton.text"));
        this.bowerSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowerOptionsPanel.this.bowerSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.bowerHintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.installLabel, (String)NbBundle.getMessage(BowerOptionsPanel.class, (String)"BowerOptionsPanel.installLabel.text"));
        this.installLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BowerOptionsPanel.this.installLabelMousePressed(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                BowerOptionsPanel.this.installLabelMouseEntered(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreBowerComponentsCheckBox, (String)NbBundle.getMessage(BowerOptionsPanel.class, (String)"BowerOptionsPanel.ignoreBowerComponentsCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.bowerjLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.bowerHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.installLabel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.bowerTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bowerBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bowerSearchButton)))).addComponent(this.errorLabel).addComponent(this.ignoreBowerComponentsCheckBox));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bowerjLabel).addComponent(this.bowerTextField, -2, -1, -2).addComponent(this.bowerSearchButton).addComponent(this.bowerBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bowerHintLabel).addComponent(this.installLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ignoreBowerComponentsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void bowerBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(BowerOptionsPanel.class).setFilesOnly(true).setTitle(Bundle.BowerOptionsPanel_bower_browse_title()).showOpenDialog();
        if (file != null) {
            this.bowerTextField.setText(file.getAbsolutePath());
        }
    }

    private void bowerSearchButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        Iterator<String> iterator = FileUtils.findFileOnUsersPath(BowerExecutable.BOWER_NAME).iterator();
        if (iterator.hasNext()) {
            String bower = iterator.next();
            this.bowerTextField.setText(new File(bower).getAbsolutePath());
            return;
        }
        StatusDisplayer.getDefault().setStatusText(Bundle.BowerOptionsPanel_bower_none());
    }

    private void installLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void installLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://bower.io/"));
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            BowerOptionsPanel.this.fireChange();
        }
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            BowerOptionsPanel.this.fireChange();
        }
    }
}

