/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.dependencies;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lsp.TextDocumentEdit;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.dependencies.Bundle;
import org.netbeans.modules.gradle.java.queries.GradleScopes;
import org.netbeans.modules.gradle.java.queries.GradleScopesBuilder;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Union2;

public class RewriteContext {
    private final Project project;
    private final DependencyResult current;
    private LineDocument lineDoc;
    private GradleScopes scopes;
    private List<TextEdit> edits = new ArrayList<TextEdit>();
    private FileObject buildFile;

    public RewriteContext(Project project, DependencyResult current) {
        this.project = project;
        this.current = current;
        this.scopes = new GradleScopesBuilder(project).build();
        NbGradleProject nbgp = NbGradleProject.get((Project)project);
        File f = nbgp.getGradleFiles().getBuildScript();
        this.buildFile = FileUtil.toFileObject((File)f);
    }

    public GradleScopes getScopes() {
        return this.scopes;
    }

    public LineDocument openDocument() throws ProjectOperationException {
        if (this.lineDoc != null) {
            return this.lineDoc;
        }
        NbGradleProject nbgp = NbGradleProject.get((Project)this.project);
        File f = nbgp.getGradleFiles().getBuildScript();
        this.buildFile = FileUtil.toFileObject((File)f);
        if (this.buildFile == null) {
            throw new ProjectOperationException(this.project, ProjectOperationException.State.UNSUPPORTED, Bundle.ERR_ProjectFileNotFound(f.toString()), (Throwable)new FileNotFoundException(f.toString()));
        }
        EditorCookie cake = (EditorCookie)this.buildFile.getLookup().lookup(EditorCookie.class);
        try {
            this.lineDoc = (LineDocument)LineDocumentUtils.asRequired((Document)cake.openDocument(), LineDocument.class);
            return this.lineDoc;
        }
        catch (IOException ex) {
            throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_ProjectFileNotFound(f.toString()), (Throwable)ex);
        }
    }

    public DependencyResult getCurrentDependencies() {
        return this.current;
    }

    public void addTextEdits(List<TextEdit> add) {
        this.edits.addAll(add);
    }

    public WorkspaceEdit createWorkspaceEdit() {
        return new WorkspaceEdit(this.edits.isEmpty() ? Collections.emptyList() : Arrays.asList(Union2.createFirst((Object)new TextDocumentEdit(URLMapper.findURL((FileObject)this.buildFile, (int)1).toString(), this.edits))));
    }
}

