/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.keymanagement.model.SignDataDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class SignRequest
extends BmcRequest<SignDataDetails> {
    private SignDataDetails signDataDetails;
    private String opcRequestId;

    public SignDataDetails getSignDataDetails() {
        return this.signDataDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public SignDataDetails getBody$() {
        return this.signDataDetails;
    }

    public Builder toBuilder() {
        return new Builder().signDataDetails(this.signDataDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",signDataDetails=").append(String.valueOf((Object)this.signDataDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignRequest)) {
            return false;
        }
        SignRequest other = (SignRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.signDataDetails, (Object)other.signDataDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.signDataDetails == null ? 43 : this.signDataDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SignRequest, SignDataDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private SignDataDetails signDataDetails = null;
        private String opcRequestId = null;

        public Builder signDataDetails(SignDataDetails signDataDetails) {
            this.signDataDetails = signDataDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SignRequest o) {
            this.signDataDetails(o.getSignDataDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SignRequest build() {
            SignRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SignDataDetails body) {
            this.signDataDetails(body);
            return this;
        }

        public SignRequest buildWithoutInvocationCallback() {
            SignRequest request = new SignRequest();
            request.signDataDetails = this.signDataDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

