/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.CaseTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Directive;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.SymbolMetadata;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.comp.InferenceContext;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MandatoryWarningHandler;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Warner;
import java.lang.annotation.Documented;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor14;
import javax.tools.JavaFileManager;
import nbjavac.ObjectsWrapper;

public class Check {
    protected static final Context.Key<Check> checkKey = new Context.Key();
    private static final int FIRST = 1;
    private static final int SECOND = 2;
    private final Names names;
    private final Log log;
    private final Resolve rs;
    private final Symtab syms;
    private final Enter enter;
    private final DeferredAttr deferredAttr;
    private final Infer infer;
    private final Types types;
    private final TypeAnnotations typeAnnotations;
    private final JCDiagnostic.Factory diags;
    private final JavaFileManager fileManager;
    private final Source source;
    private final Target target;
    private final Profile profile;
    private final Preview preview;
    private final boolean warnOnAnyAccessToMembers;
    public boolean disablePreviewCheck;
    private Lint lint;
    private Symbol.MethodSymbol method;
    char syntheticNameChar;
    private Map<Pair<Symbol.ModuleSymbol, Name>, Symbol.ClassSymbol> compiled = new HashMap<Pair<Symbol.ModuleSymbol, Name>, Symbol.ClassSymbol>();
    private MandatoryWarningHandler deprecationHandler;
    private MandatoryWarningHandler removalHandler;
    private MandatoryWarningHandler uncheckedHandler;
    private MandatoryWarningHandler sunApiHandler;
    private DeferredLintHandler deferredLintHandler;
    private final boolean allowModules;
    private final boolean allowRecords;
    private final boolean allowSealed;
    private Map<Pair<Name, Name>, Integer> localClassNameIndexes = new HashMap<Pair<Name, Name>, Integer>();
    CheckContext basicHandler = new CheckContext(){

        @Override
        public void report(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic details) {
            Check.this.log.error(pos, CompilerProperties.Errors.ProbFoundReq(details));
        }

        @Override
        public boolean compatible(Type found, Type req, Warner warn) {
            return Check.this.types.isAssignable(found, req, warn);
        }

        @Override
        public Warner checkWarner(JCDiagnostic.DiagnosticPosition pos, Type found, Type req) {
            return Check.this.convertWarner(pos, found, req);
        }

        @Override
        public InferenceContext inferenceContext() {
            return ((Check)Check.this).infer.emptyContext;
        }

        @Override
        public DeferredAttr.DeferredAttrContext deferredAttrContext() {
            return ((Check)Check.this).deferredAttr.emptyDeferredAttrContext;
        }

        public String toString() {
            return "CheckContext: basicHandler";
        }
    };
    private static final boolean ignoreAnnotatedCasts = true;
    private static final Types.SimpleVisitor<Boolean, Void> denotableChecker = new Types.SimpleVisitor<Boolean, Void>(){

        @Override
        public Boolean visitType(Type t, Void s) {
            return true;
        }

        @Override
        public Boolean visitClassType(Type.ClassType t, Void s) {
            if (t.isUnion() || t.isIntersection()) {
                return false;
            }
            for (Type targ : t.allparams()) {
                if (((Boolean)this.visit(targ, s)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitTypeVar(Type.TypeVar t, Void s) {
            return (t.tsym.flags() & 0x1000L) == 0L;
        }

        @Override
        public Boolean visitCapturedType(Type.CapturedType t, Void s) {
            return false;
        }

        @Override
        public Boolean visitArrayType(Type.ArrayType t, Void s) {
            return (Boolean)this.visit(t.elemtype, s);
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType t, Void s) {
            return (Boolean)this.visit(t.type, s);
        }
    };
    Types.UnaryVisitor<Boolean> isTypeArgErroneous = new Types.UnaryVisitor<Boolean>(){

        @Override
        public Boolean visitType(Type t, Void s) {
            return t.isErroneous();
        }

        @Override
        public Boolean visitTypeVar(Type.TypeVar t, Void s) {
            return (Boolean)this.visit(t.getUpperBound());
        }

        @Override
        public Boolean visitCapturedType(Type.CapturedType t, Void s) {
            return (Boolean)this.visit(t.getUpperBound()) != false || (Boolean)this.visit(t.getLowerBound()) != false;
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType t, Void s) {
            return (Boolean)this.visit(t.type);
        }
    };
    Warner overrideWarner = new Warner();
    private Predicate<Symbol> equalsHasCodeFilter = s -> Symbol.MethodSymbol.implementation_filter.test((Symbol)s) && (s.flags() & 0x200000000000L) == 0L;
    private Set<Name> defaultTargets;
    private Name[] dfltTargetMeta;

    public static Check instance(Context context) {
        Check instance = context.get(checkKey);
        if (instance == null) {
            instance = new Check(context);
        }
        return instance;
    }

    protected Check(Context context) {
        context.put(checkKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.rs = Resolve.instance(context);
        this.syms = Symtab.instance(context);
        this.enter = Enter.instance(context);
        this.deferredAttr = DeferredAttr.instance(context);
        this.infer = Infer.instance(context);
        this.types = Types.instance(context);
        this.typeAnnotations = TypeAnnotations.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        Options options = Options.instance(context);
        this.lint = Lint.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.source = Source.instance(context);
        this.target = Target.instance(context);
        this.warnOnAnyAccessToMembers = options.isSet("warnOnAccessToMembers");
        this.disablePreviewCheck = false;
        Target target = Target.instance(context);
        this.syntheticNameChar = target.syntheticNameChar();
        this.profile = Profile.instance(context);
        this.preview = Preview.instance(context);
        boolean verboseDeprecated = this.lint.isEnabled(Lint.LintCategory.DEPRECATION);
        boolean verboseRemoval = this.lint.isEnabled(Lint.LintCategory.REMOVAL);
        boolean verboseUnchecked = this.lint.isEnabled(Lint.LintCategory.UNCHECKED);
        boolean enforceMandatoryWarnings = true;
        this.deprecationHandler = new MandatoryWarningHandler(this.log, null, verboseDeprecated, enforceMandatoryWarnings, "deprecated", Lint.LintCategory.DEPRECATION);
        this.removalHandler = new MandatoryWarningHandler(this.log, null, verboseRemoval, enforceMandatoryWarnings, "removal", Lint.LintCategory.REMOVAL);
        this.uncheckedHandler = new MandatoryWarningHandler(this.log, null, verboseUnchecked, enforceMandatoryWarnings, "unchecked", Lint.LintCategory.UNCHECKED);
        this.sunApiHandler = new MandatoryWarningHandler(this.log, null, false, enforceMandatoryWarnings, "sunapi", null);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
        this.allowModules = Source.Feature.MODULES.allowedInSource(this.source);
        this.allowRecords = Source.Feature.RECORDS.allowedInSource(this.source);
        this.allowSealed = Source.Feature.SEALED_CLASSES.allowedInSource(this.source);
    }

    Lint setLint(Lint newLint) {
        Lint prev = this.lint;
        this.lint = newLint;
        return prev;
    }

    Symbol.MethodSymbol setMethod(Symbol.MethodSymbol newMethod) {
        Symbol.MethodSymbol prev = this.method;
        this.method = newMethod;
        return prev;
    }

    void warnDeprecated(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if (sym.isDeprecatedForRemoval()) {
            if (!this.lint.isSuppressed(Lint.LintCategory.REMOVAL)) {
                if (sym.kind == Kinds.Kind.MDL) {
                    this.removalHandler.report(pos, CompilerProperties.Warnings.HasBeenDeprecatedForRemovalModule(sym));
                } else {
                    this.removalHandler.report(pos, CompilerProperties.Warnings.HasBeenDeprecatedForRemoval(sym, sym.location()));
                }
            }
        } else if (!this.lint.isSuppressed(Lint.LintCategory.DEPRECATION)) {
            if (sym.kind == Kinds.Kind.MDL) {
                this.deprecationHandler.report(pos, CompilerProperties.Warnings.HasBeenDeprecatedModule(sym));
            } else {
                this.deprecationHandler.report(pos, CompilerProperties.Warnings.HasBeenDeprecated(sym, sym.location()));
            }
        }
    }

    public void warnPreviewAPI(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic.Warning warnKey) {
        if (!this.lint.isSuppressed(Lint.LintCategory.PREVIEW)) {
            this.preview.reportPreviewWarning(pos, warnKey);
        }
    }

    public void warnDeclaredUsingPreview(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if (!this.lint.isSuppressed(Lint.LintCategory.PREVIEW)) {
            this.preview.reportPreviewWarning(pos, CompilerProperties.Warnings.DeclaredUsingPreview(Kinds.kindName(sym), sym));
        }
    }

    public void warnRestrictedAPI(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if (this.lint.isEnabled(Lint.LintCategory.RESTRICTED)) {
            this.log.warning(Lint.LintCategory.RESTRICTED, pos, CompilerProperties.Warnings.RestrictedMethod(sym.enclClass(), sym));
        }
    }

    public void warnUnchecked(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic.Warning warnKey) {
        if (!this.lint.isSuppressed(Lint.LintCategory.UNCHECKED)) {
            this.uncheckedHandler.report(pos, warnKey);
        }
    }

    void warnUnsafeVararg(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic.Warning warnKey) {
        if (this.lint.isEnabled(Lint.LintCategory.VARARGS)) {
            this.log.warning(Lint.LintCategory.VARARGS, pos, warnKey);
        }
    }

    public void warnStatic(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic.Warning warnKey) {
        if (this.lint.isEnabled(Lint.LintCategory.STATIC)) {
            this.log.warning(Lint.LintCategory.STATIC, pos, warnKey);
        }
    }

    void warnDivZero(JCDiagnostic.DiagnosticPosition pos) {
        if (this.lint.isEnabled(Lint.LintCategory.DIVZERO)) {
            this.log.warning(Lint.LintCategory.DIVZERO, pos, CompilerProperties.Warnings.DivZero);
        }
    }

    public void reportDeferredDiagnostics() {
        this.deprecationHandler.reportDeferredDiagnostic();
        this.removalHandler.reportDeferredDiagnostic();
        this.uncheckedHandler.reportDeferredDiagnostic();
        this.sunApiHandler.reportDeferredDiagnostic();
    }

    public Type completionError(JCDiagnostic.DiagnosticPosition pos, Symbol.CompletionFailure ex) {
        this.log.error(JCDiagnostic.DiagnosticFlag.NON_DEFERRABLE, pos, CompilerProperties.Errors.CantAccess(ex.sym, ex.getDetailValue()));
        return this.syms.errType;
    }

    Type typeTagError(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic required, Object found) {
        Type type;
        if (found instanceof Type && (type = (Type)found).hasTag(TypeTag.VOID)) {
            this.log.error(pos, CompilerProperties.Errors.IllegalStartOfType);
            return this.syms.errType;
        }
        this.log.error(pos, CompilerProperties.Errors.TypeFoundReq(found, required));
        return this.types.createErrorType(found instanceof Type ? (type = (Type)found) : this.syms.errType);
    }

    void duplicateError(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if (!sym.type.isErroneous()) {
            Symbol location = sym.location();
            if (location.kind == Kinds.Kind.MTH && ((Symbol.MethodSymbol)location).isStaticOrInstanceInit()) {
                this.log.error(pos, CompilerProperties.Errors.AlreadyDefinedInClinit(Kinds.kindName(sym), sym, Kinds.kindName(sym.location()), Kinds.kindName(sym.location().enclClass()), sym.location().enclClass()));
            } else if (location.kind != Kinds.Kind.MTH || (sym.owner.flags_field & 0x1000000000L) == 0L || (sym.owner.flags_field & 0x2000000000000000L) == 0L) {
                this.log.error(pos, CompilerProperties.Errors.AlreadyDefined(Kinds.kindName(sym), sym, Kinds.kindName(sym.location()), sym.location()));
            }
        }
    }

    void varargsDuplicateError(JCDiagnostic.DiagnosticPosition pos, Symbol sym1, Symbol sym2) {
        if (!sym1.type.isErroneous() && !sym2.type.isErroneous()) {
            this.log.error(pos, CompilerProperties.Errors.ArrayAndVarargs(sym1, sym2, sym2.location()));
        }
    }

    void checkTransparentVar(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol v, Scope s) {
        for (Symbol sym : s.getSymbolsByName(v.name)) {
            if (sym.owner != v.owner) break;
            if (sym.kind != Kinds.Kind.VAR || !sym.owner.kind.matches(Kinds.KindSelector.VAL_MTH) || v.name == this.names.error) continue;
            this.duplicateError(pos, sym);
            return;
        }
    }

    void checkTransparentClass(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c, Scope s) {
        for (Symbol sym : s.getSymbolsByName(c.name)) {
            if (sym.owner != c.owner) break;
            if (sym.kind != Kinds.Kind.TYP || sym.type.hasTag(TypeTag.TYPEVAR) || !sym.owner.kind.matches(Kinds.KindSelector.VAL_MTH) || c.name == this.names.error) continue;
            this.duplicateError(pos, sym);
            return;
        }
    }

    boolean checkUniqueClassName(JCDiagnostic.DiagnosticPosition pos, Name name, Scope s) {
        for (Symbol sym : s.getSymbolsByName(name, Scope.LookupKind.NON_RECURSIVE)) {
            if (sym.kind != Kinds.Kind.TYP || sym.name == this.names.error) continue;
            this.duplicateError(pos, sym);
            return false;
        }
        Symbol sym = s.owner;
        while (sym != null) {
            if (sym.kind == Kinds.Kind.TYP && sym.name == name && sym.name != this.names.error && !sym.isImplicit()) {
                this.duplicateError(pos, sym);
                return true;
            }
            sym = sym.owner;
        }
        return true;
    }

    public Name localClassName(Symbol.ClassSymbol c) {
        int i;
        Name enclFlatname = c.owner.enclClass().flatname;
        String enclFlatnameStr = enclFlatname.toString();
        Pair<Name, Name> key = new Pair<Name, Name>(enclFlatname, c.name);
        Integer index = this.localClassNameIndexes.get(key);
        int n = i = index == null ? 1 : index;
        while (true) {
            Name flatname;
            if (this.getCompiled(c.packge().modle, flatname = this.names.fromString(enclFlatnameStr + this.syntheticNameChar + i + c.name)) == null) {
                this.localClassNameIndexes.put(key, i + 1);
                return flatname;
            }
            ++i;
        }
    }

    public void clearLocalClassNameIndexes(Symbol.ClassSymbol c) {
        if (c.owner != null && c.owner.kind != Kinds.Kind.NIL) {
            this.localClassNameIndexes.remove(new Pair<Name, Name>(c.owner.enclClass().flatname, c.name));
        }
    }

    public void newRound() {
        this.compiled.clear();
        this.localClassNameIndexes.clear();
    }

    public void clear() {
        this.deprecationHandler.clear();
        this.removalHandler.clear();
        this.uncheckedHandler.clear();
        this.sunApiHandler.clear();
    }

    public void putCompiled(Symbol.ClassSymbol csym) {
        this.compiled.put(Pair.of(csym.packge().modle, csym.flatname), csym);
    }

    public Symbol.ClassSymbol getCompiled(Symbol.ClassSymbol csym) {
        return this.compiled.get(Pair.of(csym.packge().modle, csym.flatname));
    }

    public Symbol.ClassSymbol getCompiled(Symbol.ModuleSymbol msym, Name flatname) {
        return this.compiled.get(Pair.of(msym, flatname));
    }

    public void removeCompiled(Symbol.ClassSymbol csym) {
        this.compiled.remove(Pair.of(csym.packge().modle, csym.flatname));
    }

    public Type checkType(JCDiagnostic.DiagnosticPosition pos, Type found, Type req) {
        return this.checkType(pos, found, req, this.basicHandler);
    }

    Type checkType(JCDiagnostic.DiagnosticPosition pos, Type found, Type req, CheckContext checkContext) {
        InferenceContext inferenceContext = checkContext.inferenceContext();
        if (inferenceContext.free(req) || inferenceContext.free(found)) {
            inferenceContext.addFreeTypeListener(List.of(req, found), solvedContext -> this.checkType(pos, solvedContext.asInstType(found), solvedContext.asInstType(req), checkContext));
        }
        if (req.hasTag(TypeTag.ERROR)) {
            return req;
        }
        if (req.hasTag(TypeTag.NONE)) {
            return found;
        }
        if (checkContext.compatible(found, req, checkContext.checkWarner(pos, found, req))) {
            return found;
        }
        if (found.isNumeric() && req.isNumeric()) {
            checkContext.report(pos, this.diags.fragment(CompilerProperties.Fragments.PossibleLossOfPrecision(found, req)));
            return this.types.createErrorType(found);
        }
        checkContext.report(pos, this.diags.fragment(CompilerProperties.Fragments.InconvertibleTypes(found, req)));
        return this.types.createErrorType(found);
    }

    Type checkCastable(JCDiagnostic.DiagnosticPosition pos, Type found, Type req) {
        return this.checkCastable(pos, found, req, this.basicHandler);
    }

    Type checkCastable(JCDiagnostic.DiagnosticPosition pos, Type found, Type req, CheckContext checkContext) {
        if (this.types.isCastable(found, req, this.castWarner(pos, found, req))) {
            return req;
        }
        checkContext.report(pos, this.diags.fragment(CompilerProperties.Fragments.InconvertibleTypes(found, req)));
        return this.types.createErrorType(found);
    }

    public void checkRedundantCast(Env<AttrContext> env, JCTree.JCTypeCast tree) {
        if (!tree.type.isErroneous() && this.types.isSameType(tree.expr.type, tree.clazz.type) && !TreeInfo.containsTypeAnnotation(tree.clazz) && !this.is292targetTypeCast(tree)) {
            this.deferredLintHandler.report(_l -> {
                if (this.lint.isEnabled(Lint.LintCategory.CAST)) {
                    this.log.warning(Lint.LintCategory.CAST, tree.pos(), CompilerProperties.Warnings.RedundantCast(tree.clazz.type));
                }
            });
        }
    }

    private boolean is292targetTypeCast(JCTree.JCTypeCast tree) {
        boolean is292targetTypeCast = false;
        JCTree.JCExpression expr = TreeInfo.skipParens(tree.expr);
        if (expr.hasTag(JCTree.Tag.APPLY)) {
            JCTree.JCMethodInvocation apply = (JCTree.JCMethodInvocation)expr;
            Symbol sym = TreeInfo.symbol(apply.meth);
            is292targetTypeCast = sym != null && sym.kind == Kinds.Kind.MTH && (sym.flags() & 0x2000000000L) != 0L;
        }
        return is292targetTypeCast;
    }

    private boolean checkExtends(Type a, Type bound) {
        if (a.isUnbound()) {
            return true;
        }
        if (!a.hasTag(TypeTag.WILDCARD)) {
            a = this.types.cvarUpperBound(a);
            return this.types.isSubtype(a, bound);
        }
        if (a.isExtendsBound()) {
            return this.types.isCastable(bound, this.types.wildUpperBound(a), this.types.noWarnings);
        }
        if (a.isSuperBound()) {
            return !this.types.notSoftSubtype(this.types.wildLowerBound(a), bound);
        }
        return true;
    }

    Type checkNonVoid(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (t.hasTag(TypeTag.VOID)) {
            this.log.error(pos, CompilerProperties.Errors.VoidNotAllowedHere);
            return this.types.createErrorType(t);
        }
        return t;
    }

    Type checkClassOrArrayType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (!(t.hasTag(TypeTag.CLASS) || t.hasTag(TypeTag.ARRAY) || t.hasTag(TypeTag.ERROR))) {
            return this.typeTagError(pos, this.diags.fragment(CompilerProperties.Fragments.TypeReqClassArray), this.asTypeParam(t));
        }
        return t;
    }

    Type checkClassType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (!t.hasTag(TypeTag.CLASS) && !t.hasTag(TypeTag.ERROR)) {
            return this.typeTagError(pos, this.diags.fragment(CompilerProperties.Fragments.TypeReqClass), this.asTypeParam(t));
        }
        return t;
    }

    private Object asTypeParam(Type t) {
        return t.hasTag(TypeTag.TYPEVAR) ? this.diags.fragment(CompilerProperties.Fragments.TypeParameter(t)) : t;
    }

    Type checkConstructorRefType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if ((t = this.checkClassOrArrayType(pos, t)).hasTag(TypeTag.CLASS)) {
            if ((t.tsym.flags() & 0x600L) != 0L) {
                this.log.error(pos, CompilerProperties.Errors.AbstractCantBeInstantiated(t.tsym));
                t = this.types.createErrorType(t);
            } else if ((t.tsym.flags() & 0x4000L) != 0L) {
                this.log.error(pos, CompilerProperties.Errors.EnumCantBeInstantiated);
                t = this.types.createErrorType(t);
            } else {
                t = this.checkClassType(pos, t, true);
            }
        } else if (t.hasTag(TypeTag.ARRAY) && !this.types.isReifiable(((Type.ArrayType)t).elemtype)) {
            this.log.error(pos, CompilerProperties.Errors.GenericArrayCreation);
            t = this.types.createErrorType(t);
        }
        return t;
    }

    Type checkClassType(JCDiagnostic.DiagnosticPosition pos, Type t, boolean noBounds) {
        t = this.checkClassType(pos, t);
        if (noBounds && t.isParameterized()) {
            List<Type> args = t.getTypeArguments();
            while (args.nonEmpty()) {
                if (((Type)args.head).hasTag(TypeTag.WILDCARD)) {
                    return this.typeTagError(pos, this.diags.fragment(CompilerProperties.Fragments.TypeReqExact), args.head);
                }
                args = args.tail;
            }
        }
        return t;
    }

    Type checkRefType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (t.isReference()) {
            return t;
        }
        return this.typeTagError(pos, this.diags.fragment(CompilerProperties.Fragments.TypeReqRef), t);
    }

    List<Type> checkRefTypes(List<JCTree.JCExpression> trees, List<Type> types) {
        List<JCTree.JCExpression> tl = trees;
        List<Type> l = types;
        while (l.nonEmpty()) {
            l.head = this.checkRefType(((JCTree.JCExpression)tl.head).pos(), (Type)l.head);
            tl = tl.tail;
            l = l.tail;
        }
        return types;
    }

    Type checkNullOrRefType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (t.isReference() || t.hasTag(TypeTag.BOT)) {
            return t;
        }
        return this.typeTagError(pos, this.diags.fragment(CompilerProperties.Fragments.TypeReqRef), t);
    }

    boolean checkDisjoint(JCDiagnostic.DiagnosticPosition pos, long flags, long set1, long set2) {
        if ((flags & set1) != 0L && (flags & set2) != 0L) {
            this.log.error(pos, CompilerProperties.Errors.IllegalCombinationOfModifiers(Flags.asFlagSet(TreeInfo.firstFlag(flags & set1)), Flags.asFlagSet(TreeInfo.firstFlag(flags & set2))));
            return false;
        }
        return true;
    }

    Type checkDiamond(JCTree.JCNewClass tree, Type t) {
        if (!TreeInfo.isDiamond(tree) || t.isErroneous()) {
            return this.checkClassType(tree.clazz.pos(), t, true);
        }
        if (tree.def != null && !Source.Feature.DIAMOND_WITH_ANONYMOUS_CLASS_CREATION.allowedInSource(this.source)) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, tree.clazz.pos(), CompilerProperties.Errors.CantApplyDiamond1(t, Source.Feature.DIAMOND_WITH_ANONYMOUS_CLASS_CREATION.fragment(this.source.name)));
        }
        if (t.tsym.type.getTypeArguments().isEmpty()) {
            this.log.error(tree.clazz.pos(), CompilerProperties.Errors.CantApplyDiamond1(t, CompilerProperties.Fragments.DiamondNonGeneric(t)));
            return this.types.createErrorType(t);
        }
        if (tree.typeargs != null && tree.typeargs.nonEmpty()) {
            this.log.error(tree.clazz.pos(), CompilerProperties.Errors.CantApplyDiamond1(t, CompilerProperties.Fragments.DiamondAndExplicitParams(t)));
            return this.types.createErrorType(t);
        }
        return t;
    }

    List<Type> checkDiamondDenotable(Type.ClassType t) {
        ListBuffer<Type> buf = new ListBuffer<Type>();
        for (Type arg : t.allparams()) {
            if (this.checkDenotable(arg)) continue;
            buf.append(arg);
        }
        return buf.toList();
    }

    public boolean checkDenotable(Type t) {
        return (Boolean)denotableChecker.visit(t, null);
    }

    void checkVarargsMethodDecl(Env<AttrContext> env, JCTree.JCMethodDecl tree) {
        Symbol.MethodSymbol m = tree.sym;
        boolean hasTrustMeAnno = m.attribute(this.syms.trustMeType.tsym) != null;
        Type varargElemType = null;
        if (m.isVarArgs()) {
            varargElemType = this.types.elemtype(tree.params.last().type);
        }
        if (hasTrustMeAnno && !this.isTrustMeAllowedOnMethod(m)) {
            if (varargElemType != null) {
                JCDiagnostic msg = Source.Feature.PRIVATE_SAFE_VARARGS.allowedInSource(this.source) ? this.diags.fragment(CompilerProperties.Fragments.VarargsTrustmeOnVirtualVarargs(m)) : this.diags.fragment(CompilerProperties.Fragments.VarargsTrustmeOnVirtualVarargsFinalOnly(m));
                this.log.error(tree, CompilerProperties.Errors.VarargsInvalidTrustmeAnno((Symbol)this.syms.trustMeType.tsym, msg));
            } else {
                this.log.error(tree, CompilerProperties.Errors.VarargsInvalidTrustmeAnno((Symbol)this.syms.trustMeType.tsym, CompilerProperties.Fragments.VarargsTrustmeOnNonVarargsMeth(m)));
            }
        } else if (hasTrustMeAnno && varargElemType != null && this.types.isReifiable(varargElemType)) {
            this.warnUnsafeVararg(tree, CompilerProperties.Warnings.VarargsRedundantTrustmeAnno((Symbol)this.syms.trustMeType.tsym, this.diags.fragment(CompilerProperties.Fragments.VarargsTrustmeOnReifiableVarargs(varargElemType))));
        } else if (!hasTrustMeAnno && varargElemType != null && !this.types.isReifiable(varargElemType)) {
            this.warnUnchecked(((JCTree.JCVariableDecl)tree.params.head).pos(), CompilerProperties.Warnings.UncheckedVarargsNonReifiableType(varargElemType));
        }
    }

    private boolean isTrustMeAllowedOnMethod(Symbol s) {
        return (s.flags() & 0x400000000L) != 0L && (s.isConstructor() || (s.flags() & (long)(0x18 | (Source.Feature.PRIVATE_SAFE_VARARGS.allowedInSource(this.source) ? 2 : 0))) != 0L);
    }

    Type checkLocalVarType(JCDiagnostic.DiagnosticPosition pos, Type t, Name name) {
        if (t.hasTag(TypeTag.BOT)) {
            this.log.error(pos, CompilerProperties.Errors.CantInferLocalVarType(name, CompilerProperties.Fragments.LocalCantInferNull));
            return this.types.createErrorType(t);
        }
        if (t.hasTag(TypeTag.VOID)) {
            this.log.error(pos, CompilerProperties.Errors.CantInferLocalVarType(name, CompilerProperties.Fragments.LocalCantInferVoid));
            return this.types.createErrorType(t);
        }
        return this.types.upward(t, this.types.captures(t)).baseType();
    }

    Type checkMethod(Type mtype, Symbol sym, Env<AttrContext> env, List<JCTree.JCExpression> argtrees, List<Type> argtypes, boolean useVarargs, InferenceContext inferenceContext) {
        List<JCTree.JCExpression> args;
        Type last;
        if (inferenceContext.free(mtype)) {
            inferenceContext.addFreeTypeListener(List.of(mtype), solvedContext -> this.checkMethod(solvedContext.asInstType(mtype), sym, env, argtrees, argtypes, useVarargs, solvedContext));
            return mtype;
        }
        Type owntype = mtype;
        List<Type> formals = owntype.getParameterTypes();
        List<Type> nonInferred = sym.type.getParameterTypes();
        if (nonInferred.length() != formals.length()) {
            nonInferred = formals;
        }
        Type type = last = useVarargs ? formals.last() : null;
        if (sym.name == this.names.init && sym.owner == this.syms.enumSym) {
            formals = formals.tail.tail;
            nonInferred = nonInferred.tail.tail;
        }
        if ((sym.flags() & 0x200000000000000L) != 0L) {
            formals = formals.tail;
            nonInferred = nonInferred.tail;
        }
        if ((args = argtrees) != null) {
            while (formals.head != last) {
                JCTree arg = (JCTree)args.head;
                Warner warn = this.convertWarner(arg.pos(), arg.type, (Type)nonInferred.head);
                this.assertConvertible(arg, arg.type, (Type)formals.head, warn);
                args = args.tail;
                formals = formals.tail;
                nonInferred = nonInferred.tail;
            }
            if (useVarargs) {
                Type varArg = this.types.elemtype(last);
                while (args.tail != null) {
                    JCTree arg = (JCTree)args.head;
                    Warner warn = this.convertWarner(arg.pos(), arg.type, varArg);
                    this.assertConvertible(arg, arg.type, varArg, warn);
                    args = args.tail;
                }
            } else if ((sym.flags() & 0x400400000000L) == 0x400000000L) {
                Type varParam = owntype.getParameterTypes().last();
                Type lastArg = argtypes.last();
                if (this.types.isSubtypeUnchecked(lastArg, this.types.elemtype(varParam)) && !this.types.isSameType(this.types.erasure(varParam), this.types.erasure(lastArg))) {
                    this.log.warning(argtrees.last().pos(), CompilerProperties.Warnings.InexactNonVarargsCall(this.types.elemtype(varParam), varParam));
                }
            }
        }
        if (useVarargs) {
            Type argtype = owntype.getParameterTypes().last();
            if (!(this.types.isReifiable(argtype) || sym.baseSymbol().attribute(this.syms.trustMeType.tsym) != null && this.isTrustMeAllowedOnMethod(sym))) {
                this.warnUnchecked(env.tree.pos(), CompilerProperties.Warnings.UncheckedGenericArrayCreation(argtype));
            }
            TreeInfo.setVarargsElement(env.tree, this.types.elemtype(argtype));
        }
        return owntype;
    }

    private void assertConvertible(JCTree tree, Type actual, Type formal, Warner warn) {
        if (this.types.isConvertible(actual, formal, warn)) {
            return;
        }
        if (formal.isCompound() && this.types.isSubtype(actual, this.types.supertype(formal)) && this.types.isSubtypeUnchecked(actual, this.types.interfaces(formal), warn)) {
            return;
        }
    }

    public boolean checkValidGenericType(Type t) {
        return this.firstIncompatibleTypeArg(t) == null;
    }

    private Type firstIncompatibleTypeArg(Type type) {
        List<Type> formals = type.tsym.type.allparams();
        List<Type> actuals = type.allparams();
        List<Type> args = type.getTypeArguments();
        List<Type> forms = type.tsym.type.getTypeArguments();
        ListBuffer<Type> bounds_buf = new ListBuffer<Type>();
        while (args.nonEmpty() && forms.nonEmpty()) {
            bounds_buf.append(this.types.subst(((Type)forms.head).getUpperBound(), formals, actuals));
            args = args.tail;
            forms = forms.tail;
        }
        args = type.getTypeArguments();
        List<Type> tvars_cap = this.types.substBounds(formals, formals, this.types.capture(type).allparams());
        while (args.nonEmpty() && tvars_cap.nonEmpty()) {
            ((Type)args.head).withTypeVar((Type.TypeVar)tvars_cap.head);
            args = args.tail;
            tvars_cap = tvars_cap.tail;
        }
        args = type.getTypeArguments();
        List bounds = bounds_buf.toList();
        while (args.nonEmpty() && bounds.nonEmpty()) {
            Type actual = (Type)args.head;
            if (!(this.isTypeArgErroneous(actual) || ((Type)bounds.head).isErroneous() || this.checkExtends(actual, (Type)bounds.head))) {
                return (Type)args.head;
            }
            args = args.tail;
            bounds = bounds.tail;
        }
        args = type.getTypeArguments();
        bounds = bounds_buf.toList();
        for (Type arg : this.types.capture(type).getTypeArguments()) {
            if (arg.hasTag(TypeTag.TYPEVAR) && arg.getUpperBound().isErroneous() && !((Type)bounds.head).isErroneous() && !this.isTypeArgErroneous((Type)args.head)) {
                return (Type)args.head;
            }
            bounds = bounds.tail;
            args = args.tail;
        }
        return null;
    }

    boolean isTypeArgErroneous(Type t) {
        return this.isTypeArgErroneous.visit(t);
    }

    long checkFlags(JCDiagnostic.DiagnosticPosition pos, long flags, Symbol sym, JCTree tree) {
        long mask;
        long implicit = 0L;
        switch (sym.kind) {
            case VAR: {
                if (TreeInfo.isReceiverParam(tree)) {
                    mask = 0x200000000L;
                    break;
                }
                if (sym.owner.kind != Kinds.Kind.TYP) {
                    mask = 0x200000010L;
                    break;
                }
                if ((sym.owner.flags_field & 0x200L) != 0L) {
                    implicit = 25L;
                    mask = 25L;
                    break;
                }
                mask = 16607L;
                break;
            }
            case MTH: {
                if (sym.name == this.names.init) {
                    if ((sym.owner.flags_field & 0x4000L) != 0L) {
                        implicit = 2L;
                        mask = 2L;
                    } else {
                        mask = 7L;
                    }
                } else if ((sym.owner.flags_field & 0x200L) != 0L) {
                    if ((sym.owner.flags_field & 0x2000L) != 0L) {
                        mask = 1025L;
                        implicit = 1025L;
                    } else if ((flags & 0x8000000000AL) != 0L) {
                        mask = 8796093025291L;
                        long l = implicit = (flags & 2L) != 0L ? 0L : 1L;
                        if ((flags & 0x80000000000L) != 0L) {
                            implicit |= 0x400L;
                        }
                    } else {
                        implicit = 1025L;
                        mask = 1025L;
                    }
                } else {
                    mask = (sym.owner.flags_field & 0x2000000000000000L) != 0L ? 3135L : 3391L;
                }
                if ((flags & 0x800L) != 0L) {
                    this.warnOnExplicitStrictfp(pos);
                }
                if (((flags | implicit) & 0x400L) != 0L && (flags & 0x80000000000L) == 0L) break;
                implicit |= sym.owner.flags_field & 0x800L;
                break;
            }
            case TYP: {
                if (sym.owner.kind.matches(Kinds.KindSelector.VAL_MTH) || sym.isDirectlyOrIndirectlyLocal() && (flags & 0x2000L) != 0L) {
                    boolean implicitlyStatic = !sym.isAnonymous() && ((flags & 0x2000000000000000L) != 0L || (flags & 0x4000L) != 0L || (flags & 0x200L) != 0L);
                    boolean staticOrImplicitlyStatic = (flags & 8L) != 0L || implicitlyStatic;
                    mask = staticOrImplicitlyStatic && this.allowRecords && (flags & 0x2000L) == 0L ? 24088L : 23568L;
                    implicit = implicitlyStatic ? 8L : implicit;
                } else if (sym.owner.kind == Kinds.Kind.TYP) {
                    long l = mask = (flags & 8L) != 0L && this.allowRecords && (flags & 0x2000L) == 0L ? -4611686018427363809L : -4611686018427363817L;
                    if (sym.owner.owner.kind == Kinds.Kind.PCK || (sym.owner.flags_field & 8L) != 0L) {
                        mask |= 8L;
                    } else if (!(this.allowRecords || (flags & 0x4000L) == 0L && (flags & 0x2000000000000000L) == 0L)) {
                        this.log.error(pos, CompilerProperties.Errors.StaticDeclarationNotAllowedInInnerClasses);
                    }
                    if ((flags & 0x2000000000004200L) != 0L) {
                        implicit = 8L;
                    }
                } else {
                    mask = -4611686018427355631L;
                }
                if ((flags & 0x200L) != 0L) {
                    implicit |= 0x400L;
                }
                if ((flags & 0x4000L) != 0L) {
                    mask &= 0x3FFFFFFFFFFFFBEFL;
                    implicit |= this.implicitEnumFinalFlag(tree);
                }
                if ((flags & 0x2000000000000000L) != 0L) {
                    mask &= 0xFFFFFFFFFFFFFBFFL;
                    implicit |= 0x10L;
                }
                if ((flags & 0x800L) != 0L) {
                    this.warnOnExplicitStrictfp(pos);
                }
                implicit |= sym.owner.flags_field & 0x800L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long illegal = flags & 0xC000080000000FFFL & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        if (illegal != 0L) {
            if ((illegal & 0x200L) != 0L) {
                this.log.error(pos, (flags & 0x2000L) != 0L ? CompilerProperties.Errors.AnnotationDeclNotAllowedHere : CompilerProperties.Errors.IntfNotAllowedHere);
                mask |= 0x200L;
            } else {
                this.log.error(pos, CompilerProperties.Errors.ModNotAllowedHere(Flags.asFlagSet(illegal)));
            }
        } else if (sym.kind != Kinds.Kind.TYP && !this.checkDisjoint(pos, flags, 1024L, 0x8000000000AL) || !this.checkDisjoint(pos, flags, 10L, 0x80000000000L) || !this.checkDisjoint(pos, flags, 1536L, 304L) || !this.checkDisjoint(pos, flags, 1L, 6L) || !this.checkDisjoint(pos, flags, 2L, 5L) || !this.checkDisjoint(pos, flags, 16L, 64L) || sym.kind != Kinds.Kind.TYP && !this.checkDisjoint(pos, flags, 1280L, 2048L) || !this.checkDisjoint(pos, flags, 16L, -4611686018427387904L) || !this.checkDisjoint(pos, flags, 0x4000000000000000L, -9223372036854775792L) || this.checkDisjoint(pos, flags, 0x4000000000000000L, 8192L)) {
            // empty if block
        }
        return flags & (mask | 0x3FFFF7FFFFFFF000L) | implicit;
    }

    private void warnOnExplicitStrictfp(JCDiagnostic.DiagnosticPosition pos) {
        JCDiagnostic.DiagnosticPosition prevLintPos = this.deferredLintHandler.setPos(pos);
        try {
            this.deferredLintHandler.report(_l -> {
                if (this.lint.isEnabled(Lint.LintCategory.STRICTFP)) {
                    this.log.warning(Lint.LintCategory.STRICTFP, pos, CompilerProperties.Warnings.Strictfp);
                }
            });
        }
        finally {
            this.deferredLintHandler.setPos(prevLintPos);
        }
    }

    private long implicitEnumFinalFlag(JCTree tree) {
        if (!tree.hasTag(JCTree.Tag.CLASSDEF)) {
            return 0L;
        }
        class SpecialTreeVisitor
        extends JCTree.Visitor {
            boolean specialized = false;

            SpecialTreeVisitor() {
            }

            @Override
            public void visitTree(JCTree tree) {
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl tree) {
                JCTree.JCExpression jCExpression;
                if ((tree.mods.flags & 0x4000L) != 0L && (jCExpression = tree.init) instanceof JCTree.JCNewClass) {
                    JCTree.JCNewClass newClass = (JCTree.JCNewClass)jCExpression;
                    if (newClass.def != null) {
                        this.specialized = true;
                    }
                }
            }
        }
        SpecialTreeVisitor sts = new SpecialTreeVisitor();
        JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)tree;
        for (JCTree defs : cdef.defs) {
            defs.accept(sts);
            if (!sts.specialized) continue;
            return this.allowSealed ? 0x4000000000000000L : 0L;
        }
        return 16L;
    }

    void validate(JCTree tree, Env<AttrContext> env) {
        this.validate(tree, env, true);
    }

    void validate(JCTree tree, Env<AttrContext> env, boolean checkRaw) {
        new Validator(env).validateTree(tree, checkRaw, true);
    }

    void validate(List<? extends JCTree> trees, Env<AttrContext> env) {
        List<JCTree> l = trees;
        while (l.nonEmpty()) {
            this.validate((JCTree)l.head, env);
            l = l.tail;
        }
    }

    void checkRaw(JCTree tree, Env<AttrContext> env) {
        if (this.lint.isEnabled(Lint.LintCategory.RAW) && tree.type.hasTag(TypeTag.CLASS) && !TreeInfo.isDiamond(tree) && !this.withinAnonConstr(env) && tree.type.isRaw()) {
            this.log.warning(Lint.LintCategory.RAW, tree.pos(), CompilerProperties.Warnings.RawClassUse(tree.type, tree.type.tsym.type));
        }
    }

    private boolean withinAnonConstr(Env<AttrContext> env) {
        return env.enclClass.name.length() == 0 && env.enclMethod != null && env.enclMethod.name == this.names.init;
    }

    boolean subset(Type t, List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (this.types.isSubtype(t, (Type)l.head)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    boolean intersects(Type t, List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (this.types.isSubtype(t, (Type)l.head) || this.types.isSubtype((Type)l.head, t)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    List<Type> incl(Type t, List<Type> ts) {
        return this.subset(t, ts) ? ts : this.excl(t, ts).prepend(t);
    }

    List<Type> excl(Type t, List<Type> ts) {
        if (ts.isEmpty()) {
            return ts;
        }
        List<Type> ts1 = this.excl(t, ts.tail);
        if (this.types.isSubtype((Type)ts.head, t)) {
            return ts1;
        }
        if (ts1 == ts.tail) {
            return ts;
        }
        return ts1.prepend((Type)ts.head);
    }

    List<Type> union(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = ts1;
        List<Type> l = ts2;
        while (l.nonEmpty()) {
            ts = this.incl((Type)l.head, ts);
            l = l.tail;
        }
        return ts;
    }

    List<Type> diff(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = ts1;
        List<Type> l = ts2;
        while (l.nonEmpty()) {
            ts = this.excl((Type)l.head, ts);
            l = l.tail;
        }
        return ts;
    }

    public List<Type> intersect(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = List.nil();
        List<Type> l = ts1;
        while (l.nonEmpty()) {
            if (this.subset((Type)l.head, ts2)) {
                ts = this.incl((Type)l.head, ts);
            }
            l = l.tail;
        }
        l = ts2;
        while (l.nonEmpty()) {
            if (this.subset((Type)l.head, ts1)) {
                ts = this.incl((Type)l.head, ts);
            }
            l = l.tail;
        }
        return ts;
    }

    boolean isUnchecked(Symbol.ClassSymbol exc) {
        return exc.kind == Kinds.Kind.ERR || exc.isSubClass(this.syms.errorType.tsym, this.types) || exc.isSubClass(this.syms.runtimeExceptionType.tsym, this.types);
    }

    boolean isUnchecked(Type exc) {
        return exc.hasTag(TypeTag.TYPEVAR) ? this.isUnchecked(this.types.supertype(exc)) : (exc.hasTag(TypeTag.CLASS) ? this.isUnchecked((Symbol.ClassSymbol)exc.tsym) : exc.hasTag(TypeTag.BOT));
    }

    boolean isChecked(Type exc) {
        return !this.isUnchecked(exc);
    }

    boolean isUnchecked(JCDiagnostic.DiagnosticPosition pos, Type exc) {
        try {
            return this.isUnchecked(exc);
        }
        catch (Symbol.CompletionFailure ex) {
            this.completionError(pos, ex);
            return true;
        }
    }

    boolean isHandled(Type exc, List<Type> handled) {
        return this.isUnchecked(exc) || this.subset(exc, handled);
    }

    List<Type> unhandled(List<Type> thrown, List<Type> handled) {
        List<Type> unhandled = List.nil();
        List<Type> l = thrown;
        while (l.nonEmpty()) {
            if (!this.isHandled((Type)l.head, handled)) {
                unhandled = unhandled.prepend((Type)l.head);
            }
            l = l.tail;
        }
        return unhandled;
    }

    static int protection(long flags) {
        switch ((short)(flags & 7L)) {
            case 2: {
                return 3;
            }
            case 4: {
                return 1;
            }
            default: {
                return 0;
            }
            case 0: 
        }
        return 2;
    }

    JCDiagnostic.Fragment cannotOverride(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        Symbol mloc = m.location();
        Symbol oloc = other.location();
        if ((other.owner.flags() & 0x200L) == 0L) {
            return CompilerProperties.Fragments.CantOverride(m, mloc, other, oloc);
        }
        if ((m.owner.flags() & 0x200L) == 0L) {
            return CompilerProperties.Fragments.CantImplement(m, mloc, other, oloc);
        }
        return CompilerProperties.Fragments.ClashesWith(m, mloc, other, oloc);
    }

    JCDiagnostic.Fragment uncheckedOverrides(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        Symbol mloc = m.location();
        Symbol oloc = other.location();
        if ((other.owner.flags() & 0x200L) == 0L) {
            return CompilerProperties.Fragments.UncheckedOverride(m, mloc, other, oloc);
        }
        if ((m.owner.flags() & 0x200L) == 0L) {
            return CompilerProperties.Fragments.UncheckedImplement(m, mloc, other, oloc);
        }
        return CompilerProperties.Fragments.UncheckedClashWith(m, mloc, other, oloc);
    }

    JCDiagnostic.Fragment varargsOverrides(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        Symbol mloc = m.location();
        Symbol oloc = other.location();
        if ((other.owner.flags() & 0x200L) == 0L) {
            return CompilerProperties.Fragments.VarargsOverride(m, mloc, other, oloc);
        }
        if ((m.owner.flags() & 0x200L) == 0L) {
            return CompilerProperties.Fragments.VarargsImplement(m, mloc, other, oloc);
        }
        return CompilerProperties.Fragments.VarargsClashWith(m, mloc, other, oloc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkOverride(JCTree tree, Symbol.MethodSymbol m, Symbol.MethodSymbol other, Symbol.ClassSymbol origin) {
        if ((m.flags() & 0x80001000L) != 0L || (other.flags() & 0x1000L) != 0L) {
            return;
        }
        if ((m.flags() & 8L) != 0L && (other.flags() & 8L) == 0L) {
            this.log.error(TreeInfo.diagnosticPositionFor((Symbol)m, tree), CompilerProperties.Errors.OverrideStatic(this.cannotOverride(m, other)));
            m.flags_field |= 0x200000000000L;
            return;
        }
        if ((other.flags() & 0x10L) != 0L || (m.flags() & 8L) == 0L && (other.flags() & 8L) != 0L) {
            this.log.error(TreeInfo.diagnosticPositionFor((Symbol)m, tree), CompilerProperties.Errors.OverrideMeth(this.cannotOverride(m, other), Flags.asFlagSet(other.flags() & 0x18L)));
            m.flags_field |= 0x200000000000L;
            return;
        }
        if ((m.owner.flags() & 0x2000L) != 0L) {
            return;
        }
        if (Check.protection(m.flags()) > Check.protection(other.flags())) {
            this.log.error(TreeInfo.diagnosticPositionFor((Symbol)m, tree), (other.flags() & 7L) == 0L ? CompilerProperties.Errors.OverrideWeakerAccess(this.cannotOverride(m, other), "package") : CompilerProperties.Errors.OverrideWeakerAccess(this.cannotOverride(m, other), Flags.asFlagSet(other.flags() & 7L)));
            m.flags_field |= 0x200000000000L;
            return;
        }
        if (this.shouldCheckPreview(m, other, origin)) {
            this.checkPreview(tree.pos(), m, other);
        }
        Type mt = this.types.memberType(origin.type, m);
        Type ot = this.types.memberType(origin.type, other);
        List<Type> mtvars = mt.getTypeArguments();
        List<Type> otvars = ot.getTypeArguments();
        Type mtres = mt.getReturnType();
        Type otres = this.types.subst(ot.getReturnType(), otvars, mtvars);
        this.overrideWarner.clear();
        boolean resultTypesOK = this.types.returnTypeSubstitutable(mt, ot, otres, this.overrideWarner);
        if (!resultTypesOK) {
            if ((m.flags() & 8L) != 0L && (other.flags() & 8L) != 0L) {
                this.log.error(TreeInfo.diagnosticPositionFor((Symbol)m, tree), CompilerProperties.Errors.OverrideIncompatibleRet(CompilerProperties.Fragments.CantHide(m, m.location(), other, other.location()), mtres, otres));
                m.flags_field |= 0x200000000000L;
            } else {
                this.log.error(TreeInfo.diagnosticPositionFor((Symbol)m, tree), CompilerProperties.Errors.OverrideIncompatibleRet(this.cannotOverride(m, other), mtres, otres));
                m.flags_field |= 0x200000000000L;
            }
            return;
        }
        if (this.overrideWarner.hasNonSilentLint(Lint.LintCategory.UNCHECKED)) {
            this.warnUnchecked(TreeInfo.diagnosticPositionFor((Symbol)m, tree), CompilerProperties.Warnings.OverrideUncheckedRet(this.uncheckedOverrides(m, other), mtres, otres));
        }
        List<Type> otthrown = this.types.subst(ot.getThrownTypes(), otvars, mtvars);
        List<Type> unhandledErased = this.unhandled(mt.getThrownTypes(), this.types.erasure(otthrown));
        List<Type> unhandledUnerased = this.unhandled(mt.getThrownTypes(), otthrown);
        if (unhandledErased.nonEmpty()) {
            this.log.error(TreeInfo.diagnosticPositionFor((Symbol)m, tree), CompilerProperties.Errors.OverrideMethDoesntThrow(this.cannotOverride(m, other), (Type)unhandledUnerased.head));
            m.flags_field |= 0x200000000000L;
            return;
        }
        if (unhandledUnerased.nonEmpty()) {
            this.warnUnchecked(TreeInfo.diagnosticPositionFor((Symbol)m, tree), CompilerProperties.Warnings.OverrideUncheckedThrown(this.cannotOverride(m, other), (Type)unhandledUnerased.head));
            return;
        }
        if (((m.flags() ^ other.flags()) & 0x400000000L) != 0L && this.lint.isEnabled(Lint.LintCategory.OVERRIDES)) {
            this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)m, tree), (m.flags() & 0x400000000L) != 0L ? CompilerProperties.Warnings.OverrideVarargsMissing(this.varargsOverrides(m, other)) : CompilerProperties.Warnings.OverrideVarargsExtra(this.varargsOverrides(m, other)));
        }
        if ((other.flags() & 0x80000000L) != 0L) {
            this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)m, tree), CompilerProperties.Warnings.OverrideBridge(this.uncheckedOverrides(m, other)));
        }
        if (!this.isDeprecatedOverrideIgnorable(other, origin)) {
            Lint prevLint = this.setLint(this.lint.augment(m));
            try {
                this.checkDeprecated(() -> TreeInfo.diagnosticPositionFor((Symbol)m, tree), (Symbol)m, (Symbol)other);
            }
            finally {
                this.setLint(prevLint);
            }
        }
    }

    private boolean shouldCheckPreview(Symbol.MethodSymbol m, Symbol.MethodSymbol other, Symbol.ClassSymbol origin) {
        if (m.owner != origin || (other.flags() & 0x100000000000000L) == 0L) {
            return false;
        }
        for (Symbol s : this.types.membersClosure(origin.type, false).getSymbolsByName(m.name)) {
            if (m == s || !m.overrides(s, origin, this.types, false)) continue;
            return s == other;
        }
        return false;
    }

    private boolean isDeprecatedOverrideIgnorable(Symbol.MethodSymbol m, Symbol.ClassSymbol origin) {
        Symbol.ClassSymbol mc = m.enclClass();
        Type st = this.types.supertype(origin.type);
        if (!st.hasTag(TypeTag.CLASS)) {
            return true;
        }
        Symbol.MethodSymbol stimpl = m.implementation((Symbol.ClassSymbol)st.tsym, this.types, false);
        if (mc != null && (mc.flags() & 0x200L) != 0L) {
            List<Type> intfs = this.types.interfaces(origin.type);
            return intfs.contains(mc.type) ? false : stimpl != null;
        }
        return stimpl != m;
    }

    public void checkCompatibleConcretes(JCDiagnostic.DiagnosticPosition pos, Type site) {
        Type sup = this.types.supertype(site);
        if (!sup.hasTag(TypeTag.CLASS)) {
            return;
        }
        Type t1 = sup;
        while (t1.hasTag(TypeTag.CLASS) && t1.tsym.type.isParameterized()) {
            for (Symbol s1 : t1.tsym.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                if (s1.kind != Kinds.Kind.MTH || (s1.flags() & 0x80001008L) != 0L || !s1.isInheritedIn(site.tsym, this.types) || ((Symbol.MethodSymbol)s1).implementation(site.tsym, this.types, true) != s1) continue;
                Type st1 = this.types.memberType(t1, s1);
                int s1ArgsLength = st1.getParameterTypes().length();
                if (st1 == s1.type) continue;
                Type t2 = sup;
                while (t2.hasTag(TypeTag.CLASS)) {
                    for (Symbol s2 : t2.tsym.members().getSymbolsByName(s1.name)) {
                        Type st2;
                        if (s2 == s1 || s2.kind != Kinds.Kind.MTH || (s2.flags() & 0x80001008L) != 0L || s2.type.getParameterTypes().length() != s1ArgsLength || !s2.isInheritedIn(site.tsym, this.types) || ((Symbol.MethodSymbol)s2).implementation(site.tsym, this.types, true) != s2 || !this.types.overrideEquivalent(st1, st2 = this.types.memberType(t2, s2))) continue;
                        this.log.error(pos, CompilerProperties.Errors.ConcreteInheritanceConflict(s1, t1, s2, t2, sup));
                    }
                    t2 = this.types.supertype(t2);
                }
            }
            t1 = this.types.supertype(t1);
        }
    }

    public boolean checkCompatibleAbstracts(JCDiagnostic.DiagnosticPosition pos, Type t1, Type t2, Type site) {
        if ((site.tsym.flags() & 0x1000000L) != 0L) {
            t1 = this.types.capture(t1);
            t2 = this.types.capture(t2);
        }
        return this.firstIncompatibility(pos, t1, t2, site) == null;
    }

    private Symbol firstIncompatibility(JCDiagnostic.DiagnosticPosition pos, Type t1, Type t2, Type site) {
        HashMap<Symbol.TypeSymbol, Type> interfaces2;
        HashMap<Symbol.TypeSymbol, Type> interfaces1 = new HashMap<Symbol.TypeSymbol, Type>();
        this.closure(t1, interfaces1);
        if (t1 == t2) {
            interfaces2 = interfaces1;
        } else {
            interfaces2 = new HashMap<Symbol.TypeSymbol, Type>();
            this.closure(t2, interfaces1, interfaces2);
        }
        for (Type t3 : interfaces1.values()) {
            for (Type t4 : interfaces2.values()) {
                Symbol s = this.firstDirectIncompatibility(pos, t3, t4, site);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    private void closure(Type t, Map<Symbol.TypeSymbol, Type> typeMap) {
        if (!t.hasTag(TypeTag.CLASS)) {
            return;
        }
        if (typeMap.put(t.tsym, t) == null) {
            this.closure(this.types.supertype(t), typeMap);
            for (Type i : this.types.interfaces(t)) {
                this.closure(i, typeMap);
            }
        }
    }

    private void closure(Type t, Map<Symbol.TypeSymbol, Type> typesSkip, Map<Symbol.TypeSymbol, Type> typeMap) {
        if (!t.hasTag(TypeTag.CLASS)) {
            return;
        }
        if (typesSkip.get(t.tsym) != null) {
            return;
        }
        if (typeMap.put(t.tsym, t) == null) {
            this.closure(this.types.supertype(t), typesSkip, typeMap);
            for (Type i : this.types.interfaces(t)) {
                this.closure(i, typesSkip, typeMap);
            }
        }
    }

    private Symbol firstDirectIncompatibility(JCDiagnostic.DiagnosticPosition pos, Type t1, Type t2, Type site) {
        for (Symbol s1 : t1.tsym.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            Symbol.MethodSymbol impl;
            Type st1 = null;
            if (s1.kind != Kinds.Kind.MTH || !s1.isInheritedIn(site.tsym, this.types) || (s1.flags() & 0x1000L) != 0L || (impl = ((Symbol.MethodSymbol)s1).implementation(site.tsym, this.types, false)) != null && (impl.flags() & 0x400L) == 0L) continue;
            for (Symbol s2 : t2.tsym.members().getSymbolsByName(s1.name)) {
                Type st2;
                if (s1 == s2 || s2.kind != Kinds.Kind.MTH || !s2.isInheritedIn(site.tsym, this.types) || (s2.flags() & 0x1000L) != 0L) continue;
                if (st1 == null) {
                    st1 = this.types.memberType(t1, s1);
                }
                if (this.types.overrideEquivalent(st1, st2 = this.types.memberType(t2, s2))) {
                    Type rt2;
                    List<Type> tvars1 = st1.getTypeArguments();
                    List<Type> tvars2 = st2.getTypeArguments();
                    Type rt1 = st1.getReturnType();
                    boolean compat = this.types.isSameType(rt1, rt2 = this.types.subst(st2.getReturnType(), tvars2, tvars1)) || !rt1.isPrimitiveOrVoid() && !rt2.isPrimitiveOrVoid() && (this.types.covariantReturnType(rt1, rt2, this.types.noWarnings) || this.types.covariantReturnType(rt2, rt1, this.types.noWarnings)) || this.checkCommonOverriderIn(s1, s2, site);
                    if (compat) continue;
                    if (this.types.isSameType(t1, t2)) {
                        this.log.error(pos, CompilerProperties.Errors.IncompatibleDiffRetSameType(t1, s2.name, this.types.memberType(t2, s2).getParameterTypes()));
                    } else {
                        this.log.error(pos, CompilerProperties.Errors.TypesIncompatible(t1, t2, CompilerProperties.Fragments.IncompatibleDiffRet(s2.name, this.types.memberType(t2, s2).getParameterTypes())));
                    }
                    return s2;
                }
                if (!this.checkNameClash((Symbol.ClassSymbol)site.tsym, s1, s2) || this.checkCommonOverriderIn(s1, s2, site)) continue;
                this.log.error(pos, CompilerProperties.Errors.NameClashSameErasureNoOverride(s1.name, this.types.memberType(site, s1).asMethodType().getParameterTypes(), s1.location(), s2.name, this.types.memberType(site, s2).asMethodType().getParameterTypes(), s2.location()));
                return s2;
            }
        }
        return null;
    }

    boolean checkCommonOverriderIn(Symbol s1, Symbol s2, Type site) {
        HashMap<Symbol.TypeSymbol, Type> supertypes = new HashMap<Symbol.TypeSymbol, Type>();
        Type st1 = this.types.memberType(site, s1);
        Type st2 = this.types.memberType(site, s2);
        this.closure(site, supertypes);
        for (Type t : supertypes.values()) {
            for (Symbol s3 : t.tsym.members().getSymbolsByName(s1.name)) {
                Type st3;
                if (s3 == s1 || s3 == s2 || s3.kind != Kinds.Kind.MTH || (s3.flags() & 0x80001000L) != 0L || !this.types.overrideEquivalent(st3 = this.types.memberType(site, s3), st1) || !this.types.overrideEquivalent(st3, st2) || !this.types.returnTypeSubstitutable(st3, st1) || !this.types.returnTypeSubstitutable(st3, st2)) continue;
                return true;
            }
        }
        return false;
    }

    void checkOverride(Env<AttrContext> env, JCTree.JCMethodDecl tree, Symbol.MethodSymbol m) {
        boolean mustOverride;
        Optional<Symbol.RecordComponent> recordComponent;
        Symbol.ClassSymbol origin = (Symbol.ClassSymbol)m.owner;
        if ((origin.flags() & 0x4000L) != 0L && this.names.finalize.equals(m.name) && m.overrides(this.syms.enumFinalFinalize, origin, this.types, false)) {
            this.log.error(tree.pos(), CompilerProperties.Errors.EnumNoFinalize);
            return;
        }
        if (this.allowRecords && origin.isRecord() && (recordComponent = origin.getRecordComponents().stream().filter(rc -> rc.accessor == tree.sym && (rc.accessor.flags_field & 0x1000000L) == 0L).findFirst()).isPresent()) {
            return;
        }
        Type t = origin.type;
        while (t.hasTag(TypeTag.CLASS)) {
            if (t != origin.type) {
                this.checkOverride((JCTree)tree, t, origin, m);
            }
            for (Type t2 : this.types.interfaces(t)) {
                this.checkOverride((JCTree)tree, t2, origin, m);
            }
            t = this.types.supertype(t);
        }
        boolean explicitOverride = m.attribute(this.syms.overrideType.tsym) != null;
        boolean bl = mustOverride = explicitOverride || ((AttrContext)env.info).isAnonymousDiamond && !m.isConstructor() && !m.isPrivate();
        if (mustOverride && !this.isOverrider(m)) {
            JCDiagnostic.DiagnosticPosition pos = tree.pos();
            for (JCTree.JCAnnotation a : tree.getModifiers().annotations) {
                if (a.annotationType.type.tsym != this.syms.overrideType.tsym) continue;
                pos = a.pos();
                break;
            }
            this.log.error(pos, explicitOverride ? (m.isStatic() ? CompilerProperties.Errors.StaticMethodsCannotBeAnnotatedWithOverride : CompilerProperties.Errors.MethodDoesNotOverrideSuperclass) : CompilerProperties.Errors.AnonymousDiamondMethodDoesNotOverrideSuperclass(CompilerProperties.Fragments.DiamondAnonymousMethodsImplicitlyOverride));
        }
    }

    void checkOverride(JCTree tree, Type site, Symbol.ClassSymbol origin, Symbol.MethodSymbol m) {
        Symbol.TypeSymbol c = site.tsym;
        for (Symbol sym : c.members().getSymbolsByName(m.name)) {
            if (!m.overrides(sym, origin, this.types, false) || (sym.flags() & 0x400L) != 0L) continue;
            this.checkOverride(tree, m, (Symbol.MethodSymbol)sym, origin);
        }
    }

    public void checkClassOverrideEqualsAndHashIfNeeded(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol someClass) {
        List<Type> interfaces;
        if (someClass == (Symbol.ClassSymbol)this.syms.objectType.tsym || someClass.isInterface() || someClass.isEnum() || (someClass.flags() & 0x2000L) != 0L || (someClass.flags() & 0x400L) != 0L) {
            return;
        }
        if (someClass.isAnonymous() && (interfaces = this.types.interfaces(someClass.type)) != null && !interfaces.isEmpty() && ((Type)interfaces.head).tsym == this.syms.comparatorType.tsym) {
            return;
        }
        this.checkClassOverrideEqualsAndHash(pos, someClass);
    }

    private void checkClassOverrideEqualsAndHash(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol someClass) {
        if (this.lint.isEnabled(Lint.LintCategory.OVERRIDES)) {
            boolean overridesHashCode;
            Symbol.MethodSymbol equalsAtObject = (Symbol.MethodSymbol)this.syms.objectType.tsym.members().findFirst(this.names.equals);
            Symbol.MethodSymbol hashCodeAtObject = (Symbol.MethodSymbol)this.syms.objectType.tsym.members().findFirst(this.names.hashCode);
            Symbol.MethodSymbol equalsImpl = this.types.implementation(equalsAtObject, someClass, false, this.equalsHasCodeFilter);
            boolean overridesEquals = equalsImpl != null && equalsImpl.owner == someClass;
            boolean bl = overridesHashCode = this.types.implementation(hashCodeAtObject, someClass, false, this.equalsHasCodeFilter) != hashCodeAtObject;
            if (overridesEquals && !overridesHashCode) {
                this.log.warning(Lint.LintCategory.OVERRIDES, pos, CompilerProperties.Warnings.OverrideEqualsButNotHashcode(someClass));
            }
        }
    }

    public void checkHasMain(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
        boolean found = false;
        for (Symbol sym : c.members().getSymbolsByName(this.names.main)) {
            Symbol.MethodSymbol meth;
            if (sym.kind != Kinds.Kind.MTH || (sym.flags() & 2L) != 0L || !this.types.isSameType((meth = (Symbol.MethodSymbol)sym).getReturnType(), this.syms.voidType)) continue;
            if (meth.params.isEmpty()) {
                found = true;
                break;
            }
            if (meth.params.size() != 1 || !this.types.isSameType(((Symbol.VarSymbol)meth.params.head).type, this.types.makeArrayType(this.syms.stringType))) continue;
            found = true;
            break;
        }
        if (!found) {
            this.log.error(pos, CompilerProperties.Errors.ImplicitClassDoesNotHaveMainMethod);
        }
    }

    public void checkModuleName(JCTree.JCModuleDecl tree) {
        Name moduleName = tree.sym.name;
        Assert.checkNonNull(moduleName);
        if (this.lint.isEnabled(Lint.LintCategory.MODULE)) {
            JCTree.JCExpression qualId = tree.qualId;
            while (qualId != null) {
                String moduleNameComponentString;
                int nameLength;
                JCDiagnostic.DiagnosticPosition pos;
                Name componentName;
                switch (qualId.getTag()) {
                    case SELECT: {
                        JCTree.JCFieldAccess selectNode = (JCTree.JCFieldAccess)qualId;
                        componentName = selectNode.name;
                        pos = selectNode.pos();
                        qualId = selectNode.selected;
                        break;
                    }
                    case IDENT: {
                        componentName = ((JCTree.JCIdent)qualId).name;
                        pos = qualId.pos();
                        qualId = null;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected qualified identifier: " + qualId.toString()));
                    }
                }
                if (componentName == null || (nameLength = (moduleNameComponentString = componentName.toString()).length()) <= 0 || !Character.isDigit(moduleNameComponentString.charAt(nameLength - 1))) continue;
                this.log.warning(Lint.LintCategory.MODULE, pos, CompilerProperties.Warnings.PoorChoiceForModuleName(componentName));
            }
        }
    }

    private boolean checkNameClash(Symbol.ClassSymbol origin, Symbol s1, Symbol s2) {
        ClashFilter cf = new ClashFilter(origin.type);
        return cf.test(s1) && cf.test(s2) && this.types.hasSameArgs(s1.erasure(this.types), s2.erasure(this.types));
    }

    void checkAllDefined(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
        Symbol.MethodSymbol undef = this.types.firstUnimplementedAbstract(c);
        if (undef != null) {
            Symbol.MethodSymbol undef1 = new Symbol.MethodSymbol(undef.flags(), undef.name, this.types.memberType(c.type, undef), undef.owner);
            this.log.error(pos, CompilerProperties.Errors.DoesNotOverrideAbstract(c, undef1, undef1.location()));
        }
    }

    void checkNonCyclicDecl(JCTree.JCClassDecl tree) {
        CycleChecker cc = new CycleChecker();
        cc.scan(tree);
        if (!cc.errorFound && !cc.partialCheck) {
            tree.sym.flags_field |= 0x40000000L;
        }
    }

    void checkNonCyclic(JCDiagnostic.DiagnosticPosition pos, Type t) {
        this.checkNonCyclicInternal(pos, t);
    }

    void checkNonCyclic(JCDiagnostic.DiagnosticPosition pos, Type.TypeVar t) {
        this.checkNonCyclic1(pos, t, List.nil());
    }

    private void checkNonCyclic1(JCDiagnostic.DiagnosticPosition pos, Type t, List<Type.TypeVar> seen) {
        if (t.hasTag(TypeTag.TYPEVAR) && (t.tsym.flags() & 0x10000000L) != 0L) {
            return;
        }
        if (seen.contains(t)) {
            Type.TypeVar tv = (Type.TypeVar)t;
            tv.setUpperBound(this.types.createErrorType(t));
            this.log.error(pos, CompilerProperties.Errors.CyclicInheritance(t));
        } else if (t.hasTag(TypeTag.TYPEVAR)) {
            Type.TypeVar tv = (Type.TypeVar)t;
            seen = seen.prepend(tv);
            for (Type b : this.types.getBounds(tv)) {
                this.checkNonCyclic1(pos, b, seen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNonCyclicInternal(JCDiagnostic.DiagnosticPosition pos, Type t) {
        boolean complete = true;
        Symbol.TypeSymbol c = t.tsym;
        if ((c.flags_field & 0x40000000L) != 0L) {
            return true;
        }
        if ((c.flags_field & 0x8000000L) != 0L) {
            this.noteCyclic(pos, (Symbol.ClassSymbol)c);
        } else if (!c.type.isErroneous()) {
            try {
                c.flags_field |= 0x8000000L;
                if (c.type.hasTag(TypeTag.CLASS)) {
                    Type st;
                    Type.ClassType clazz = (Type.ClassType)c.type;
                    if (clazz.interfaces_field != null) {
                        List<Type> l = clazz.interfaces_field;
                        while (l.nonEmpty()) {
                            complete &= this.checkNonCyclicInternal(pos, (Type)l.head);
                            l = l.tail;
                        }
                    }
                    if (clazz.supertype_field != null && (st = clazz.supertype_field) != null && st.hasTag(TypeTag.CLASS)) {
                        complete &= this.checkNonCyclicInternal(pos, st);
                    }
                    if (c.owner.kind == Kinds.Kind.TYP) {
                        complete &= this.checkNonCyclicInternal(pos, c.owner.type);
                    }
                }
            }
            finally {
                c.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
        }
        if (complete) {
            boolean bl = complete = (c.flags_field & 0x10000000L) == 0L && c.isCompleted();
        }
        if (complete) {
            c.flags_field |= 0x40000000L;
        }
        return complete;
    }

    private void noteCyclic(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
        this.log.error(pos, CompilerProperties.Errors.CyclicInheritance(c));
        List<Type> l = this.types.interfaces(c.type);
        while (l.nonEmpty()) {
            l.head = this.types.createErrorType((Symbol.ClassSymbol)((Type)l.head).tsym, Type.noType);
            l = l.tail;
        }
        Type st = this.types.supertype(c.type);
        if (st.hasTag(TypeTag.CLASS)) {
            ((Type.ClassType)c.type).supertype_field = this.types.createErrorType((Symbol.ClassSymbol)st.tsym, Type.noType);
        }
        c.type = this.types.createErrorType(c, c.type);
        c.flags_field |= 0x40000000L;
    }

    void checkImplementations(JCTree.JCClassDecl tree) {
        this.checkImplementations(tree, tree.sym, tree.sym);
    }

    void checkImplementations(JCTree tree, Symbol.ClassSymbol origin, Symbol.ClassSymbol ic) {
        List<Type> l = this.types.closure(ic.type);
        while (l.nonEmpty()) {
            Symbol.ClassSymbol lc = (Symbol.ClassSymbol)((Type)l.head).tsym;
            if ((lc.flags() & 0x400L) != 0L) {
                for (Symbol sym : lc.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                    Symbol.MethodSymbol absmeth;
                    Symbol.MethodSymbol implmeth;
                    if (sym.kind != Kinds.Kind.MTH || (sym.flags() & 0x408L) != 1024L || (implmeth = (absmeth = (Symbol.MethodSymbol)sym).implementation(origin, this.types, false)) == null || implmeth == absmeth || (implmeth.owner.flags() & 0x200L) != (origin.flags() & 0x200L)) continue;
                    this.checkOverride(tree, implmeth, absmeth, origin);
                }
            }
            l = l.tail;
        }
    }

    void checkCompatibleSupertypes(JCDiagnostic.DiagnosticPosition pos, Type c) {
        List<Type> supertypes = this.types.interfaces(c);
        Type supertype = this.types.supertype(c);
        if (supertype.hasTag(TypeTag.CLASS) && (supertype.tsym.flags() & 0x400L) != 0L) {
            supertypes = supertypes.prepend(supertype);
        }
        List<Type> l = supertypes;
        while (l.nonEmpty()) {
            if (!((Type)l.head).getTypeArguments().isEmpty() && !this.checkCompatibleAbstracts(pos, (Type)l.head, (Type)l.head, c)) {
                return;
            }
            List<Type> m = supertypes;
            while (m != l) {
                if (!this.checkCompatibleAbstracts(pos, (Type)l.head, (Type)m.head, c)) {
                    return;
                }
                m = m.tail;
            }
            l = l.tail;
        }
        this.checkCompatibleConcretes(pos, c);
    }

    void checkOverrideClashes(JCDiagnostic.DiagnosticPosition pos, Type site, Symbol.MethodSymbol sym) {
        ClashFilter cf = new ClashFilter(site);
        ArrayList symbolsByName = new ArrayList();
        this.types.membersClosure(site, false).getSymbolsByName(sym.name, cf).forEach(symbolsByName::add);
        for (Symbol m1 : symbolsByName) {
            if (!sym.overrides(m1, site.tsym, this.types, false)) continue;
            for (Symbol m2 : symbolsByName) {
                if (m2 == m1 || this.types.isSubSignature(sym.type, this.types.memberType(site, m2)) || !this.types.hasSameArgs(m2.erasure(this.types), m1.erasure(this.types))) continue;
                sym.flags_field |= 0x40000000000L;
                if (m1 == sym) {
                    this.log.error(pos, CompilerProperties.Errors.NameClashSameErasureNoOverride(m1.name, this.types.memberType(site, m1).asMethodType().getParameterTypes(), m1.location(), m2.name, this.types.memberType(site, m2).asMethodType().getParameterTypes(), m2.location()));
                } else {
                    Type.ClassType ct = (Type.ClassType)site;
                    String kind = ct.isInterface() ? "interface" : "class";
                    this.log.error(pos, CompilerProperties.Errors.NameClashSameErasureNoOverride1(kind, ct.tsym.name, m1.name, this.types.memberType(site, m1).asMethodType().getParameterTypes(), m1.location(), m2.name, this.types.memberType(site, m2).asMethodType().getParameterTypes(), m2.location()));
                }
                return;
            }
        }
    }

    void checkHideClashes(JCDiagnostic.DiagnosticPosition pos, Type site, Symbol.MethodSymbol sym) {
        ClashFilter cf = new ClashFilter(site);
        for (Symbol s : this.types.membersClosure(site, true).getSymbolsByName(sym.name, cf)) {
            if (this.types.isSubSignature(sym.type, this.types.memberType(site, s)) || !this.types.hasSameArgs(s.erasure(this.types), sym.erasure(this.types))) continue;
            this.log.error(pos, CompilerProperties.Errors.NameClashSameErasureNoHide(sym, sym.location(), s, s.location()));
            return;
        }
    }

    void checkDefaultMethodClashes(JCDiagnostic.DiagnosticPosition pos, Type site) {
        DefaultMethodClashFilter dcf = new DefaultMethodClashFilter(site);
        block0: for (Symbol m : this.types.membersClosure(site, false).getSymbols(dcf)) {
            Assert.check(m.kind == Kinds.Kind.MTH);
            List<Symbol.MethodSymbol> prov = this.types.interfaceCandidates(site, (Symbol.MethodSymbol)m);
            if (prov.size() <= 1) continue;
            ListBuffer<Object> abstracts = new ListBuffer<Symbol.MethodSymbol>();
            ListBuffer<Object> defaults = new ListBuffer<Symbol.MethodSymbol>();
            for (Symbol.MethodSymbol provSym : prov) {
                JCDiagnostic.Fragment diagKey;
                Symbol s2;
                if ((provSym.flags() & 0x80000000000L) != 0L) {
                    defaults = defaults.append(provSym);
                } else if ((provSym.flags() & 0x400L) != 0L) {
                    abstracts = abstracts.append(provSym);
                }
                if (!defaults.nonEmpty() || defaults.size() + abstracts.size() < 2) continue;
                Symbol s1 = (Symbol)defaults.first();
                if (defaults.size() > 1) {
                    s2 = (Symbol)defaults.toList().tail.head;
                    diagKey = CompilerProperties.Fragments.IncompatibleUnrelatedDefaults(Kinds.kindName(site.tsym), site, m.name, this.types.memberType(site, m).getParameterTypes(), s1.location(), s2.location());
                } else {
                    s2 = (Symbol)abstracts.first();
                    diagKey = CompilerProperties.Fragments.IncompatibleAbstractDefault(Kinds.kindName(site.tsym), site, m.name, this.types.memberType(site, m).getParameterTypes(), s1.location(), s2.location());
                }
                this.log.error(pos, CompilerProperties.Errors.TypesIncompatible(s1.location().type, s2.location().type, diagKey));
                continue block0;
            }
        }
    }

    void checkPotentiallyAmbiguousOverloads(JCTree.JCClassDecl tree, Type site) {
        if (!this.lint.isEnabled(Lint.LintCategory.OVERLOADS)) {
            return;
        }
        List<java.util.List> methodGroups = this.methodsGroupedByName(site, new PotentiallyAmbiguousFilter(site), ArrayList::new);
        BiPredicate<Symbol.MethodSymbol, Symbol.MethodSymbol> responsible = this.buildResponsiblePredicate(site, methodGroups);
        methodGroups.forEach(list -> this.removePreempted((java.util.List)list, (m1, m2) -> m1.overrides((Symbol)m2, site.tsym, this.types, false)));
        methodGroups.forEach(list -> list.removeIf(m -> m.owner == site.tsym && !this.lint.augment((Symbol)m).isEnabled(Lint.LintCategory.OVERLOADS)));
        methodGroups.forEach(list -> this.compareAndRemove((java.util.List)list, (m1, m2) -> {
            if (!this.potentiallyAmbiguousOverload(site, (Symbol.MethodSymbol)m1, (Symbol.MethodSymbol)m2) || !responsible.test((Symbol.MethodSymbol)m1, (Symbol.MethodSymbol)m2)) {
                return 0;
            }
            JCDiagnostic.DiagnosticPosition pos = m1.owner == site.tsym ? TreeInfo.diagnosticPositionFor((Symbol)m1, tree) : (m2.owner == site.tsym ? TreeInfo.diagnosticPositionFor((Symbol)m2, tree) : tree.pos());
            this.log.warning(Lint.LintCategory.OVERLOADS, pos, CompilerProperties.Warnings.PotentiallyAmbiguousOverload(m1.asMemberOf(site, this.types), m1.location(), m2.asMemberOf(site, this.types), m2.location()));
            return 3;
        }));
    }

    BiPredicate<Symbol.MethodSymbol, Symbol.MethodSymbol> buildResponsiblePredicate(Type site, List<? extends Collection<Symbol.MethodSymbol>> methodGroups) {
        BiPredicate<Symbol.MethodSymbol, Symbol.MethodSymbol> overrides = (m1, m2) -> m1.overrides((Symbol)m2, site.tsym, this.types, false);
        HashMap overriddenMethodsMap = new HashMap();
        methodGroups.forEach(list -> {
            for (Symbol.MethodSymbol m : list) {
                if (m.owner != site.tsym) continue;
                ArrayList overriddenMethods = list.stream().filter(m2 -> m2 != m && overrides.test(m, (Symbol.MethodSymbol)m2)).collect(Collectors.toCollection(ArrayList::new));
                this.removePreempted(overriddenMethods, overrides);
                overriddenMethodsMap.put(m, overriddenMethods);
            }
        });
        return (m1, m2) -> {
            java.util.List<Symbol.MethodSymbol> overriddenMethods1 = (java.util.List<Symbol.MethodSymbol>)overriddenMethodsMap.get(m1);
            java.util.List<Symbol.MethodSymbol> overriddenMethods2 = (java.util.List<Symbol.MethodSymbol>)overriddenMethodsMap.get(m2);
            if (overriddenMethods1 != null && overriddenMethods1.isEmpty()) {
                return true;
            }
            if (overriddenMethods2 != null && overriddenMethods2.isEmpty()) {
                return true;
            }
            java.util.List<Symbol.MethodSymbol> supertypeMethods1 = overriddenMethods1 != null ? overriddenMethods1 : Collections.singletonList(m1);
            java.util.List<Symbol.MethodSymbol> supertypeMethods2 = overriddenMethods2 != null ? overriddenMethods2 : Collections.singletonList(m2);
            return this.types.directSupertypes(site).stream().filter(stype -> stype != this.syms.objectType).map(stype -> stype.tsym.type).noneMatch(stype -> {
                for (Symbol.MethodSymbol sm1 : supertypeMethods1) {
                    if (!this.types.isSubtype(this.types.erasure((Type)stype), this.types.erasure(sm1.owner.type))) continue;
                    for (Symbol.MethodSymbol sm2 : supertypeMethods2) {
                        if (!this.types.isSubtype(this.types.erasure((Type)stype), this.types.erasure(sm2.owner.type)) || !this.potentiallyAmbiguousOverload((Type)stype, sm1, sm2)) continue;
                        return true;
                    }
                }
                return false;
            });
        };
    }

    <C extends Collection<Symbol.MethodSymbol>> List<C> methodsGroupedByName(Type site, Predicate<Symbol> filter, Supplier<? extends C> groupMaker) {
        Iterable<Symbol> symbols = this.types.membersClosure(site, false).getSymbols(filter, Scope.LookupKind.RECURSIVE);
        return StreamSupport.stream(symbols.spliterator(), false).map(Symbol.MethodSymbol.class::cast).collect(Collectors.groupingBy(m -> m.name, Collectors.toCollection(groupMaker))).entrySet().stream().sorted(Comparator.comparing(e -> ((Name)e.getKey()).toString())).map(Map.Entry::getValue).collect(List.collector());
    }

    <T> void compareAndRemove(java.util.List<T> list, ToIntBiFunction<? super T, ? super T> comparer) {
        block0: for (int index1 = 0; index1 < list.size() - 1; ++index1) {
            T item1 = list.get(index1);
            for (int index2 = index1 + 1; index2 < list.size(); ++index2) {
                T item2 = list.get(index2);
                int flags = comparer.applyAsInt(item1, item2);
                if ((flags & 2) != 0) {
                    list.remove(index2--);
                }
                if ((flags & 1) == 0) continue;
                list.remove(index1--);
                continue block0;
            }
        }
    }

    <T> void removePreempted(java.util.List<T> list, BiPredicate<? super T, ? super T> preempts) {
        this.compareAndRemove(list, (item1, item2) -> {
            int flags = 0;
            if (preempts.test(item1, item2)) {
                flags |= 2;
            }
            if (preempts.test(item2, item1)) {
                flags |= 1;
            }
            return flags;
        });
    }

    boolean potentiallyAmbiguousOverload(Type site, Symbol.MethodSymbol msym1, Symbol.MethodSymbol msym2) {
        Assert.check(msym1.name == msym2.name);
        if (msym1 == msym2) {
            return false;
        }
        Type mt1 = this.types.memberType(site, msym1);
        Type mt2 = this.types.memberType(site, msym2);
        if (mt1.hasTag(TypeTag.FORALL) && mt2.hasTag(TypeTag.FORALL) && this.types.hasSameBounds((Type.ForAll)mt1, (Type.ForAll)mt2)) {
            mt2 = this.types.subst(mt2, ((Type.ForAll)mt2).tvars, ((Type.ForAll)mt1).tvars);
        }
        int maxLength = Math.max(mt1.getParameterTypes().length(), mt2.getParameterTypes().length());
        List<Type> args1 = this.rs.adjustArgs(mt1.getParameterTypes(), msym1, maxLength, true);
        List<Type> args2 = this.rs.adjustArgs(mt2.getParameterTypes(), msym2, maxLength, true);
        if (args1.length() != args2.length()) {
            return false;
        }
        boolean potentiallyAmbiguous = false;
        while (args1.nonEmpty() && args2.nonEmpty()) {
            Type t = (Type)args2.head;
            Type s = (Type)args1.head;
            if (!this.types.isSubtype(t, s) && !this.types.isSubtype(s, t)) {
                if (this.types.isFunctionalInterface(s) && this.types.isFunctionalInterface(t) && this.types.findDescriptorType(s).getParameterTypes().length() > 0 && this.types.findDescriptorType(s).getParameterTypes().length() == this.types.findDescriptorType(t).getParameterTypes().length()) {
                    potentiallyAmbiguous = true;
                } else {
                    return false;
                }
            }
            args1 = args1.tail;
            args2 = args2.tail;
        }
        return potentiallyAmbiguous;
    }

    void checkAccessFromSerializableElement(JCTree tree, boolean isLambda) {
        if (this.warnOnAnyAccessToMembers || this.lint.isEnabled(Lint.LintCategory.SERIAL) && !this.lint.isSuppressed(Lint.LintCategory.SERIAL) && isLambda) {
            Symbol sym = TreeInfo.symbol(tree);
            if (!sym.kind.matches(Kinds.KindSelector.VAL_MTH)) {
                return;
            }
            if (sym.kind == Kinds.Kind.VAR && ((sym.flags() & 0x200000000L) != 0L || sym.isDirectlyOrIndirectlyLocal() || sym.name == this.names._this || sym.name == this.names._super)) {
                return;
            }
            if (!this.types.isSubtype(sym.owner.type, this.syms.serializableType) && this.isEffectivelyNonPublic(sym)) {
                if (isLambda) {
                    if (this.belongsToRestrictedPackage(sym)) {
                        this.log.warning(Lint.LintCategory.SERIAL, tree.pos(), CompilerProperties.Warnings.AccessToMemberFromSerializableLambda(sym));
                    }
                } else {
                    this.log.warning(tree.pos(), CompilerProperties.Warnings.AccessToMemberFromSerializableElement(sym));
                }
            }
        }
    }

    private boolean isEffectivelyNonPublic(Symbol sym) {
        if (sym.packge() == this.syms.rootPackage) {
            return false;
        }
        while (sym.kind != Kinds.Kind.PCK) {
            if ((sym.flags() & 1L) == 0L) {
                return true;
            }
            sym = sym.owner;
        }
        return false;
    }

    private boolean belongsToRestrictedPackage(Symbol sym) {
        String fullName = sym.packge().fullname.toString();
        return fullName.startsWith("java.") || fullName.startsWith("javax.") || fullName.startsWith("sun.") || fullName.contains(".internal.");
    }

    void checkClassBounds(JCDiagnostic.DiagnosticPosition pos, Type type) {
        this.checkClassBounds(pos, new HashMap<Symbol.TypeSymbol, Type>(), type);
    }

    void checkClassBounds(JCDiagnostic.DiagnosticPosition pos, Map<Symbol.TypeSymbol, Type> seensofar, Type type) {
        if (type.isErroneous()) {
            return;
        }
        List<Type> l = this.types.interfaces(type);
        while (l.nonEmpty()) {
            Type it = (Type)l.head;
            if (!type.hasTag(TypeTag.CLASS) || it.hasTag(TypeTag.CLASS)) {
                List<Type> newparams;
                List<Type> oldparams;
                Type oldit = seensofar.put(it.tsym, it);
                if (oldit != null && !this.types.containsTypeEquivalent(oldparams = oldit.allparams(), newparams = it.allparams())) {
                    this.log.error(pos, CompilerProperties.Errors.CantInheritDiffArg(it.tsym, Type.toString(oldparams), Type.toString(newparams)));
                }
                this.checkClassBounds(pos, seensofar, it);
            }
            l = l.tail;
        }
        Type st = this.types.supertype(type);
        if (type.hasTag(TypeTag.CLASS) && !st.hasTag(TypeTag.CLASS)) {
            return;
        }
        if (st != Type.noType) {
            this.checkClassBounds(pos, seensofar, st);
        }
    }

    void checkNotRepeated(JCDiagnostic.DiagnosticPosition pos, Type it, Set<Symbol> its) {
        if (its.contains(it.tsym)) {
            this.log.error(pos, CompilerProperties.Errors.RepeatedInterface);
        } else {
            its.add(it.tsym);
        }
    }

    void validateAnnotationTree(JCTree tree) {
        class AnnotationValidator
        extends TreeScanner {
            AnnotationValidator() {
            }

            @Override
            public void visitAnnotation(JCTree.JCAnnotation tree) {
                if (!tree.type.isErroneous() && tree.type.tsym.isAnnotationType()) {
                    super.visitAnnotation(tree);
                    Check.this.validateAnnotation(tree);
                }
            }
        }
        tree.accept(new AnnotationValidator());
    }

    void validateAnnotationType(JCTree restype) {
        if (restype != null) {
            this.validateAnnotationType(restype.pos(), restype.type);
        }
    }

    void validateAnnotationType(JCDiagnostic.DiagnosticPosition pos, Type type) {
        if (type.isPrimitive()) {
            return;
        }
        if (this.types.isSameType(type, this.syms.stringType)) {
            return;
        }
        if ((type.tsym.flags() & 0x4000L) != 0L) {
            return;
        }
        if ((type.tsym.flags() & 0x2000L) != 0L) {
            return;
        }
        if (this.types.cvarLowerBound((Type)type).tsym == this.syms.classType.tsym) {
            return;
        }
        if (this.types.isArray(type) && !this.types.isArray(this.types.elemtype(type))) {
            this.validateAnnotationType(pos, this.types.elemtype(type));
            return;
        }
        this.log.error(pos, CompilerProperties.Errors.InvalidAnnotationMemberType);
    }

    void validateAnnotationMethod(JCDiagnostic.DiagnosticPosition pos, Symbol.MethodSymbol m) {
        Type sup = this.syms.annotationType;
        while (sup.hasTag(TypeTag.CLASS)) {
            Scope.WriteableScope s = sup.tsym.members();
            for (Symbol sym : s.getSymbolsByName(m.name)) {
                if (sym.kind != Kinds.Kind.MTH || (sym.flags() & 5L) == 0L || !this.types.overrideEquivalent(m.type, sym.type)) continue;
                this.log.error(pos, CompilerProperties.Errors.IntfAnnotationMemberClash(sym, sup));
            }
            sup = this.types.supertype(sup);
        }
    }

    public void validateAnnotations(List<JCTree.JCAnnotation> annotations, JCTree declarationTree, Symbol s) {
        for (JCTree.JCAnnotation a : annotations) {
            this.validateAnnotation(a, declarationTree, s);
        }
    }

    public void validateTypeAnnotations(List<JCTree.JCAnnotation> annotations, Symbol s, boolean isTypeParameter) {
        for (JCTree.JCAnnotation a : annotations) {
            this.validateTypeAnnotation(a, s, isTypeParameter);
        }
    }

    private void validateAnnotation(JCTree.JCAnnotation a, JCTree declarationTree, Symbol s) {
        Optional<Set<Name>> applicableTargetsOp;
        boolean isRecordField;
        this.validateAnnotationTree(a);
        boolean isRecordMember = (s.flags_field & 0x2000000000000000L) != 0L || s.enclClass() != null && s.enclClass().isRecord();
        boolean bl = isRecordField = (s.flags_field & 0x2000000000000000L) != 0L && declarationTree.hasTag(JCTree.Tag.VARDEF) && s.owner.kind == Kinds.Kind.TYP;
        if (isRecordField) {
            Name[] targets = this.getTargetNames(a);
            boolean appliesToRecords = false;
            for (Name target : targets) {
                boolean bl2 = appliesToRecords = target == this.names.FIELD || target == this.names.PARAMETER || target == this.names.METHOD || target == this.names.TYPE_USE || target == this.names.RECORD_COMPONENT;
                if (appliesToRecords) break;
            }
            if (!appliesToRecords) {
                this.log.error(a.pos(), CompilerProperties.Errors.AnnotationTypeNotApplicable);
            } else {
                Symbol.ClassSymbol recordClass = (Symbol.ClassSymbol)s.owner;
                Symbol.RecordComponent rc = recordClass.getRecordComponent((Symbol.VarSymbol)s);
                SymbolMetadata metadata = rc.getMetadata();
                if (metadata == null || metadata.isEmpty()) {
                    rc.appendAttributes(s.getRawAttributes().stream().filter(anno -> Arrays.stream(this.getTargetNames(anno.type.tsym)).anyMatch(name -> name == this.names.RECORD_COMPONENT)).collect(List.collector()));
                    JCTree.JCVariableDecl fieldAST = (JCTree.JCVariableDecl)declarationTree;
                    block1: for (JCTree.JCAnnotation fieldAnnot : fieldAST.mods.annotations) {
                        for (JCTree.JCAnnotation rcAnnot : rc.declarationFor().mods.annotations) {
                            if (rcAnnot.pos != fieldAnnot.pos) continue;
                            rcAnnot.setType(fieldAnnot.type);
                            continue block1;
                        }
                    }
                }
            }
        }
        if (a.type.tsym.isAnnotationType() && (applicableTargetsOp = this.getApplicableTargets(a, s)).isPresent()) {
            boolean isCompRecordElementWithNonApplicableDeclAnno;
            Set<Name> applicableTargets = applicableTargetsOp.get();
            boolean notApplicableOrIsTypeUseOnly = applicableTargets.isEmpty() || applicableTargets.size() == 1 && applicableTargets.contains(this.names.TYPE_USE);
            boolean isCompGeneratedRecordElement = isRecordMember && (s.flags_field & 0x1000000L) != 0L;
            boolean bl3 = isCompRecordElementWithNonApplicableDeclAnno = isCompGeneratedRecordElement && notApplicableOrIsTypeUseOnly;
            if (applicableTargets.isEmpty() || isCompRecordElementWithNonApplicableDeclAnno) {
                if (isCompRecordElementWithNonApplicableDeclAnno) {
                    JCTree.JCModifiers modifiers = TreeInfo.getModifiers(declarationTree);
                    if (modifiers != null && applicableTargets.isEmpty()) {
                        ListBuffer<JCTree.JCAnnotation> newAnnotations = new ListBuffer<JCTree.JCAnnotation>();
                        for (JCTree.JCAnnotation anno2 : modifiers.annotations) {
                            if (anno2 == a) continue;
                            newAnnotations.add(anno2);
                        }
                        modifiers.annotations = newAnnotations.toList();
                    }
                    s.getMetadata().removeDeclarationMetadata(a.attribute);
                } else {
                    this.log.error(a.pos(), CompilerProperties.Errors.AnnotationTypeNotApplicable);
                }
            }
            if (isCompGeneratedRecordElement && !isRecordField && a.type.tsym == this.syms.trustMeType.tsym && declarationTree.hasTag(JCTree.Tag.METHODDEF)) {
                this.log.error(a.pos(), CompilerProperties.Errors.VarargsInvalidTrustmeAnno((Symbol)this.syms.trustMeType.tsym, CompilerProperties.Fragments.VarargsTrustmeOnNonVarargsAccessor(s)));
            }
        }
        if (a.annotationType.type.tsym == this.syms.functionalInterfaceType.tsym) {
            if (s.kind != Kinds.Kind.TYP) {
                this.log.error(a.pos(), CompilerProperties.Errors.BadFunctionalIntfAnno);
            } else if (!s.isInterface() || (s.flags() & 0x2000L) != 0L) {
                this.log.error(a.pos(), CompilerProperties.Errors.BadFunctionalIntfAnno1(CompilerProperties.Fragments.NotAFunctionalIntf(s)));
            }
        }
    }

    public void validateTypeAnnotation(JCTree.JCAnnotation a, Symbol s, boolean isTypeParameter) {
        Assert.checkNonNull(a.type);
        if (s != null) {
            this.getApplicableTargets(a, s);
        }
        this.validateAnnotationTree(a);
        if (a.hasTag(JCTree.Tag.TYPE_ANNOTATION) && !a.annotationType.type.isErroneous() && !this.isTypeAnnotation(a, isTypeParameter)) {
            this.log.error(a.pos(), CompilerProperties.Errors.AnnotationTypeNotApplicableToType(a.type));
        }
    }

    public void validateRepeatable(Symbol.TypeSymbol s, Attribute.Compound repeatable, JCDiagnostic.DiagnosticPosition pos) {
        Assert.check(this.types.isSameType(repeatable.type, this.syms.repeatableType));
        Type t = null;
        List<Pair<Symbol.MethodSymbol, Attribute>> l = repeatable.values;
        if (!l.isEmpty()) {
            Assert.check(((Symbol.MethodSymbol)((Pair)l.head).fst).name == this.names.value);
            if (((Pair)l.head).snd instanceof Attribute.Class) {
                t = ((Attribute.Class)((Pair)l.head).snd).getValue();
            }
        }
        if (t == null) {
            return;
        }
        this.validateValue(t.tsym, s, pos);
        this.validateRetention(t.tsym, s, pos);
        this.validateDocumented(t.tsym, s, pos);
        this.validateInherited(t.tsym, s, pos);
        this.validateTarget(t.tsym, s, pos);
        this.validateDefault(t.tsym, pos);
    }

    private void validateValue(Symbol.TypeSymbol container, Symbol.TypeSymbol contained, JCDiagnostic.DiagnosticPosition pos) {
        Symbol sym = container.members().findFirst(this.names.value);
        if (sym != null && sym.kind == Kinds.Kind.MTH) {
            Symbol.MethodSymbol m = (Symbol.MethodSymbol)sym;
            Type ret = m.getReturnType();
            if (!ret.hasTag(TypeTag.ARRAY) || !this.types.isSameType(((Type.ArrayType)ret).elemtype, contained.type)) {
                this.log.error(pos, CompilerProperties.Errors.InvalidRepeatableAnnotationValueReturn(container, ret, (Type)this.types.makeArrayType(contained.type)));
            }
        } else {
            this.log.error(pos, CompilerProperties.Errors.InvalidRepeatableAnnotationNoValue(container));
        }
    }

    private void validateRetention(Symbol.TypeSymbol container, Symbol.TypeSymbol contained, JCDiagnostic.DiagnosticPosition pos) {
        Attribute.RetentionPolicy containerRetention = this.types.getRetention(container);
        Attribute.RetentionPolicy containedRetention = this.types.getRetention(contained);
        boolean error = false;
        switch (containedRetention) {
            case RUNTIME: {
                if (containerRetention == Attribute.RetentionPolicy.RUNTIME) break;
                error = true;
                break;
            }
            case CLASS: {
                if (containerRetention != Attribute.RetentionPolicy.SOURCE) break;
                error = true;
            }
        }
        if (error) {
            this.log.error(pos, CompilerProperties.Errors.InvalidRepeatableAnnotationRetention(container, containerRetention.name(), contained, containedRetention.name()));
        }
    }

    private void validateDocumented(Symbol container, Symbol contained, JCDiagnostic.DiagnosticPosition pos) {
        if (contained.attribute(this.syms.documentedType.tsym) != null && container.attribute(this.syms.documentedType.tsym) == null) {
            this.log.error(pos, CompilerProperties.Errors.InvalidRepeatableAnnotationNotDocumented(container, contained));
        }
    }

    private void validateInherited(Symbol container, Symbol contained, JCDiagnostic.DiagnosticPosition pos) {
        if (contained.attribute(this.syms.inheritedType.tsym) != null && container.attribute(this.syms.inheritedType.tsym) == null) {
            this.log.error(pos, CompilerProperties.Errors.InvalidRepeatableAnnotationNotInherited(container, contained));
        }
    }

    private void validateTarget(Symbol.TypeSymbol container, Symbol.TypeSymbol contained, JCDiagnostic.DiagnosticPosition pos) {
        Set<Name> containedTargets;
        Set<Name> containerTargets;
        Attribute.Array containerTarget = this.getAttributeTargetAttribute(container);
        if (containerTarget == null) {
            containerTargets = this.getDefaultTargetSet();
        } else {
            containerTargets = new HashSet<Name>();
            for (Attribute app : containerTarget.values) {
                if (!(app instanceof Attribute.Enum)) continue;
                Attribute.Enum attributeEnum = (Attribute.Enum)app;
                containerTargets.add(attributeEnum.value.name);
            }
        }
        Attribute.Array containedTarget = this.getAttributeTargetAttribute(contained);
        if (containedTarget == null) {
            containedTargets = this.getDefaultTargetSet();
        } else {
            containedTargets = new HashSet<Name>();
            for (Attribute app : containedTarget.values) {
                if (!(app instanceof Attribute.Enum)) continue;
                Attribute.Enum attributeEnum = (Attribute.Enum)app;
                containedTargets.add(attributeEnum.value.name);
            }
        }
        if (!this.isTargetSubsetOf(containerTargets, containedTargets)) {
            this.log.error(pos, CompilerProperties.Errors.InvalidRepeatableAnnotationIncompatibleTarget(container, contained));
        }
    }

    private Set<Name> getDefaultTargetSet() {
        if (this.defaultTargets == null) {
            this.defaultTargets = Collections.unmodifiableSet(new HashSet<Name>(Arrays.asList(this.defaultTargetMetaInfo())));
        }
        return this.defaultTargets;
    }

    private boolean isTargetSubsetOf(Set<Name> s, Set<Name> t) {
        for (Name n2 : s) {
            boolean currentElementOk = false;
            for (Name n1 : t) {
                if (n1 == n2) {
                    currentElementOk = true;
                    break;
                }
                if (n1 == this.names.TYPE && n2 == this.names.ANNOTATION_TYPE) {
                    currentElementOk = true;
                    break;
                }
                if (n1 != this.names.TYPE_USE || n2 != this.names.TYPE && n2 != this.names.ANNOTATION_TYPE && n2 != this.names.TYPE_PARAMETER) continue;
                currentElementOk = true;
                break;
            }
            if (currentElementOk) continue;
            return false;
        }
        return true;
    }

    private void validateDefault(Symbol container, JCDiagnostic.DiagnosticPosition pos) {
        Scope.WriteableScope scope = container.members();
        for (Symbol elm : scope.getSymbols()) {
            if (elm.name == this.names.value || elm.kind != Kinds.Kind.MTH || ((Symbol.MethodSymbol)elm).defaultValue != null) continue;
            this.log.error(pos, CompilerProperties.Errors.InvalidRepeatableAnnotationElemNondefault(container, elm));
        }
    }

    boolean isOverrider(Symbol s) {
        if (s.kind != Kinds.Kind.MTH || s.isStatic()) {
            return false;
        }
        Symbol.MethodSymbol m = (Symbol.MethodSymbol)s;
        Symbol.TypeSymbol owner = (Symbol.TypeSymbol)m.owner;
        for (Type sup : this.types.closure(owner.type)) {
            if (sup == owner.type) continue;
            Scope.WriteableScope scope = sup.tsym.members();
            for (Symbol sym : scope.getSymbolsByName(m.name)) {
                if (sym.isStatic() || !m.overrides(sym, owner, this.types, true)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isTypeAnnotation(JCTree.JCAnnotation a, boolean isTypeParameter) {
        List<Attribute> targets = this.typeAnnotations.annotationTargets(a.annotationType.type.tsym);
        return targets == null ? Source.Feature.NO_TARGET_ANNOTATION_APPLICABILITY.allowedInSource(this.source) && isTypeParameter : targets.stream().anyMatch(attr -> this.isTypeAnnotation((Attribute)attr, isTypeParameter));
    }

    boolean isTypeAnnotation(Attribute a, boolean isTypeParameter) {
        Attribute.Enum e = (Attribute.Enum)a;
        return e.value.name == this.names.TYPE_USE || isTypeParameter && e.value.name == this.names.TYPE_PARAMETER;
    }

    Name[] getTargetNames(JCTree.JCAnnotation a) {
        return this.getTargetNames(a.annotationType.type.tsym);
    }

    public Name[] getTargetNames(Symbol.TypeSymbol annoSym) {
        Name[] targets;
        Attribute.Array arr = this.getAttributeTargetAttribute(annoSym);
        if (arr == null) {
            targets = this.defaultTargetMetaInfo();
        } else {
            targets = new Name[arr.values.length];
            for (int i = 0; i < arr.values.length; ++i) {
                Attribute app = arr.values[i];
                if (!(app instanceof Attribute.Enum)) {
                    return new Name[0];
                }
                Attribute.Enum attributeEnum = (Attribute.Enum)app;
                targets[i] = attributeEnum.value.name;
            }
        }
        return targets;
    }

    boolean annotationApplicable(JCTree.JCAnnotation a, Symbol s) {
        Optional<Set<Name>> targets = this.getApplicableTargets(a, s);
        return !targets.isPresent() || targets.isPresent() && !targets.get().isEmpty();
    }

    Optional<Set<Name>> getApplicableTargets(JCTree.JCAnnotation a, Symbol s) {
        Name[] targets;
        Attribute.Array arr = this.getAttributeTargetAttribute(a.annotationType.type.tsym);
        HashSet<Name> applicableTargets = new HashSet<Name>();
        if (arr == null) {
            targets = this.defaultTargetMetaInfo();
        } else {
            targets = new Name[arr.values.length];
            for (int i = 0; i < arr.values.length; ++i) {
                Attribute app = arr.values[i];
                if (!(app instanceof Attribute.Enum)) {
                    return Optional.empty();
                }
                Attribute.Enum attributeEnum = (Attribute.Enum)app;
                targets[i] = attributeEnum.value.name;
            }
        }
        for (Name target : targets) {
            if (target == this.names.TYPE) {
                if (s.kind != Kinds.Kind.TYP) continue;
                applicableTargets.add(this.names.TYPE);
                continue;
            }
            if (target == this.names.FIELD) {
                if (s.kind != Kinds.Kind.VAR || s.owner.kind == Kinds.Kind.MTH) continue;
                applicableTargets.add(this.names.FIELD);
                continue;
            }
            if (target == this.names.RECORD_COMPONENT) {
                if (s.getKind() != ElementKind.RECORD_COMPONENT) continue;
                applicableTargets.add(this.names.RECORD_COMPONENT);
                continue;
            }
            if (target == this.names.METHOD) {
                if (s.kind != Kinds.Kind.MTH || s.isConstructor()) continue;
                applicableTargets.add(this.names.METHOD);
                continue;
            }
            if (target == this.names.PARAMETER) {
                if (s.kind != Kinds.Kind.VAR || s.owner.kind != Kinds.Kind.MTH || (s.flags() & 0x200000000L) == 0L) continue;
                applicableTargets.add(this.names.PARAMETER);
                continue;
            }
            if (target == this.names.CONSTRUCTOR) {
                if (s.kind != Kinds.Kind.MTH || !s.isConstructor()) continue;
                applicableTargets.add(this.names.CONSTRUCTOR);
                continue;
            }
            if (target == this.names.LOCAL_VARIABLE) {
                if (s.kind != Kinds.Kind.VAR || s.owner.kind != Kinds.Kind.MTH || (s.flags() & 0x200000000L) != 0L) continue;
                applicableTargets.add(this.names.LOCAL_VARIABLE);
                continue;
            }
            if (target == this.names.ANNOTATION_TYPE) {
                if (s.kind != Kinds.Kind.TYP || (s.flags() & 0x2000L) == 0L) continue;
                applicableTargets.add(this.names.ANNOTATION_TYPE);
                continue;
            }
            if (target == this.names.PACKAGE) {
                if (s.kind != Kinds.Kind.PCK) continue;
                applicableTargets.add(this.names.PACKAGE);
                continue;
            }
            if (target == this.names.TYPE_USE) {
                if (s.kind == Kinds.Kind.VAR && s.owner.kind == Kinds.Kind.MTH && s.type.hasTag(TypeTag.NONE) || s.kind != Kinds.Kind.TYP && s.kind != Kinds.Kind.VAR && (s.kind != Kinds.Kind.MTH || s.isConstructor() || s.type.getReturnType().hasTag(TypeTag.VOID)) && (s.kind != Kinds.Kind.MTH || !s.isConstructor())) continue;
                applicableTargets.add(this.names.TYPE_USE);
                continue;
            }
            if (target == this.names.TYPE_PARAMETER) {
                if (s.kind != Kinds.Kind.TYP || !s.type.hasTag(TypeTag.TYPEVAR)) continue;
                applicableTargets.add(this.names.TYPE_PARAMETER);
                continue;
            }
            if (target == this.names.MODULE) {
                if (s.kind != Kinds.Kind.MDL) continue;
                applicableTargets.add(this.names.MODULE);
                continue;
            }
            this.log.error(a, CompilerProperties.Errors.AnnotationUnrecognizedAttributeName(a.type, target));
            return Optional.empty();
        }
        return Optional.of(applicableTargets);
    }

    Attribute.Array getAttributeTargetAttribute(Symbol.TypeSymbol s) {
        Attribute.Array attributeArray;
        Attribute.Compound atTarget = s.getAnnotationTypeMetadata().getTarget();
        if (atTarget == null) {
            return null;
        }
        Attribute atValue = atTarget.member(this.names.value);
        return atValue instanceof Attribute.Array ? (attributeArray = (Attribute.Array)atValue) : null;
    }

    private Name[] defaultTargetMetaInfo() {
        if (this.dfltTargetMeta == null) {
            ArrayList<Name> defaultTargets = new ArrayList<Name>();
            defaultTargets.add(this.names.PACKAGE);
            defaultTargets.add(this.names.TYPE);
            defaultTargets.add(this.names.FIELD);
            defaultTargets.add(this.names.METHOD);
            defaultTargets.add(this.names.CONSTRUCTOR);
            defaultTargets.add(this.names.ANNOTATION_TYPE);
            defaultTargets.add(this.names.LOCAL_VARIABLE);
            defaultTargets.add(this.names.PARAMETER);
            if (this.allowRecords) {
                defaultTargets.add(this.names.RECORD_COMPONENT);
            }
            if (this.allowModules) {
                defaultTargets.add(this.names.MODULE);
            }
            this.dfltTargetMeta = defaultTargets.toArray(new Name[0]);
        }
        return this.dfltTargetMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAnnotationDeferErrors(JCTree.JCAnnotation a) {
        boolean res = false;
        Log.DiscardDiagnosticHandler diagHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            res = this.validateAnnotation(a);
        }
        finally {
            this.log.popDiagnosticHandler(diagHandler);
        }
        return res;
    }

    private boolean validateAnnotation(JCTree.JCAnnotation a) {
        boolean isValid = true;
        Annotate.AnnotationTypeMetadata metadata = a.annotationType.type.tsym.getAnnotationTypeMetadata();
        Set<Symbol.MethodSymbol> elements = metadata.getAnnotationElements();
        for (JCTree jCTree : a.args) {
            if (!jCTree.hasTag(JCTree.Tag.ASSIGN)) continue;
            JCTree.JCAssign assign = (JCTree.JCAssign)jCTree;
            Symbol symbol = TreeInfo.symbol(assign.lhs);
            if (symbol == null || symbol.type.isErroneous() || elements.remove(symbol)) continue;
            isValid = false;
            this.log.error(assign.lhs.pos(), CompilerProperties.Errors.DuplicateAnnotationMemberValue(symbol.name, a.type));
        }
        List<Name> missingDefaults = List.nil();
        Set<Symbol.MethodSymbol> set = metadata.getAnnotationElementsWithDefault();
        for (Symbol.MethodSymbol methodSymbol : elements) {
            if (methodSymbol.type.isErroneous() || set.contains(methodSymbol)) continue;
            missingDefaults = missingDefaults.append(methodSymbol.name);
        }
        if ((missingDefaults = missingDefaults.reverse()).nonEmpty()) {
            isValid = false;
            JCDiagnostic.Error errorKey = missingDefaults.size() > 1 ? CompilerProperties.Errors.AnnotationMissingDefaultValue1(a.type, missingDefaults) : CompilerProperties.Errors.AnnotationMissingDefaultValue(a.type, missingDefaults);
            this.log.error(a.pos(), errorKey);
        }
        return isValid && this.validateTargetAnnotationValue(a);
    }

    boolean validateTargetAnnotationValue(JCTree.JCAnnotation a) {
        if (a.annotationType.type.tsym != this.syms.annotationTargetType.tsym || a.args.tail == null) {
            return true;
        }
        boolean isValid = true;
        if (!((JCTree.JCExpression)a.args.head).hasTag(JCTree.Tag.ASSIGN)) {
            return false;
        }
        JCTree.JCAssign assign = (JCTree.JCAssign)a.args.head;
        Symbol m = TreeInfo.symbol(assign.lhs);
        if (m.name != this.names.value) {
            return false;
        }
        JCTree.JCExpression rhs = assign.rhs;
        if (!rhs.hasTag(JCTree.Tag.NEWARRAY)) {
            return false;
        }
        JCTree.JCNewArray na = (JCTree.JCNewArray)rhs;
        HashSet<Symbol> targets = new HashSet<Symbol>();
        for (JCTree jCTree : na.elems) {
            if (targets.add(TreeInfo.symbol(jCTree))) continue;
            isValid = false;
            this.log.error(jCTree.pos(), CompilerProperties.Errors.RepeatedAnnotationTarget);
        }
        return isValid;
    }

    void checkDeprecatedAnnotation(JCDiagnostic.DiagnosticPosition pos, Symbol s) {
        if (this.lint.isEnabled(Lint.LintCategory.DEP_ANN) && s.isDeprecatableViaAnnotation() && (s.flags() & 0x20000L) != 0L && !this.syms.deprecatedType.isErroneous() && s.attribute(this.syms.deprecatedType.tsym) == null) {
            this.log.warning(Lint.LintCategory.DEP_ANN, pos, CompilerProperties.Warnings.MissingDeprecatedAnnotation);
        }
        if (this.lint.isEnabled(Lint.LintCategory.DEPRECATION) && !s.isDeprecatableViaAnnotation() && !this.syms.deprecatedType.isErroneous() && s.attribute(this.syms.deprecatedType.tsym) != null) {
            this.log.warning(Lint.LintCategory.DEPRECATION, pos, CompilerProperties.Warnings.DeprecatedAnnotationHasNoEffect(Kinds.kindName(s)));
        }
    }

    void checkDeprecated(JCDiagnostic.DiagnosticPosition pos, Symbol other, Symbol s) {
        this.checkDeprecated(() -> pos, other, s);
    }

    void checkDeprecated(Supplier<JCDiagnostic.DiagnosticPosition> pos, Symbol other, Symbol s) {
        if ((s.isDeprecatedForRemoval() || s.isDeprecated() && !other.isDeprecated()) && (s.outermostClass() != other.outermostClass() || s.outermostClass() == null) && s.kind != Kinds.Kind.PCK) {
            this.deferredLintHandler.report(_l -> this.warnDeprecated((JCDiagnostic.DiagnosticPosition)pos.get(), s));
        }
    }

    void checkSunAPI(JCDiagnostic.DiagnosticPosition pos, Symbol s) {
        if ((s.flags() & 0x4000000000L) != 0L) {
            this.deferredLintHandler.report(_l -> this.log.mandatoryWarning(pos, CompilerProperties.Warnings.SunProprietary(s)));
        }
    }

    void checkProfile(JCDiagnostic.DiagnosticPosition pos, Symbol s) {
        if (this.profile != Profile.DEFAULT && (s.flags() & 0x200000000000L) != 0L) {
            this.log.error(pos, CompilerProperties.Errors.NotInProfile(s, (Object)this.profile));
        }
    }

    void checkPreview(JCDiagnostic.DiagnosticPosition pos, Symbol other, Symbol s) {
        if ((s.flags() & 0x100000000000000L) != 0L && !this.preview.participatesInPreview(this.syms, other, s) && !this.disablePreviewCheck) {
            if ((s.flags() & 0x400000000000000L) == 0L) {
                if (!this.preview.isEnabled()) {
                    this.log.error(pos, CompilerProperties.Errors.IsPreview(s));
                } else {
                    this.preview.markUsesPreview(pos);
                    this.deferredLintHandler.report(_l -> this.warnPreviewAPI(pos, CompilerProperties.Warnings.IsPreview(s)));
                }
            } else {
                this.deferredLintHandler.report(_l -> this.warnPreviewAPI(pos, CompilerProperties.Warnings.IsPreviewReflective(s)));
            }
        }
        if (this.preview.declaredUsingPreviewFeature(s) && this.preview.isEnabled()) {
            this.preview.markUsesPreview(pos);
            this.deferredLintHandler.report(_l -> this.warnDeclaredUsingPreview(pos, s));
        }
    }

    void checkRestricted(JCDiagnostic.DiagnosticPosition pos, Symbol s) {
        if (s.kind == Kinds.Kind.MTH && (s.flags() & 0x4000000000000000L) != 0L) {
            this.deferredLintHandler.report(_l -> this.warnRestrictedAPI(pos, s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElements(JCTree.JCClassDecl tree) {
        if ((tree.sym.flags_field & 0x2000L) == 0L) {
            return;
        }
        Assert.check((tree.sym.flags_field & 0x8000000L) == 0L);
        try {
            tree.sym.flags_field |= 0x8000000L;
            for (JCTree def : tree.defs) {
                if (!def.hasTag(JCTree.Tag.METHODDEF)) continue;
                JCTree.JCMethodDecl meth = (JCTree.JCMethodDecl)def;
                this.checkAnnotationResType(meth.pos(), meth.restype.type);
            }
        }
        finally {
            tree.sym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            tree.sym.flags_field |= 0x800000000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElementsInternal(JCDiagnostic.DiagnosticPosition pos, Symbol.TypeSymbol tsym) {
        if ((tsym.flags_field & 0x800000000L) != 0L) {
            return;
        }
        if ((tsym.flags_field & 0x8000000L) != 0L) {
            this.log.error(pos, CompilerProperties.Errors.CyclicAnnotationElement(tsym));
            return;
        }
        try {
            tsym.flags_field |= 0x8000000L;
            for (Symbol s : tsym.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                if (s.kind != Kinds.Kind.MTH) continue;
                this.checkAnnotationResType(pos, ((Symbol.MethodSymbol)s).type.getReturnType());
            }
        }
        finally {
            tsym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            tsym.flags_field |= 0x800000000L;
        }
    }

    void checkAnnotationResType(JCDiagnostic.DiagnosticPosition pos, Type type) {
        switch (type.getTag()) {
            case CLASS: {
                if ((type.tsym.flags() & 0x2000L) == 0L) break;
                this.checkNonCyclicElementsInternal(pos, type.tsym);
                break;
            }
            case ARRAY: {
                this.checkAnnotationResType(pos, this.types.elemtype(type));
                break;
            }
        }
    }

    void checkCyclicConstructors(JCTree.JCClassDecl tree) {
        LinkedHashMap<Symbol, Symbol> callMap = new LinkedHashMap<Symbol, Symbol>();
        List<JCTree> l = tree.defs;
        while (l.nonEmpty()) {
            if (TreeInfo.isConstructor((JCTree)l.head)) {
                JCTree.JCMethodDecl meth = (JCTree.JCMethodDecl)l.head;
                JCTree.JCMethodInvocation app = TreeInfo.findConstructorCall(meth);
                if (app != null && TreeInfo.name(app.meth) == this.names._this) {
                    callMap.put(meth.sym, TreeInfo.symbol(app.meth));
                } else {
                    meth.sym.flags_field |= 0x40000000L;
                }
            }
            l = l.tail;
        }
        Symbol[] ctors = new Symbol[]{};
        for (Symbol caller : ctors = callMap.keySet().toArray(ctors)) {
            this.checkCyclicConstructor(tree, caller, callMap);
        }
    }

    private void checkCyclicConstructor(JCTree.JCClassDecl tree, Symbol ctor, Map<Symbol, Symbol> callMap) {
        if (ctor != null && (ctor.flags_field & 0x40000000L) == 0L) {
            if ((ctor.flags_field & 0x8000000L) != 0L) {
                this.log.error(TreeInfo.diagnosticPositionFor(ctor, tree, false, t -> t.hasTag(JCTree.Tag.IDENT)), CompilerProperties.Errors.RecursiveCtorInvocation);
            } else {
                ctor.flags_field |= 0x8000000L;
                this.checkCyclicConstructor(tree, callMap.remove(ctor), callMap);
                ctor.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
            ctor.flags_field |= 0x40000000L;
        }
    }

    void checkSuperInitCalls(JCTree.JCClassDecl tree) {
        new SuperThisChecker().check(tree);
    }

    void checkDivZero(JCDiagnostic.DiagnosticPosition pos, Symbol operator, Type operand) {
        int opc;
        if (operand.constValue() != null && operand.getTag().isSubRangeOf(TypeTag.LONG) && ((Number)operand.constValue()).longValue() == 0L && ((opc = ((Symbol.OperatorSymbol)operator).opcode) == 108 || opc == 112 || opc == 109 || opc == 113)) {
            this.deferredLintHandler.report(_l -> this.warnDivZero(pos));
        }
    }

    void checkLossOfPrecision(JCDiagnostic.DiagnosticPosition pos, Type found, Type req) {
        if (found.isNumeric() && req.isNumeric() && !this.types.isAssignable(found, req)) {
            this.deferredLintHandler.report(_l -> {
                if (this.lint.isEnabled(Lint.LintCategory.LOSSY_CONVERSIONS)) {
                    this.log.warning(Lint.LintCategory.LOSSY_CONVERSIONS, pos, CompilerProperties.Warnings.PossibleLossOfPrecision(found, req));
                }
            });
        }
    }

    void checkEmptyIf(JCTree.JCIf tree) {
        if (tree.thenpart.hasTag(JCTree.Tag.SKIP) && tree.elsepart == null && this.lint.isEnabled(Lint.LintCategory.EMPTY)) {
            this.log.warning(Lint.LintCategory.EMPTY, tree.thenpart.pos(), CompilerProperties.Warnings.EmptyIf);
        }
    }

    boolean checkUnique(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Scope s) {
        if (sym.type.isErroneous()) {
            return true;
        }
        if (sym.owner.name == this.names.any) {
            return false;
        }
        for (Symbol byName : s.getSymbolsByName(sym.name, Scope.LookupKind.NON_RECURSIVE)) {
            if (sym == byName || (byName.flags() & 0x40000000000L) != 0L || sym.kind != byName.kind || sym.name == this.names.error || sym.kind == Kinds.Kind.MTH && !this.types.hasSameArgs(sym.type, byName.type) && !this.types.hasSameArgs(this.types.erasure(sym.type), this.types.erasure(byName.type))) continue;
            if ((sym.flags() & 0x400000000L) != (byName.flags() & 0x400000000L)) {
                sym.flags_field |= 0x40000000000L;
                this.varargsDuplicateError(pos, sym, byName);
                return true;
            }
            if (sym.kind == Kinds.Kind.MTH && !this.types.hasSameArgs(sym.type, byName.type, false)) {
                this.duplicateErasureError(pos, sym, byName);
                sym.flags_field |= 0x40000000000L;
                return true;
            }
            if ((sym.flags() & 0x800000000000000L) != 0L && (byName.flags() & 0x800000000000000L) != 0L && (byName.flags() & 0x1000000000000000L) == 0L) {
                if (!sym.type.isErroneous()) {
                    this.log.error(pos, CompilerProperties.Errors.MatchBindingExists);
                    sym.flags_field |= 0x40000000000L;
                }
                return false;
            }
            this.duplicateError(pos, byName);
            return false;
        }
        return true;
    }

    void duplicateErasureError(JCDiagnostic.DiagnosticPosition pos, Symbol sym1, Symbol sym2) {
        if (!sym1.type.isErroneous() && !sym2.type.isErroneous()) {
            this.log.error(pos, CompilerProperties.Errors.NameClashSameErasure(sym1, sym2));
        }
    }

    void checkImportsUnique(JCTree.JCCompilationUnit toplevel) {
        Scope.WriteableScope ordinallyImportedSoFar = Scope.WriteableScope.create(toplevel.packge);
        Scope.WriteableScope staticallyImportedSoFar = Scope.WriteableScope.create(toplevel.packge);
        Scope.WriteableScope topLevelScope = toplevel.toplevelScope;
        for (JCTree def : toplevel.defs) {
            if (!def.hasTag(JCTree.Tag.IMPORT)) continue;
            JCTree.JCImport imp = (JCTree.JCImport)def;
            if (imp.importScope == null) continue;
            for (Symbol sym2 : imp.importScope.getSymbols(sym -> sym.kind == Kinds.Kind.TYP)) {
                if (imp.isStatic()) {
                    this.checkUniqueImport(imp.pos(), ordinallyImportedSoFar, staticallyImportedSoFar, topLevelScope, sym2, true);
                    staticallyImportedSoFar.enter(sym2);
                    continue;
                }
                this.checkUniqueImport(imp.pos(), ordinallyImportedSoFar, staticallyImportedSoFar, topLevelScope, sym2, false);
                ordinallyImportedSoFar.enter(sym2);
            }
            imp.importScope = null;
        }
    }

    private boolean checkUniqueImport(JCDiagnostic.DiagnosticPosition pos, Scope ordinallyImportedSoFar, Scope staticallyImportedSoFar, Scope topLevelScope, Symbol sym, boolean staticImport) {
        Predicate<Symbol> duplicates = candidate -> candidate != sym && !candidate.type.isErroneous();
        Symbol ordinaryClashing = ordinallyImportedSoFar.findFirst(sym.name, duplicates);
        Symbol staticClashing = null;
        if (ordinaryClashing == null && !staticImport) {
            staticClashing = staticallyImportedSoFar.findFirst(sym.name, duplicates);
        }
        if (ordinaryClashing != null || staticClashing != null) {
            if (ordinaryClashing != null) {
                this.log.error(pos, CompilerProperties.Errors.AlreadyDefinedSingleImport(ordinaryClashing));
            } else {
                this.log.error(pos, CompilerProperties.Errors.AlreadyDefinedStaticSingleImport(staticClashing));
            }
            return false;
        }
        Symbol clashing = topLevelScope.findFirst(sym.name, duplicates);
        if (clashing != null) {
            this.log.error(pos, CompilerProperties.Errors.AlreadyDefinedThisUnit(clashing));
            return false;
        }
        return true;
    }

    public void checkCanonical(JCTree tree) {
        if (!this.isCanonical(tree)) {
            this.log.error(tree.pos(), CompilerProperties.Errors.ImportRequiresCanonical(TreeInfo.symbol(tree)));
        }
    }

    private boolean isCanonical(JCTree tree) {
        while (tree.hasTag(JCTree.Tag.SELECT)) {
            JCTree.JCFieldAccess s = (JCTree.JCFieldAccess)tree;
            if (s.sym.owner.getQualifiedName() != TreeInfo.symbol(s.selected).getQualifiedName()) {
                return false;
            }
            tree = s.selected;
        }
        return true;
    }

    void checkForBadAuxiliaryClassAccess(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Symbol.ClassSymbol c) {
        if (this.lint.isEnabled(Lint.LintCategory.AUXILIARYCLASS) && (c.flags() & 0x100000000000L) != 0L && this.rs.isAccessible(env, c) && !this.fileManager.isSameFile(c.sourcefile, env.toplevel.sourcefile)) {
            this.log.warning(pos, CompilerProperties.Warnings.AuxiliaryClassAccessedFromOutsideOfItsSourceFile((Symbol)c, c.sourcefile));
        }
    }

    void checkDefaultConstructor(Symbol.ClassSymbol c, JCDiagnostic.DiagnosticPosition pos) {
        if (this.lint.isEnabled(Lint.LintCategory.MISSING_EXPLICIT_CTOR) && (c.flags() & 0x2000000000004000L) == 0L && !c.isAnonymous() && (c.flags() & 5L) != 0L && Source.Feature.MODULES.allowedInSource(this.source)) {
            NestingKind nestingKind = c.getNestingKind();
            switch (nestingKind) {
                case ANONYMOUS: 
                case LOCAL: {
                    return;
                }
                case TOP_LEVEL: {
                    break;
                }
                case MEMBER: {
                    Symbol owner = c.owner;
                    while (owner != null && owner.kind == Kinds.Kind.TYP) {
                        if ((owner.flags() & 5L) == 0L) {
                            return;
                        }
                        owner = owner.owner;
                    }
                    break;
                }
            }
            Symbol.PackageSymbol pkg = c.packge();
            if (!pkg.isUnnamed()) {
                Symbol.ModuleSymbol modle = pkg.modle;
                for (Directive.ExportsDirective exportDir : modle.exports) {
                    if (!exportDir.packge.equals(pkg)) continue;
                    if (exportDir.modules == null || exportDir.modules.isEmpty()) {
                        this.deferredLintHandler.report(_l -> {
                            if (this.lint.isEnabled(Lint.LintCategory.MISSING_EXPLICIT_CTOR)) {
                                this.log.warning(Lint.LintCategory.MISSING_EXPLICIT_CTOR, pos, CompilerProperties.Warnings.MissingExplicitCtor(c, pkg, modle));
                            }
                        });
                        continue;
                    }
                    return;
                }
            }
        }
    }

    public Warner castWarner(JCDiagnostic.DiagnosticPosition pos, Type found, Type expected) {
        return new ConversionWarner(pos, "unchecked.cast.to.type", found, expected);
    }

    public Warner convertWarner(JCDiagnostic.DiagnosticPosition pos, Type found, Type expected) {
        return new ConversionWarner(pos, "unchecked.assign", found, expected);
    }

    public void checkFunctionalInterface(JCTree.JCClassDecl tree, Symbol.ClassSymbol cs) {
        Attribute.Compound functionalType = cs.attribute(this.syms.functionalInterfaceType.tsym);
        if (functionalType != null) {
            try {
                this.types.findDescriptorSymbol(cs);
            }
            catch (Types.FunctionDescriptorLookupError ex) {
                JCDiagnostic.DiagnosticPosition pos = tree.pos();
                for (JCTree.JCAnnotation a : tree.getModifiers().annotations) {
                    if (a.annotationType.type.tsym != this.syms.functionalInterfaceType.tsym) continue;
                    pos = a.pos();
                    break;
                }
                this.log.error(pos, CompilerProperties.Errors.BadFunctionalIntfAnno1(ex.getDiagnostic()));
            }
        }
    }

    public void checkImportsResolvable(JCTree.JCCompilationUnit toplevel) {
        for (JCTree.JCImportBase impBase : toplevel.getImports()) {
            Symbol.TypeSymbol site;
            Symbol origin;
            if (!(impBase instanceof JCTree.JCImport)) continue;
            JCTree.JCImport imp = (JCTree.JCImport)impBase;
            if (!imp.staticImport || !imp.qualid.hasTag(JCTree.Tag.SELECT)) continue;
            JCTree.JCFieldAccess select = imp.qualid;
            if (select.name == this.names.asterisk || (origin = TreeInfo.symbol(select.selected)) == null || origin.kind != Kinds.Kind.TYP || this.checkTypeContainsImportableElement(site = (Symbol.TypeSymbol)TreeInfo.symbol(select.selected), site, toplevel.packge, select.name, new HashSet<Symbol>())) continue;
            this.log.error(imp.pos(), CompilerProperties.Errors.CantResolveLocation(Kinds.KindName.STATIC, select.name, null, null, CompilerProperties.Fragments.Location(Kinds.kindName(site), site, null)));
        }
    }

    public void checkImportedPackagesObservable(JCTree.JCCompilationUnit toplevel) {
        for (JCTree.JCImportBase impBase : toplevel.getImports()) {
            if (!(impBase instanceof JCTree.JCImport)) continue;
            JCTree.JCImport imp = (JCTree.JCImport)impBase;
            if (imp.staticImport || TreeInfo.name(imp.qualid) != this.names.asterisk) continue;
            Symbol.TypeSymbol tsym = imp.qualid.selected.type.tsym;
            if (tsym.kind != Kinds.Kind.PCK || !tsym.members().isEmpty() || Source.Feature.IMPORT_ON_DEMAND_OBSERVABLE_PACKAGES.allowedInSource(this.source) && tsym.exists()) continue;
            this.log.error(JCDiagnostic.DiagnosticFlag.RESOLVE_ERROR, imp.qualid.selected.pos(), CompilerProperties.Errors.DoesntExist(tsym));
        }
    }

    private boolean checkTypeContainsImportableElement(Symbol.TypeSymbol tsym, Symbol.TypeSymbol origin, Symbol.PackageSymbol packge, Name name, Set<Symbol> processed) {
        if (tsym == null || !processed.add(tsym)) {
            return false;
        }
        if (this.checkTypeContainsImportableElement(this.types.supertype((Type)tsym.type).tsym, origin, packge, name, processed)) {
            return true;
        }
        for (Type t : this.types.interfaces(tsym.type)) {
            if (!this.checkTypeContainsImportableElement(t.tsym, origin, packge, name, processed)) continue;
            return true;
        }
        for (Symbol sym : tsym.members().getSymbolsByName(name)) {
            if (!sym.isStatic() || !this.importAccessible(sym, packge) || !sym.isMemberOf(origin, this.types)) continue;
            return true;
        }
        return false;
    }

    public boolean importAccessible(Symbol sym, Symbol.PackageSymbol packge) {
        try {
            int flags = (int)(sym.flags() & 7L);
            switch (flags) {
                default: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case 0: 
                case 4: 
            }
            return sym.packge() == packge;
        }
        catch (ClassFinder.BadClassFile err) {
            throw err;
        }
        catch (Symbol.CompletionFailure ex) {
            return false;
        }
    }

    public void checkLeaksNotAccessible(final Env<AttrContext> env, final JCTree.JCClassDecl check) {
        final JCTree.JCCompilationUnit toplevel = env.toplevel;
        if (toplevel.modle == this.syms.unnamedModule || toplevel.modle == this.syms.noModule || (check.sym.flags() & 0x1000000L) != 0L) {
            return;
        }
        Directive.ExportsDirective currentExport = this.findExport(toplevel.packge);
        if (currentExport == null || currentExport.modules != null) {
            return;
        }
        new TreeScanner(){
            Lint lint;
            boolean inSuperType;
            {
                this.lint = ((AttrContext)env.info).lint;
            }

            @Override
            public void visitBlock(JCTree.JCBlock tree) {
            }

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl tree) {
                if (!Check.this.isAPISymbol(tree.sym)) {
                    return;
                }
                Lint prevLint = this.lint;
                try {
                    this.lint = this.lint.augment(tree.sym);
                    if (this.lint.isEnabled(Lint.LintCategory.EXPORTS)) {
                        super.visitMethodDef(tree);
                    }
                }
                finally {
                    this.lint = prevLint;
                }
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl tree) {
                if (!Check.this.isAPISymbol(tree.sym) && tree.sym.owner.kind != Kinds.Kind.MTH) {
                    return;
                }
                Lint prevLint = this.lint;
                try {
                    this.lint = this.lint.augment(tree.sym);
                    if (this.lint.isEnabled(Lint.LintCategory.EXPORTS)) {
                        this.scan(tree.mods);
                        this.scan(tree.vartype);
                    }
                }
                finally {
                    this.lint = prevLint;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
                block8: {
                    if (tree != check) {
                        return;
                    }
                    if (!Check.this.isAPISymbol(tree.sym)) {
                        return;
                    }
                    Lint prevLint = this.lint;
                    try {
                        this.lint = this.lint.augment(tree.sym);
                        if (!this.lint.isEnabled(Lint.LintCategory.EXPORTS)) break block8;
                        this.scan(tree.mods);
                        this.scan(tree.typarams);
                        try {
                            this.inSuperType = true;
                            this.scan(tree.extending);
                            this.scan(tree.implementing);
                        }
                        finally {
                            this.inSuperType = false;
                        }
                        this.scan(tree.defs);
                    }
                    finally {
                        this.lint = prevLint;
                    }
                }
            }

            @Override
            public void visitTypeApply(JCTree.JCTypeApply tree) {
                this.scan(tree.clazz);
                boolean oldInSuperType = this.inSuperType;
                try {
                    this.inSuperType = false;
                    this.scan(tree.arguments);
                }
                finally {
                    this.inSuperType = oldInSuperType;
                }
            }

            @Override
            public void visitIdent(JCTree.JCIdent tree) {
                Symbol sym = TreeInfo.symbol(tree);
                if (sym.kind == Kinds.Kind.TYP && !sym.type.hasTag(TypeTag.TYPEVAR)) {
                    Check.this.checkVisible(tree.pos(), sym, toplevel.packge, this.inSuperType);
                }
            }

            @Override
            public void visitSelect(JCTree.JCFieldAccess tree) {
                Symbol sym = TreeInfo.symbol(tree);
                Symbol sitesym = TreeInfo.symbol(tree.selected);
                if (sym.kind == Kinds.Kind.TYP && sitesym.kind == Kinds.Kind.PCK) {
                    Check.this.checkVisible(tree.pos(), sym, toplevel.packge, this.inSuperType);
                } else {
                    super.visitSelect(tree);
                }
            }

            @Override
            public void visitAnnotation(JCTree.JCAnnotation tree) {
                if (tree.attribute.type.tsym.getAnnotation(Documented.class) != null) {
                    super.visitAnnotation(tree);
                }
            }
        }.scan(check);
    }

    private Directive.ExportsDirective findExport(Symbol.PackageSymbol pack) {
        for (Directive.ExportsDirective d : pack.modle.exports) {
            if (d.packge != pack) continue;
            return d;
        }
        return null;
    }

    private boolean isAPISymbol(Symbol sym) {
        while (sym.kind != Kinds.Kind.PCK) {
            if ((sym.flags() & 1L) == 0L && (sym.flags() & 4L) == 0L) {
                return false;
            }
            sym = sym.owner;
        }
        return true;
    }

    private void checkVisible(JCDiagnostic.DiagnosticPosition pos, Symbol what, Symbol.PackageSymbol inPackage, boolean inSuperType) {
        if (!this.isAPISymbol(what) && !inSuperType) {
            this.log.warning(Lint.LintCategory.EXPORTS, pos, CompilerProperties.Warnings.LeaksNotAccessible(Kinds.kindName(what), what, what.packge().modle));
            return;
        }
        Symbol.PackageSymbol whatPackage = what.packge();
        Directive.ExportsDirective whatExport = this.findExport(whatPackage);
        Directive.ExportsDirective inExport = this.findExport(inPackage);
        if (whatExport == null) {
            this.log.warning(Lint.LintCategory.EXPORTS, pos, CompilerProperties.Warnings.LeaksNotAccessibleUnexported(Kinds.kindName(what), what, what.packge().modle));
            return;
        }
        if (!(whatExport.modules == null || inExport.modules != null && whatExport.modules.containsAll(inExport.modules))) {
            this.log.warning(Lint.LintCategory.EXPORTS, pos, CompilerProperties.Warnings.LeaksNotAccessibleUnexportedQualified(Kinds.kindName(what), what, what.packge().modle));
        }
        if (whatPackage.modle != inPackage.modle && whatPackage.modle != this.syms.java_base) {
            List<Symbol.ModuleSymbol> todo = List.of(inPackage.modle);
            while (todo.nonEmpty()) {
                Symbol.ModuleSymbol current = (Symbol.ModuleSymbol)todo.head;
                todo = todo.tail;
                if (current == whatPackage.modle) {
                    return;
                }
                if ((current.flags() & 0x10000000000000L) != 0L) continue;
                for (Directive.RequiresDirective req : current.requires) {
                    if (!req.isTransitive()) continue;
                    todo = todo.prepend(req.module);
                }
            }
            this.log.warning(Lint.LintCategory.EXPORTS, pos, CompilerProperties.Warnings.LeaksNotAccessibleNotRequiredTransitive(Kinds.kindName(what), what, what.packge().modle));
        }
    }

    void checkModuleExists(JCDiagnostic.DiagnosticPosition pos, Symbol.ModuleSymbol msym) {
        if (msym.kind != Kinds.Kind.MDL) {
            this.deferredLintHandler.report(_l -> {
                if (this.lint.isEnabled(Lint.LintCategory.MODULE)) {
                    this.log.warning(Lint.LintCategory.MODULE, pos, CompilerProperties.Warnings.ModuleNotFound(msym));
                }
            });
        }
    }

    void checkPackageExistsForOpens(JCDiagnostic.DiagnosticPosition pos, Symbol.PackageSymbol packge) {
        if (packge.members().isEmpty() && (packge.flags() & 0x10000000000000L) == 0L) {
            this.deferredLintHandler.report(_l -> {
                if (this.lint.isEnabled(Lint.LintCategory.OPENS)) {
                    this.log.warning(pos, CompilerProperties.Warnings.PackageEmptyOrNotFound(packge));
                }
            });
        }
    }

    void checkModuleRequires(JCDiagnostic.DiagnosticPosition pos, Directive.RequiresDirective rd) {
        if ((rd.module.flags() & 0x10000000000000L) != 0L) {
            this.deferredLintHandler.report(_l -> {
                if (rd.isTransitive() && this.lint.isEnabled(Lint.LintCategory.REQUIRES_TRANSITIVE_AUTOMATIC)) {
                    this.log.warning(pos, CompilerProperties.Warnings.RequiresTransitiveAutomatic);
                } else if (this.lint.isEnabled(Lint.LintCategory.REQUIRES_AUTOMATIC)) {
                    this.log.warning(pos, CompilerProperties.Warnings.RequiresAutomatic);
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void checkSwitchCaseStructure(List<JCTree.JCCase> cases) {
        block20: {
            l /* !! */  = cases;
            while (l /* !! */ .nonEmpty()) {
                c = (JCTree.JCCase)l /* !! */ .head;
                var5_7 = c.labels.head;
                if (var5_7 instanceof JCTree.JCConstantCaseLabel) {
                    constLabel = (JCTree.JCConstantCaseLabel)var5_7;
                    if (TreeInfo.isNull(constLabel.expr)) {
                        if (c.labels.tail.nonEmpty()) {
                            var6_8 = c.labels.tail.head;
                            if (var6_8 instanceof JCTree.JCDefaultCaseLabel) {
                                defLabel = (JCTree.JCDefaultCaseLabel)var6_8;
                                if (c.labels.tail.tail.nonEmpty()) {
                                    this.log.error(((JCTree.JCCaseLabel)c.labels.tail.tail.head).pos(), CompilerProperties.Errors.InvalidCaseLabelCombination);
                                }
                            } else {
                                this.log.error(((JCTree.JCCaseLabel)c.labels.tail.head).pos(), CompilerProperties.Errors.InvalidCaseLabelCombination);
                            }
                        }
                    } else {
                        for (JCTree.JCCaseLabel label : c.labels.tail) {
                            if (label instanceof JCTree.JCConstantCaseLabel && !TreeInfo.isNullCaseLabel(label)) continue;
                            this.log.error(label.pos(), CompilerProperties.Errors.InvalidCaseLabelCombination);
                            break;
                        }
                    }
                } else if (c.labels.tail.nonEmpty()) {
                    patterCaseLabels = c.labels.stream().filter((Predicate<JCTree.JCCaseLabel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkSwitchCaseStructure$42(com.sun.tools.javac.tree.JCTree$JCCaseLabel ), (Lcom/sun/tools/javac/tree/JCTree$JCCaseLabel;)Z)()).map((Function<JCTree.JCCaseLabel, JCTree.JCPatternCaseLabel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkSwitchCaseStructure$43(com.sun.tools.javac.tree.JCTree$JCCaseLabel ), (Lcom/sun/tools/javac/tree/JCTree$JCCaseLabel;)Lcom/sun/tools/javac/tree/JCTree$JCPatternCaseLabel;)());
                    allUnderscore = patterCaseLabels.allMatch((Predicate<JCTree.JCPatternCaseLabel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkSwitchCaseStructure$44(com.sun.tools.javac.tree.JCTree$JCPatternCaseLabel ), (Lcom/sun/tools/javac/tree/JCTree$JCPatternCaseLabel;)Z)((Check)this));
                    if (!allUnderscore) {
                        this.log.error(((JCTree.JCCaseLabel)c.labels.tail.head).pos(), CompilerProperties.Errors.FlowsThroughFromPattern);
                    }
                    if (allPatternCaseLabels = c.labels.stream().allMatch((Predicate<JCTree.JCCaseLabel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkSwitchCaseStructure$45(com.sun.tools.javac.tree.JCTree$JCCaseLabel ), (Lcom/sun/tools/javac/tree/JCTree$JCCaseLabel;)Z)())) {
                        this.preview.checkSourceLevel(((JCTree.JCCaseLabel)c.labels.tail.head).pos(), Source.Feature.UNNAMED_VARIABLES);
                    }
                    var8_14 = c.labels.tail.iterator();
                    while (var8_14.hasNext()) {
                        label = (JCTree.JCCaseLabel)var8_14.next();
                        if (!(label instanceof JCTree.JCConstantCaseLabel)) continue;
                        this.log.error(label.pos(), CompilerProperties.Errors.InvalidCaseLabelCombination);
                        break;
                    }
                }
                l /* !! */  = l /* !! */ .tail;
            }
            v0 = isCaseStatementGroup = cases.nonEmpty() != false && ((JCTree.JCCase)cases.head).caseKind == CaseTree.CaseKind.STATEMENT;
            if (!isCaseStatementGroup) break block20;
            previousCompletessNormally = false;
            l /* !! */  = cases;
            while (l /* !! */ .nonEmpty()) {
                c = (JCTree.JCCase)l /* !! */ .head;
                if (!previousCompletessNormally || !c.stats.nonEmpty() || !((var8_14 = c.labels.head) instanceof JCTree.JCPatternCaseLabel)) ** GOTO lbl-1000
                patternLabel = (JCTree.JCPatternCaseLabel)var8_14;
                if (this.hasBindings(patternLabel.pat) || this.hasBindings(c.guard)) {
                    this.log.error(((JCTree.JCCaseLabel)c.labels.head).pos(), CompilerProperties.Errors.FlowsThroughToPattern);
                } else if (c.stats.isEmpty() && (var8_14 = c.labels.head) instanceof JCTree.JCPatternCaseLabel) {
                    patternLabel = (JCTree.JCPatternCaseLabel)var8_14;
                    if ((this.hasBindings(patternLabel.pat) || this.hasBindings(c.guard)) && this.hasStatements(l /* !! */ .tail)) {
                        this.log.error(((JCTree.JCCaseLabel)c.labels.head).pos(), CompilerProperties.Errors.FlowsThroughFromPattern);
                    }
                }
                previousCompletessNormally = c.completesNormally;
                l /* !! */  = l /* !! */ .tail;
            }
        }
    }

    boolean hasBindings(JCTree p) {
        final boolean[] bindings = new boolean[1];
        new TreeScanner(){

            @Override
            public void visitBindingPattern(JCTree.JCBindingPattern tree) {
                bindings[0] = !tree.var.sym.isUnnamedVariable();
                super.visitBindingPattern(tree);
            }
        }.scan(p);
        return bindings[0];
    }

    boolean hasStatements(List<JCTree.JCCase> cases) {
        List<JCTree.JCCase> l = cases;
        while (l.nonEmpty()) {
            if (((JCTree.JCCase)l.head).stats.nonEmpty()) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    void checkSwitchCaseLabelDominated(JCTree.JCCaseLabel unconditionalCaseLabel, List<JCTree.JCCase> cases) {
        List<Pair<JCTree.JCCase, JCTree.JCCaseLabel>> caseLabels = List.nil();
        boolean seenDefault = false;
        boolean seenDefaultLabel = false;
        boolean warnDominatedByDefault = false;
        boolean unconditionalFound = false;
        List<JCTree.JCCase> l = cases;
        while (l.nonEmpty()) {
            JCTree.JCCase c = (JCTree.JCCase)l.head;
            for (JCTree.JCCaseLabel label : c.labels) {
                if (label.hasTag(JCTree.Tag.DEFAULTCASELABEL)) {
                    seenDefault = true;
                    seenDefaultLabel |= TreeInfo.isNullCaseLabel((JCTree.JCCaseLabel)c.labels.head);
                    continue;
                }
                if (TreeInfo.isNullCaseLabel(label)) {
                    if (!seenDefault) continue;
                    this.log.error(label.pos(), CompilerProperties.Errors.PatternDominated);
                    continue;
                }
                if (seenDefault && !warnDominatedByDefault && (label.hasTag(JCTree.Tag.PATTERNCASELABEL) || label instanceof JCTree.JCConstantCaseLabel && seenDefaultLabel)) {
                    this.log.error(label.pos(), CompilerProperties.Errors.PatternDominated);
                    warnDominatedByDefault = true;
                }
                Type currentType = this.labelType(label);
                for (Pair pair : caseLabels) {
                    JCTree.JCCase testCase = (JCTree.JCCase)pair.fst;
                    JCTree.JCCaseLabel testCaseLabel = (JCTree.JCCaseLabel)pair.snd;
                    Type testType = this.labelType(testCaseLabel);
                    boolean dominated = false;
                    if (this.types.isUnconditionallyExact(currentType, testType) && !currentType.hasTag(TypeTag.ERROR) && !testType.hasTag(TypeTag.ERROR)) {
                        if (label instanceof JCTree.JCConstantCaseLabel) {
                            dominated |= !(testCaseLabel instanceof JCTree.JCConstantCaseLabel) && TreeInfo.unguardedCase(testCase);
                        } else if (label instanceof JCTree.JCPatternCaseLabel) {
                            JCTree.JCPatternCaseLabel patternCL = (JCTree.JCPatternCaseLabel)label;
                            if (testCaseLabel instanceof JCTree.JCPatternCaseLabel) {
                                JCTree.JCPatternCaseLabel testPatternCaseLabel = (JCTree.JCPatternCaseLabel)testCaseLabel;
                                if (testCase.equals(c) || TreeInfo.unguardedCase(testCase)) {
                                    dominated = this.patternDominated(testPatternCaseLabel.pat, patternCL.pat);
                                }
                            }
                        }
                    }
                    if (!dominated) continue;
                    this.log.error(label.pos(), CompilerProperties.Errors.PatternDominated);
                }
                caseLabels = caseLabels.prepend(Pair.of(c, label));
            }
            l = l.tail;
        }
    }

    private Type labelType(JCTree.JCCaseLabel label) {
        Type type;
        switch (label.getTag()) {
            case PATTERNCASELABEL: {
                type = ((JCTree.JCPatternCaseLabel)label).pat.type;
                break;
            }
            case CONSTANTCASELABEL: {
                type = ((JCTree.JCConstantCaseLabel)label).expr.type;
                break;
            }
            default: {
                throw Assert.error("Unexpected tree kind: " + (Object)((Object)label.getTag()));
            }
        }
        return this.types.erasure(type);
    }

    private boolean patternDominated(JCTree.JCPattern existingPattern, JCTree.JCPattern currentPattern) {
        Type existingPatternType = this.types.erasure(existingPattern.type);
        Type currentPatternType = this.types.erasure(currentPattern.type);
        if (!this.types.isUnconditionallyExact(currentPatternType, existingPatternType)) {
            return false;
        }
        if (currentPattern instanceof JCTree.JCBindingPattern || currentPattern instanceof JCTree.JCAnyPattern) {
            return existingPattern instanceof JCTree.JCBindingPattern || existingPattern instanceof JCTree.JCAnyPattern;
        }
        if (currentPattern instanceof JCTree.JCRecordPattern) {
            JCTree.JCRecordPattern currentRecordPattern = (JCTree.JCRecordPattern)currentPattern;
            if (existingPattern instanceof JCTree.JCBindingPattern || existingPattern instanceof JCTree.JCAnyPattern) {
                return true;
            }
            if (existingPattern instanceof JCTree.JCRecordPattern) {
                JCTree.JCRecordPattern existingRecordPattern = (JCTree.JCRecordPattern)existingPattern;
                List<JCTree.JCPattern> existingNested = existingRecordPattern.nested;
                List<JCTree.JCPattern> currentNested = currentRecordPattern.nested;
                if (existingNested.size() != currentNested.size()) {
                    return false;
                }
                while (existingNested.nonEmpty()) {
                    if (!this.patternDominated((JCTree.JCPattern)existingNested.head, (JCTree.JCPattern)currentNested.head)) {
                        return false;
                    }
                    existingNested = existingNested.tail;
                    currentNested = currentNested.tail;
                }
                return true;
            }
            Assert.error("Unknown pattern: " + (Object)((Object)existingPattern.getTag()));
        } else {
            Assert.error("Unknown pattern: " + (Object)((Object)currentPattern.getTag()));
        }
        return false;
    }

    boolean isExternalizable(Type t) {
        try {
            this.syms.externalizableType.complete();
        }
        catch (Symbol.CompletionFailure e) {
            return false;
        }
        return this.types.isSubtype(t, this.syms.externalizableType);
    }

    public void checkSerialStructure(JCTree.JCClassDecl tree, Symbol.ClassSymbol c) {
        new SerialTypeVisitor().visit(c, tree);
    }

    private static /* synthetic */ boolean lambda$checkSwitchCaseStructure$45(JCTree.JCCaseLabel p) {
        return p instanceof JCTree.JCPatternCaseLabel;
    }

    private /* synthetic */ boolean lambda$checkSwitchCaseStructure$44(JCTree.JCPatternCaseLabel pcl) {
        return !this.hasBindings(pcl.getPattern());
    }

    private static /* synthetic */ JCTree.JCPatternCaseLabel lambda$checkSwitchCaseStructure$43(JCTree.JCCaseLabel cl) {
        return (JCTree.JCPatternCaseLabel)cl;
    }

    private static /* synthetic */ boolean lambda$checkSwitchCaseStructure$42(JCTree.JCCaseLabel ll) {
        return ll instanceof JCTree.JCPatternCaseLabel;
    }

    public static interface CheckContext {
        public boolean compatible(Type var1, Type var2, Warner var3);

        public void report(JCDiagnostic.DiagnosticPosition var1, JCDiagnostic var2);

        public Warner checkWarner(JCDiagnostic.DiagnosticPosition var1, Type var2, Type var3);

        public InferenceContext inferenceContext();

        public DeferredAttr.DeferredAttrContext deferredAttrContext();
    }

    class Validator
    extends JCTree.Visitor {
        boolean checkRaw;
        boolean isOuter;
        Env<AttrContext> env;

        Validator(Env<AttrContext> env) {
            this.env = env;
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
            this.validateTree(tree.elemtype, this.checkRaw, this.isOuter);
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply tree) {
            if (tree.type.hasTag(TypeTag.CLASS)) {
                boolean is_java_lang_Class;
                List<JCTree.JCExpression> args = tree.arguments;
                List<Type> forms = tree.type.tsym.type.getTypeArguments();
                Type incompatibleArg = Check.this.firstIncompatibleTypeArg(tree.type);
                if (incompatibleArg != null) {
                    for (JCTree jCTree : tree.arguments) {
                        if (jCTree.type == incompatibleArg) {
                            Check.this.log.error(jCTree, CompilerProperties.Errors.NotWithinBounds(incompatibleArg, (Type)forms.head));
                        }
                        forms = forms.tail;
                    }
                }
                forms = tree.type.tsym.type.getTypeArguments();
                boolean bl = is_java_lang_Class = tree.type.tsym.flatName() == ((Check)Check.this).names.java_lang_Class;
                while (args.nonEmpty() && forms.nonEmpty()) {
                    this.validateTree((JCTree)args.head, !this.isOuter || !is_java_lang_Class, false);
                    args = args.tail;
                    forms = forms.tail;
                }
                if (tree.type.getEnclosingType().isRaw()) {
                    Check.this.log.error(tree.pos(), CompilerProperties.Errors.ImproperlyFormedTypeInnerRawParam);
                }
                if (tree.clazz.hasTag(JCTree.Tag.SELECT)) {
                    this.visitSelectInternal((JCTree.JCFieldAccess)tree.clazz);
                }
            }
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter tree) {
            this.validateTrees(tree.bounds, true, this.isOuter);
            Check.this.checkClassBounds(tree.pos(), tree.type);
        }

        @Override
        public void visitWildcard(JCTree.JCWildcard tree) {
            if (tree.inner != null) {
                this.validateTree(tree.inner, true, this.isOuter);
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            if (tree.type.hasTag(TypeTag.CLASS)) {
                this.visitSelectInternal(tree);
                if (tree.selected.type.isParameterized() && tree.type.tsym.type.getTypeArguments().nonEmpty()) {
                    Check.this.log.error(tree.pos(), CompilerProperties.Errors.ImproperlyFormedTypeParamMissing);
                }
            }
        }

        public void visitSelectInternal(JCTree.JCFieldAccess tree) {
            if (tree.type.tsym.isStatic() && tree.selected.type.isParameterized()) {
                Check.this.log.error(tree.pos(), CompilerProperties.Errors.CantSelectStaticClassFromParamType);
            } else {
                tree.selected.accept(this);
            }
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
            tree.underlyingType.accept(this);
        }

        @Override
        public void visitTypeIdent(JCTree.JCPrimitiveTypeTree that) {
            if (that.type.hasTag(TypeTag.VOID)) {
                Check.this.log.error(that.pos(), CompilerProperties.Errors.VoidNotAllowedHere);
            }
            super.visitTypeIdent(that);
        }

        @Override
        public void visitTree(JCTree tree) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validateTree(JCTree tree, boolean checkRaw, boolean isOuter) {
            if (tree != null) {
                boolean prevCheckRaw = this.checkRaw;
                this.checkRaw = checkRaw;
                this.isOuter = isOuter;
                try {
                    tree.accept(this);
                    if (checkRaw) {
                        Check.this.checkRaw(tree, this.env);
                    }
                }
                catch (Symbol.CompletionFailure ex) {
                    Check.this.completionError(tree.pos(), ex);
                }
                finally {
                    this.checkRaw = prevCheckRaw;
                }
            }
        }

        public void validateTrees(List<? extends JCTree> trees, boolean checkRaw, boolean isOuter) {
            List<JCTree> l = trees;
            while (l.nonEmpty()) {
                this.validateTree((JCTree)l.head, checkRaw, isOuter);
                l = l.tail;
            }
        }
    }

    private class ClashFilter
    implements Predicate<Symbol> {
        Type site;

        ClashFilter(Type site) {
            this.site = site;
        }

        boolean shouldSkip(Symbol s) {
            return (s.flags() & 0x40000000000L) != 0L && s.owner == this.site.tsym;
        }

        @Override
        public boolean test(Symbol s) {
            return s.kind == Kinds.Kind.MTH && (s.flags() & 0x1000L) == 0L && !this.shouldSkip(s) && s.isInheritedIn(this.site.tsym, Check.this.types) && !s.isConstructor();
        }
    }

    class CycleChecker
    extends TreeScanner {
        Set<Symbol> seenClasses = new HashSet<Symbol>();
        boolean errorFound = false;
        boolean partialCheck = false;

        CycleChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkSymbol(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
            if (sym != null && sym.kind == Kinds.Kind.TYP) {
                Env<AttrContext> classEnv = Check.this.enter.getEnv((Symbol.TypeSymbol)sym);
                if (classEnv != null) {
                    DiagnosticSource prevSource = Check.this.log.currentSource();
                    try {
                        Check.this.log.useSource(classEnv.toplevel.sourcefile);
                        this.scan(classEnv.tree);
                    }
                    finally {
                        Check.this.log.useSource(prevSource.getFile());
                    }
                } else if (sym.kind == Kinds.Kind.TYP) {
                    this.checkClass(pos, sym, List.nil());
                }
            } else if (sym == null || sym.kind != Kinds.Kind.PCK) {
                this.partialCheck = true;
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            super.visitSelect(tree);
            this.checkSymbol(tree.pos(), tree.sym);
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            this.checkSymbol(tree.pos(), tree.sym);
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply tree) {
            this.scan(tree.clazz);
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
            this.scan(tree.elemtype);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            List<JCTree> supertypes = List.nil();
            if (tree.getExtendsClause() != null) {
                supertypes = supertypes.prepend(tree.getExtendsClause());
            }
            if (tree.getImplementsClause() != null) {
                for (JCTree intf : tree.getImplementsClause()) {
                    supertypes = supertypes.prepend(intf);
                }
            }
            this.checkClass(tree.pos(), tree.sym, supertypes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkClass(JCDiagnostic.DiagnosticPosition pos, Symbol c, List<JCTree> supertypes) {
            if ((c.flags_field & 0x40000000L) != 0L) {
                return;
            }
            if (this.seenClasses.contains(c)) {
                this.errorFound = true;
                Check.this.noteCyclic(pos, (Symbol.ClassSymbol)c);
            } else if (!c.type.isErroneous()) {
                try {
                    this.seenClasses.add(c);
                    if (c.type.hasTag(TypeTag.CLASS)) {
                        if (supertypes.nonEmpty()) {
                            this.scan(supertypes);
                        } else {
                            Type.ClassType ct = (Type.ClassType)c.type;
                            if (ct.supertype_field == null || ct.interfaces_field == null) {
                                this.partialCheck = true;
                                return;
                            }
                            this.checkSymbol(pos, ct.supertype_field.tsym);
                            for (Type intf : ct.interfaces_field) {
                                this.checkSymbol(pos, intf.tsym);
                            }
                        }
                        if (c.owner.kind == Kinds.Kind.TYP) {
                            this.checkSymbol(pos, c.owner);
                        }
                    }
                }
                finally {
                    this.seenClasses.remove(c);
                }
            }
        }
    }

    private class DefaultMethodClashFilter
    implements Predicate<Symbol> {
        Type site;

        DefaultMethodClashFilter(Type site) {
            this.site = site;
        }

        @Override
        public boolean test(Symbol s) {
            return s.kind == Kinds.Kind.MTH && (s.flags() & 0x80000000000L) != 0L && s.isInheritedIn(this.site.tsym, Check.this.types) && !s.isConstructor();
        }
    }

    class PotentiallyAmbiguousFilter
    extends ClashFilter {
        PotentiallyAmbiguousFilter(Type site) {
            super(site);
        }

        @Override
        boolean shouldSkip(Symbol s) {
            return s.owner.type.tsym == ((Check)Check.this).syms.objectType.tsym || super.shouldSkip(s);
        }
    }

    private class SuperThisChecker
    extends TreeScanner {
        private static final int MATCH_SCAN_DEPTH = 3;
        private boolean constructor;
        private boolean firstStatement;
        private JCTree.JCReturn earlyReturn;
        private Name initCall;
        private int scanDepth;

        private SuperThisChecker() {
        }

        public void check(JCTree.JCClassDecl classDef) {
            this.scan(classDef.defs);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            Assert.check(!this.constructor);
            Assert.check(this.earlyReturn == null);
            Assert.check(this.initCall == null);
            Assert.check(this.scanDepth == 1);
            this.constructor = TreeInfo.isConstructor(tree);
            try {
                if (tree.body != null) {
                    this.firstStatement = true;
                    List<JCTree.JCStatement> l = tree.body.stats;
                    while (l.nonEmpty()) {
                        this.scan((JCTree)l.head);
                        this.firstStatement = false;
                        l = l.tail;
                    }
                }
                if (this.constructor && this.earlyReturn != null && this.initCall != null) {
                    Check.this.log.error(this.earlyReturn.pos(), CompilerProperties.Errors.ReturnBeforeSuperclassInitialized);
                }
            }
            finally {
                this.firstStatement = false;
                this.constructor = false;
                this.earlyReturn = null;
                this.initCall = null;
            }
        }

        @Override
        public void scan(JCTree tree) {
            ++this.scanDepth;
            try {
                super.scan(tree);
            }
            finally {
                --this.scanDepth;
            }
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation apply) {
            Name methodName = TreeInfo.name(apply.meth);
            if (methodName == ((Check)Check.this).names._super || methodName == ((Check)Check.this).names._this) {
                if (!this.constructor) {
                    Check.this.log.error(apply.pos(), CompilerProperties.Errors.CallMustOnlyAppearInCtor);
                } else if (this.scanDepth != 3) {
                    Check.this.log.error(apply.pos(), CompilerProperties.Errors.CtorCallsNotAllowedHere);
                } else if (this.initCall != null) {
                    Check.this.log.error(apply.pos(), CompilerProperties.Errors.RedundantSuperclassInit);
                } else {
                    if (!this.firstStatement) {
                        Check.this.preview.checkSourceLevel(apply.pos(), Source.Feature.FLEXIBLE_CONSTRUCTORS);
                    }
                    this.initCall = methodName;
                }
            }
            super.visitApply(apply);
        }

        @Override
        public void visitReturn(JCTree.JCReturn tree) {
            if (this.constructor && this.initCall == null && this.earlyReturn == null) {
                this.earlyReturn = tree;
            }
            super.visitReturn(tree);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
        }
    }

    private class ConversionWarner
    extends Warner {
        final String uncheckedKey;
        final Type found;
        final Type expected;

        public ConversionWarner(JCDiagnostic.DiagnosticPosition pos, String uncheckedKey, Type found, Type expected) {
            super(pos);
            this.uncheckedKey = uncheckedKey;
            this.found = found;
            this.expected = expected;
        }

        @Override
        public void warn(Lint.LintCategory lint) {
            boolean warned = this.warned;
            super.warn(lint);
            if (warned) {
                return;
            }
            switch (lint) {
                case UNCHECKED: {
                    Check.this.warnUnchecked(this.pos(), CompilerProperties.Warnings.ProbFoundReq(Check.this.diags.fragment(this.uncheckedKey, new Object[0]), this.found, this.expected));
                    break;
                }
                case VARARGS: {
                    if (Check.this.method == null || Check.this.method.attribute(((Check)Check.this).syms.trustMeType.tsym) == null || !Check.this.isTrustMeAllowedOnMethod(Check.this.method) || Check.this.types.isReifiable(((Check)Check.this).method.type.getParameterTypes().last())) break;
                    Check.this.warnUnsafeVararg(this.pos(), CompilerProperties.Warnings.VarargsUnsafeUseVarargsParam(((Check)Check.this).method.params.last()));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected lint: " + (Object)((Object)lint)));
                }
            }
        }
    }

    private class SerialTypeVisitor
    extends ElementKindVisitor14<Void, JCTree.JCClassDecl> {
        private static final Set<String> serialMethodNames = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("writeObject", "writeReplace", "readObject", "readObjectNoData", "readResolve")));
        private static final Set<String> serialFieldNames = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("serialVersionUID", "serialPersistentFields")));
        private final Type OSF_TYPE;
        Lint lint;

        SerialTypeVisitor() {
            this.OSF_TYPE = new Type.ArrayType(((Check)Check.this).syms.objectStreamFieldType, ((Check)Check.this).syms.arrayClass);
            this.lint = Check.this.lint;
        }

        @Override
        public Void defaultAction(Element e, JCTree.JCClassDecl p) {
            throw new IllegalArgumentException(ObjectsWrapper.requireNonNullElse(e.toString(), ""));
        }

        @Override
        public Void visitType(TypeElement e, JCTree.JCClassDecl p) {
            this.runUnderLint(e, p, (symbol, param) -> super.visitType((TypeElement)symbol, param));
            return null;
        }

        @Override
        public Void visitTypeAsClass(TypeElement e, JCTree.JCClassDecl p) {
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)e;
            this.checkCtorAccess(p, c);
            Symbol.VarSymbol svuidSym = null;
            for (Symbol sym2 : c.members().getSymbolsByName(((Check)Check.this).names.serialVersionUID)) {
                if (sym2.kind != Kinds.Kind.VAR) continue;
                svuidSym = (Symbol.VarSymbol)sym2;
                break;
            }
            if (svuidSym == null) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, p.pos(), CompilerProperties.Warnings.MissingSVUID(c));
            }
            boolean serialPersistentFieldsPresent = c.members().getSymbolsByName(((Check)Check.this).names.serialPersistentFields, sym -> sym.kind == Kinds.Kind.VAR).iterator().hasNext();
            for (Symbol el : c.getEnclosedElements()) {
                this.runUnderLint(el, p, (enclosed, tree) -> {
                    String name = null;
                    block0 : switch (enclosed.getKind()) {
                        case FIELD: {
                            long flags;
                            if (!serialPersistentFieldsPresent && ((flags = enclosed.flags()) & 0x80L) == 0L && (flags & 8L) == 0L) {
                                Type varType = enclosed.asType();
                                if (!this.canBeSerialized(varType)) {
                                    Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor(enclosed, tree), CompilerProperties.Warnings.NonSerializableInstanceField);
                                } else if (varType.hasTag(TypeTag.ARRAY)) {
                                    Type.ArrayType arrayType = (Type.ArrayType)varType;
                                    Type elementType = arrayType.elemtype;
                                    while (elementType.hasTag(TypeTag.ARRAY)) {
                                        arrayType = (Type.ArrayType)elementType;
                                        elementType = arrayType.elemtype;
                                    }
                                    if (!this.canBeSerialized(elementType)) {
                                        Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor(enclosed, tree), CompilerProperties.Warnings.NonSerializableInstanceFieldArray(elementType));
                                    }
                                }
                            }
                            if (!serialFieldNames.contains(name = enclosed.getSimpleName().toString())) break;
                            Symbol.VarSymbol field = (Symbol.VarSymbol)enclosed;
                            switch (name) {
                                case "serialVersionUID": {
                                    this.checkSerialVersionUID((JCTree.JCClassDecl)tree, e, field);
                                    break block0;
                                }
                                case "serialPersistentFields": {
                                    this.checkSerialPersistentFields((JCTree.JCClassDecl)tree, e, field);
                                    break block0;
                                }
                            }
                            throw new AssertionError();
                        }
                        case METHOD: {
                            Symbol.MethodSymbol method = (Symbol.MethodSymbol)enclosed;
                            name = ((Name)method.getSimpleName()).toString();
                            if (!serialMethodNames.contains(name)) break;
                            switch (name) {
                                case "writeObject": {
                                    this.checkWriteObject((JCTree.JCClassDecl)tree, e, method);
                                    break block0;
                                }
                                case "writeReplace": {
                                    this.checkWriteReplace((JCTree.JCClassDecl)tree, e, method);
                                    break block0;
                                }
                                case "readObject": {
                                    this.checkReadObject((JCTree.JCClassDecl)tree, e, method);
                                    break block0;
                                }
                                case "readObjectNoData": {
                                    this.checkReadObjectNoData((JCTree.JCClassDecl)tree, e, method);
                                    break block0;
                                }
                                case "readResolve": {
                                    this.checkReadResolve((JCTree.JCClassDecl)tree, e, method);
                                    break block0;
                                }
                            }
                            throw new AssertionError();
                        }
                    }
                });
            }
            return null;
        }

        boolean canBeSerialized(Type type) {
            return type.isPrimitive() || Check.this.rs.isSerializable(type);
        }

        private void checkCtorAccess(JCTree.JCClassDecl tree, Symbol.ClassSymbol c) {
            if (Check.this.isExternalizable(c.type)) {
                for (Symbol sym : c.getEnclosedElements()) {
                    if (!sym.isConstructor() || (sym.flags() & 1L) != 1L || !((List)((Symbol.MethodSymbol)sym).getParameters()).isEmpty()) continue;
                    return;
                }
            } else {
                Type superClass = c.getSuperclass();
                while (Check.this.rs.isSerializable(superClass)) {
                    try {
                        superClass = (Type)((TypeElement)((DeclaredType)((Object)superClass)).asElement()).getSuperclass();
                    }
                    catch (ClassCastException cce) {
                        return;
                    }
                }
                try {
                    Symbol.ClassSymbol supertype = (Symbol.ClassSymbol)((DeclaredType)((Object)superClass)).asElement();
                    for (Symbol sym : supertype.getEnclosedElements()) {
                        Symbol.MethodSymbol ctor;
                        if (!sym.isConstructor() || !((List)(ctor = (Symbol.MethodSymbol)sym).getParameters()).isEmpty() || (ctor.flags() & 2L) != 2L && (supertype.getNestingKind() != NestingKind.MEMBER || (supertype.flags() & 8L) != 0L)) continue;
                        Check.this.log.warning(Lint.LintCategory.SERIAL, tree.pos(), CompilerProperties.Warnings.SerializableMissingAccessNoArgCtor(supertype.getQualifiedName()));
                    }
                }
                catch (ClassCastException cce) {
                    return;
                }
                return;
            }
            Check.this.log.warning(Lint.LintCategory.SERIAL, tree.pos(), CompilerProperties.Warnings.ExternalizableMissingPublicNoArgCtor);
        }

        private void checkSerialVersionUID(JCTree.JCClassDecl tree, Element e, Symbol.VarSymbol svuid) {
            if ((svuid.flags() & 0x18L) != 24L) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)svuid, tree), CompilerProperties.Warnings.ImproperSVUID((Symbol)e));
            }
            if (!svuid.type.hasTag(TypeTag.LONG)) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)svuid, tree), CompilerProperties.Warnings.LongSVUID((Symbol)e));
            }
            if (svuid.getConstValue() == null) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)svuid, tree), CompilerProperties.Warnings.ConstantSVUID((Symbol)e));
            }
        }

        private void checkSerialPersistentFields(JCTree.JCClassDecl tree, Element e, Symbol.VarSymbol spf) {
            JCTree spfDecl;
            if ((spf.flags() & 0x1AL) != 26L) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)spf, tree), CompilerProperties.Warnings.ImproperSPF);
            }
            if (!Check.this.types.isSameType(spf.type, this.OSF_TYPE)) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)spf, tree), CompilerProperties.Warnings.OSFArraySPF);
            }
            if (Check.this.isExternalizable((Type)e.asType())) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)spf, tree), CompilerProperties.Warnings.IneffectualSerialFieldExternalizable);
            }
            if ((spfDecl = TreeInfo.declarationFor(spf, tree)) != null && spfDecl.getTag() == JCTree.Tag.VARDEF) {
                JCTree.JCVariableDecl variableDef = (JCTree.JCVariableDecl)spfDecl;
                JCTree.JCExpression initExpr = variableDef.init;
                if (initExpr != null && TreeInfo.isNull(initExpr)) {
                    Check.this.log.warning(Lint.LintCategory.SERIAL, initExpr.pos(), CompilerProperties.Warnings.SPFNullInit);
                }
            }
        }

        private void checkWriteObject(JCTree.JCClassDecl tree, Element e, Symbol.MethodSymbol method) {
            this.checkPrivateNonStaticMethod(tree, method);
            this.checkReturnType(tree, e, method, ((Check)Check.this).syms.voidType);
            this.checkOneArg(tree, e, method, ((Check)Check.this).syms.objectOutputStreamType);
            this.checkExceptions(tree, e, method, ((Check)Check.this).syms.ioExceptionType);
            this.checkExternalizable(tree, e, method);
        }

        private void checkWriteReplace(JCTree.JCClassDecl tree, Element e, Symbol.MethodSymbol method) {
            this.checkConcreteInstanceMethod(tree, e, method);
            this.checkReturnType(tree, e, method, ((Check)Check.this).syms.objectType);
            this.checkNoArgs(tree, e, method);
            this.checkExceptions(tree, e, method, ((Check)Check.this).syms.objectStreamExceptionType);
        }

        private void checkReadObject(JCTree.JCClassDecl tree, Element e, Symbol.MethodSymbol method) {
            this.checkPrivateNonStaticMethod(tree, method);
            this.checkReturnType(tree, e, method, ((Check)Check.this).syms.voidType);
            this.checkOneArg(tree, e, method, ((Check)Check.this).syms.objectInputStreamType);
            this.checkExceptions(tree, e, method, ((Check)Check.this).syms.ioExceptionType, ((Check)Check.this).syms.classNotFoundExceptionType);
            this.checkExternalizable(tree, e, method);
        }

        private void checkReadObjectNoData(JCTree.JCClassDecl tree, Element e, Symbol.MethodSymbol method) {
            this.checkPrivateNonStaticMethod(tree, method);
            this.checkReturnType(tree, e, method, ((Check)Check.this).syms.voidType);
            this.checkNoArgs(tree, e, method);
            this.checkExceptions(tree, e, method, ((Check)Check.this).syms.objectStreamExceptionType);
            this.checkExternalizable(tree, e, method);
        }

        private void checkReadResolve(JCTree.JCClassDecl tree, Element e, Symbol.MethodSymbol method) {
            this.checkConcreteInstanceMethod(tree, e, method);
            this.checkReturnType(tree, e, method, ((Check)Check.this).syms.objectType);
            this.checkNoArgs(tree, e, method);
            this.checkExceptions(tree, e, method, ((Check)Check.this).syms.objectStreamExceptionType);
        }

        private void checkWriteExternalRecord(JCTree.JCClassDecl tree, Element e, Symbol.MethodSymbol method, boolean isExtern) {
            this.checkExternMethodRecord(tree, e, method, ((Check)Check.this).syms.objectOutputType, isExtern);
        }

        private void checkReadExternalRecord(JCTree.JCClassDecl tree, Element e, Symbol.MethodSymbol method, boolean isExtern) {
            this.checkExternMethodRecord(tree, e, method, ((Check)Check.this).syms.objectInputType, isExtern);
        }

        private void checkExternMethodRecord(JCTree.JCClassDecl tree, Element e, Symbol.MethodSymbol method, Type argType, boolean isExtern) {
            if (isExtern && this.isExternMethod(tree, e, method, argType)) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)method, tree), CompilerProperties.Warnings.IneffectualExternalizableMethodRecord(((Name)method.getSimpleName()).toString()));
            }
        }

        void checkPrivateNonStaticMethod(JCTree.JCClassDecl tree, Symbol.MethodSymbol method) {
            long flags = method.flags();
            if ((flags & 2L) == 0L) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)method, tree), CompilerProperties.Warnings.SerialMethodNotPrivate((Name)method.getSimpleName()));
            }
            if ((flags & 8L) != 0L) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)method, tree), CompilerProperties.Warnings.SerialMethodStatic((Name)method.getSimpleName()));
            }
        }

        @Override
        public Void visitTypeAsEnum(TypeElement e, JCTree.JCClassDecl p) {
            boolean isExtern = Check.this.isExternalizable((Type)e.asType());
            for (Element element : e.getEnclosedElements()) {
                this.runUnderLint(element, p, (enclosed, tree) -> {
                    String name = enclosed.getSimpleName().toString();
                    switch (enclosed.getKind()) {
                        case FIELD: {
                            Symbol.VarSymbol field = (Symbol.VarSymbol)enclosed;
                            if (!serialFieldNames.contains(name)) break;
                            Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)field, tree), CompilerProperties.Warnings.IneffectualSerialFieldEnum(name));
                            break;
                        }
                        case METHOD: {
                            Symbol.MethodSymbol method = (Symbol.MethodSymbol)enclosed;
                            if (serialMethodNames.contains(name)) {
                                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)method, tree), CompilerProperties.Warnings.IneffectualSerialMethodEnum(name));
                            }
                            if (isExtern) {
                                switch (name) {
                                    case "writeExternal": {
                                        this.checkWriteExternalEnum((JCTree.JCClassDecl)tree, e, method);
                                        break;
                                    }
                                    case "readExternal": {
                                        this.checkReadExternalEnum((JCTree.JCClassDecl)tree, e, method);
                                    }
                                }
                            }
                            break;
                        }
                        case ENUM_CONSTANT: {
                            Symbol.VarSymbol field = (Symbol.VarSymbol)enclosed;
                            JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)TreeInfo.declarationFor(field, p);
                            JCTree.JCExpression patt0$temp = decl.init;
                            if (!(patt0$temp instanceof JCTree.JCNewClass)) break;
                            JCTree.JCNewClass nc = (JCTree.JCNewClass)patt0$temp;
                            if (nc.def == null) break;
                            Symbol.ClassSymbol enumConstantType = nc.def.sym;
                            this.visitTypeAsEnum((TypeElement)enumConstantType, p);
                        }
                    }
                });
            }
            return null;
        }

        private void checkWriteExternalEnum(JCTree.JCClassDecl tree, Element e, Symbol.MethodSymbol method) {
            this.checkExternMethodEnum(tree, e, method, ((Check)Check.this).syms.objectOutputType);
        }

        private void checkReadExternalEnum(JCTree.JCClassDecl tree, Element e, Symbol.MethodSymbol method) {
            this.checkExternMethodEnum(tree, e, method, ((Check)Check.this).syms.objectInputType);
        }

        private void checkExternMethodEnum(JCTree.JCClassDecl tree, Element e, Symbol.MethodSymbol method, Type argType) {
            if (this.isExternMethod(tree, e, method, argType)) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)method, tree), CompilerProperties.Warnings.IneffectualExternMethodEnum(((Name)method.getSimpleName()).toString()));
            }
        }

        private boolean isExternMethod(JCTree.JCClassDecl tree, Element e, Symbol.MethodSymbol method, Type argType) {
            long flags = method.flags();
            Type rtype = method.getReturnType();
            return (flags & 1L) != 0L && (flags & 8L) == 0L && Check.this.types.isSameType(((Check)Check.this).syms.voidType, rtype) && this.hasExactlyOneArgWithType(tree, e, method, argType);
        }

        @Override
        public Void visitTypeAsInterface(TypeElement e, JCTree.JCClassDecl p) {
            for (Element element : e.getEnclosedElements()) {
                this.runUnderLint(element, p, (enclosed, tree) -> {
                    String name = null;
                    block0 : switch (enclosed.getKind()) {
                        case FIELD: {
                            Symbol.VarSymbol field = (Symbol.VarSymbol)enclosed;
                            switch (name = ((Name)field.getSimpleName()).toString()) {
                                case "serialPersistentFields": {
                                    Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)field, tree), CompilerProperties.Warnings.IneffectualSerialFieldInterface);
                                    break;
                                }
                                case "serialVersionUID": {
                                    this.checkSerialVersionUID((JCTree.JCClassDecl)tree, e, field);
                                }
                            }
                            break;
                        }
                        case METHOD: {
                            Symbol.MethodSymbol method = (Symbol.MethodSymbol)enclosed;
                            name = enclosed.getSimpleName().toString();
                            if (!serialMethodNames.contains(name)) break;
                            switch (name) {
                                case "readObject": 
                                case "readObjectNoData": 
                                case "writeObject": {
                                    this.checkPrivateMethod((JCTree.JCClassDecl)tree, e, method);
                                    break block0;
                                }
                                case "writeReplace": 
                                case "readResolve": {
                                    this.checkDefaultIneffective((JCTree.JCClassDecl)tree, e, method);
                                    break block0;
                                }
                            }
                            throw new AssertionError();
                        }
                    }
                });
            }
            return null;
        }

        private void checkPrivateMethod(JCTree.JCClassDecl tree, Element e, Symbol.MethodSymbol method) {
            if ((method.flags() & 2L) == 0L) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)method, tree), CompilerProperties.Warnings.NonPrivateMethodWeakerAccess);
            }
        }

        private void checkDefaultIneffective(JCTree.JCClassDecl tree, Element e, Symbol.MethodSymbol method) {
            if ((method.flags() & 0x80000000000L) == 0x80000000000L) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)method, tree), CompilerProperties.Warnings.DefaultIneffective);
            }
        }

        @Override
        public Void visitTypeAsAnnotationType(TypeElement e, JCTree.JCClassDecl p) {
            return null;
        }

        @Override
        public Void visitTypeAsRecord(TypeElement e, JCTree.JCClassDecl p) {
            boolean isExtern = Check.this.isExternalizable((Type)e.asType());
            for (Element element : e.getEnclosedElements()) {
                this.runUnderLint(element, p, (enclosed, tree) -> {
                    String name = enclosed.getSimpleName().toString();
                    block0 : switch (enclosed.getKind()) {
                        case FIELD: {
                            Symbol.VarSymbol field = (Symbol.VarSymbol)enclosed;
                            switch (name) {
                                case "serialPersistentFields": {
                                    Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)field, tree), CompilerProperties.Warnings.IneffectualSerialFieldRecord);
                                    break;
                                }
                                case "serialVersionUID": {
                                    this.checkSerialVersionUID((JCTree.JCClassDecl)tree, e, field);
                                }
                            }
                            break;
                        }
                        case METHOD: {
                            Symbol.MethodSymbol method = (Symbol.MethodSymbol)enclosed;
                            switch (name) {
                                case "writeReplace": {
                                    this.checkWriteReplace((JCTree.JCClassDecl)tree, e, method);
                                    break block0;
                                }
                                case "readResolve": {
                                    this.checkReadResolve((JCTree.JCClassDecl)tree, e, method);
                                    break block0;
                                }
                                case "writeExternal": {
                                    this.checkWriteExternalRecord((JCTree.JCClassDecl)tree, e, method, isExtern);
                                    break block0;
                                }
                                case "readExternal": {
                                    this.checkReadExternalRecord((JCTree.JCClassDecl)tree, e, method, isExtern);
                                    break block0;
                                }
                            }
                            if (!serialMethodNames.contains(name)) break;
                            Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)method, tree), CompilerProperties.Warnings.IneffectualSerialMethodRecord(name));
                        }
                    }
                });
            }
            return null;
        }

        void checkConcreteInstanceMethod(JCTree.JCClassDecl tree, Element enclosing, Symbol.MethodSymbol method) {
            if ((method.flags() & 0x408L) != 0L) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)method, tree), CompilerProperties.Warnings.SerialConcreteInstanceMethod((Name)method.getSimpleName()));
            }
        }

        private void checkReturnType(JCTree.JCClassDecl tree, Element enclosing, Symbol.MethodSymbol method, Type expectedReturnType) {
            Type rtype = method.getReturnType();
            if (!Check.this.types.isSameType(expectedReturnType, rtype)) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)method, tree), CompilerProperties.Warnings.SerialMethodUnexpectedReturnType((Name)method.getSimpleName(), rtype, expectedReturnType));
            }
        }

        private void checkOneArg(JCTree.JCClassDecl tree, Element enclosing, Symbol.MethodSymbol method, Type expectedType) {
            String name = ((Name)method.getSimpleName()).toString();
            java.util.List parameters = method.getParameters();
            if (((List)parameters).size() != 1) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)method, tree), CompilerProperties.Warnings.SerialMethodOneArg((Name)method.getSimpleName(), ((List)parameters).size()));
                return;
            }
            TypeMirror parameterType = ((Symbol.VarSymbol)((List)parameters).get(0)).asType();
            if (!Check.this.types.isSameType((Type)parameterType, expectedType)) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)method, tree), CompilerProperties.Warnings.SerialMethodParameterType((Name)method.getSimpleName(), expectedType, (Type)parameterType));
            }
        }

        private boolean hasExactlyOneArgWithType(JCTree.JCClassDecl tree, Element enclosing, Symbol.MethodSymbol method, Type expectedType) {
            java.util.List parameters = method.getParameters();
            return ((List)parameters).size() == 1 && Check.this.types.isSameType((Type)((Symbol.VarSymbol)((List)parameters).get(0)).asType(), expectedType);
        }

        private void checkNoArgs(JCTree.JCClassDecl tree, Element enclosing, Symbol.MethodSymbol method) {
            java.util.List parameters = method.getParameters();
            if (!((List)parameters).isEmpty()) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)((List)parameters).get(0), tree), CompilerProperties.Warnings.SerialMethodNoArgs((Name)method.getSimpleName()));
            }
        }

        private void checkExternalizable(JCTree.JCClassDecl tree, Element enclosing, Symbol.MethodSymbol method) {
            if (Check.this.isExternalizable((Type)enclosing.asType())) {
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)method, tree), CompilerProperties.Warnings.IneffectualSerialMethodExternalizable((Name)method.getSimpleName()));
            }
        }

        private void checkExceptions(JCTree.JCClassDecl tree, Element enclosing, Symbol.MethodSymbol method, Type ... declaredExceptions) {
            for (Type thrownType : method.getThrownTypes()) {
                if (Check.this.types.isSubtype(thrownType, ((Check)Check.this).syms.runtimeExceptionType) || Check.this.types.isSubtype(thrownType, ((Check)Check.this).syms.errorType)) continue;
                boolean declared = false;
                for (Type declaredException : declaredExceptions) {
                    if (!Check.this.types.isSubtype(thrownType, declaredException)) continue;
                    declared = true;
                }
                if (declared) continue;
                Check.this.log.warning(Lint.LintCategory.SERIAL, TreeInfo.diagnosticPositionFor((Symbol)method, tree), CompilerProperties.Warnings.SerialMethodUnexpectedException((Name)method.getSimpleName(), thrownType));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <E extends Element> Void runUnderLint(E symbol, JCTree.JCClassDecl p, BiConsumer<E, JCTree.JCClassDecl> task) {
            Lint prevLint = this.lint;
            try {
                this.lint = this.lint.augment((Symbol)symbol);
                if (this.lint.isEnabled(Lint.LintCategory.SERIAL)) {
                    task.accept(symbol, p);
                }
                Void void_ = null;
                return void_;
            }
            finally {
                this.lint = prevLint;
            }
        }
    }

    static class NestedCheckContext
    implements CheckContext {
        CheckContext enclosingContext;

        NestedCheckContext(CheckContext enclosingContext) {
            this.enclosingContext = enclosingContext;
        }

        @Override
        public boolean compatible(Type found, Type req, Warner warn) {
            return this.enclosingContext.compatible(found, req, warn);
        }

        @Override
        public void report(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic details) {
            this.enclosingContext.report(pos, details);
        }

        @Override
        public Warner checkWarner(JCDiagnostic.DiagnosticPosition pos, Type found, Type req) {
            return this.enclosingContext.checkWarner(pos, found, req);
        }

        @Override
        public InferenceContext inferenceContext() {
            return this.enclosingContext.inferenceContext();
        }

        @Override
        public DeferredAttr.DeferredAttrContext deferredAttrContext() {
            return this.enclosingContext.deferredAttrContext();
        }
    }
}

