/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.netbeans.modules.java.j2seplatform.JDKDetectorUtils;

public class SdkManJavaPlatformDetector
implements Runnable {
    static final Path SDKMAN_JAVA_DIR = Paths.get(System.getProperty("user.home"), ".sdkman", "candidates", "java");

    @Override
    public void run() {
        if (Files.isDirectory(SDKMAN_JAVA_DIR, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(SDKMAN_JAVA_DIR);){
                List<Path> jdks = files.filter(p -> Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS)).filter(p -> !p.getFileName().toString().equals("current")).collect(Collectors.toList());
                JDKDetectorUtils.registerJDKs(jdks, jdk -> SdkManJavaPlatformDetector.getDisplayName(jdk));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String getDisplayName(Path path) {
        return "JDK " + path.getFileName().toString() + " (SDKMAN)";
    }
}

