/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.modelcache.MavenProjectCache;
import org.netbeans.modules.maven.queries.Bundle;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.ProjectReload;
import org.netbeans.modules.project.dependency.spi.ProjectReloadImplementation;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class MavenPrimingReloadImplementation
implements ProjectReloadImplementation {
    private Set<String> placeholderArtifactNames = new HashSet<String>();
    private Reference<ProjectReloadImplementation.ProjectStateData> lastData = new WeakReference<Object>(null);

    private ProjectReload.Quality getProjectQuality(MavenProject mp) {
        if (MavenProjectCache.isFallbackproject(mp)) {
            MavenProject fallback = MavenProjectCache.getPartialProject(mp);
            return fallback != null ? ProjectReload.Quality.BROKEN : ProjectReload.Quality.NONE;
        }
        if (!MavenProjectCache.getPlaceholderArtifacts(mp).isEmpty()) {
            return ProjectReload.Quality.LOADED;
        }
        return ProjectReload.Quality.RESOLVED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectReloadImplementation.ProjectStateData createStateData(MavenProject mp) {
        MavenPrimingReloadImplementation mavenPrimingReloadImplementation = this;
        synchronized (mavenPrimingReloadImplementation) {
            ModelHolder h;
            ProjectReloadImplementation.ProjectStateData d2 = this.lastData.get();
            if (d2 != null && (h = (ModelHolder)d2.getProjectData()) != null && h.p == mp) {
                return d2;
            }
        }
        ProjectReloadImplementation.ProjectStateBuilder builder = ProjectReloadImplementation.ProjectStateData.builder((ProjectReload.Quality)this.getProjectQuality(mp)).timestamp(MavenProjectCache.getLoadTimestamp(mp));
        builder.data((Object)new ModelHolder(mp));
        builder.attachLookup(Lookups.fixed((Object[])new Object[]{mp}));
        ProjectReloadImplementation.ProjectStateData d = builder.build();
        MavenPrimingReloadImplementation mavenPrimingReloadImplementation2 = this;
        synchronized (mavenPrimingReloadImplementation2) {
            ProjectReloadImplementation.ProjectStateData d2 = this.lastData.get();
            if (d2 != null) {
                if (d2.getProjectData() == mp) {
                    return d2;
                }
                d2.fireChanged(true, false);
            }
            this.lastData = new WeakReference<ProjectReloadImplementation.ProjectStateData>(d);
        }
        return d;
    }

    static boolean checkForMissingArtifacts(MavenProject p) {
        return p == null || !MavenProjectCache.isIncompleteProject(p) || MavenProjectCache.getPlaceholderArtifacts(p).isEmpty();
    }

    static String artifactGav(Artifact a) {
        return String.format("%s:%s:%s:%s", a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture reload(final Project project, ProjectReload.StateRequest request, final ProjectReloadImplementation.LoadContext context) {
        final MavenProject p = (MavenProject)context.stateLookup().lookup(MavenProject.class);
        LC lc = (LC)context.ensureLoadContext(LC.class, LC::new);
        boolean ok = MavenPrimingReloadImplementation.checkForMissingArtifacts(p);
        if (ok) {
            MavenPrimingReloadImplementation mavenPrimingReloadImplementation = this;
            synchronized (mavenPrimingReloadImplementation) {
                this.placeholderArtifactNames.clear();
            }
            return CompletableFuture.completedFuture(null);
        }
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (!ap.isActionEnabled("prime", Lookup.EMPTY)) {
            return CompletableFuture.completedFuture(null);
        }
        Collection<Artifact> placeholders = MavenProjectCache.getPlaceholderArtifacts(p);
        HashSet<String> gavs = new HashSet<String>();
        placeholders.forEach(a -> gavs.add(MavenPrimingReloadImplementation.artifactGav(a)));
        String parentGav = MavenPrimingReloadImplementation.artifactGav(p.getParentArtifact());
        final CompletableFuture<ProjectReloadImplementation.ProjectStateData> future = new CompletableFuture<ProjectReloadImplementation.ProjectStateData>();
        if (gavs.contains(parentGav)) {
            if (request.getMinQuality().isWorseThan(ProjectReload.Quality.BROKEN)) {
                future.complete(this.createStateData(p));
            } else if (request.isOfflineOperation()) {
                ProjectReloadImplementation.PartialLoadException ex = new ProjectReloadImplementation.PartialLoadException(this.createStateData(p), Bundle.ERR_ParentPomMissing(ProjectUtils.getInformation((Project)project).getDisplayName(), parentGav), (Throwable)new ProjectOperationException(project, ProjectOperationException.State.OFFLINE, Bundle.ERR_UnprimedInOfflineMode(ProjectUtils.getInformation((Project)project).getDisplayName())));
                future.completeExceptionally((Throwable)ex);
                return future;
            }
        }
        if (request.getMinQuality().isWorseThan(ProjectReload.Quality.RESOLVED)) {
            future.complete(this.createStateData(p));
            return future;
        }
        if (request.isOfflineOperation()) {
            ProjectReloadImplementation.PartialLoadException ex = new ProjectReloadImplementation.PartialLoadException(this.createStateData(p), Bundle.ERR_ParentPomMissing(ProjectUtils.getInformation((Project)project).getDisplayName(), parentGav), (Throwable)new ProjectOperationException(project, ProjectOperationException.State.OFFLINE, Bundle.ERR_UnprimedInOfflineMode(ProjectUtils.getInformation((Project)project).getDisplayName())));
            future.completeExceptionally((Throwable)ex);
            return future;
        }
        MavenPrimingReloadImplementation ex = this;
        synchronized (ex) {
            if (!lc.firstRun && this.placeholderArtifactNames.containsAll(gavs) && !request.isForceReload()) {
                future.complete(this.createStateData(p));
                return future;
            }
            this.placeholderArtifactNames = gavs;
        }
        lc.firstRun = false;
        class CancelSignalDelegator
        implements Consumer<Cancellable>,
        Cancellable {
            private final AtomicReference<Cancellable> ref = new AtomicReference();

            CancelSignalDelegator() {
            }

            @Override
            public void accept(Cancellable other) {
                this.ref.set(other);
            }

            public boolean cancel() {
                Cancellable other = this.ref.get();
                return other != null && other.cancel();
            }
        }
        CancelSignalDelegator csd = new CancelSignalDelegator();
        context.setCancellable((Cancellable)csd);
        ActionProgress prg = new ActionProgress(){

            protected void started() {
            }

            public void finished(boolean success) {
                if (success) {
                    context.retryReload();
                    future.complete(null);
                } else if (context.isCancelled()) {
                    future.completeExceptionally(context.getCancelled());
                } else {
                    String n = ProjectUtils.getInformation((Project)project).getDisplayName();
                    ProjectOperationException cause = new ProjectOperationException(project, ProjectOperationException.State.BROKEN, Bundle.ERR_PrimingBuildFailed(n));
                    ProjectReloadImplementation.ProjectStateData partialdata = MavenPrimingReloadImplementation.this.createStateData(p);
                    ProjectReloadImplementation.PartialLoadException ex = new ProjectReloadImplementation.PartialLoadException(partialdata, Bundle.ERR_PrimingBuildFailed(n), (Throwable)cause);
                    future.completeExceptionally((Throwable)ex);
                }
            }
        };
        if (context.isCancelled()) {
            future.cancel(true);
            return future;
        }
        ap.invokeAction("prime", Lookups.fixed((Object[])new Object[]{prg, csd}));
        return future;
    }

    private static class ModelHolder {
        final MavenProject p;

        public ModelHolder(MavenProject p) {
            this.p = p;
        }
    }

    static class LC {
        boolean firstRun = true;

        LC() {
        }
    }
}

