/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.project;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.fish.payara.micro.project.DeployOnSaveManager;
import org.netbeans.modules.fish.payara.micro.project.MicroApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.ModelRunConfig;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ReloadAction
extends AbstractAction {
    static final String CATEGORY = "Build";
    static final String ID = "org.netbeans.modules.payara.micro.action.reload";
    private static final RequestProcessor RP = new RequestProcessor(ReloadAction.class.getName());

    @Override
    public void actionPerformed(ActionEvent e) {
        Lookup context = Utilities.actionsGlobalContext();
        Project project = (Project)context.lookup(Project.class);
        if (project == null) {
            return;
        }
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        MavenProject mavenProject = nbMavenProject.getMavenProject();
        MicroApplication microApplication = MicroApplication.getInstance(project);
        if (microApplication == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ReloadAction.class, (String)"ERR_Payara_Micro_Plugin_Not_Found", (Object)mavenProject.getArtifactId()));
        } else if (!RunUtils.isCompileOnSaveEnabled((Project)microApplication.getProject())) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ReloadAction.class, (String)"ERR_Compile_On_Save_Not_Enabled", (Object)mavenProject.getArtifactId()));
        } else {
            RP.post(() -> {
                String action = RunUtils.isCompileOnSaveEnabled((Project)project) ? "micro-explode" : "micro-complie-explode";
                NetbeansActionMapping mapping = ActionToGoalUtils.getDefaultMapping((String)action, (Project)project);
                ModelRunConfig rc = new ModelRunConfig(project, mapping, mapping.getActionName(), null, Lookup.EMPTY, false);
                rc.setTaskDisplayName(NbBundle.getMessage(ReloadAction.class, (String)"TXT_Reload", (Object)mavenProject.getArtifactId()));
                RunUtils.run((RunConfig)rc);
            });
        }
    }

    public static void reloadApplication(String buildPath, DeployOnSaveManager.DeployArtifact deployArtifact) {
        block19: {
            try {
                boolean metadataChanged = false;
                ArrayList<String> sourcesChanged = new ArrayList<String>();
                FileObject destRoot = FileUtil.createFolder((File)new File(buildPath));
                if (deployArtifact != null) {
                    for (ArtifactListener.Artifact artifact : deployArtifact.getArtifacts()) {
                        File altDistFile = artifact.getDistributionPath();
                        FileObject checkFile = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)altDistFile));
                        String relative = FileUtil.getRelativePath((FileObject)destRoot, (FileObject)checkFile);
                        sourcesChanged.add(relative);
                        if (!checkFile.getExt().equals("xml") && !checkFile.getExt().equals("properties")) continue;
                        metadataChanged = true;
                    }
                }
                Preferences pref = ProjectUtils.getPreferences((Project)deployArtifact.getProject(), MicroApplication.class, (boolean)true);
                Boolean hotDeploy = pref.getBoolean("hotDeploy", false);
                File reloadFile = new File(buildPath, ".reload");
                if (hotDeploy.booleanValue()) {
                    Properties props = new Properties();
                    props.setProperty("hotdeploy", "true");
                    if (metadataChanged) {
                        props.setProperty("metadatachanged", "true");
                    }
                    if (!sourcesChanged.isEmpty()) {
                        props.setProperty("sourceschanged", String.join((CharSequence)",", sourcesChanged));
                    }
                    try (FileOutputStream outputStrem = new FileOutputStream(reloadFile);){
                        props.store(outputStrem, null);
                        break block19;
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Unable to save .reload file " + ex.toString());
                    }
                }
                if (reloadFile.exists()) {
                    try {
                        PrintWriter pw = new PrintWriter(reloadFile);
                        pw.close();
                    }
                    catch (FileNotFoundException ex) {
                        throw new IllegalStateException("Unable to find .reload file " + ex.toString());
                    }
                    reloadFile.setLastModified(System.currentTimeMillis());
                    break block19;
                }
                try {
                    reloadFile.createNewFile();
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Unable to create .reload file " + ex.toString());
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

