/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PushDownPanel
extends JPanel
implements CustomRefactoringPanel {
    private static final String[] COLUMN_NAMES = new String[]{"LBL_PullUp_Selected", "LBL_PullUp_Member", "LBL_PushDown_KeepAbstract"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, MemberInfo.class, Boolean.class};
    private final PushDownRefactoring refactoring;
    private final TableModel tableModel;
    private final Set selectedMembers;
    private Object[][] members = new Object[0][0];
    private ChangeListener parent;
    private boolean initialized = false;
    private JLabel chooseLabel;
    private JScrollPane membersScrollPane;
    private JTable membersTable;

    public PushDownPanel(PushDownRefactoring refactoring, Set selectedMembers, ChangeListener parent) {
        this.refactoring = refactoring;
        this.tableModel = new TableModel();
        this.selectedMembers = selectedMembers;
        this.initComponents();
        this.setPreferredSize(new Dimension(420, 380));
        this.parent = parent;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        TreePathHandle handle = this.refactoring.getSourceType();
        JavaSource source = JavaSource.forFileObject((FileObject)handle.getFileObject());
        try {
            source.runUserActionTask((Task)new InitialisationTask(handle), true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.parent.stateChanged(null);
        this.initialized = true;
    }

    public MemberInfo[] getMembers() {
        ArrayList<MemberInfo> list = new ArrayList<MemberInfo>();
        for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i][0].equals(Boolean.TRUE)) continue;
            Object element = this.members[i][1];
            MemberInfo member = (MemberInfo)element;
            if (this.members[i][2] != null) {
                member.setMakeAbstract((Boolean)this.members[i][2]);
            }
            list.add(member);
        }
        return list.toArray(new MemberInfo[0]);
    }

    private void initComponents() {
        this.membersScrollPane = new JScrollPane();
        this.membersTable = new JTable();
        this.chooseLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.membersScrollPane.setToolTipText("");
        this.membersTable.setModel(this.tableModel);
        this.membersScrollPane.setViewportView(this.membersTable);
        this.membersTable.getAccessibleContext().setAccessibleName(null);
        this.membersTable.getAccessibleContext().setAccessibleDescription(null);
        this.add((Component)this.membersScrollPane, "Center");
        this.chooseLabel.setLabelFor(this.membersTable);
        Mnemonics.setLocalizedText((JLabel)this.chooseLabel, (String)NbBundle.getMessage(PushDownPanel.class, (String)"LBL_PushDownLabel"));
        this.add((Component)this.chooseLabel, "North");
    }

    public Component getComponent() {
        return this;
    }

    static /* synthetic */ Object[][] access$302(PushDownPanel x0, Object[][] x1) {
        x0.members = x1;
        return x1;
    }

    private class TableModel
    extends AbstractTableModel {
        private TableModel() {
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return UIUtilities.getColumnName(NbBundle.getMessage(PushDownPanel.class, (String)COLUMN_NAMES[column]));
        }

        public Class getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public int getRowCount() {
            return PushDownPanel.this.members.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return PushDownPanel.this.members[rowIndex][columnIndex];
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ((PushDownPanel)PushDownPanel.this).members[rowIndex][columnIndex] = value;
            PushDownPanel.this.parent.stateChanged(null);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                if (PushDownPanel.this.members[rowIndex][2] == null) {
                    return false;
                }
                Object element = PushDownPanel.this.members[rowIndex][1];
                return !((MemberInfo)element).getModifiers().contains((Object)Modifier.STATIC);
            }
            return columnIndex == 0;
        }
    }

    private class InitialisationTask
    implements CancellableTask<CompilationController> {
        private final TreePathHandle handle;

        public InitialisationTask(TreePathHandle handle) {
            this.handle = handle;
        }

        public void cancel() {
        }

        /*
         * WARNING - void declaration
         */
        public void run(CompilationController controller) throws Exception {
            void var5_9;
            controller.toPhase(JavaSource.Phase.RESOLVED);
            ArrayList<MemberInfo<Object>> l = new ArrayList<MemberInfo<Object>>();
            TypeElement sourceTypeElement = (TypeElement)this.handle.resolveElement((CompilationInfo)controller);
            for (TypeMirror typeMirror : sourceTypeElement.getInterfaces()) {
                l.add(MemberInfo.create(RefactoringUtils.typeToElement(typeMirror, (CompilationInfo)controller), (CompilationInfo)controller, MemberInfo.Group.IMPLEMENTS));
            }
            for (Element element : sourceTypeElement.getEnclosedElements()) {
                if (element.getKind() == ElementKind.CONSTRUCTOR || element.getKind() == ElementKind.STATIC_INIT || element.getKind() == ElementKind.INSTANCE_INIT || element instanceof TypeElement && controller.getTypes().isSubtype(element.asType(), sourceTypeElement.asType())) continue;
                l.add(MemberInfo.create(element, (CompilationInfo)controller));
            }
            Object[][] allMembers = new Object[l.size()][3];
            boolean bl = false;
            for (MemberInfo memberInfo : l) {
                allMembers[var5_9][0] = PushDownPanel.this.selectedMembers.contains(memberInfo) ? Boolean.TRUE : Boolean.FALSE;
                allMembers[var5_9][1] = memberInfo;
                allMembers[var5_9][2] = ((ElementHandle)memberInfo.getElementHandle()).getKind() == ElementKind.METHOD ? Boolean.FALSE : null;
                ++var5_9;
            }
            PushDownPanel.access$302(PushDownPanel.this, new Object[var5_9][3]);
            if (var5_9 > 0) {
                System.arraycopy(allMembers, 0, PushDownPanel.this.members, 0, (int)var5_9);
            }
            PushDownPanel.this.membersTable.setDefaultRenderer(COLUMN_CLASSES[1], new UIUtilities.JavaElementTableCellRenderer(){

                @Override
                protected String extractText(Object value) {
                    String displayValue = super.extractText(value);
                    if (value instanceof MemberInfo && ((MemberInfo)value).getGroup() == MemberInfo.Group.IMPLEMENTS) {
                        displayValue = "implements " + displayValue;
                    }
                    return displayValue;
                }
            });
            PushDownPanel.this.membersTable.getColumnModel().getColumn(2).setCellRenderer(new UIUtilities.BooleanTableCellRenderer(PushDownPanel.this.membersTable){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    MemberInfo object = (MemberInfo)table.getModel().getValueAt(row, 1);
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            });
            PushDownPanel.this.membersScrollPane.setBackground(PushDownPanel.this.membersTable.getBackground());
            PushDownPanel.this.membersScrollPane.getViewport().setBackground(PushDownPanel.this.membersTable.getBackground());
            PushDownPanel.this.membersTable.setRowHeight(18);
            if (UIManager.getColor("control") != null) {
                PushDownPanel.this.membersTable.setGridColor(UIManager.getColor("control"));
            }
            UIUtilities.initColumnWidth(PushDownPanel.this.membersTable, 0, Boolean.TRUE, 4);
            UIUtilities.initColumnWidth(PushDownPanel.this.membersTable, 2, Boolean.TRUE, 4);
        }
    }
}

