/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.file.launcher.actions;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.base.ExplicitProcessParameters;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.file.launcher.SingleSourceFileUtil;
import org.netbeans.modules.java.file.launcher.actions.JPDAStart;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Utilities;

final class LaunchProcess
implements Callable<Process> {
    private final FileObject fileObject;
    private final JPDAStart start;
    private final ExplicitProcessParameters params;

    LaunchProcess(FileObject fileObject, JPDAStart start, ExplicitProcessParameters params) {
        this.fileObject = fileObject;
        this.start = start;
        this.params = params;
    }

    @Override
    public Process call() throws Exception {
        if (this.start != null) {
            return this.setupProcess(this.start.execute());
        }
        return this.setupProcess(null);
    }

    private Process setupProcess(String port) throws InterruptedException {
        try {
            Process p;
            boolean compile = SingleSourceFileUtil.findJavaVersion() < 11 || SingleSourceFileUtil.hasClassSibling(this.fileObject);
            JavaPlatform jdk = LaunchProcess.readRunJdkFromAttribute(this.fileObject);
            if (compile && (p = SingleSourceFileUtil.compileJavaSource(this.fileObject, jdk)).waitFor() != 0) {
                return p;
            }
            ArrayList<String> commandsList = new ArrayList<String>();
            FileObject java = jdk.findTool("java");
            File javaFile = FileUtil.toFile((FileObject)java);
            String javaPath = javaFile.getAbsolutePath();
            URI cwd = SingleSourceFileUtil.getOptionsFor(this.fileObject).getWorkDirectory();
            File workDir = Utilities.toFile((URI)cwd);
            ExplicitProcessParameters paramsFromAttributes = ExplicitProcessParameters.builder().args(LaunchProcess.readArgumentsFromAttribute(this.fileObject, "single_file_run_arguments")).launcherArgs(LaunchProcess.readArgumentsFromAttribute(this.fileObject, "single_file_vm_options")).workingDirectory(workDir).build();
            ExplicitProcessParameters realParameters = ExplicitProcessParameters.builder().combine(this.params).combine(paramsFromAttributes).build();
            commandsList.add(javaPath);
            if (realParameters.getLauncherArguments() != null) {
                commandsList.addAll(realParameters.getLauncherArguments());
            }
            if (port != null) {
                commandsList.add("-agentlib:jdwp=transport=dt_socket,address=" + port + ",server=n");
            }
            if (compile) {
                commandsList.add("-cp");
                commandsList.add(FileUtil.toFile((FileObject)this.fileObject.getParent()).toString());
                commandsList.add(this.fileObject.getName());
            } else {
                commandsList.add(FileUtil.toFile((FileObject)this.fileObject).getAbsolutePath());
            }
            if (realParameters.getArguments() != null) {
                commandsList.addAll(realParameters.getArguments());
            }
            ProcessBuilder runFileProcessBuilder = new ProcessBuilder(commandsList);
            runFileProcessBuilder.environment().putAll(realParameters.getEnvironmentVariables());
            runFileProcessBuilder.directory(realParameters.getWorkingDirectory());
            runFileProcessBuilder.redirectErrorStream(true);
            runFileProcessBuilder.redirectOutput();
            return runFileProcessBuilder.start();
        }
        catch (IOException ex) {
            SingleSourceFileUtil.LOG.log(Level.WARNING, "Could not get InputStream of Run Process");
            return null;
        }
    }

    private static JavaPlatform readRunJdkFromAttribute(FileObject fo) {
        String str;
        String runJDKAttribute;
        Object object = fo.getAttribute("single_file_run_jdk");
        String string = runJDKAttribute = object instanceof String ? (str = (String)object) : null;
        if (runJDKAttribute != null && !runJDKAttribute.isBlank()) {
            for (JavaPlatform jdk : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                if (!runJDKAttribute.equals(jdk.getDisplayName())) continue;
                return jdk;
            }
            Logger.getLogger(LaunchProcess.class.getName()).log(Level.WARNING, "Unknown JDK: [{0}]", runJDKAttribute);
        }
        return JavaPlatformManager.getDefault().getDefaultPlatform();
    }

    private static List<String> readArgumentsFromAttribute(FileObject fileObject, String attributeName) {
        Object argumentsObject = fileObject.getAttribute(attributeName);
        if (!(argumentsObject instanceof String)) {
            return null;
        }
        return Arrays.asList(BaseUtilities.parseParameters((String)((String)argumentsObject).trim()));
    }
}

