/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gradle.tooling.ProjectConnection;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.modules.gradle.Bundle;
import org.netbeans.modules.gradle.GradleAuxiliaryConfigImpl;
import org.netbeans.modules.gradle.GradleAuxiliaryPropertiesImpl;
import org.netbeans.modules.gradle.GradleProject;
import org.netbeans.modules.gradle.GradleProjectErrorNotifications;
import org.netbeans.modules.gradle.GradleProjectLoader;
import org.netbeans.modules.gradle.ProjectTrust;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleReport;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.loaders.GradleProjectLoaderImpl;
import org.netbeans.modules.gradle.options.GradleExperimentalSettings;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class NbGradleProjectImpl
implements Project {
    static final Logger LOG = Logger.getLogger(NbGradleProjectImpl.class.getName());
    public static final RequestProcessor RELOAD_RP = new RequestProcessor("Gradle project reloading", 1);
    private final RequestProcessor.Task reloadTask = RELOAD_RP.create(new Runnable(){

        @Override
        public void run() {
            NbGradleProjectImpl.this.loadOwnProject(null, false, false, NbGradleProjectImpl.this.aimedQuality, new String[0]);
        }
    });
    private final FileObject projectDir;
    private final ProjectState projectState;
    private final Lookup lookup;
    private final Lookup basicLookup;
    private final Lookup completeLookup;
    private Updater openedProjectUpdater;
    private volatile NbGradleProject.Quality aimedQuality = NbGradleProject.Quality.FALLBACK;
    @NonNull
    private final NbGradleProject watcher;
    @SuppressWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static WatcherAccessor ACCESSOR = null;
    private volatile GradleProject project;
    private NbGradleProject.Quality attemptedQuality;
    private final GradleFiles gradleFiles;
    private final AtomicInteger currentSerial = new AtomicInteger();
    private int loadedProjectSerial;
    private LoadingCF loading;
    final RequestProcessor GRADLE_PRIMING_RP = new RequestProcessor("gradle-project-resolver", 1);
    private CompletableFuture<GradleProject> primingBuild;

    public boolean isGradleProjectLoaded() {
        return this.project != null;
    }

    public NbGradleProjectImpl(FileObject projectDir, ProjectState projectState) {
        this.projectDir = projectDir;
        this.projectState = projectState;
        this.gradleFiles = new GradleFiles(FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)projectDir)), true);
        this.lookup = Lookups.proxy((Lookup.Provider)new Lookup.Provider(){

            public Lookup getLookup() {
                if (NbGradleProjectImpl.this.completeLookup == null) {
                    LOG.log(Level.FINE, "Accessing project's lookup before the instance is fully initialized at " + NbGradleProjectImpl.this.gradleFiles.getBuildScript(), new Exception());
                    assert (NbGradleProjectImpl.this.basicLookup != null);
                    return NbGradleProjectImpl.this.basicLookup;
                }
                return NbGradleProjectImpl.this.completeLookup;
            }
        });
        this.watcher = ACCESSOR.createWatcher(this);
        GradleAuxiliaryConfigImpl aux = new GradleAuxiliaryConfigImpl(projectDir, true);
        this.basicLookup = this.createBasicLookup(projectState, aux);
        this.completeLookup = LookupProviderSupport.createCompositeLookup((Lookup)this.basicLookup, (Lookup)new PluginDependentLookup(this.watcher));
    }

    public GradleFiles getGradleFiles() {
        return this.gradleFiles;
    }

    public FileObject getProjectDirectory() {
        return this.projectDir;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private Lookup createBasicLookup(ProjectState state, GradleAuxiliaryConfigImpl aux) {
        return Lookups.fixed((Object[])new Object[]{this, this.watcher, new CacheDirProvider(), aux, aux.getProblemProvider(), new GradleAuxiliaryPropertiesImpl(this), UILookupMergerSupport.createProjectOpenHookMerger((ProjectOpenedHook)new ProjectOpenedHookImpl()), UILookupMergerSupport.createProjectProblemsProviderMerger(), UILookupMergerSupport.createRecommendedTemplatesMerger(), UILookupMergerSupport.createPrivilegedTemplatesMerger(), LookupProviderSupport.createSourcesMerger(), LookupProviderSupport.createSharabilityQueryMerger(), new GradleProjectLoaderImpl(this), new GradleProjectErrorNotifications(), state});
    }

    public GradleProject getGradleProject() {
        return this.projectWithQuality(null, NbGradleProject.Quality.EVALUATED, false, false);
    }

    public void fireProjectReload(boolean wait) {
        this.reloadTask.schedule(0);
        if (wait) {
            this.reloadTask.waitFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachAllUpdater() {
        NbGradleProjectImpl nbGradleProjectImpl = this;
        synchronized (nbGradleProjectImpl) {
            if (this.openedProjectUpdater == null) {
                this.openedProjectUpdater = new Updater(new FileProvider(){

                    @Override
                    public Set<File> getFiles() {
                        GradleFiles gf = NbGradleProjectImpl.this.getGradleFiles();
                        LinkedHashSet<File> ret = new LinkedHashSet<File>();
                        for (GradleFiles.Kind kind : GradleFiles.Kind.PROJECT_FILES) {
                            File f = gf.getFile(kind);
                            if (f == null) continue;
                            ret.add(f);
                        }
                        return ret;
                    }
                });
            }
        }
        this.openedProjectUpdater.attachAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachAllUpdater() {
        NbGradleProjectImpl nbGradleProjectImpl = this;
        synchronized (nbGradleProjectImpl) {
            if (this.openedProjectUpdater != null) {
                this.openedProjectUpdater.detachAll();
            }
        }
    }

    synchronized void dumpProject() {
        this.loading = null;
        this.project = null;
        this.attemptedQuality = null;
        this.loadedProjectSerial = 0;
        this.aimedQuality = NbGradleProject.Quality.FALLBACK;
    }

    public NbGradleProject.Quality getAimedQuality() {
        return this.aimedQuality;
    }

    public NbGradleProject getProjectWatcher() {
        return this.watcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GradleProject projectWithQuality(String desc, NbGradleProject.Quality aim, boolean interactive, boolean force) {
        NbGradleProjectImpl nbGradleProjectImpl = this;
        synchronized (nbGradleProjectImpl) {
            GradleProject c = this.project;
            if (c != null) {
                if (!force && c.getQuality().atLeast(aim)) {
                    LOG.log(Level.FINER, "Asked for {0}, got {1} already: ", new Object[]{aim, c.getQuality()});
                    return c;
                }
                if (!force && this.attemptedQuality.atLeast(aim)) {
                    LOG.log(Level.FINER, "Attempted quality was {0}, ignoring request to get {1}", new Object[]{this.attemptedQuality, aim});
                    return c;
                }
            }
        }
        try {
            return this.loadOwnProject0(desc, false, interactive, aim, true, force, new String[0]).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<GradleProject> projectWithQualityTask(String desc, NbGradleProject.Quality aim, boolean interactive, boolean force) {
        NbGradleProjectImpl nbGradleProjectImpl = this;
        synchronized (nbGradleProjectImpl) {
            GradleProject c = this.project;
            if (c != null) {
                if (!force && c.getQuality().atLeast(aim)) {
                    return CompletableFuture.completedFuture(c);
                }
                if (!force && this.attemptedQuality.atLeast(aim)) {
                    return CompletableFuture.completedFuture(c);
                }
            }
        }
        CompletableFuture<GradleProject> toRet = new CompletableFuture<GradleProject>();
        RELOAD_RP.post(() -> this.loadOwnProject0(desc, false, interactive, aim, false, force, new String[0]).handle((p, e) -> {
            if (e == null) {
                toRet.complete((GradleProject)p);
            } else {
                toRet.completeExceptionally((Throwable)e);
            }
            return null;
        }));
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAimedQuality(NbGradleProject.Quality aim) {
        NbGradleProjectImpl nbGradleProjectImpl = this;
        synchronized (nbGradleProjectImpl) {
            if (this.aimedQuality == NbGradleProject.Quality.FALLBACK && aim.betterThan(NbGradleProject.Quality.FALLBACK)) {
                ACCESSOR.activate(this.watcher);
            }
            if (aim == NbGradleProject.Quality.FALLBACK && this.aimedQuality.betterThan(NbGradleProject.Quality.FALLBACK)) {
                ACCESSOR.passivate(this.watcher);
            }
            this.aimedQuality = aim;
            if (this.project != null && !this.project.getQuality().worseThan(aim)) {
                return;
            }
        }
        this.loadOwnProject0(null, false, false, this.aimedQuality, true, false, new String[0]);
    }

    CompletableFuture<GradleProject> loadOwnProject(String desc, boolean ignoreCache, boolean interactive, NbGradleProject.Quality aim, String ... args) {
        return this.loadOwnProject0(desc, ignoreCache, interactive, aim, false, true, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<GradleProject> loadOwnProject0(String desc, boolean ignoreCache, boolean interactive, NbGradleProject.Quality aim, boolean sync, boolean force, String ... args) {
        GradleProjectLoader loader = (GradleProjectLoader)this.getLookup().lookup(GradleProjectLoader.class);
        if (loader == null) {
            throw new IllegalStateException("No loader implementation is present!");
        }
        LoadingCF f = new LoadingCF(aim, ignoreCache, interactive, sync, Arrays.asList(args));
        NbGradleProjectImpl nbGradleProjectImpl = this;
        synchronized (nbGradleProjectImpl) {
            if (this.loading != null && this.loading.satisifes(f) && !force) {
                LOG.log(Level.FINER, "Project {2} is already loading to quality {0}, now attempted {1}, returning existing handle", new Object[]{this.loading.aim, aim, this});
                return this.loading;
            }
            this.loading = f;
        }
        int s = this.currentSerial.incrementAndGet();
        LOG.log(Level.FINER, "Starting project {2} load, serial {0}, attempted quality {1}", new Object[]{s, aim, this});
        GradleProject prj = loader.loadProject(aim, desc, ignoreCache, interactive, args);
        NbGradleProjectImpl nbGradleProjectImpl2 = this;
        synchronized (nbGradleProjectImpl2) {
            boolean replace;
            if (this.loadedProjectSerial > s && this.project != null) {
                LOG.log(Level.FINER, "Future finished project load, returing {0} throwing away {1}", new Object[]{this.project, prj});
                return CompletableFuture.completedFuture(this.project);
            }
            this.loadedProjectSerial = s;
            this.attemptedQuality = aim;
            boolean bl = replace = this.project == null || force;
            if (this.project != null) {
                if (prj.getQuality().betterThan(this.project.getQuality())) {
                    replace = true;
                } else if (this.project.getQuality().equals((Object)prj.getQuality()) && !this.project.getProblems().equals(prj.getProblems()) && !prj.getProblems().isEmpty()) {
                    replace = true;
                }
            }
            if (!replace) {
                LOG.log(Level.FINER, "Current project {1} sufficient for attempted quality {0}", new Object[]{this.project, aim});
                return CompletableFuture.completedFuture(this.project);
            }
            LOG.log(Level.FINER, "Replacing {0} with {1}, attempted quality {2}", new Object[]{this.project, prj, this.attemptedQuality});
            this.project = prj;
        }
        if (sync || RELOAD_RP.isRequestProcessorThread()) {
            nbGradleProjectImpl2 = this;
            synchronized (nbGradleProjectImpl2) {
                if (this.loading == f) {
                    this.loading = null;
                }
            }
            LOG.log(Level.FINER, "Firing changes/reload synchronously");
            try {
                f.ownThreadCompletion.set(prj);
                ACCESSOR.doFireReload(this.watcher);
            }
            finally {
                f.ownThreadCompletion.remove();
                f.complete(prj);
            }
            return f;
        }
        LOG.log(Level.FINER, "Firing changes/reload in RP");
        RELOAD_RP.post(() -> this.callAccessorReload(f, prj));
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<GradleProject> callAccessorReload(LoadingCF f, GradleProject prj) {
        try {
            NbGradleProjectImpl nbGradleProjectImpl = this;
            synchronized (nbGradleProjectImpl) {
                if (this.loading == f) {
                    this.loading = null;
                }
            }
            try {
                f.ownThreadCompletion.set(prj);
                ACCESSOR.doFireReload(this.watcher);
            }
            finally {
                f.ownThreadCompletion.remove();
                f.complete(prj);
            }
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Error | RuntimeException ex) {
            f.completeExceptionally(ex);
            throw ex;
        }
        catch (Throwable t) {
            f.completeExceptionally(t);
            LOG.log(Level.WARNING, "Unexpected exception from project listeners", t);
        }
        return f;
    }

    RequestProcessor.Task forceReloadProject(String reloadReason, boolean interactive, NbGradleProject.Quality aim, String ... args) {
        return this.reloadProject(reloadReason, true, interactive, aim, args);
    }

    private RequestProcessor.Task reloadProject(String desc, boolean ignoreCache, boolean interactive, NbGradleProject.Quality aim, String ... args) {
        return RELOAD_RP.post(() -> this.loadOwnProject(desc, ignoreCache, interactive, aim, args));
    }

    public int hashCode() {
        return this.gradleFiles.hashCode() * 3;
    }

    public boolean equals(Object obj) {
        NbGradleProjectImpl impl;
        if (obj instanceof Project && (impl = (NbGradleProjectImpl)((Project)obj).getLookup().lookup(NbGradleProjectImpl.class)) != null) {
            return this.getGradleFiles().equals(impl.getGradleFiles());
        }
        return false;
    }

    public String toString() {
        GradleProject p = this.project;
        if (p != null) {
            return "Gradle: " + p.getBaseProject().getName() + "[" + p.getQuality() + "]";
        }
        return "Unloaded Gradle Project: " + this.gradleFiles.toString();
    }

    boolean isProjectPrimingRequired() {
        return this.getPrimedProject() == null;
    }

    GradleProject getPrimedProject() {
        GradleProject gp = this.projectWithQuality(null, NbGradleProject.Quality.EVALUATED, false, false);
        return gp.getQuality().betterThan(NbGradleProject.Quality.EVALUATED) ? gp : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<GradleProject> primeProject() {
        CompletableFuture<GradleProject> ret;
        NbGradleProjectImpl nbGradleProjectImpl = this;
        synchronized (nbGradleProjectImpl) {
            if (this.primingBuild != null && !this.primingBuild.isDone()) {
                LOG.log(Level.FINER, "Priming build runs for {0}: {1}", new Object[]{this, this.primingBuild});
                return this.primingBuild;
            }
            ret = new CompletableFuture<GradleProject>();
            this.primingBuild = ret;
        }
        LOG.log(Level.FINER, "Submitting priming build runs for {0}: {1}", new Object[]{this, ret});
        this.GRADLE_PRIMING_RP.submit(() -> {
            block3: {
                GradleProject gradleProject = null;
                try {
                    ProjectTrust.getDefault().trustProject(this, true);
                    gradleProject = this.getPrimedProject();
                    if (gradleProject != null) {
                        ret.complete(gradleProject);
                        return;
                    }
                    GradleProject fallback = this.projectWithQuality(null, NbGradleProject.Quality.FALLBACK, false, false);
                    ((CompletableFuture)this.loadOwnProject0(Bundle.ACT_PrimingProject(fallback.getBaseProject().getName()), true, true, NbGradleProject.Quality.FULL_ONLINE, false, true, new String[0]).thenApply(p -> ret.complete((GradleProject)p))).exceptionally(e -> ret.completeExceptionally((Throwable)e));
                    LOG.log(Level.FINER, "Priming finished, reloaded {0}: {1}", gradleProject);
                }
                catch (Throwable t) {
                    LOG.log(Level.FINER, t, () -> String.format("Priming errored for %s", this.project));
                    ret.completeExceptionally(t);
                    if (!(t instanceof ThreadDeath)) break block3;
                    throw t;
                }
            }
        });
        return ret;
    }

    public static File getCacheDir(GradleFiles gf) {
        return NbGradleProjectImpl.getCacheDir(gf.getRootDir(), gf.getProjectDir());
    }

    public static File getCacheDir(GradleProject gp) {
        GradleBaseProject base = gp.getBaseProject();
        return NbGradleProjectImpl.getCacheDir(base.getRootDir(), base.getProjectDir());
    }

    private static File getCacheDir(File rootDir, File projectDir) {
        int code = Math.abs(projectDir.getAbsolutePath().hashCode());
        String dirName = projectDir.getName() + "-" + code;
        File dir = new File(rootDir, ".gradle/nb-cache/" + dirName);
        return dir;
    }

    static {
        Class<NbGradleProject> c = NbGradleProject.class;
        try {
            Class.forName(c.getName(), true, c.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            LOG.log(Level.SEVERE, "very wrong, very wrong, yes indeed", ex);
        }
    }

    public static abstract class WatcherAccessor {
        public abstract NbGradleProject createWatcher(NbGradleProjectImpl var1);

        public abstract void doFireReload(NbGradleProject var1);

        public abstract void activate(NbGradleProject var1);

        public abstract void passivate(NbGradleProject var1);

        public abstract GradleReport createReport(GradleReport.Severity var1, String var2, String var3, int var4, String var5, GradleReport var6, String[] var7);

        public abstract void setProblems(GradleBaseProject var1, Set<GradleReport> var2);
    }

    private static class PluginDependentLookup
    extends ProxyLookup
    implements PropertyChangeListener {
        private static final String NB_ROOT_PLUGIN = "root";
        private final WeakReference<NbGradleProject> watcherRef;
        private Map<String, Lookup> pluginLookups = Collections.emptyMap();
        private List<String> pluginOrder = Collections.emptyList();
        private static final String GRADLE_DEFAULT_LOOKUP = "Projects/org-netbeans-modules-gradle/Lookup";
        private static final String GRADLE_ANY_PLUGIN_LOOKUP = "Projects/org-netbeans-modules-gradle/Plugins/_any/Lookup";
        private static final String GRADLE_PLUGINS_ROOT = "Projects/org-netbeans-modules-gradle/Plugins";

        public PluginDependentLookup(NbGradleProject watcher) {
            this.watcherRef = new WeakReference<NbGradleProject>(watcher);
            this.check();
            watcher.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)watcher));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void check() {
            Map<String, Lookup> prevLookups;
            PluginDependentLookup pluginRoot;
            NbGradleProject watcher = (NbGradleProject)this.watcherRef.get();
            if (watcher == null) {
                return;
            }
            ArrayList<String> orderedPaths = new ArrayList<String>();
            orderedPaths.add(GRADLE_DEFAULT_LOOKUP);
            if (watcher.isGradleProjectLoaded()) {
                GradleBaseProject prj = watcher.projectLookup(GradleBaseProject.class);
                HashSet<String> currentPlugins = new HashSet<String>(prj.getPlugins());
                if (prj.isRoot()) {
                    currentPlugins.add(NB_ROOT_PLUGIN);
                }
                if ((pluginRoot = FileUtil.getConfigFile((String)GRADLE_PLUGINS_ROOT)) != null) {
                    for (FileObject pl : pluginRoot.getChildren()) {
                        if (!currentPlugins.remove(pl.getName())) continue;
                        orderedPaths.add("Projects/org-netbeans-modules-gradle/Plugins/" + pl.getName() + "/Lookup");
                    }
                }
                ArrayList<String> remaining = new ArrayList<String>(currentPlugins);
                Collections.sort(remaining);
                remaining.forEach(r -> orderedPaths.add("Projects/org-netbeans-modules-gradle/Plugins/" + r + "/Lookup"));
            }
            orderedPaths.add(GRADLE_ANY_PLUGIN_LOOKUP);
            pluginRoot = this;
            synchronized (pluginRoot) {
                if (this.pluginOrder.equals(orderedPaths)) {
                    return;
                }
                prevLookups = this.pluginLookups;
            }
            HashMap<String, Lookup> newLookups = new HashMap<String, Lookup>(prevLookups);
            newLookups.keySet().retainAll(orderedPaths);
            Lookup[] lkps = new Lookup[orderedPaths.size()];
            int i = 0;
            for (String s : orderedPaths) {
                Lookup l = (Lookup)newLookups.get(s);
                if (l == null) {
                    l = Lookups.forPath((String)s);
                    newLookups.put(s, l);
                }
                lkps[i++] = l;
            }
            PluginDependentLookup pluginDependentLookup = this;
            synchronized (pluginDependentLookup) {
                if (this.pluginLookups != prevLookups) {
                    return;
                }
                this.pluginLookups = newLookups;
                this.pluginOrder = orderedPaths;
            }
            this.setLookups(lkps);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("ProjectInfo".equals(evt.getPropertyName())) {
                this.check();
            }
        }
    }

    private class CacheDirProvider
    implements CacheDirectoryProvider {
        private CacheDirProvider() {
        }

        public FileObject getCacheDirectory() throws IOException {
            return FileUtil.createFolder((File)NbGradleProjectImpl.getCacheDir(NbGradleProjectImpl.this.gradleFiles));
        }
    }

    private class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        private ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
            Runnable open = () -> {
                NbGradleProjectImpl.this.setAimedQuality(NbGradleProject.Quality.FULL);
                NbGradleProjectImpl.this.attachAllUpdater();
                if (ProjectProblems.isBroken((Project)NbGradleProjectImpl.this)) {
                    ProjectProblems.showAlert((Project)NbGradleProjectImpl.this);
                }
            };
            if (GradleExperimentalSettings.getDefault().isOpenLazy()) {
                RELOAD_RP.post(open, 100);
            } else {
                open.run();
            }
        }

        protected void projectClosed() {
            NbGradleProjectImpl.this.setAimedQuality(NbGradleProject.Quality.FALLBACK);
            NbGradleProjectImpl.this.detachAllUpdater();
            NbGradleProjectImpl.this.dumpProject();
            ((ProjectConnection)NbGradleProjectImpl.this.getLookup().lookup(ProjectConnection.class)).close();
            ((GradleProjectErrorNotifications)NbGradleProjectImpl.this.getLookup().lookup(GradleProjectErrorNotifications.class)).clear();
        }
    }

    private class Updater
    implements FileChangeListener {
        final FileProvider fileProvider;
        Set<File> filesToWatch;
        long lastEventTime = 0L;

        Updater(FileProvider fp) {
            this.fileProvider = fp;
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            if (this.lastEventTime < fe.getTime()) {
                this.lastEventTime = System.currentTimeMillis();
                NbGradleProjectImpl.this.fireProjectReload(false);
            }
        }

        public void fileChanged(FileEvent fe) {
            if (this.lastEventTime < fe.getTime()) {
                this.lastEventTime = System.currentTimeMillis();
                NbGradleProjectImpl.this.fireProjectReload(false);
            }
        }

        public void fileDeleted(FileEvent fe) {
            this.lastEventTime = System.currentTimeMillis();
            NbGradleProjectImpl.this.fireProjectReload(false);
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        synchronized void attachAll() {
            this.filesToWatch = this.fileProvider.getFiles();
            if (this.filesToWatch != null) {
                for (File f : this.filesToWatch) {
                    if (f == null) continue;
                    try {
                        FileUtil.addFileChangeListener((FileChangeListener)this, (File)f);
                    }
                    catch (IllegalArgumentException ex) {
                        assert (false) : "Project opened twice in a row";
                    }
                }
            }
        }

        synchronized void detachAll() {
            if (this.filesToWatch != null) {
                for (File f : this.filesToWatch) {
                    if (f == null) continue;
                    try {
                        FileUtil.removeFileChangeListener((FileChangeListener)this, (File)f);
                    }
                    catch (IllegalArgumentException ex) {
                        assert (false) : "Project closed twice in a row";
                    }
                }
            }
        }
    }

    static interface FileProvider {
        public Set<File> getFiles();
    }

    private static class LoadingCF
    extends CompletableFuture<GradleProject> {
        private final NbGradleProject.Quality aim;
        private final boolean ignoreCache;
        private final boolean interactive;
        private final boolean sync;
        private final List<String> args;
        private ThreadLocal<GradleProject> ownThreadCompletion = new ThreadLocal();

        public LoadingCF(NbGradleProject.Quality aim, boolean ignoreCache, boolean interactive, boolean sync, List<String> args) {
            this.aim = aim;
            this.ignoreCache = ignoreCache;
            this.interactive = interactive;
            this.sync = sync;
            this.args = args;
        }

        public boolean satisifes(LoadingCF other) {
            if (this.aim.worseThan(other.aim)) {
                return false;
            }
            if (this.ignoreCache != other.ignoreCache || this.interactive != other.interactive || this.sync != other.sync) {
                return false;
            }
            return this.args.equals(other.args);
        }

        @Override
        public GradleProject getNow(GradleProject valueIfAbsent) {
            GradleProject p = this.ownThreadCompletion.get();
            return p != null ? p : super.getNow(valueIfAbsent);
        }

        @Override
        public GradleProject join() {
            GradleProject p = this.ownThreadCompletion.get();
            return p != null ? p : (GradleProject)super.join();
        }

        @Override
        public GradleProject get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            GradleProject p = this.ownThreadCompletion.get();
            return p != null ? p : (GradleProject)super.get(timeout, unit);
        }

        @Override
        public GradleProject get() throws InterruptedException, ExecutionException {
            GradleProject p = this.ownThreadCompletion.get();
            return p != null ? p : (GradleProject)super.get();
        }
    }
}

