/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsfapi.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.modules.web.jsfapi.api.LibraryInfo;

public final class NamespaceUtils {
    public static final String JAKARTA_ORG_LOCATION = "jakarta.faces";
    public static final String JCP_ORG_LOCATION = "http://xmlns.jcp.org";
    public static final String SUN_COM_LOCATION = "http://java.sun.com";
    public static final Map<String, String> NS_MAPPING = new HashMap<String, String>(16);
    public static final Map<String, String> JAKARTA_NS_MAPPING;

    @CheckForNull
    public static <T> T getForNs(Map<String, T> map, String ns) {
        if (map.containsKey(ns)) {
            return map.get(ns);
        }
        LibraryInfo libraryInfo = DefaultLibraryInfo.forNamespace(ns);
        if (libraryInfo == null) {
            ns = DefaultLibraryInfo.COMPOSITE.getValidNamespaces().stream().filter(ns::startsWith).findFirst().orElse(null);
            if (ns == null) {
                return null;
            }
            libraryInfo = DefaultLibraryInfo.forNamespace(ns);
        }
        return libraryInfo.getValidNamespaces().stream().map(map::get).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static boolean containsNsOf(Collection<String> collection, DefaultLibraryInfo library) {
        return library.getValidNamespaces().stream().anyMatch(collection::contains);
    }

    static {
        NS_MAPPING.put("http://xmlns.jcp.org/jsf/html", "http://java.sun.com/jsf/html");
        NS_MAPPING.put("http://xmlns.jcp.org/jsf/core", "http://java.sun.com/jsf/core");
        NS_MAPPING.put("http://xmlns.jcp.org/jsp/jstl/core", "http://java.sun.com/jsp/jstl/core");
        NS_MAPPING.put("http://xmlns.jcp.org/jsp/jstl/functions", "http://java.sun.com/jsp/jstl/functions");
        NS_MAPPING.put("http://xmlns.jcp.org/jsf/facelets", "http://java.sun.com/jsf/facelets");
        NS_MAPPING.put("http://xmlns.jcp.org/jsf/composite", "http://java.sun.com/jsf/composite");
        NS_MAPPING.put("http://xmlns.jcp.org/jsf", "http://java.sun.com/jsf");
        NS_MAPPING.put("http://xmlns.jcp.org/jsf/passthrough", "http://java.sun.com/jsf/passthrough");
        JAKARTA_NS_MAPPING = new HashMap<String, String>(16);
        JAKARTA_NS_MAPPING.put("jakarta.faces.html", "http://xmlns.jcp.org/jsf/html");
        JAKARTA_NS_MAPPING.put("jakarta.faces.core", "http://xmlns.jcp.org/jsf/core");
        JAKARTA_NS_MAPPING.put("jakarta.tags.core", "http://xmlns.jcp.org/jsp/jstl/core");
        JAKARTA_NS_MAPPING.put("jakarta.tags.fmt", "http://xmlns.jcp.org/jsp/jstl/fmt");
        JAKARTA_NS_MAPPING.put("jakarta.tags.functions", "http://xmlns.jcp.org/jsp/jstl/functions");
        JAKARTA_NS_MAPPING.put("jakarta.faces.facelets", "http://xmlns.jcp.org/jsf/facelets");
        JAKARTA_NS_MAPPING.put("jakarta.faces.composite", "http://xmlns.jcp.org/jsf/composite");
        JAKARTA_NS_MAPPING.put(JAKARTA_ORG_LOCATION, "http://xmlns.jcp.org/jsf");
        JAKARTA_NS_MAPPING.put("jakarta.faces.passthrough", "http://xmlns.jcp.org/jsf/passthrough");
        JAKARTA_NS_MAPPING.put("jakarta.faces.component", "http://xmlns.jcp.org/jsf/component");
    }
}

