/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.installer.maven.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.installer.ui.SuiteInstallerProjectProperties;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class BuildInstallersAction
extends AbstractAction
implements ContextAwareAction {
    public BuildInstallersAction() {
        this.putValue("Name", NbBundle.getMessage(BuildInstallersAction.class, (String)"CTL_BuildInstallers"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ContextBuildInstaller(actionContext);
    }

    static class ContextBuildInstaller
    extends AbstractAction {
        private final Lookup actionContext;

        public ContextBuildInstaller(Lookup actionContext) {
            this.actionContext = actionContext;
            this.putValue("Name", NbBundle.getMessage(BuildInstallersAction.class, (String)"CTL_BuildInstallers"));
            this.putValue("hideWhenDisabled", true);
            Project project = (Project)actionContext.lookup(Project.class);
            if (project == null) {
                this.setEnabled(false);
            } else {
                NbMavenProject watcher = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
                if (watcher == null || !"nbm-application".equalsIgnoreCase(watcher.getPackagingType())) {
                    this.setEnabled(false);
                } else {
                    String version = PluginPropertyUtils.getPluginVersion((MavenProject)watcher.getMavenProject(), (String)"org.codehaus.mojo", (String)"nbm-maven-plugin");
                    if (version == null || new ComparableVersion(version).compareTo(new ComparableVersion("3.7-SNAPSHOT")) >= 0) {
                        this.setEnabled(false);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Project project = (Project)this.actionContext.lookup(Project.class);
            NbMavenProject watcher = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            if (watcher != null && "nbm-application".equalsIgnoreCase(watcher.getPackagingType())) {
                File suiteLocation = FileUtil.toFile((FileObject)project.getProjectDirectory());
                String zipName = watcher.getMavenProject().getArtifactId() + "-" + watcher.getMavenProject().getVersion() + ".zip";
                File zipFile = new File(suiteLocation, "target/" + zipName);
                Logger.getLogger(BuildInstallersAction.class.getName()).log(Level.WARNING, "Running Build Installers action for (existing={1}) zip file {0}", new Object[]{zipFile, zipFile.exists()});
                Preferences prefs = SuiteInstallerProjectProperties.prefs((Project)project);
                String appName = watcher.getMavenProject().getParent().getArtifactId();
                File appIconIcnsFile = null;
                String licenseType = prefs.get("license-type", null);
                File licenseFile = null;
                String licenseFileProp = prefs.get("license-file", null);
                if (licenseFileProp != null) {
                    licenseFile = PropertyUtils.resolveFile((File)suiteLocation, (String)licenseFileProp);
                }
                appIconIcnsFile = new File(InstalledFileLocator.getDefault().locate("etc/applicationIcon.icns", "org.netbeans.modules.apisupport.harness", false).getAbsolutePath().replace("\\", "/"));
                if (licenseFile == null && licenseType != null && !licenseType.equals("no")) {
                    Logger.getLogger(BuildInstallersAction.class.getName()).log(Level.FINE, "License type defined to {0}", licenseType);
                    String licenseResource = null;
                    try {
                        licenseResource = NbBundle.getMessage(SuiteInstallerProjectProperties.class, (String)("SuiteInstallerProjectProperties.license.file." + licenseType));
                    }
                    catch (MissingResourceException ex) {
                        Logger.getLogger(BuildInstallersAction.class.getName()).log(Level.WARNING, "License resource not found");
                    }
                    if (licenseResource != null) {
                        InputStream is = null;
                        try {
                            URL url = new URL(licenseResource);
                            is = url.openStream();
                            if (is != null) {
                                licenseFile = Files.createTempFile("license", ".txt", new FileAttribute[0]).toFile();
                                licenseFile.getParentFile().mkdirs();
                                licenseFile.deleteOnExit();
                                FileOutputStream os = new FileOutputStream(licenseFile);
                                byte[] byArray = new byte[4096];
                                int read = 0;
                                while ((read = is.read(byArray)) > 0) {
                                    ((OutputStream)os).write(byArray, 0, read);
                                }
                                os.flush();
                                ((OutputStream)os).close();
                            } else {
                                Logger.getLogger(BuildInstallersAction.class.getName()).log(Level.WARNING, "License resource {0} not found", licenseResource);
                            }
                        }
                        catch (MalformedURLException ex) {
                            Logger.getLogger(BuildInstallersAction.class.getName()).log(Level.WARNING, "Can`t parse URL", ex);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(BuildInstallersAction.class.getName()).log(Level.WARNING, "Input/Output error", ex);
                        }
                        finally {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException ex) {}
                            }
                        }
                    }
                }
                Properties props = new Properties();
                File parentProjectDir = watcher.getMavenProject().getParent().getBasedir();
                props.put("suite.location", parentProjectDir.getAbsolutePath().replace("\\", "/"));
                props.put("suite.dist.zip", zipFile.getAbsolutePath().replace("\\", "/"));
                props.put("suite.dist.directory", new File(suiteLocation, "target").getAbsolutePath().replace("\\", "/"));
                props.put("installer.build.dir", new File(suiteLocation, "target/installerbuild").getAbsolutePath().replace("\\", "/"));
                props.put("installers.file.prefix", watcher.getMavenProject().getArtifactId() + "-" + watcher.getMavenProject().getVersion());
                props.put("suite.nbi.product.uid", appName.replaceAll("[0-9]+", "").replace("_", "-").toLowerCase(Locale.ENGLISH));
                props.put("nbi.stub.location", InstalledFileLocator.getDefault().locate("nbi/stub", "org.netbeans.libs.nbi.ant", false).getAbsolutePath().replace("\\", "/"));
                props.put("nbi.stub.common.location", InstalledFileLocator.getDefault().locate("nbi/.common", "org.netbeans.libs.nbi.ant", false).getAbsolutePath().replace("\\", "/"));
                props.put("nbi.ant.tasks.jar", InstalledFileLocator.getDefault().locate("modules/ext/nbi-ant-tasks.jar", "org.netbeans.libs.nbi.ant", false).getAbsolutePath().replace("\\", "/"));
                props.put("nbi.registries.management.jar", InstalledFileLocator.getDefault().locate("modules/ext/nbi-registries-management.jar", "org.netbeans.libs.nbi.ant", false).getAbsolutePath().replace("\\", "/"));
                props.put("nbi.engine.jar", InstalledFileLocator.getDefault().locate("modules/ext/nbi-engine.jar", "org.netbeans.libs.nbi.engine", false).getAbsolutePath().replace("\\", "/"));
                if (licenseFile != null) {
                    Logger.getLogger(BuildInstallersAction.class.getName()).log(Level.FINE, "License file is at {0}, exist = {1}", new Object[]{licenseFile, licenseFile.exists()});
                    props.put("nbi.license.file", licenseFile.getAbsolutePath());
                }
                ArrayList<String> platforms = new ArrayList<String>();
                boolean installerConfDefined = false;
                for (String k : new String[]{"os-windows", "os-linux", "os-solaris", "os-macosx"}) {
                    if (!prefs.getBoolean(k, false)) continue;
                    installerConfDefined = true;
                    platforms.add(k.replaceFirst("^os-", ""));
                }
                if (!installerConfDefined) {
                    if (Utilities.isWindows()) {
                        platforms.add("windows");
                    } else if (Utilities.getOperatingSystem() == 16) {
                        platforms.add("linux");
                    } else if (Utilities.getOperatingSystem() == 8) {
                        platforms.add("solaris");
                    } else if (Utilities.isMac()) {
                        platforms.add("macosx");
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < platforms.size(); ++i) {
                    if (i != 0) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append((String)platforms.get(i));
                }
                if (stringBuilder.length() == 0) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            DialogDescriptor d = new DialogDescriptor((Object)NbBundle.getMessage(BuildInstallersAction.class, (String)"BuildInstallersAction.NotConfigured.Warning.Message"), NbBundle.getMessage(BuildInstallersAction.class, (String)"BuildInstallersAction.NotConfigured.Warning.Title"));
                            d.setModal(true);
                            JButton accept = new JButton(NbBundle.getMessage(BuildInstallersAction.class, (String)"BuildInstallersAction.NotConfigured.Warning.OK"));
                            accept.setDefaultCapable(true);
                            d.setOptions(new Object[]{accept});
                            d.setMessageType(2);
                            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d).equals(accept)) {
                                // empty if block
                            }
                        }
                    });
                    return;
                }
                props.put("generate.installer.for.platforms", stringBuilder.toString());
                File javaHome = new File(System.getProperty("java.home"));
                if (new File(javaHome, "lib/rt.jar").exists() && javaHome.getName().equals("jre")) {
                    javaHome = javaHome.getParentFile();
                }
                props.put("generator-jdk-location-forward-slashes", javaHome.getAbsolutePath().replace("\\", "/"));
                if (appIconIcnsFile != null) {
                    props.put("nbi.dock.icon.file", appIconIcnsFile.getAbsolutePath());
                }
                try {
                    ActionUtils.runTarget((FileObject)ContextBuildInstaller.findGenXml(), (String[])new String[]{"build"}, (Properties)props);
                }
                catch (FileStateInvalidException ex) {
                    ErrorManager.getDefault().getInstance("org.netbeans.modules.apisupport.project").notify((Throwable)ex);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().getInstance("org.netbeans.modules.apisupport.project").notify((Throwable)ex);
                }
            }
        }

        private static FileObject findGenXml() {
            return FileUtil.toFileObject((File)InstalledFileLocator.getDefault().locate("nbi/stub/template.xml", "org.netbeans.libs.nbi.ant", false));
        }
    }
}

