/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.status;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.status.VersioningPanel;
import org.netbeans.modules.subversion.util.Context;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class SvnVersioningTopComponent
extends TopComponent
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private VersioningPanel syncPanel;
    private Context context;
    private String contentTitle;
    private String branchTitle;
    private long lastUpdateTimestamp;
    private static SvnVersioningTopComponent instance;

    public SvnVersioningTopComponent() {
        this.putClientProperty("SlidingName", NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.setName(NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/subversion/resources/icons/versioning-view.png"));
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.syncPanel = new VersioningPanel(this);
        this.add(this.syncPanel);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    protected void componentActivated() {
        this.updateTitle();
        this.syncPanel.focus(true);
    }

    protected void componentDeactivated() {
        this.syncPanel.focus(false);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.context);
        out.writeObject(this.contentTitle);
        out.writeLong(this.lastUpdateTimestamp);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.context = (Context)in.readObject();
        this.contentTitle = (String)in.readObject();
        this.lastUpdateTimestamp = in.readLong();
        this.syncPanel.deserialize();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.refreshContent();
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    private void refreshContent() {
        if (this.syncPanel == null) {
            return;
        }
        this.updateTitle();
        this.syncPanel.setContext(this.context);
    }

    public void setContentTitle(String contentTitle) {
        this.contentTitle = contentTitle;
        this.updateTitle();
    }

    void setBranchTitle(String branchTitle) {
        this.branchTitle = branchTitle;
        this.updateTitle();
    }

    public void contentRefreshed() {
        this.lastUpdateTimestamp = System.currentTimeMillis();
        this.updateTitle();
    }

    private void updateTitle() {
        final String age = this.computeAge(System.currentTimeMillis() - this.lastUpdateTimestamp);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SvnVersioningTopComponent.this.contentTitle == null) {
                    SvnVersioningTopComponent.this.setName(NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
                } else if (SvnVersioningTopComponent.this.branchTitle == null) {
                    SvnVersioningTopComponent.this.setName(NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_MultiTitle", (Object)SvnVersioningTopComponent.this.contentTitle, (Object)age));
                } else {
                    SvnVersioningTopComponent.this.setName(NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title_ContentBranch", (Object)SvnVersioningTopComponent.this.contentTitle, (Object)SvnVersioningTopComponent.this.branchTitle, (Object)age));
                }
            }
        });
    }

    String getContentTitle() {
        return this.contentTitle;
    }

    private String computeAge(long l) {
        if (this.lastUpdateTimestamp == 0L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeUnknown");
        }
        if (l < 1000L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeCurrent");
        }
        if (l < 2000L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeOneSecond");
        }
        if (l < 60000L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeSeconds", (Object)Long.toString(l / 1000L));
        }
        if (l < 120000L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeOneMinute");
        }
        if (l < 3600000L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeMinutes", (Object)Long.toString(l / 60000L));
        }
        if (l < 0x6DDD00L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeOneHour");
        }
        if (l < 86400000L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeHours", (Object)Long.toString(l / 3600000L));
        }
        if (l < 172800000L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeOneDay");
        }
        return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeDays", (Object)Long.toString(l / 86400000L));
    }

    public static synchronized SvnVersioningTopComponent getInstance() {
        if (instance == null && (instance = (SvnVersioningTopComponent)WindowManager.getDefault().findTopComponent("svnversioning")) == null) {
            Subversion.LOG.log(Level.INFO, null, new IllegalStateException("Can not find Versioning component"));
            instance = new SvnVersioningTopComponent();
        }
        return instance;
    }

    public Object readResolve() {
        return SvnVersioningTopComponent.getInstance();
    }

    public void performRefreshAction() {
        this.syncPanel.performRefreshAction();
    }

    public void setContext(Context ctx) {
        this.syncPanel.cancelRefresh();
        if (ctx == null) {
            this.setName(NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"MSG_Preparing"));
            this.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setEnabled(true);
            this.setCursor(Cursor.getDefaultCursor());
            this.context = ctx;
            this.setBranchTitle(null);
            this.refreshContent();
        }
        this.setToolTipText(this.getContextFilesList(ctx, NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title")));
    }

    private String getContextFilesList(Context ctx, String def) {
        if (ctx == null || ctx.getRootFiles().length == 0) {
            return def;
        }
        StringBuffer sb = new StringBuffer(200);
        sb.append("<html>");
        for (File file : ctx.getRootFiles()) {
            sb.append(file.getAbsolutePath());
            sb.append("<br>");
        }
        sb.delete(sb.length() - 4, Integer.MAX_VALUE);
        return sb.toString();
    }

    public boolean hasContext() {
        return this.context != null && this.context.getRootFiles().length > 0;
    }

    protected String preferredID() {
        return "synchronize";
    }

    public int getPersistenceType() {
        return 0;
    }
}

