/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.steps;

import com.oracle.bmc.identity.model.Tenancy;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.assets.AbstractStep;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.items.TenancyItem;
import org.netbeans.modules.cloud.oracle.steps.Bundle;
import org.openide.NotifyDescriptor;

public final class TenancyStep
extends AbstractStep<TenancyItem> {
    private List<OCIProfile> profiles = new LinkedList<OCIProfile>();
    private final AtomicReference<TenancyItem> selected = new AtomicReference();

    @Override
    public NotifyDescriptor createInput() {
        if (this.onlyOneChoice()) {
            throw new IllegalStateException("No data to create input");
        }
        String title = Bundle.SelectProfile();
        ArrayList<NotifyDescriptor.QuickPick.Item> items = new ArrayList<NotifyDescriptor.QuickPick.Item>(this.profiles.size());
        for (OCIProfile p2 : this.profiles) {
            Tenancy t = p2.getTenancyData();
            if (t == null) continue;
            items.add(new NotifyDescriptor.QuickPick.Item(p2.getId(), Bundle.SelectProfile_Description(t.getName(), t.getHomeRegionKey())));
        }
        if (this.profiles.stream().filter(p -> p.getTenancy().isPresent()).count() == 0L) {
            title = Bundle.NoProfile();
        }
        return new NotifyDescriptor.QuickPick(title, title, items, false);
    }

    @Override
    public void prepare(ProgressHandle h, Steps.Values values) {
        h.progress(Bundle.CollectingProfiles_Text());
        this.profiles = OCIManager.getDefault().getConnectedProfiles();
    }

    @Override
    public void setValue(String value) {
        for (OCIProfile profile : this.profiles) {
            if (!profile.getId().equals(value)) continue;
            profile.getTenancy().ifPresent(t -> this.selected.set((TenancyItem)t));
            break;
        }
    }

    @Override
    public TenancyItem getValue() {
        if (this.onlyOneChoice()) {
            return this.profiles.stream().map(p -> p.getTenancy()).filter(Optional::isPresent).map(Optional::get).findFirst().get();
        }
        return this.selected.get();
    }

    @Override
    public boolean onlyOneChoice() {
        return this.profiles.stream().filter(p -> p.getTenancy().isPresent()).count() == 1L;
    }
}

