/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.netbeans.modules.cloud.oracle.assets.Bundle;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class SetReferenceNameAction
implements ActionListener {
    private final OCIItem context;

    public SetReferenceNameAction(OCIItem context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String oldRefName = CloudAssets.getDefault().getReferenceName(this.context);
        if (oldRefName == null) {
            oldRefName = "";
        }
        NotifyDescriptor.InputLine inp = new NotifyDescriptor.InputLine(oldRefName, Bundle.ReferenceName());
        Object selected = DialogDisplayer.getDefault().notify((NotifyDescriptor)inp);
        if (DialogDescriptor.OK_OPTION != selected) {
            return;
        }
        String refName = inp.getInputText();
        if (refName.matches("[a-zA-Z0-9]+")) {
            if (!CloudAssets.getDefault().setReferenceName(this.context, refName)) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.ReferenceNameSame());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
        } else {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.ReferenceNameValidationError());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        }
    }
}

