/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import com.oracle.bmc.identity.Identity;
import com.oracle.bmc.identity.IdentityClient;
import com.oracle.bmc.identity.model.Compartment;
import com.oracle.bmc.identity.model.Tenancy;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import com.oracle.bmc.model.BmcException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.OCISessionInitiator;
import org.netbeans.modules.cloud.oracle.actions.AbstractPasswordPanel;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.netbeans.modules.cloud.oracle.actions.DownloadWalletAction;
import org.netbeans.modules.cloud.oracle.actions.DownloadWalletDialog;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.database.DatabaseNode;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.items.TenancyItem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public class AddADBAction
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(AddADBAction.class.getName());
    private static final String DB = "db";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final int NUMBER_OF_INPUTS = 4;
    private static final RequestProcessor RP = new RequestProcessor(AddADBAction.class);

    @Override
    public void actionPerformed(ActionEvent e) {
        this.addADB();
    }

    public CompletableFuture<DatabaseItem> addADB() {
        final HashMap result = new HashMap();
        CompletableFuture<DatabaseItem> future = new CompletableFuture<DatabaseItem>();
        NotifyDescriptor.ComposedInput ci = new NotifyDescriptor.ComposedInput(Bundle.AddADB(), 4, new NotifyDescriptor.ComposedInput.Callback(){
            Map<Integer, Map> values = new HashMap<Integer, Map>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public NotifyDescriptor createInput(NotifyDescriptor.ComposedInput input, int number) {
                if (number == 1) {
                    String title;
                    ProgressHandle h = ProgressHandle.createHandle((String)Bundle.MSG_CollectingProfiles());
                    h.start();
                    h.progress(Bundle.MSG_CollectingProfiles_Text());
                    LinkedHashMap<OCIProfile, Tenancy> profiles = new LinkedHashMap<OCIProfile, Tenancy>();
                    LinkedHashMap<String, TenancyItem> tenancyItems = new LinkedHashMap<String, TenancyItem>();
                    try {
                        for (OCIProfile p : OCIManager.getDefault().getConnectedProfiles()) {
                            TenancyItem t = p.getTenancy().orElse(null);
                            if (t == null) continue;
                            Tenancy data = p.getTenancyData();
                            profiles.put(p, data);
                            tenancyItems.put(p.getId(), t);
                        }
                    }
                    finally {
                        h.finish();
                    }
                    if (profiles.size() == 1) {
                        h = ProgressHandle.createHandle((String)Bundle.MSG_CollectingItems());
                        h.start();
                        h.progress(Bundle.MSG_CollectingItems_Text());
                        try {
                            OCIProfile p;
                            this.values.put(1, AddADBAction.this.getFlatCompartment(((OCIProfile)profiles.keySet().iterator().next()).getTenancy().get()));
                            title = Bundle.SelectCompartment();
                            p = AddADBAction.this.createQuickPick(this.values.get(1), title);
                            return p;
                        }
                        finally {
                            h.finish();
                        }
                    }
                    title = Bundle.SelectProfile();
                    ArrayList<NotifyDescriptor.QuickPick.Item> items = new ArrayList<NotifyDescriptor.QuickPick.Item>(profiles.size());
                    for (OCIProfile p : profiles.keySet()) {
                        Tenancy t = (Tenancy)((Object)profiles.get(p));
                        items.add(new NotifyDescriptor.QuickPick.Item(p.getId(), Bundle.SelectProfile_Description(t.getName(), t.getHomeRegionKey())));
                    }
                    this.values.put(1, tenancyItems);
                    input.setEstimatedNumberOfInputs(5);
                    return new NotifyDescriptor.QuickPick(title, title, items, false);
                }
                NotifyDescriptor prev = input.getInputs()[number - 2];
                OCIItem prevItem = null;
                if (prev instanceof NotifyDescriptor.QuickPick) {
                    for (NotifyDescriptor.QuickPick.Item item : ((NotifyDescriptor.QuickPick)prev).getItems()) {
                        if (!item.isSelected()) continue;
                        prevItem = (OCIItem)this.values.get(number - 1).get(item.getLabel());
                        break;
                    }
                    if (prevItem == null) {
                        return null;
                    }
                    if (prevItem instanceof DatabaseItem) {
                        result.put(AddADBAction.DB, prevItem);
                        return new NotifyDescriptor.InputLine(Bundle.EnterUsername(), Bundle.EnterUsername());
                    }
                    ProgressHandle h = ProgressHandle.createHandle((String)Bundle.MSG_CollectingItems());
                    h.start();
                    h.progress(Bundle.MSG_CollectingItems_Text());
                    try {
                        String title;
                        if (prevItem instanceof TenancyItem) {
                            this.values.put(number, AddADBAction.this.getFlatCompartment((TenancyItem)prevItem));
                            title = Bundle.SelectCompartment();
                        } else {
                            Map<String, OCIItem> dbs = AddADBAction.this.getDbs(prevItem);
                            this.values.put(number, dbs);
                            title = dbs.isEmpty() ? Bundle.NoDatabase() : Bundle.SelectDatabase();
                        }
                        NotifyDescriptor.QuickPick quickPick = AddADBAction.this.createQuickPick(this.values.get(number), title);
                        return quickPick;
                    }
                    finally {
                        h.finish();
                    }
                }
                if (prev instanceof NotifyDescriptor.PasswordLine) {
                    result.put(AddADBAction.PASSWORD, ((NotifyDescriptor.PasswordLine)prev).getInputText());
                    return null;
                }
                if (prev instanceof NotifyDescriptor.InputLine) {
                    String username = ((NotifyDescriptor.InputLine)prev).getInputText();
                    if (username == null || username.trim().isEmpty()) {
                        return prev;
                    }
                    result.put(AddADBAction.USERNAME, username);
                    return new NotifyDescriptor.PasswordLine(Bundle.EnterPassword(), Bundle.EnterPassword());
                }
                return null;
            }
        });
        DialogDisplayer.getDefault().notifyFuture((NotifyDescriptor)ci).handle((r, exception) -> {
            if (exception == null) {
                try {
                    DatabaseItem selectedDatabase = (DatabaseItem)result.get(DB);
                    DownloadWalletAction action = new DownloadWalletAction(selectedDatabase);
                    DownloadWalletDialog.WalletInfo info = new DownloadWalletDialog.WalletInfo(DownloadWalletDialog.getWalletsDir().getAbsolutePath(), AbstractPasswordPanel.generatePassword(), (String)result.get(USERNAME), ((String)result.get(PASSWORD)).toCharArray(), selectedDatabase);
                    action.addConnection(info);
                    future.complete(selectedDatabase);
                }
                catch (IOException ex) {
                    future.completeExceptionally((Throwable)exception);
                }
            } else {
                future.completeExceptionally((Throwable)exception);
            }
            return null;
        });
        return future;
    }

    private <T extends OCIItem> NotifyDescriptor.QuickPick createQuickPick(Map<String, T> ociItems, String title) {
        List items = ociItems.entrySet().stream().map(entry -> new NotifyDescriptor.QuickPick.Item((String)entry.getKey(), ((OCIItem)entry.getValue()).getDescription())).collect(Collectors.toList());
        return new NotifyDescriptor.QuickPick(title, title, items, false);
    }

    private Map<String, OCIItem> getFlatCompartment(TenancyItem tenancy) {
        ListCompartmentsResponse response;
        final HashMap<OCID, FlatCompartmentItem> compartments = new HashMap<OCID, FlatCompartmentItem>();
        OCISessionInitiator session = OCIManager.getDefault().getActiveSession();
        Identity identityClient = session.newClient(IdentityClient.class);
        String nextPageToken = null;
        do {
            response = identityClient.listCompartments(ListCompartmentsRequest.builder().compartmentId(tenancy.getKey().getValue()).compartmentIdInSubtree(true).lifecycleState(Compartment.LifecycleState.Active).accessLevel(ListCompartmentsRequest.AccessLevel.Accessible).limit(1000).page(nextPageToken).build());
            for (Compartment comp : response.getItems()) {
                FlatCompartmentItem ci = new FlatCompartmentItem(comp){

                    @Override
                    FlatCompartmentItem getItem(OCID compId) {
                        return (FlatCompartmentItem)compartments.get(compId);
                    }
                };
                compartments.put(ci.getKey(), ci);
            }
        } while ((nextPageToken = response.getOpcNextPage()) != null);
        Map<String, OCIItem> pickItems = this.computeFlatNames(compartments);
        pickItems.put(tenancy.getName() + " (root)", tenancy);
        return pickItems;
    }

    private Map<String, OCIItem> computeFlatNames(Map<OCID, FlatCompartmentItem> compartments) {
        TreeMap<String, OCIItem> pickItems = new TreeMap<String, OCIItem>(String.CASE_INSENSITIVE_ORDER);
        for (FlatCompartmentItem comp : compartments.values()) {
            pickItems.put(comp.getName(), comp);
        }
        return pickItems;
    }

    private Map<String, OCIItem> getDbs(OCIItem parent) {
        HashMap<String, OCIItem> items = new HashMap<String, OCIItem>();
        try {
            if (parent instanceof CompartmentItem) {
                DatabaseNode.getDatabases().apply((CompartmentItem)parent).forEach(db -> items.put(db.getName(), (OCIItem)db));
            }
        }
        catch (BmcException e) {
            LOGGER.log(Level.SEVERE, "Unable to load compartment list", e);
        }
        return items;
    }

    private abstract class FlatCompartmentItem
    extends CompartmentItem {
        private final OCID parentId;
        private String flatName;

        private FlatCompartmentItem(Compartment ociComp) {
            super(OCID.of(ociComp.getId(), "Compartment"), ociComp.getCompartmentId(), ociComp.getName());
            this.setDescription(ociComp.getDescription());
            this.parentId = OCID.of(ociComp.getCompartmentId(), "Compartment");
        }

        @Override
        public String getName() {
            if (this.parentId.getValue() == null) {
                return "";
            }
            if (this.flatName == null) {
                String parentFlatName = "";
                FlatCompartmentItem parentComp = this.getItem(this.parentId);
                if (parentComp != null) {
                    parentFlatName = parentComp.getName();
                }
                this.flatName = super.getName();
                if (!parentFlatName.isEmpty()) {
                    this.flatName = parentFlatName + "/" + this.flatName;
                }
            }
            return this.flatName;
        }

        abstract FlatCompartmentItem getItem(OCID var1);
    }
}

