/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.refactoring.FormRefactoringUpdate;
import org.netbeans.modules.form.refactoring.RefactoringInfo;
import org.netbeans.modules.nbform.FormEditorSupport;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandler;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandlerFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;

public class GuardedBlockHandlerFactoryImpl
implements GuardedBlockHandlerFactory {
    public GuardedBlockHandler createInstance(AbstractRefactoring refactoring) {
        RefactoringInfo refInfo = (RefactoringInfo)refactoring.getContext().lookup(RefactoringInfo.class);
        return new GuardedBlockHandlerImpl(refInfo);
    }

    private static class GuardedBlockHandlerImpl
    implements GuardedBlockHandler {
        private RefactoringInfo refInfo;
        private Map<FileObject, GuardedBlockUpdate> guardedUpdates;
        private boolean first = true;

        public GuardedBlockHandlerImpl(RefactoringInfo refInfo) {
            this.refInfo = refInfo;
        }

        public Problem handleChange(RefactoringElementImplementation proposedChange, Collection<RefactoringElementImplementation> replacements, Collection<Transaction> transactions) {
            ModificationResult.Difference diff;
            if (this.refInfo == null) {
                return null;
            }
            FileObject changedFile = proposedChange.getParentFile();
            if (!RefactoringInfo.isJavaFileOfForm(changedFile)) {
                return null;
            }
            FormRefactoringUpdate update = this.refInfo.getUpdateForFile(changedFile);
            update.setGaurdedCodeChanging(true);
            boolean preloadForm = false;
            boolean canRegenerate = false;
            if (this.refInfo.containsOriginalFile(changedFile)) {
                switch (this.refInfo.getChangeType()) {
                    case VARIABLE_RENAME: 
                    case CLASS_RENAME: 
                    case EVENT_HANDLER_RENAME: {
                        preloadForm = true;
                        canRegenerate = true;
                        break;
                    }
                    case CLASS_MOVE: {
                        if (this.refInfo.getOriginalFiles().length != 1) break;
                        canRegenerate = true;
                    }
                }
            } else if (this.first) {
                replacements.add(update.getPreviewElement());
                this.first = false;
            }
            if (preloadForm && !update.prepareForm(true)) {
                return new Problem(true, "Error loading form. Cannot update generated code.");
            }
            if (!canRegenerate && (diff = (ModificationResult.Difference)proposedChange.getLookup().lookup(ModificationResult.Difference.class)) != null) {
                GuardedBlockUpdate gbUpdate;
                if (this.guardedUpdates == null) {
                    this.guardedUpdates = new HashMap<FileObject, GuardedBlockUpdate>();
                    gbUpdate = null;
                } else {
                    gbUpdate = this.guardedUpdates.get(changedFile);
                }
                if (gbUpdate == null) {
                    FormDataObject formDataObject = update.getFormDataObject();
                    FormEditorSupport fes = (FormEditorSupport)formDataObject.getFormEditorSupport();
                    gbUpdate = new GuardedBlockUpdate(fes);
                    this.guardedUpdates.put(changedFile, gbUpdate);
                }
                gbUpdate.addChange(diff);
                transactions.add(gbUpdate);
            }
            transactions.add(update);
            return null;
        }
    }

    private static class GuardedBlockInfo {
        private String blockName;
        private int originalPosition;
        private String originalText;
        private Set<ChangeInfo> changes = new TreeSet<ChangeInfo>();

        GuardedBlockInfo(SimpleSection section) {
            this.blockName = section.getName();
            this.originalPosition = section.getStartPosition().getOffset();
            this.originalText = section.getText();
        }

        boolean containsPosition(ModificationResult.Difference diff) {
            int pos = diff.getStartPosition().getOffset();
            return pos >= this.originalPosition && pos < this.originalPosition + this.originalText.length();
        }

        void addChange(ModificationResult.Difference diff) {
            this.changes.add(new ChangeInfo(diff.getStartPosition().getOffset() - this.originalPosition, diff.getOldText() != null ? diff.getOldText().length() : 0, diff.getNewText()));
        }

        String getName() {
            return this.blockName;
        }

        String getNewSectionText() {
            if (this.changes.size() > 0) {
                StringBuilder buf = new StringBuilder();
                int lastOrigPos = 0;
                for (ChangeInfo change : this.changes) {
                    buf.append(this.originalText.substring(lastOrigPos, change.startPos));
                    if (change.newText != null) {
                        buf.append(change.newText);
                    }
                    lastOrigPos = change.startPos + change.length;
                }
                buf.append(this.originalText.substring(lastOrigPos));
                return buf.toString();
            }
            return null;
        }

        private static class ChangeInfo
        implements Comparable<ChangeInfo> {
            private int startPos;
            private int length;
            private String newText;

            ChangeInfo(int startPos, int len, String newText) {
                this.startPos = startPos;
                this.length = len;
                this.newText = newText;
            }

            @Override
            public int compareTo(ChangeInfo ch) {
                return this.startPos - ch.startPos;
            }
        }
    }

    private static class GuardedBlockUpdate
    implements Transaction {
        private FormEditorSupport formEditorSupport;
        private List<GuardedBlockInfo> guardedInfos;

        GuardedBlockUpdate(FormEditorSupport fes) {
            this.formEditorSupport = fes;
            this.guardedInfos = new ArrayList<GuardedBlockInfo>(2);
            this.guardedInfos.add(new GuardedBlockInfo(fes.getInitComponentSection()));
            this.guardedInfos.add(new GuardedBlockInfo(fes.getVariablesSection()));
        }

        void addChange(ModificationResult.Difference diff) {
            for (GuardedBlockInfo block : this.guardedInfos) {
                if (!block.containsPosition(diff)) continue;
                block.addChange(diff);
                break;
            }
        }

        public void commit() {
            for (GuardedBlockInfo block : this.guardedInfos) {
                String newText = block.getNewSectionText();
                if (newText == null) continue;
                this.formEditorSupport.getGuardedSectionManager().findSimpleSection(block.getName()).setText(newText);
            }
        }

        public void rollback() {
        }
    }
}

