/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.samples.wizard.iterator;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.web.clientproject.api.network.NetworkException;
import org.netbeans.modules.web.clientproject.api.network.NetworkSupport;
import org.netbeans.modules.web.clientproject.api.sites.SiteHelper;
import org.netbeans.modules.web.clientproject.createprojectapi.CreateProjectProperties;
import org.openide.filesystems.FileObject;

public class OnlineSiteTemplate {
    private static final Logger LOGGER = Logger.getLogger(OnlineSiteTemplate.class.getName());
    private final String name;
    private final String url;
    private final File libFile;

    public OnlineSiteTemplate(String name, String url, String zipName) {
        this.name = name;
        this.url = url;
        this.libFile = new File(SiteHelper.getJsLibsDirectory(), zipName);
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrepared() {
        return this.libFile.isFile();
    }

    public void prepare() throws NetworkException, IOException, InterruptedException {
        assert (!EventQueue.isDispatchThread());
        assert (!this.isPrepared());
        NetworkSupport.download((String)this.url, (File)this.libFile);
    }

    public void configure(CreateProjectProperties projectProperties) {
        projectProperties.setSiteRootFolder("public_html").setTestFolder("test").setStartFile("index.html");
    }

    public final void apply(FileObject projectDir, CreateProjectProperties projectProperties, ProgressHandle handle) throws IOException {
        assert (!EventQueue.isDispatchThread());
        if (!this.isPrepared()) {
            LOGGER.info("Template not correctly prepared, nothing to be applied");
            return;
        }
        SiteHelper.unzipProjectTemplate((FileObject)this.getTargetDir(projectDir, projectProperties), (File)this.libFile, (ProgressHandle)handle, (String[])new String[0]);
    }

    protected FileObject getTargetDir(FileObject projectDir, CreateProjectProperties projectProperties) {
        return projectDir.getFileObject(projectProperties.getSiteRootFolder());
    }
}

