/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.ClassLinesCustomizer;
import org.netbeans.modules.php.editor.verification.CustomisableRule;
import org.netbeans.modules.php.editor.verification.FunctionLinesCustomizer;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.InterfaceLinesCustomizer;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.TraitLinesCustomizer;
import org.openide.filesystems.FileObject;

public abstract class TooManyLinesHint
extends HintRule
implements CustomisableRule {
    @Override
    public void invoke(PHPRuleContext context, List<Hint> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = this.createVisitor(fileObject, context.doc);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            result.addAll(checkVisitor.getHints());
        }
    }

    abstract CheckVisitor createVisitor(FileObject var1, BaseDocument var2);

    private static abstract class CheckVisitor
    extends DefaultVisitor {
        private static final Logger LOGGER = Logger.getLogger(CheckVisitor.class.getName());
        private final List<Hint> hints;
        private final BaseDocument baseDocument;
        private final FileObject fileObject;
        private final TooManyLinesHint linesHint;
        private final List<OffsetRange> commentRanges;

        private CheckVisitor(TooManyLinesHint linesHint, FileObject fileObject, BaseDocument baseDocument) {
            this.linesHint = linesHint;
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
            this.hints = new ArrayList<Hint>();
            this.commentRanges = new ArrayList<OffsetRange>();
        }

        @Override
        public void visit(Program node) {
            for (Comment comment : node.getComments()) {
                this.commentRanges.add(new OffsetRange(comment.getStartOffset(), comment.getEndOffset()));
            }
            super.visit(node);
        }

        protected int countLines(final Block block) {
            final AtomicInteger result = new AtomicInteger(0);
            this.baseDocument.render(new Runnable(){

                @Override
                public void run() {
                    result.set(this.countLinesUnderReadLock(block));
                }
            });
            return result.get();
        }

        private int countLinesUnderReadLock(Block block) {
            int result = 0;
            try {
                result = this.tryCountLines(block);
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            return result;
        }

        private int tryCountLines(Block block) throws BadLocationException {
            int searchOffset = block.getStartOffset() + 1;
            int firstNonWhiteFwd = LineDocumentUtils.getNextNonWhitespace((LineDocument)this.baseDocument, (int)searchOffset);
            int startLineOffset = LineDocumentUtils.getLineIndex((LineDocument)this.baseDocument, (int)(firstNonWhiteFwd == -1 ? searchOffset : firstNonWhiteFwd));
            int endLineOffset = LineDocumentUtils.getLineIndex((LineDocument)this.baseDocument, (int)LineDocumentUtils.getPreviousNonWhitespace((LineDocument)this.baseDocument, (int)block.getEndOffset()));
            return this.countLinesBetweenLineOffsets(startLineOffset, endLineOffset);
        }

        private int countLinesBetweenLineOffsets(int startLineOffset, int endLineOffset) throws BadLocationException {
            int result = 0;
            for (int lineOffset = startLineOffset; lineOffset < endLineOffset; ++lineOffset) {
                int rowStartFromLineOffset = LineDocumentUtils.getLineStartFromIndex((LineDocument)this.baseDocument, (int)lineOffset);
                if (LineDocumentUtils.isLineWhitespace((LineDocument)this.baseDocument, (int)rowStartFromLineOffset) || this.isJustCommentOnLine(rowStartFromLineOffset)) continue;
                ++result;
            }
            return result;
        }

        private boolean isJustCommentOnLine(int rowStartOffset) throws BadLocationException {
            boolean result = false;
            int rowFirstNonWhite = LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)this.baseDocument, (int)rowStartOffset);
            int rowLastNonWhite = LineDocumentUtils.getLineLastNonWhitespace((LineDocument)this.baseDocument, (int)rowStartOffset);
            for (OffsetRange commentRange : this.commentRanges) {
                if (!commentRange.containsInclusive(rowFirstNonWhite) || !commentRange.containsInclusive(rowLastNonWhite)) continue;
                result = true;
                break;
            }
            return result;
        }

        protected void addHint(String description, OffsetRange warningRange) {
            if (this.linesHint.showHint(warningRange, this.baseDocument)) {
                this.hints.add(new Hint((Rule)this.linesHint, description, this.fileObject, warningRange, null, 500));
            }
        }

        public List<Hint> getHints() {
            return this.hints;
        }
    }

    public static class TraitLinesHint
    extends TooManyLinesHint {
        private static final String HINT_ID = "Trait.Lines.Hint";
        private static final String MAX_ALLOWED_TRAIT_LINES = "php.verification.max.allowed.trait.lines";
        private static final int DEFAULT_MAX_ALLOWED_TRAIT_LINES = 200;
        private Preferences preferences;

        @Override
        CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new TraitVisitor((TooManyLinesHint)this, fileObject, baseDocument, this.getMaxAllowedLines(this.preferences));
        }

        @Override
        public void setPreferences(Preferences preferences) {
            this.preferences = preferences;
        }

        public void setMaxAllowedLines(Preferences preferences, Integer value) {
            assert (preferences != null);
            assert (value != null);
            preferences.putInt(MAX_ALLOWED_TRAIT_LINES, value);
        }

        public int getMaxAllowedLines(Preferences preferences) {
            assert (preferences != null);
            return preferences.getInt(MAX_ALLOWED_TRAIT_LINES, 200);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.TraitLinesHintDesc();
        }

        public String getDisplayName() {
            return Bundle.TraitLinesHintDisp();
        }

        @Override
        public JComponent getCustomizer(Preferences preferences) {
            TraitLinesCustomizer customizer = new TraitLinesCustomizer(preferences, this);
            this.setMaxAllowedLines(preferences, this.getMaxAllowedLines(preferences));
            return customizer;
        }

        private static final class TraitVisitor
        extends CheckVisitor {
            private final int maxAllowedLines;

            public TraitVisitor(TooManyLinesHint linesHint, FileObject fileObject, BaseDocument baseDocument, int maxAllowedLines) {
                super(linesHint, fileObject, baseDocument);
                this.maxAllowedLines = maxAllowedLines;
            }

            @Override
            public void visit(TraitDeclaration node) {
                super.visit(node);
                this.checkBlock(node.getBody(), new OffsetRange(node.getName().getStartOffset(), node.getName().getEndOffset()));
            }

            private void checkBlock(Block block, OffsetRange warningRange) {
                int countLines = this.countLines(block);
                if (countLines > this.maxAllowedLines) {
                    this.addHint(Bundle.TraitLinesHintText(countLines, this.maxAllowedLines), warningRange);
                }
            }
        }
    }

    public static class InterfaceLinesHint
    extends TooManyLinesHint {
        private static final String HINT_ID = "Interface.Lines.Hint";
        private static final String MAX_ALLOWED_INTERFACE_LINES = "php.verification.max.allowed.interface.lines";
        private static final int DEFAULT_MAX_ALLOWED_INTERFACE_LINES = 100;
        private Preferences preferences;

        @Override
        CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new InterfaceVisitor((TooManyLinesHint)this, fileObject, baseDocument, this.getMaxAllowedLines(this.preferences));
        }

        @Override
        public void setPreferences(Preferences preferences) {
            this.preferences = preferences;
        }

        public void setMaxAllowedLines(Preferences preferences, Integer value) {
            assert (preferences != null);
            assert (value != null);
            preferences.putInt(MAX_ALLOWED_INTERFACE_LINES, value);
        }

        public int getMaxAllowedLines(Preferences preferences) {
            assert (preferences != null);
            return preferences.getInt(MAX_ALLOWED_INTERFACE_LINES, 100);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.InterfaceLinesHintDesc();
        }

        public String getDisplayName() {
            return Bundle.InterfaceLinesHintDisp();
        }

        @Override
        public JComponent getCustomizer(Preferences preferences) {
            InterfaceLinesCustomizer customizer = new InterfaceLinesCustomizer(preferences, this);
            this.setMaxAllowedLines(preferences, this.getMaxAllowedLines(preferences));
            return customizer;
        }

        private static final class InterfaceVisitor
        extends CheckVisitor {
            private final int maxAllowedLines;

            public InterfaceVisitor(TooManyLinesHint linesHint, FileObject fileObject, BaseDocument baseDocument, int maxAllowedLines) {
                super(linesHint, fileObject, baseDocument);
                this.maxAllowedLines = maxAllowedLines;
            }

            @Override
            public void visit(InterfaceDeclaration node) {
                super.visit(node);
                this.checkBlock(node.getBody(), new OffsetRange(node.getName().getStartOffset(), node.getName().getEndOffset()));
            }

            private void checkBlock(Block block, OffsetRange warningRange) {
                int countLines = this.countLines(block);
                if (countLines > this.maxAllowedLines) {
                    this.addHint(Bundle.InterfaceLinesHintText(countLines, this.maxAllowedLines), warningRange);
                }
            }
        }
    }

    public static class ClassLinesHint
    extends TooManyLinesHint {
        private static final String HINT_ID = "Class.Lines.Hint";
        private static final String MAX_ALLOWED_CLASS_LINES = "php.verification.max.allowed.class.lines";
        private static final int DEFAULT_MAX_ALLOWED_CLASS_LINES = 200;
        private Preferences preferences;

        @Override
        CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new ClassVisitor((TooManyLinesHint)this, fileObject, baseDocument, this.getMaxAllowedLines(this.preferences));
        }

        @Override
        public void setPreferences(Preferences preferences) {
            this.preferences = preferences;
        }

        public void setMaxAllowedLines(Preferences preferences, Integer value) {
            assert (preferences != null);
            assert (value != null);
            preferences.putInt(MAX_ALLOWED_CLASS_LINES, value);
        }

        public int getMaxAllowedLines(Preferences preferences) {
            assert (preferences != null);
            return preferences.getInt(MAX_ALLOWED_CLASS_LINES, 200);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.ClassLinesHintDesc();
        }

        public String getDisplayName() {
            return Bundle.ClassLinesHintDisp();
        }

        @Override
        public JComponent getCustomizer(Preferences preferences) {
            ClassLinesCustomizer customizer = new ClassLinesCustomizer(preferences, this);
            this.setMaxAllowedLines(preferences, this.getMaxAllowedLines(preferences));
            return customizer;
        }

        private static final class ClassVisitor
        extends CheckVisitor {
            private final int maxAllowedLines;

            public ClassVisitor(TooManyLinesHint linesHint, FileObject fileObject, BaseDocument baseDocument, int maxAllowedLines) {
                super(linesHint, fileObject, baseDocument);
                this.maxAllowedLines = maxAllowedLines;
            }

            @Override
            public void visit(ClassDeclaration node) {
                super.visit(node);
                this.checkBlock(node.getBody(), new OffsetRange(node.getName().getStartOffset(), node.getName().getEndOffset()));
            }

            private void checkBlock(Block block, OffsetRange warningRange) {
                int countLines = this.countLines(block);
                if (countLines > this.maxAllowedLines) {
                    this.addHint(Bundle.ClassLinesHintText(countLines, this.maxAllowedLines), warningRange);
                }
            }
        }
    }

    public static class FunctionLinesHint
    extends TooManyLinesHint {
        private static final String HINT_ID = "Function.Lines.Hint";
        private static final String MAX_ALLOWED_FUNCTION_LINES = "php.verification.max.allowed.function.lines";
        private static final int DEFAULT_MAX_ALLOWED_FUNCTION_LINES = 20;
        private Preferences preferences;

        @Override
        CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new FunctionVisitor((TooManyLinesHint)this, fileObject, baseDocument, this.getMaxAllowedLines(this.preferences));
        }

        @Override
        public void setPreferences(Preferences preferences) {
            assert (preferences != null);
            this.preferences = preferences;
        }

        public void setMaxAllowedLines(Preferences preferences, Integer value) {
            assert (preferences != null);
            assert (value != null);
            preferences.putInt(MAX_ALLOWED_FUNCTION_LINES, value);
        }

        public int getMaxAllowedLines(Preferences preferences) {
            assert (preferences != null);
            return preferences.getInt(MAX_ALLOWED_FUNCTION_LINES, 20);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.FunctionLinesHintDesc();
        }

        public String getDisplayName() {
            return Bundle.FunctionLinesHintDisp();
        }

        @Override
        public JComponent getCustomizer(Preferences preferences) {
            FunctionLinesCustomizer customizer = new FunctionLinesCustomizer(preferences, this);
            this.setMaxAllowedLines(preferences, this.getMaxAllowedLines(preferences));
            return customizer;
        }

        private static final class FunctionVisitor
        extends CheckVisitor {
            private final int maxAllowedLines;

            public FunctionVisitor(TooManyLinesHint linesHint, FileObject fileObject, BaseDocument baseDocument, int maxAllowedLines) {
                super(linesHint, fileObject, baseDocument);
                this.maxAllowedLines = maxAllowedLines;
            }

            @Override
            public void visit(FunctionDeclaration node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                super.visit(node);
                this.checkBlock(node.getBody(), new OffsetRange(node.getFunctionName().getStartOffset(), node.getFunctionName().getEndOffset()));
            }

            @Override
            public void visit(LambdaFunctionDeclaration node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                super.visit(node);
                this.checkBlock(node.getBody(), new OffsetRange(node.getStartOffset(), node.getBody().getStartOffset()));
            }

            @Override
            public void visit(InterfaceDeclaration node) {
            }

            private void checkBlock(Block block, OffsetRange warningRange) {
                int countLines;
                int n = countLines = block == null ? 0 : this.countLines(block);
                if (countLines > this.maxAllowedLines) {
                    this.addHint(Bundle.FunctionLinesHintText(countLines, this.maxAllowedLines), warningRange);
                }
            }
        }
    }
}

