/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class AbstractClassInstantiationHintError
extends HintErrorRule {
    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.getIndex(), phpParseResult.getModel());
        phpParseResult.getProgram().accept(checkVisitor);
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        hints.addAll(checkVisitor.getHints());
    }

    public String getDisplayName() {
        return Bundle.AbstractClassInstantiationHintDispName();
    }

    private final class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final ElementQuery.Index index;
        private final List<Hint> hints = new ArrayList<Hint>();
        private final Model model;

        private CheckVisitor(FileObject fileObject, ElementQuery.Index index, Model model) {
            this.fileObject = fileObject;
            this.index = index;
            this.model = model;
        }

        public List<Hint> getHints() {
            return Collections.unmodifiableList(this.hints);
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            ClassElement classElement;
            if (CancelSupport.getDefault().isCancelled() || CodeUtils.isDollaredName(node.getClassName())) {
                return;
            }
            ASTNodeInfo<ClassInstanceCreation> info = ASTNodeInfo.create(node);
            int startOffset = node.getStartOffset();
            VariableScope variableScope = this.model.getVariableScope(startOffset);
            QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(info.getQualifiedName(), startOffset, variableScope);
            Set<ClassElement> classes = this.index.getClasses(NameKind.exact(fullyQualifiedName));
            if (!classes.isEmpty() && (classElement = ModelUtils.getFirst(classes)) != null && classElement.isAbstract()) {
                OffsetRange offsetRange = new OffsetRange(startOffset, node.getEndOffset());
                this.hints.add(new Hint((Rule)AbstractClassInstantiationHintError.this, Bundle.AbstractClassInstantiationDesc(classElement.getFullyQualifiedName().toString()), this.fileObject, offsetRange, null, 500));
            }
        }
    }
}

