/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.adm.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListApplicationDependencyVulnerabilitiesRequest
extends BmcRequest<Void> {
    private String vulnerabilityAuditId;
    private String vulnerabilityId;
    private Float cvssV3GreaterThanOrEqual;
    private Float cvssV2GreaterThanOrEqual;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String rootNodeId;
    private Integer depth;
    private String gav;
    private String opcRequestId;

    public String getVulnerabilityAuditId() {
        return this.vulnerabilityAuditId;
    }

    public String getVulnerabilityId() {
        return this.vulnerabilityId;
    }

    public Float getCvssV3GreaterThanOrEqual() {
        return this.cvssV3GreaterThanOrEqual;
    }

    public Float getCvssV2GreaterThanOrEqual() {
        return this.cvssV2GreaterThanOrEqual;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getRootNodeId() {
        return this.rootNodeId;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public String getGav() {
        return this.gav;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().vulnerabilityAuditId(this.vulnerabilityAuditId).vulnerabilityId(this.vulnerabilityId).cvssV3GreaterThanOrEqual(this.cvssV3GreaterThanOrEqual).cvssV2GreaterThanOrEqual(this.cvssV2GreaterThanOrEqual).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).rootNodeId(this.rootNodeId).depth(this.depth).gav(this.gav).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",vulnerabilityAuditId=").append(String.valueOf(this.vulnerabilityAuditId));
        sb.append(",vulnerabilityId=").append(String.valueOf(this.vulnerabilityId));
        sb.append(",cvssV3GreaterThanOrEqual=").append(String.valueOf(this.cvssV3GreaterThanOrEqual));
        sb.append(",cvssV2GreaterThanOrEqual=").append(String.valueOf(this.cvssV2GreaterThanOrEqual));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",rootNodeId=").append(String.valueOf(this.rootNodeId));
        sb.append(",depth=").append(String.valueOf(this.depth));
        sb.append(",gav=").append(String.valueOf(this.gav));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListApplicationDependencyVulnerabilitiesRequest)) {
            return false;
        }
        ListApplicationDependencyVulnerabilitiesRequest other = (ListApplicationDependencyVulnerabilitiesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.vulnerabilityAuditId, other.vulnerabilityAuditId) && Objects.equals(this.vulnerabilityId, other.vulnerabilityId) && Objects.equals(this.cvssV3GreaterThanOrEqual, other.cvssV3GreaterThanOrEqual) && Objects.equals(this.cvssV2GreaterThanOrEqual, other.cvssV2GreaterThanOrEqual) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.rootNodeId, other.rootNodeId) && Objects.equals(this.depth, other.depth) && Objects.equals(this.gav, other.gav) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vulnerabilityAuditId == null ? 43 : this.vulnerabilityAuditId.hashCode());
        result = result * 59 + (this.vulnerabilityId == null ? 43 : this.vulnerabilityId.hashCode());
        result = result * 59 + (this.cvssV3GreaterThanOrEqual == null ? 43 : this.cvssV3GreaterThanOrEqual.hashCode());
        result = result * 59 + (this.cvssV2GreaterThanOrEqual == null ? 43 : this.cvssV2GreaterThanOrEqual.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.rootNodeId == null ? 43 : this.rootNodeId.hashCode());
        result = result * 59 + (this.depth == null ? 43 : this.depth.hashCode());
        result = result * 59 + (this.gav == null ? 43 : this.gav.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListApplicationDependencyVulnerabilitiesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String vulnerabilityAuditId = null;
        private String vulnerabilityId = null;
        private Float cvssV3GreaterThanOrEqual = null;
        private Float cvssV2GreaterThanOrEqual = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String rootNodeId = null;
        private Integer depth = null;
        private String gav = null;
        private String opcRequestId = null;

        public Builder vulnerabilityAuditId(String vulnerabilityAuditId) {
            this.vulnerabilityAuditId = vulnerabilityAuditId;
            return this;
        }

        public Builder vulnerabilityId(String vulnerabilityId) {
            this.vulnerabilityId = vulnerabilityId;
            return this;
        }

        public Builder cvssV3GreaterThanOrEqual(Float cvssV3GreaterThanOrEqual) {
            this.cvssV3GreaterThanOrEqual = cvssV3GreaterThanOrEqual;
            return this;
        }

        public Builder cvssV2GreaterThanOrEqual(Float cvssV2GreaterThanOrEqual) {
            this.cvssV2GreaterThanOrEqual = cvssV2GreaterThanOrEqual;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder rootNodeId(String rootNodeId) {
            this.rootNodeId = rootNodeId;
            return this;
        }

        public Builder depth(Integer depth) {
            this.depth = depth;
            return this;
        }

        public Builder gav(String gav) {
            this.gav = gav;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListApplicationDependencyVulnerabilitiesRequest o) {
            this.vulnerabilityAuditId(o.getVulnerabilityAuditId());
            this.vulnerabilityId(o.getVulnerabilityId());
            this.cvssV3GreaterThanOrEqual(o.getCvssV3GreaterThanOrEqual());
            this.cvssV2GreaterThanOrEqual(o.getCvssV2GreaterThanOrEqual());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.rootNodeId(o.getRootNodeId());
            this.depth(o.getDepth());
            this.gav(o.getGav());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListApplicationDependencyVulnerabilitiesRequest build() {
            ListApplicationDependencyVulnerabilitiesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListApplicationDependencyVulnerabilitiesRequest buildWithoutInvocationCallback() {
            ListApplicationDependencyVulnerabilitiesRequest request = new ListApplicationDependencyVulnerabilitiesRequest();
            request.vulnerabilityAuditId = this.vulnerabilityAuditId;
            request.vulnerabilityId = this.vulnerabilityId;
            request.cvssV3GreaterThanOrEqual = this.cvssV3GreaterThanOrEqual;
            request.cvssV2GreaterThanOrEqual = this.cvssV2GreaterThanOrEqual;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.rootNodeId = this.rootNodeId;
            request.depth = this.depth;
            request.gav = this.gav;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Gav("gav"),
        NodeId("nodeId"),
        Dfs("dfs"),
        Bfs("bfs");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

