/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.ActivationConfigProperties;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.Bundle;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class MdbPropertiesPanelVisual
extends JPanel {
    private final J2eeProjectCapabilities eeProjectCapabilities;
    private TableModel tableModel;
    private MessageDestination destination;
    private JScrollPane propertiesScrollPane;
    private JTable propertiesTable;

    public MdbPropertiesPanelVisual(J2eeProjectCapabilities eeProjectCapabilities) {
        this.eeProjectCapabilities = eeProjectCapabilities;
        this.initComponents();
        this.updateTableUI();
    }

    private TableModel getPropertiesTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new ACPTableModel(this.getActivationConfigProperties());
        }
        return this.tableModel;
    }

    private void initComponents() {
        this.propertiesScrollPane = new JScrollPane();
        this.propertiesTable = new JTable();
        this.setName(NbBundle.getMessage(MdbPropertiesPanelVisual.class, (String)"LBL_SpecifyActivationProperties"));
        this.setPreferredSize(new Dimension(460, 300));
        this.propertiesTable.setModel(this.getPropertiesTableModel());
        this.propertiesTable.setRowHeight(20);
        this.propertiesTable.setSelectionMode(0);
        this.propertiesScrollPane.setViewportView(this.propertiesTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.propertiesScrollPane, -1, 436, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.propertiesScrollPane, -1, 276, Short.MAX_VALUE).addContainerGap()));
    }

    private void updateTableUI() {
        TableColumnModel columnModel = this.propertiesTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(180);
        TableColumn columnTwo = columnModel.getColumn(1);
        columnTwo.setPreferredWidth(280);
        columnTwo.setCellEditor(this.createCellEditor(this.getActivationConfigProperties()));
        columnTwo.setCellRenderer(new ACPCellRenderer(this.getActivationConfigProperties()));
        this.propertiesTable.setSelectionModel(new NullSelectionModel());
    }

    private ACPCellEditor createCellEditor(List<ActivationConfigProperties.ActivationConfigProperty> activationConfigProperties) {
        ACPCellEditor tce = new ACPCellEditor(this.propertiesTable);
        for (int i = 0; i < activationConfigProperties.size(); ++i) {
            ActivationConfigProperties.ActivationConfigProperty acp = activationConfigProperties.get(i);
            if (acp.getPropertyClass() == String.class) {
                tce.setEditorAt(i, new DefaultCellEditor(new JTextField()));
                continue;
            }
            if (!acp.getPropertyClass().isEnum()) continue;
            T[] consts = acp.getPropertyClass().getEnumConstants();
            JComboBox comboBox = new JComboBox(consts);
            tce.setEditorAt(i, new DefaultCellEditor(comboBox));
        }
        return tce;
    }

    private List<ActivationConfigProperties.ActivationConfigProperty> getActivationConfigProperties() {
        List<ActivationConfigProperties.ActivationConfigProperty> activationConfigProperties = ActivationConfigProperties.getActivationConfigProperties(ActivationConfigProperties.EjbVersion.EJB_3_2);
        return activationConfigProperties;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        for (int i = 0; i < this.propertiesTable.getRowCount(); ++i) {
            Object value = this.propertiesTable.getValueAt(i, 1);
            if (value instanceof String) {
                if (((String)value).isEmpty()) continue;
                props.put((String)this.propertiesTable.getValueAt(i, 0), (String)value);
                continue;
            }
            if (value instanceof ActivationConfigProperties.AcknowledgeMode) {
                if ((ActivationConfigProperties.AcknowledgeMode)((Object)value) == ActivationConfigProperties.AcknowledgeMode.AUTO_ACKNOWLEDGE) continue;
                props.put((String)this.propertiesTable.getValueAt(i, 0), ((ActivationConfigProperties.AcknowledgeMode)((Object)value)).getValue());
                continue;
            }
            if (value instanceof ActivationConfigProperties.DestinationType) {
                props.put((String)this.propertiesTable.getValueAt(i, 0), ((ActivationConfigProperties.DestinationType)((Object)value)).getValue());
                continue;
            }
            if (!(value instanceof ActivationConfigProperties.SubscriptionDurability) || (ActivationConfigProperties.SubscriptionDurability)((Object)value) == ActivationConfigProperties.SubscriptionDurability.NON_DURABLE) continue;
            props.put((String)this.propertiesTable.getValueAt(i, 0), ((ActivationConfigProperties.SubscriptionDurability)((Object)value)).getValue());
        }
        return props;
    }

    public void setProperty(String propertyName, Object propertyValue) {
        for (int i = 0; i < this.propertiesTable.getRowCount(); ++i) {
            if (!propertyName.equals(this.propertiesTable.getValueAt(i, 0))) continue;
            this.propertiesTable.setValueAt(propertyValue, i, 1);
        }
    }

    public void setDefaultProperties(MessageDestination destination) {
        this.eraseAllProperties();
        switch (destination.getType()) {
            case QUEUE: {
                this.setProperty("acknowledgeMode", (Object)ActivationConfigProperties.AcknowledgeMode.AUTO_ACKNOWLEDGE);
                this.setProperty("destinationType", (Object)ActivationConfigProperties.DestinationType.QUEUE);
                if (!this.eeProjectCapabilities.isEjb32Supported()) break;
                this.setProperty("destinationLookup", destination.getName());
                break;
            }
            case TOPIC: {
                this.setProperty("acknowledgeMode", (Object)ActivationConfigProperties.AcknowledgeMode.AUTO_ACKNOWLEDGE);
                this.setProperty("clientId", destination.getName());
                this.setProperty("destinationType", (Object)ActivationConfigProperties.DestinationType.TOPIC);
                this.setProperty("subscriptionDurability", (Object)ActivationConfigProperties.SubscriptionDurability.DURABLE);
                this.setProperty("subscriptionName", destination.getName());
                if (!this.eeProjectCapabilities.isEjb32Supported()) break;
                this.setProperty("destinationLookup", destination.getName());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not valid destination type: " + destination.getType().name());
            }
        }
    }

    void read(WizardDescriptor descriptor) {
        this.destination = (MessageDestination)descriptor.getProperty("DESTINATION_TYPE");
        this.setDefaultProperties(this.destination);
    }

    private void eraseAllProperties() {
        this.setProperty("acknowledgeMode", (Object)ActivationConfigProperties.AcknowledgeMode.AUTO_ACKNOWLEDGE);
        this.setProperty("clientId", "");
        this.setProperty("connectionFactoryLookup", "");
        this.setProperty("destinationLookup", "");
        this.setProperty("destinationType", (Object)ActivationConfigProperties.DestinationType.QUEUE);
        this.setProperty("messageSelector", "");
        this.setProperty("subscriptionDurability", (Object)ActivationConfigProperties.SubscriptionDurability.NON_DURABLE);
        this.setProperty("subscriptionName", "");
    }

    private static class ACPTableModel
    extends DefaultTableModel {
        private final List<ActivationConfigProperties.ActivationConfigProperty> activationConfigProperties;
        private static final String[] COLUMN_NAMES = new String[]{Bundle.ACPTableModel_lbl_property_name(), Bundle.ACPTableModel_lbl_property_value()};

        public ACPTableModel(List<ActivationConfigProperties.ActivationConfigProperty> activationConfigProperties) {
            this.activationConfigProperties = activationConfigProperties;
            this.initRows();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMN_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column > 0;
        }

        private void initRows() {
            for (ActivationConfigProperties.ActivationConfigProperty activationConfigProperty : this.activationConfigProperties) {
                if (activationConfigProperty.getPropertyClass().isEnum()) {
                    this.addRow(new Object[]{activationConfigProperty.getName(), activationConfigProperty.getPropertyClass().getEnumConstants()[0]});
                    continue;
                }
                this.addRow(new Object[]{activationConfigProperty.getName(), null});
            }
        }
    }

    private static class ACPCellEditor
    implements TableCellEditor {
        private final Map<Integer, TableCellEditor> cellEditors = new HashMap<Integer, TableCellEditor>();
        private TableCellEditor editor;
        private TableCellEditor defaultEditor = new DefaultCellEditor(new JTextField());
        private final JTable table;

        public ACPCellEditor(JTable table) {
            this.table = table;
        }

        public void setEditorAt(int row, TableCellEditor editor) {
            this.cellEditors.put(row, editor);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            this.selectEditor(anEvent);
            return this.editor.isCellEditable(anEvent);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            this.selectEditor(anEvent);
            return this.editor.shouldSelectCell(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return this.editor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.editor.cancelCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.editor.addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.editor.removeCellEditorListener(l);
        }

        protected void selectEditor(EventObject e) {
            int row = e instanceof MouseEvent ? (e == null ? this.table.getSelectionModel().getAnchorSelectionIndex() : this.table.rowAtPoint(((MouseEvent)e).getPoint())) : this.table.getSelectionModel().getAnchorSelectionIndex();
            this.editor = this.cellEditors.get(row);
            if (this.editor == null) {
                this.editor = this.defaultEditor;
            }
        }
    }

    private static class ACPCellRenderer
    extends JComboBox
    implements TableCellRenderer {
        private final DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
        private final List<ActivationConfigProperties.ActivationConfigProperty> acp;

        public ACPCellRenderer(List<ActivationConfigProperties.ActivationConfigProperty> activationConfigProperties) {
            this.acp = activationConfigProperties;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof String) {
                return this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            if (value instanceof ActivationConfigProperties.AcknowledgeMode) {
                ComboCellRenderer combo = new ComboCellRenderer((Object[])ActivationConfigProperties.AcknowledgeMode.values(), table);
                combo.setSelectedItem(value);
                return combo;
            }
            if (value instanceof ActivationConfigProperties.DestinationType) {
                ComboCellRenderer combo = new ComboCellRenderer((Object[])ActivationConfigProperties.DestinationType.values(), table);
                combo.setSelectedItem(value);
                return combo;
            }
            if (value instanceof ActivationConfigProperties.SubscriptionDurability) {
                ComboCellRenderer combo = new ComboCellRenderer((Object[])ActivationConfigProperties.SubscriptionDurability.values(), table);
                combo.setSelectedItem(value);
                return combo;
            }
            return this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class NullSelectionModel
    implements ListSelectionModel {
        private NullSelectionModel() {
        }

        @Override
        public boolean isSelectionEmpty() {
            return true;
        }

        @Override
        public boolean isSelectedIndex(int index) {
            return false;
        }

        @Override
        public int getMinSelectionIndex() {
            return -1;
        }

        @Override
        public int getMaxSelectionIndex() {
            return -1;
        }

        @Override
        public int getLeadSelectionIndex() {
            return -1;
        }

        @Override
        public int getAnchorSelectionIndex() {
            return -1;
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
        }

        @Override
        public void setLeadSelectionIndex(int index) {
        }

        @Override
        public void setAnchorSelectionIndex(int index) {
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
        }

        @Override
        public void insertIndexInterval(int index, int length, boolean before) {
        }

        @Override
        public void clearSelection() {
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
        }

        @Override
        public void removeIndexInterval(int index0, int index1) {
        }

        @Override
        public void setSelectionMode(int selectionMode) {
        }

        @Override
        public int getSelectionMode() {
            return 0;
        }

        @Override
        public void addListSelectionListener(ListSelectionListener lsl) {
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener lsl) {
        }

        @Override
        public void setValueIsAdjusting(boolean valueIsAdjusting) {
        }

        @Override
        public boolean getValueIsAdjusting() {
            return false;
        }
    }

    private static class ComboCellRenderer
    extends JComboBox {
        public ComboCellRenderer(Object[] items, JTable table) {
            super(items);
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
    }
}

