/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.apisupport.project.queries.GlobalSourceForBinaryImpl;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.universe.SourceRootsProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class NbPlatformCustomizerSources
extends JPanel {
    private SourceRootsProvider srcRP;
    private PlatformComponentFactory.SourceRootsModel model;
    private final ListListener listListener;
    private JButton addFolderButton;
    private JPanel buttonPanel;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton removeButton;
    private JLabel sourceLabel;
    private JList sourceList;
    private JScrollPane sourceSP;

    public NbPlatformCustomizerSources() {
        this.initComponents();
        this.initAccessibility();
        this.listListener = new ListListener(){

            @Override
            void listChanged() {
                NbPlatformCustomizerSources.this.updateEnabled();
            }
        };
        this.updateEnabled();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.sourceList.addListSelectionListener(this.listListener);
        this.sourceList.getModel().addListDataListener(this.listListener);
    }

    @Override
    public void removeNotify() {
        this.sourceList.removeListSelectionListener(this.listListener);
        this.sourceList.getModel().removeListDataListener(this.listListener);
        super.removeNotify();
    }

    public void setSourceRootsProvider(SourceRootsProvider srp) {
        this.srcRP = srp;
        this.model = new PlatformComponentFactory.SourceRootsModel(srp);
        this.sourceList.setModel(this.model);
    }

    private void updateEnabled() {
        this.removeButton.setEnabled(this.sourceList.getModel().getSize() > 0 && this.sourceList.getSelectedIndex() != -1);
        this.moveUpButton.setEnabled(this.sourceList.getSelectionModel().getMinSelectionIndex() > 0);
        this.moveDownButton.setEnabled(this.srcRP != null && this.sourceList.getSelectionModel().getMaxSelectionIndex() < this.srcRP.getSourceRoots().length - 1);
    }

    private void initComponents() {
        this.sourceLabel = new JLabel();
        this.sourceSP = new JScrollPane();
        this.sourceList = new JList();
        this.buttonPanel = new JPanel();
        this.addFolderButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.sourceLabel.setLabelFor(this.sourceList);
        Mnemonics.setLocalizedText((JLabel)this.sourceLabel, (String)NbBundle.getMessage(NbPlatformCustomizerSources.class, (String)"LBL_PlatformSources"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sourceLabel, gridBagConstraints);
        this.sourceList.setCellRenderer(PlatformComponentFactory.getURLListRenderer());
        this.sourceSP.setViewportView(this.sourceList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.sourceSP, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.addFolderButton, (String)NbBundle.getMessage(NbPlatformCustomizerSources.class, (String)"CTL_AddZipOrFolder"));
        this.addFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerSources.this.addZipOrFolder(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.addFolderButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(NbPlatformCustomizerSources.class, (String)"CTL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerSources.this.removeFolder(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getMessage(NbPlatformCustomizerSources.class, (String)"CTL_MoveUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerSources.this.moveUp(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.buttonPanel.add((Component)this.moveUpButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getMessage(NbPlatformCustomizerSources.class, (String)"CTL_MoveDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerSources.this.moveDown(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void moveDown(ActionEvent evt) {
        int[] selIndices = this.sourceList.getSelectedIndices();
        this.model.moveSourceRootsDown(selIndices);
        for (int i = 0; i < selIndices.length; ++i) {
            int n = i;
            int n2 = selIndices[n] + 1;
            selIndices[n] = n2;
            selIndices[i] = n2;
        }
        this.sourceList.setSelectedIndices(selIndices);
    }

    private void moveUp(ActionEvent evt) {
        int[] selIndices = this.sourceList.getSelectedIndices();
        this.model.moveSourceRootsUp(selIndices);
        for (int i = 0; i < selIndices.length; ++i) {
            int n = i;
            int n2 = selIndices[n] - 1;
            selIndices[n] = n2;
            selIndices[i] = n2;
        }
        this.sourceList.setSelectedIndices(selIndices);
    }

    private void removeFolder(ActionEvent evt) {
        Object[] selVals = this.sourceList.getSelectedValues();
        int toSelect = this.sourceList.getSelectedIndex() - 1;
        URL[] selURLs = new URL[selVals.length];
        System.arraycopy(selVals, 0, selURLs, 0, selVals.length);
        this.model.removeSourceRoot(selURLs);
        this.sourceList.setSelectedIndex(toSelect);
    }

    private void addZipOrFolder(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(ModuleUISettings.getDefault().getLastUsedNbPlatformLocation());
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || NbPlatformCustomizerSources.isValidNbSourceRoot(f);
            }

            @Override
            public String getDescription() {
                return NbPlatformCustomizerSources.this.getMessage("CTL_SourcesTab");
            }
        });
        int ret = chooser.showOpenDialog(this);
        if (ret == 0) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            if (!file.exists() || file.isFile() && !NbPlatformCustomizerSources.isValidNbSourceRoot(file)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.getMessage("MSG_NotValidNBSrcZIP")));
            } else {
                URL newUrl = FileUtil.urlForArchiveOrDir((File)file);
                if (this.model.containsRoot(newUrl)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.getMessage("MSG_ExistingNBSrcZIP")));
                } else {
                    ModuleUISettings.getDefault().setLastUsedNbPlatformLocation(file.getParentFile().getAbsolutePath());
                    this.model.addSourceRoot(newUrl);
                    this.sourceList.setSelectedValue(newUrl, true);
                }
            }
        }
    }

    private static boolean isValidNbSourceRoot(File nbSrcRoot) {
        boolean isValid = false;
        String lcName = nbSrcRoot.getName().toLowerCase(Locale.US);
        if (lcName.endsWith(".jar") || lcName.endsWith(".zip")) {
            try {
                isValid = GlobalSourceForBinaryImpl.NetBeansSourcesParser.getInstance(nbSrcRoot) != null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return isValid;
    }

    private void initAccessibility() {
        this.addFolderButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_addFolderButton"));
        this.sourceList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_sourceList"));
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_moveDownButton"));
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_moveUpButton"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_removeButton"));
    }

    private String getMessage(String key) {
        return NbBundle.getMessage(NbPlatformCustomizerSources.class, (String)key);
    }

    static abstract class ListListener
    implements ListDataListener,
    ListSelectionListener {
        ListListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.listChanged();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.listChanged();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.listChanged();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                this.listChanged();
            }
        }

        abstract void listChanged();
    }
}

