/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.file.launcher.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.modules.java.file.launcher.SingleSourceFileUtil;
import org.netbeans.modules.java.file.launcher.queries.MultiSourceRootProvider;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;

public final class SourceLauncher {
    private static final String ENABLE_PREVIEW = "--enable-preview";
    private static final String SOURCE = "--source";
    private static final String CLASS_PATH = "--class-path";
    private static final String CLASSPATH = "-classpath";
    private static final String CP = "-cp";
    private static final String MODULE_PATH = "--module-path";
    private static final String P = "-p";

    public static boolean isSourceLauncherFile(FileObject file) {
        MultiSourceRootProvider msrp = (MultiSourceRootProvider)Lookup.getDefault().lookup(MultiSourceRootProvider.class);
        return msrp != null && msrp.isSourceLauncher(file);
    }

    public static String joinCommandLines(Iterable<? extends String> inputLines) {
        HashMap<String, String> joinedOptions = new HashMap<String, String>();
        for (String string : inputLines) {
            List<String> args = SingleSourceFileUtil.parseLine(string);
            block16: for (int i = 0; i < args.size(); ++i) {
                switch (args.get(i)) {
                    case "--enable-preview": {
                        joinedOptions.put(ENABLE_PREVIEW, null);
                        continue block16;
                    }
                    case "-classpath": 
                    case "--class-path": 
                    case "-cp": {
                        if (i + 1 >= args.size()) continue block16;
                        joinedOptions.put(CLASS_PATH, SourceLauncher.mergePaths((String)joinedOptions.get(CLASS_PATH), args.get(i + 1)));
                        ++i;
                        continue block16;
                    }
                    case "--module-path": 
                    case "-p": {
                        if (i + 1 >= args.size()) continue block16;
                        joinedOptions.put(MODULE_PATH, SourceLauncher.mergePaths((String)joinedOptions.get(MODULE_PATH), args.get(i + 1)));
                        ++i;
                        continue block16;
                    }
                    case "--source": {
                        String existingVersion;
                        if (i + 1 >= args.size()) continue block16;
                        String version = args.get(i + 1);
                        String testVersion = version;
                        if (testVersion.startsWith("1.")) {
                            testVersion = testVersion.substring(2);
                        }
                        if ((existingVersion = (String)joinedOptions.get(SOURCE)) != null) {
                            if (existingVersion.startsWith("1.")) {
                                existingVersion = existingVersion.substring(2);
                            }
                            if (new SpecificationVersion(testVersion).compareTo(new SpecificationVersion(existingVersion)) > 0) {
                                joinedOptions.put(SOURCE, version);
                            }
                        } else {
                            joinedOptions.put(SOURCE, version);
                        }
                        ++i;
                    }
                }
            }
        }
        return joinedOptions.entrySet().stream().map(e -> (String)e.getKey() + (e.getValue() != null ? " " + (String)e.getValue() : "")).collect(Collectors.joining(" "));
    }

    private static String mergePaths(String oldPath, String newPath) {
        if (oldPath == null) {
            return newPath;
        }
        if (newPath == null) {
            return oldPath;
        }
        return oldPath + File.pathSeparator + newPath;
    }
}

